/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.service.notify;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.ks.common.NotifyInfo;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.mail.MailService;
import org.exoplatform.services.mail.Message;
import org.exoplatform.services.scheduler.JobInfo;
import org.exoplatform.services.scheduler.JobSchedulerService;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class NotifyJob
implements Job {
    private static Log log_ = ExoLogger.getLogger((String)"job.RecordsJob");

    public void execute(JobExecutionContext context) throws JobExecutionException {
        try {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            MailService mailService = (MailService)container.getComponentInstanceOfType(MailService.class);
            FAQService faqService = (FAQService)container.getComponentInstanceOfType(FAQService.class);
            String name = context.getJobDetail().getName();
            NotifyInfo messageInfo = faqService.getMessageInfo(name);
            List emailAddresses = messageInfo.getEmailAddresses();
            Message message = messageInfo.getMessage();
            JobSchedulerService schedulerService = (JobSchedulerService)container.getComponentInstanceOfType(JobSchedulerService.class);
            JobInfo info = new JobInfo(name, "KnowledgeSuite-faq", context.getJobDetail().getJobClass());
            if (message != null && emailAddresses != null && emailAddresses.size() > 0) {
                ArrayList<String> sentMessages = new ArrayList<String>();
                int countEmail = 0;
                for (String address : emailAddresses) {
                    if (sentMessages.contains(address)) continue;
                    message.setTo(address);
                    mailService.sendMessage(message);
                    sentMessages.add(address);
                    ++countEmail;
                }
                if (log_.isDebugEnabled()) {
                    log_.debug((Object)("\n\nEmail notifications for Thread Save Question have been sent to " + countEmail + " addresses"));
                }
            }
            schedulerService.removeJob(info);
        }
        catch (Exception e) {
            log_.debug((Object)"Failed to send email notifications for thread save question.", (Throwable)e);
        }
    }
}

