/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.service;

import java.util.List;
import org.exoplatform.faq.service.Category;
import org.exoplatform.faq.service.ObjectSearchResult;
import org.exoplatform.faq.service.Question;
import org.exoplatform.faq.service.Watch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JCRPageList {
    private long pageSize_;
    protected long available_ = 0L;
    protected long availablePage_ = 1L;
    protected long currentPage_ = 1L;
    protected List<Question> currentListPage_;
    protected List currentListObject_;
    protected List<Category> currentListCategory_;
    protected List<ObjectSearchResult> currentListResultSearch_;
    protected List<Watch> currentListWatch_;
    private String objectId_ = null;
    private long pageJump_ = 0L;

    public JCRPageList(long pageSize) {
        this.pageSize_ = pageSize;
    }

    public String getObjectId() {
        return this.objectId_;
    }

    public void setObjectId(String id) {
        this.objectId_ = id;
    }

    public long getPageSize() {
        return this.pageSize_;
    }

    public void setPageSize(long pageSize) {
        this.pageSize_ = pageSize;
        this.setAvailablePage(this.available_);
    }

    public long getCurrentPage() {
        return this.currentPage_;
    }

    public long getAvailable() {
        return this.available_;
    }

    public long getAvailablePage() {
        return this.availablePage_;
    }

    public List<Question> currentPage(String username) throws Exception {
        if (this.currentListPage_ == null) {
            this.populateCurrentPage(this.currentPage_, username);
        }
        return this.currentListPage_;
    }

    public void setQuestion(List<Question> questions, boolean isUpdate) throws Exception {
        if (this.currentListPage_ == null) {
            return;
        }
        block0: for (Question qt : questions) {
            for (int i = 0; i < this.currentListPage_.size(); ++i) {
                if (!this.currentListPage_.get(i).getId().endsWith(qt.getId())) continue;
                if (isUpdate) {
                    this.currentListPage_.set(i, qt);
                    continue block0;
                }
                this.currentListPage_.remove(i);
                continue block0;
            }
        }
    }

    protected abstract void populateCurrentPage(long var1, String var3) throws Exception;

    public List<Question> getPage(long page, String username) throws Exception {
        this.checkAndSetPage(page);
        this.populateCurrentPage(this.currentPage_, username);
        return this.currentListPage_;
    }

    protected abstract void populateCurrentPageItem(long var1) throws Exception;

    public List getPageItem(long page) throws Exception {
        this.checkAndSetPage(page);
        this.populateCurrentPageItem(this.currentPage_);
        return this.currentListObject_;
    }

    protected abstract void populateCurrentPageResultSearch(long var1, String var3) throws Exception;

    public List<ObjectSearchResult> getPageResultSearch(long page, String username) throws Exception {
        this.checkAndSetPage(page);
        this.populateCurrentPageResultSearch(this.currentPage_, username);
        return this.currentListResultSearch_;
    }

    protected abstract void populateCurrentPageCategoriesSearch(long var1, String var3) throws Exception;

    public List<Category> getPageResultCategoriesSearch(long page, String username) throws Exception {
        this.checkAndSetPage(page);
        this.populateCurrentPageCategoriesSearch(this.currentPage_, username);
        return this.currentListCategory_;
    }

    protected abstract void populateCurrentPageQuestionsSearch(long var1, String var3) throws Exception;

    public List<Question> getPageResultQuestionsSearch(long page, String username) throws Exception {
        this.checkAndSetPage(page);
        this.populateCurrentPageQuestionsSearch(this.currentPage_, username);
        return this.currentListPage_;
    }

    protected abstract void populateCurrentPageCategoriesQuestionsSearch(long var1, String var3) throws Exception;

    public List<Object> getPageListCategoriesQuestions(long page, String username) throws Exception {
        this.checkAndSetPage(page);
        this.populateCurrentPageCategoriesQuestionsSearch(this.currentPage_, username);
        return this.currentListObject_;
    }

    protected abstract void populateCurrentPageWatch(long var1, String var3) throws Exception;

    public List<Watch> getPageListWatch(long page, String username) throws Exception {
        this.checkAndSetPage(page);
        this.populateCurrentPageWatch(this.currentPage_, username);
        return this.currentListWatch_;
    }

    public abstract List<Question> getAll() throws Exception;

    public abstract void setList(List<Question> var1);

    protected void checkAndSetPage(long page) {
        if (page < 0L) {
            page = 1L;
        } else if (page > this.availablePage_) {
            page = this.availablePage_;
        }
        this.currentPage_ = page;
    }

    protected void setAvailablePage(long available) {
        this.available_ = available;
        if (available == 0L) {
            this.availablePage_ = 1L;
            this.currentPage_ = 1L;
        } else {
            long pages = available / this.pageSize_;
            if (available % this.pageSize_ > 0L) {
                ++pages;
            }
            this.availablePage_ = pages;
        }
    }

    public void setPageJump(long pageJump) {
        this.pageJump_ = pageJump;
    }

    public long getPageJump() {
        return this.pageJump_;
    }
}

