/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.webui;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.download.DownloadResource;
import org.exoplatform.download.DownloadService;
import org.exoplatform.download.InputStreamDownloadResource;
import org.exoplatform.faq.service.Category;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.FAQServiceUtils;
import org.exoplatform.faq.service.FAQSetting;
import org.exoplatform.faq.service.FileAttachment;
import org.exoplatform.faq.service.JCRPageList;
import org.exoplatform.faq.service.Question;
import org.exoplatform.faq.service.QuestionLanguage;
import org.exoplatform.faq.service.Watch;
import org.exoplatform.faq.webui.FAQUtils;
import org.exoplatform.faq.webui.UIFAQPageIterator;
import org.exoplatform.faq.webui.UIQuestions;
import org.exoplatform.faq.webui.UIQuickSearch;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.event.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/templates/faq/webui/UIQuestions.gtmpl", events={@EventConfig(listeners={DownloadAttachActionListener.class}), @EventConfig(listeners={AddCategoryActionListener.class}), @EventConfig(listeners={AddNewQuestionActionListener.class}), @EventConfig(listeners={OpenCategoryActionListener.class}), @EventConfig(listeners={EditSubCategoryActionListener.class}), @EventConfig(listeners={EditCategoryActionListener.class}), @EventConfig(listeners={DeleteCategoryActionListener.class}, confirm="UIQuestions.msg.confirm-delete-category"), @EventConfig(listeners={MoveCategoryActionListener.class}), @EventConfig(listeners={MoveDownActionListener.class}), @EventConfig(listeners={MoveUpActionListener.class}), @EventConfig(listeners={SettingActionListener.class}), @EventConfig(listeners={WatchActionListener.class}), @EventConfig(listeners={WatchManagerActionListener.class}), @EventConfig(listeners={ExportActionListener.class}), @EventConfig(listeners={ImportActionListener.class}), @EventConfig(listeners={QuestionManagamentActionListener.class}), @EventConfig(listeners={ViewQuestionActionListener.class}), @EventConfig(listeners={ResponseQuestionActionListener.class}), @EventConfig(listeners={EditQuestionActionListener.class}), @EventConfig(listeners={DeleteQuestionActionListener.class}), @EventConfig(listeners={MoveQuestionActionListener.class}), @EventConfig(listeners={SendQuestionActionListener.class}), @EventConfig(listeners={ChangeQuestionActionListener.class})})
public class UIQuestions
extends UIContainer {
    private static String SEARCH_INPUT = "SearchInput";
    private static final String OBJECT_ITERATOR = "object_iter";
    private static final String QUICK_SEARCH = "QuickSearch";
    private FAQSetting faqSetting_ = null;
    private List<Category> categories_ = null;
    private List<Boolean> categoryModerators = new ArrayList();
    public List<Question> listQuestion_ = null;
    private List<String> listCateId_ = new ArrayList();
    private boolean canEditQuestion = false;
    private String categoryId_ = null;
    public String questionView_ = "";
    public static String newPath_ = "";
    private String currentUser_ = "";
    private List<String> listUserGroupMember = new ArrayList();
    private String link_ = "";
    private static FAQService faqService_ = (FAQService)PortalContainer.getInstance().getComponentInstanceOfType(FAQService.class);
    public List<QuestionLanguage> listQuestionLanguage = new ArrayList();
    public boolean isChangeLanguage = false;
    public List<String> listLanguage = new ArrayList();
    public String backPath_ = null;
    private static String language_ = "";
    private List<Watch> watchList_ = new ArrayList();
    private String[] firstTollbar_ = new String[]{"AddCategory", "AddNewQuestion", "QuestionManagament", "Export", "Import"};
    private String[] secondTollbar_ = new String[]{"AddCategory", "AddNewQuestion", "QuestionManagament", "Export", "Import"};
    private String[] firstActionCate_ = new String[]{"Export", "Import", "AddCategory", "AddNewQuestion", "EditCategory", "DeleteCategory", "MoveCategory", "MoveDown", "MoveUp", "Watch"};
    private String[] secondActionCate_ = new String[]{"Export", "Import", "AddCategory", "AddNewQuestion", "EditSubCategory", "DeleteCategory", "MoveCategory", "MoveDown", "MoveUp", "Watch"};
    private String[] userActionsCate_ = new String[]{"AddNewQuestion", "Watch"};
    private String[] moderatorActionQues_ = new String[]{"ResponseQuestion", "EditQuestion", "DeleteQuestion", "MoveQuestion", "SendQuestion"};
    private String[] userActionQues_ = new String[]{"SendQuestion"};
    private String[] sizes_ = new String[]{"bytes", "KB", "MB"};
    private boolean viewAuthorInfor = false;
    public JCRPageList pageList;
    private UIFAQPageIterator pageIterator = null;
    long pageSelect = 0L;

    public UIQuestions() throws Exception {
        this.categoryId_ = new String();
        this.currentUser_ = FAQUtils.getCurrentUser();
        this.faqSetting_ = new FAQSetting();
        FAQUtils.getPorletPreference((FAQSetting)this.faqSetting_);
        if (this.currentUser_ != null && this.currentUser_.trim().length() > 0) {
            if (this.faqSetting_.getIsAdmin() == null || this.faqSetting_.getIsAdmin().trim().length() < 1) {
                if (faqService_.isAdminRole(this.currentUser_)) {
                    this.faqSetting_.setIsAdmin("TRUE");
                } else {
                    this.faqSetting_.setIsAdmin("FALSE");
                }
            }
            SessionProvider sessionProvider = FAQUtils.getSystemProvider();
            faqService_.getUserSetting(sessionProvider, this.currentUser_, this.faqSetting_);
            sessionProvider.close();
        } else {
            this.faqSetting_.setIsAdmin("FALSE");
        }
        this.addChild(UIQuickSearch.class, null, QUICK_SEARCH);
        this.addChild(UIFAQPageIterator.class, null, OBJECT_ITERATOR);
        this.setListObject();
    }

    public String getPortalName() {
        PortalContainer pcontainer = PortalContainer.getInstance();
        return pcontainer.getPortalContainerInfo().getContainerName();
    }

    public String getRepository() throws Exception {
        RepositoryService rService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        return rService.getCurrentRepository().getConfiguration().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setListObject() {
        this.isChangeLanguage = false;
        SessionProvider sessionProvider = FAQUtils.getSystemProvider();
        try {
            if (this.currentUser_ != null && this.currentUser_.trim().length() > 0) {
                FAQServiceUtils serviceUtils = new FAQServiceUtils();
                if (this.faqSetting_.getIsAdmin().equals("TRUE")) {
                    this.faqSetting_.setCanEdit(true);
                } else if (this.categoryId_ != null && this.categoryId_.trim().length() > 0 && Arrays.asList(faqService_.getCategoryById(this.categoryId_, sessionProvider).getModerators()).contains(this.currentUser_)) {
                    this.faqSetting_.setCanEdit(true);
                } else {
                    this.faqSetting_.setCanEdit(false);
                }
            }
            String object = null;
            if (this.pageList != null) {
                object = this.pageList.getObjectRepare_();
            }
            this.pageList = faqService_.getListCatesAndQuesByCateId(this.categoryId_, sessionProvider, this.faqSetting_);
            this.pageList.setPageSize(10L);
            if (object != null && object.trim().length() > 0) {
                this.pageList.setObjectRepare_(object);
            }
            this.pageIterator = (UIFAQPageIterator)this.getChildById(OBJECT_ITERATOR);
            this.pageIterator.updatePageList(this.pageList);
        }
        catch (Exception e) {
            this.pageList = null;
            this.pageList.setPageSize(10L);
            this.pageIterator.updatePageList(this.pageList);
            e.printStackTrace();
        }
        finally {
            sessionProvider.close();
        }
    }

    public String[] getActionTollbar() {
        if (this.categoryId_ == null || this.categoryId_.equals("null") || this.categoryId_.trim().length() < 1) {
            return this.firstTollbar_;
        }
        return this.secondTollbar_;
    }

    public FAQSetting getFAQSetting() {
        return this.faqSetting_;
    }

    public void setFAQSetting(FAQSetting setting) {
        this.faqSetting_ = setting;
        if (this.faqSetting_.isAdmin()) {
            try {
                this.listUserGroupMember = FAQServiceUtils.getAllGroupAndMembershipOfUser((String)this.currentUser_);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private String[] getActionCategory() {
        return this.firstActionCate_;
    }

    private String[] getSecondActionCategory() {
        return this.secondActionCate_;
    }

    private String[] getActionCategoryWithUser() {
        return this.userActionsCate_;
    }

    private String[] getActionQuestion() {
        if (this.canEditQuestion) {
            return this.moderatorActionQues_;
        }
        return this.userActionQues_;
    }

    private String[] getActionQuestionWithUser() {
        String[] action = new String[]{"SendQuestion"};
        return action;
    }

    public void setCategories() throws Exception {
        if (this.categories_ != null) {
            this.categories_.clear();
        }
        this.pageSelect = this.pageIterator.getPageSelected();
        this.categories_ = new ArrayList();
        this.listQuestion_ = new ArrayList();
        List listObject = this.pageList.getPageListCategoriesQuestions(this.pageSelect, null);
        for (Object obj : listObject) {
            if (obj instanceof Category) {
                this.categories_.add((Category)obj);
                continue;
            }
            this.listQuestion_.add((Question)obj);
        }
        while (listObject.isEmpty() && this.pageSelect > 1L) {
            listObject = this.pageList.getPageListCategoriesQuestions(--this.pageSelect, null);
            for (Object obj : listObject) {
                if (obj instanceof Category) {
                    this.categories_.add((Category)obj);
                    continue;
                }
                this.listQuestion_.add((Question)obj);
            }
            this.pageIterator.setSelectPage(this.pageSelect);
        }
        this.pageIterator.setSelectPage(this.pageList.getPageJump());
        this.setIsModerators();
    }

    public void setLanguageView(String language) {
        language_ = language;
    }

    public void setCategories(String categoryId) throws Exception {
        this.setCategoryId(categoryId);
    }

    private String[] getMenuSubCategory(Category category) {
        if (this.currentUser_ == null) {
            return this.userActionsCate_;
        }
        if (category.getModerators().length == 1 && this.currentUser_.equals(category.getModerators()[0])) {
            return this.secondActionCate_;
        }
        for (String str : category.getModerators()) {
            if (!this.listUserGroupMember.contains(str)) continue;
            return this.secondActionCate_;
        }
        return this.userActionsCate_;
    }

    private void setIsModerators() {
        block16: {
            block15: {
                this.categoryModerators.clear();
                FAQServiceUtils serviceUtils = new FAQServiceUtils();
                if (!this.faqSetting_.getIsAdmin().equals("TRUE")) break block15;
                this.canEditQuestion = true;
                for (int i = 0; i < this.categories_.size(); ++i) {
                    this.categoryModerators.add(true);
                }
                break block16;
            }
            if (this.categoryId_ == null || this.categoryId_.trim().length() < 1) {
                this.listCateId_.clear();
            } else if (!this.listCateId_.contains(this.categoryId_)) {
                this.listCateId_.add(this.categoryId_);
            } else {
                int pos = this.listCateId_.indexOf(this.categoryId_);
                for (int i = pos + 1; i < this.listCateId_.size(); ++i) {
                    this.listCateId_.remove(i);
                }
            }
            boolean isContinue = true;
            if (this.listCateId_.size() > 0) {
                SessionProvider sessionProvider = FAQUtils.getSystemProvider();
                for (String cateIdProcess : this.listCateId_) {
                    try {
                        if (!Arrays.asList(faqService_.getCategoryById(cateIdProcess, sessionProvider).getModeratorsCategory()).contains(this.currentUser_)) continue;
                        for (int j = 0; j < this.categories_.size(); ++j) {
                            this.categoryModerators.add(true);
                        }
                        isContinue = false;
                        this.canEditQuestion = true;
                        break;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                sessionProvider.close();
            }
            if (!isContinue) break block16;
            this.canEditQuestion = false;
            for (Category category : this.categories_) {
                try {
                    if (Arrays.asList(category.getModeratorsCategory()).contains(this.currentUser_)) {
                        this.categoryModerators.add(true);
                        continue;
                    }
                    this.categoryModerators.add(false);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private List<Boolean> getIsModerator() {
        return this.categoryModerators;
    }

    private String[] getActionWithCategory() {
        return null;
    }

    private List<Category> getCategories() throws Exception {
        if (this.isChangeLanguage && this.pageSelect != this.pageIterator.getPageSelected()) {
            this.isChangeLanguage = false;
        }
        if (!this.isChangeLanguage) {
            this.setCategories();
        }
        return this.categories_;
    }

    private long[] getCategoryInfo(String categoryId) {
        long[] result = new long[]{0L, 0L, 0L, 0L};
        SessionProvider sessionProvider = FAQUtils.getSystemProvider();
        try {
            result = faqService_.getCategoryInfo(categoryId, sessionProvider);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        sessionProvider.close();
        return result;
    }

    public void setIsNotChangeLanguage() {
        this.isChangeLanguage = false;
    }

    public void setListQuestion(List<Question> listQuestion) {
        this.listQuestion_ = listQuestion;
    }

    private String convertSize(long size) {
        String result = "";
        long residual = 0L;
        int i = 0;
        while (size >= 1000L) {
            ++i;
            residual = size % 1024L;
            size /= 1024L;
        }
        if (residual > 500L) {
            String str = residual + "";
            result = size + 1L + " " + this.sizes_[i];
        } else {
            result = size + " " + this.sizes_[i];
        }
        return result;
    }

    public List<Question> getListQuestion() {
        return this.listQuestion_;
    }

    private boolean getCanEditQuestion() {
        return this.canEditQuestion;
    }

    private String getQuestionView() {
        return this.questionView_;
    }

    private List<String> getQuestionLangauges(Question question) {
        try {
            if (!this.isChangeLanguage) {
                this.listLanguage.clear();
                this.listQuestionLanguage.clear();
                QuestionLanguage quesLanguage = new QuestionLanguage();
                quesLanguage.setLanguage(question.getLanguage());
                quesLanguage.setQuestion(question.getQuestion());
                quesLanguage.setResponse(question.getAllResponses());
                quesLanguage.setResponseBy(question.getResponseBy());
                quesLanguage.setDateResponse(question.getDateResponse());
                this.listQuestionLanguage.add(quesLanguage);
                SessionProvider sessionProvider = FAQUtils.getSystemProvider();
                this.listQuestionLanguage.addAll(faqService_.getQuestionLanguages(question.getId(), sessionProvider));
                for (QuestionLanguage questionLanguage : this.listQuestionLanguage) {
                    this.listLanguage.add(questionLanguage.getLanguage());
                }
                sessionProvider.close();
            }
            return this.listLanguage;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getFileSource(InputStream input, String fileName, DownloadService dservice) throws Exception {
        byte[] imageBytes = null;
        if (input != null) {
            imageBytes = new byte[input.available()];
            input.read(imageBytes);
            ByteArrayInputStream byteImage = new ByteArrayInputStream(imageBytes);
            InputStreamDownloadResource dresource = new InputStreamDownloadResource((InputStream)byteImage, "image");
            dresource.setDownloadName(fileName);
            return dservice.getDownloadLink(dservice.addDownloadResource((DownloadResource)dresource));
        }
        return null;
    }

    private String getFileSource(FileAttachment attachment) throws Exception {
        DownloadService dservice = (DownloadService)this.getApplicationComponent(DownloadService.class);
        try {
            InputStream input = attachment.getInputStream();
            String fileName = attachment.getName();
            return this.getFileSource(input, fileName, dservice);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setQuestionView(String questionid) {
        this.questionView_ = questionid;
    }

    public String getCategoryId() {
        return this.categoryId_;
    }

    public void setCategoryId(String categoryId) throws Exception {
        this.categoryId_ = categoryId;
        this.setListObject();
        this.setIsNotChangeLanguage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getQuestionRelationById(String questionId) {
        Question question = new Question();
        SessionProvider sessionProvider = FAQUtils.getSystemProvider();
        try {
            question = faqService_.getQuestionById(questionId, sessionProvider);
            if (question != null) {
                String string = question.getCategoryId() + "/" + question.getId() + "/" + question.getQuestion();
                return string;
            }
            String string = "";
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            sessionProvider.close();
            String string = "";
            return string;
        }
        finally {
            sessionProvider.close();
        }
    }

    public void moveDownUp(Event<UIQuestions> event, int i) {
        Category cate;
        String categoryId = event.getRequestContext().getRequestParameter("objectId");
        int index = 0;
        Iterator i$ = this.categories_.iterator();
        while (i$.hasNext() && !(cate = (Category)i$.next()).getId().equals(categoryId)) {
            ++index;
        }
        if (index < 0) {
            return;
        }
        if (index == 0 && i == -1) {
            return;
        }
        if (index == this.categories_.size() - 1 && i == 1) {
            return;
        }
        Category category = (Category)this.categories_.remove(index);
        for (Category cate2 : this.categories_) {
        }
        this.categories_.add(index + i, category);
    }

    private String getBackPath() {
        return this.backPath_;
    }

    public List<Watch> getListWatch(String categoryId) throws Exception {
        FAQService faqService = (FAQService)PortalContainer.getInstance().getComponentInstanceOfType(FAQService.class);
        SessionProvider sessionProvider = FAQUtils.getSystemProvider();
        this.watchList_ = faqService.getListMailInWatch(categoryId, sessionProvider);
        sessionProvider.close();
        return this.watchList_;
    }

    public void setListWatch(List<Watch> list) {
        this.watchList_ = list;
    }

    public void setPath(String s) {
        newPath_ = s;
    }

    public String getPathService(String categoryId) throws Exception {
        String oldPath = "";
        String path = "FAQService";
        if (categoryId != null && !categoryId.equals("null")) {
            SessionProvider sessionProvider = FAQUtils.getSystemProvider();
            List listPath = faqService_.getCategoryPath(sessionProvider, categoryId);
            sessionProvider.close();
            for (int i = listPath.size() - 1; i >= 0; --i) {
                oldPath = oldPath + "/" + (String)listPath.get(i);
            }
            path = path + oldPath;
            oldPath = path.substring(0, path.lastIndexOf("/"));
        } else {
            oldPath = path;
        }
        return oldPath;
    }

    public String cutCaret(String name) {
        StringBuffer string = new StringBuffer();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == '/') continue;
            string.append(c);
        }
        return string.toString();
    }

    public String getLink() {
        return this.link_;
    }

    public void setLink(String link) {
        this.link_ = link;
    }

    private List<Category> getSubCategories(String cateId) {
        SessionProvider sProvider = FAQUtils.getSystemProvider();
        ArrayList<Category> listCategories = new ArrayList();
        try {
            listCategories = faqService_.getSubCategories(cateId, sProvider, this.faqSetting_);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        sProvider.close();
        return listCategories;
    }

    private List<Question> getListSubQuestion(String cateId) {
        SessionProvider sessionProvider = FAQUtils.getSystemProvider();
        List<Object> listQuestions = new ArrayList<Question>();
        try {
            listQuestions = faqService_.getQuestionsByCatetory(cateId, sessionProvider, this.faqSetting_).getAll();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        sessionProvider.close();
        return listQuestions;
    }

    private List<Category> getAllSubCategory(String categoryId) throws Exception {
        ArrayList<Category> listResult = new ArrayList<Category>();
        Stack<Category> stackCate = new Stack<Category>();
        SessionProvider sessionProvider = FAQUtils.getSystemProvider();
        Category cate = null;
        listResult.add(faqService_.getCategoryById(categoryId, sessionProvider));
        for (Category category : faqService_.getSubCategories(categoryId, sessionProvider, this.faqSetting_)) {
            stackCate.push(category);
        }
        while (!stackCate.isEmpty()) {
            cate = (Category)stackCate.pop();
            listResult.add(cate);
            for (Category category : faqService_.getSubCategories(cate.getId(), sessionProvider, this.faqSetting_)) {
                stackCate.push(category);
            }
        }
        sessionProvider.close();
        return listResult;
    }

    static /* synthetic */ FAQService access$000() {
        return faqService_;
    }

    static /* synthetic */ FAQSetting access$100(UIQuestions x0) {
        return x0.faqSetting_;
    }

    static /* synthetic */ boolean access$200(UIQuestions x0) {
        return x0.canEditQuestion;
    }

    static /* synthetic */ String access$302(UIQuestions x0, String x1) {
        x0.categoryId_ = x1;
        return x0.categoryId_;
    }

    static /* synthetic */ boolean access$402(UIQuestions x0, boolean x1) {
        x0.viewAuthorInfor = x1;
        return x0.viewAuthorInfor;
    }

    static /* synthetic */ List access$500(UIQuestions x0, String x1) throws Exception {
        return x0.getAllSubCategory(x1);
    }

    static /* synthetic */ String access$602(String x0) {
        language_ = x0;
        return language_;
    }

    static /* synthetic */ String access$300(UIQuestions x0) {
        return x0.categoryId_;
    }

    static /* synthetic */ List access$700(UIQuestions x0) {
        return x0.listCateId_;
    }

    static /* synthetic */ String access$600() {
        return language_;
    }
}

