/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.webui.popup;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.faq.service.Category;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.FAQSetting;
import org.exoplatform.faq.service.Question;
import org.exoplatform.faq.webui.FAQUtils;
import org.exoplatform.faq.webui.popup.UIMoveQuestionForm;
import org.exoplatform.faq.webui.popup.UIPopupComponent;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.UIForm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/faq/webui/popup/UIMoveQuestionForm.gtmpl", events={@EventConfig(listeners={OkActionListener.class}), @EventConfig(listeners={CancelActionListener.class})})
public class UIMoveQuestionForm
extends UIForm
implements UIPopupComponent {
    private String link = "";
    private String questionId_ = new String();
    private String categoryId_;
    private FAQSetting faqSetting_;
    private List<Cate> listCate = new ArrayList();
    private static FAQService faqService_ = (FAQService)PortalContainer.getInstance().getComponentInstanceOfType(FAQService.class);

    public String getCategoryID() {
        return this.categoryId_;
    }

    public void setCategoryID(String s) {
        this.categoryId_ = s;
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public List<Cate> getListCate() {
        return this.listCate;
    }

    private void setLink(String url) {
        this.link = url;
    }

    public void setQuestionId(String questionId) throws Exception {
        this.questionId_ = questionId;
        SessionProvider sessionProvider = FAQUtils.getSystemProvider();
        Question question = faqService_.getQuestionById(this.questionId_, sessionProvider);
        this.categoryId_ = question.getCategoryId();
        sessionProvider.close();
    }

    public void setFAQSetting(FAQSetting faqSetting) {
        this.faqSetting_ = faqSetting;
        String orderType = faqSetting.getOrderType();
        if (orderType.equals("asc")) {
            faqSetting.setOrderType("desc");
        } else {
            faqSetting.setOrderType("asc");
        }
    }

    public void setListCate() throws Exception {
        ArrayList<Cate> listCate = new ArrayList<Cate>();
        Cate parentCate = null;
        Cate childCate = null;
        SessionProvider sessionProvider = FAQUtils.getSystemProvider();
        for (Category category : faqService_.getSubCategories(null, sessionProvider, this.faqSetting_)) {
            if (category == null) continue;
            Cate cate = new Cate(this);
            cate.setCategory(category);
            cate.setDeft(0);
            listCate.add(cate);
        }
        while (!listCate.isEmpty()) {
            parentCate = new Cate(this);
            parentCate = (Cate)listCate.get(listCate.size() - 1);
            listCate.remove(parentCate);
            this.listCate.add(parentCate);
            for (Category category : faqService_.getSubCategories(parentCate.getCategory().getId(), sessionProvider, this.faqSetting_)) {
                if (category == null) continue;
                childCate = new Cate(this);
                childCate.setCategory(category);
                childCate.setDeft(parentCate.getDeft() + 1);
                listCate.add(childCate);
            }
        }
        String orderType = this.faqSetting_.getOrderType();
        if (orderType.equals("asc")) {
            this.faqSetting_.setOrderType("desc");
        } else {
            this.faqSetting_.setOrderType("asc");
        }
        sessionProvider.close();
    }

    public List<Question> getQuestions(String cateId) {
        try {
            SessionProvider sessionProvider = FAQUtils.getSystemProvider();
            List list = faqService_.getQuestionsByCatetory(cateId, sessionProvider, this.faqSetting_).getAll();
            sessionProvider.close();
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static /* synthetic */ FAQService access$000() {
        return faqService_;
    }

    static /* synthetic */ String access$100(UIMoveQuestionForm x0) {
        return x0.questionId_;
    }

    static /* synthetic */ String access$200(UIMoveQuestionForm x0) {
        return x0.link;
    }

    static /* synthetic */ FAQSetting access$300(UIMoveQuestionForm x0) {
        return x0.faqSetting_;
    }
}

