/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.webui.popup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.faq.service.EmailNotifyPlugin;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.Question;
import org.exoplatform.faq.service.QuestionLanguage;
import org.exoplatform.faq.webui.FAQUtils;
import org.exoplatform.faq.webui.popup.UIPopupComponent;
import org.exoplatform.faq.webui.popup.UISendMailForm;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.organization.User;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormWYSIWYGInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/faq/webui/popup/UISendMailForm.gtmpl", events={@EventConfig(listeners={SendActionListener.class}), @EventConfig(listeners={CancelActionListener.class}), @EventConfig(listeners={ChangeLanguageActionListener.class})})
public class UISendMailForm
extends UIForm
implements UIPopupComponent {
    private static final String FILED_FROM_NAME = "FromName";
    private static final String FILED_FROM = "From";
    private static final String FILED_TO = "To";
    private static final String ADD_CC = "AddCc";
    private static final String ADD_BCC = "AddBcc";
    private static final String FILED_SUBJECT = "Subject";
    private static final String FILED_QUESTION_LANGUAGE = "Language";
    private static final String FILED_MESSAGE = "Message";
    public static final String FIELD_FROM_INPUT = "fromInput";
    private static final String MIMETYPE_TEXTHTML = "text/html".intern();
    private static Map<String, String> serverConfig_ = new HashMap();
    private List<SelectItemOption<String>> listLanguageToReponse = new ArrayList();
    private List<QuestionLanguage> listQuestionLanguage = new ArrayList();
    private String languageIsResponsed = "";
    private static FAQService faqService_ = (FAQService)PortalContainer.getInstance().getComponentInstanceOfType(FAQService.class);
    private String questionChanged_ = new String();
    private String link_ = "";
    public List<User> toUsers = new ArrayList();
    public List<User> addCCUsers = new ArrayList();
    public List<User> addBCCUsers = new ArrayList();
    private int posOfResponse = 0;

    public UISendMailForm() throws Exception {
        this.setActions(new String[]{"Send", "Cancel"});
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public String getLink() {
        return this.link_;
    }

    public void setLink(String link) {
        this.link_ = link;
    }

    private List<SelectItemOption<String>> getListLanguageToSendFriend() {
        return this.listLanguageToReponse;
    }

    public void addPlugin(ComponentPlugin plugin) throws Exception {
        try {
            serverConfig_ = ((EmailNotifyPlugin)plugin).getServerConfiguration();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setUpdateQuestion(String questionId, String language) throws Exception {
        SessionProvider sessionProvider = FAQUtils.getSystemProvider();
        Question question = FAQUtils.getFAQService().getQuestionById(questionId, sessionProvider);
        if (language.equals("")) {
            language = question.getLanguage();
        }
        String email = "";
        String name = "";
        String userName = FAQUtils.getCurrentUser();
        if (!FAQUtils.isFieldEmpty((String)userName)) {
            name = FAQUtils.getFullName((String)userName);
            email = FAQUtils.getEmailUser((String)userName);
        }
        String quest = question.getQuestion().replaceAll("\n", "<br>").replaceAll("'", "&#39;");
        this.languageIsResponsed = question.getLanguage();
        QuestionLanguage questionLanguage = new QuestionLanguage();
        questionLanguage.setLanguage(question.getLanguage());
        questionLanguage.setQuestion(quest);
        questionLanguage.setResponse(question.getAllResponses());
        this.listQuestionLanguage.add(questionLanguage);
        for (QuestionLanguage questionLanguage2 : faqService_.getQuestionLanguages(questionId, sessionProvider)) {
            String quest2 = questionLanguage2.getQuestion().replaceAll("\n", "<br>").replaceAll("'", "&#39;");
            questionLanguage2.setQuestion(quest2);
            this.listQuestionLanguage.add(questionLanguage2);
        }
        sessionProvider.close();
        this.questionChanged_ = question.getQuestion();
        for (QuestionLanguage quesLanguage : this.listQuestionLanguage) {
            this.listLanguageToReponse.add(new SelectItemOption(quesLanguage.getLanguage(), (Object)quesLanguage.getLanguage()));
        }
        this.addChild((UIComponent)new UIFormStringInput(FILED_FROM_NAME, FILED_FROM_NAME, name));
        this.addChild((UIComponent)new UIFormStringInput(FILED_FROM, FILED_FROM, email));
        this.addChild((UIComponent)new UIFormStringInput(FILED_TO, FILED_TO, null));
        this.addChild((UIComponent)new UIFormStringInput(ADD_CC, ADD_CC, null));
        this.addChild((UIComponent)new UIFormStringInput(ADD_BCC, ADD_BCC, null));
        UIFormSelectBox questionLanguages = new UIFormSelectBox(FILED_QUESTION_LANGUAGE, FILED_QUESTION_LANGUAGE, this.getListLanguageToSendFriend());
        questionLanguages.setSelectedValues(new String[]{language});
        questionLanguages.setOnChange("ChangeLanguage");
        this.addChild((UIComponent)questionLanguages);
        String content = "";
        String contenQuestion = "";
        for (QuestionLanguage questionLangua : this.listQuestionLanguage) {
            if (!questionLangua.getLanguage().equals(language)) continue;
            contenQuestion = questionLangua.getQuestion();
            String[] response = questionLangua.getResponse();
            if (response[this.posOfResponse].equals(" ")) {
                content = this.getLabel("change-content1") + this.getLabel("change-content2") + "<p><b>" + this.getLabel("Question") + "</b> " + contenQuestion + "</p>" + "<p>" + this.getLabel("Link1") + "<a href =" + this.link_ + ">" + this.getLabel("Link2") + "</a>" + this.getLabel("Link3") + "</p>";
                continue;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getLabel("change-content1")).append(this.getLabel("change-content2")).append("<p><b>").append(this.getLabel("Question")).append("</b> " + contenQuestion + "</p>").append("<p><b>" + this.getLabel("Response") + "</b> ");
            for (String res : response) {
                stringBuffer.append(res + "</p>");
            }
            stringBuffer.append("<p>" + this.getLabel("Link1") + "<a href =" + this.link_ + ">" + this.getLabel("Link2") + "</a>" + this.getLabel("Link3") + "</p>");
            content = stringBuffer.toString();
        }
        this.addChild((UIComponent)new UIFormStringInput(FILED_SUBJECT, FILED_SUBJECT, this.getLabel("change-title") + " " + contenQuestion.replaceAll("<br>", " ")));
        this.addChild((UIComponent)new UIFormWYSIWYGInput(FILED_MESSAGE, null, content, true));
    }

    static /* synthetic */ Map access$000() {
        return serverConfig_;
    }

    static /* synthetic */ String access$100() {
        return MIMETYPE_TEXTHTML;
    }

    static /* synthetic */ FAQService access$200() {
        return faqService_;
    }

    static /* synthetic */ List access$300(UISendMailForm x0) {
        return x0.listQuestionLanguage;
    }

    static /* synthetic */ String access$402(UISendMailForm x0, String x1) {
        x0.languageIsResponsed = x1;
        return x0.languageIsResponsed;
    }

    static /* synthetic */ int access$500(UISendMailForm x0) {
        return x0.posOfResponse;
    }
}

