/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.webui;

import java.io.IOException;
import java.io.InputStream;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.services.jcr.ext.common.SessionProvider;

public class IFAQServlet
extends HttpServlet {
    public void init(ServletConfig config) throws ServletException {
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setHeader("Cache-Control", "private max-age=600, s-maxage=120");
        String pathInfo = request.getPathInfo();
        String[] arrayInfo = pathInfo.toString().split("/");
        Session session = null;
        try {
            String portalName = arrayInfo[1];
            String categoryId = arrayInfo[2];
            PortalContainer pcontainer = this.getPortalContainer(portalName);
            PortalContainer.setInstance((PortalContainer)pcontainer);
            FAQService faqService = (FAQService)pcontainer.getComponentInstanceOfType(FAQService.class);
            SessionProvider sessionProvider = SessionProviderFactory.createSystemProvider();
            Node node = faqService.getRSSNode(sessionProvider, categoryId);
            sessionProvider.close();
            if (node == null) {
                throw new Exception("Node not found. ");
            }
            session = node.getSession();
            response.setContentType("text/xml");
            InputStream is = node.getProperty("exo:content").getStream();
            byte[] buf = new byte[is.available()];
            is.read(buf);
            ServletOutputStream os = response.getOutputStream();
            os.write(buf);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            if (session != null) {
                session.logout();
                PortalContainer.setInstance(null);
            }
        }
    }

    private PortalContainer getPortalContainer(String portalName) {
        PortalContainer pcontainer = RootContainer.getInstance().getPortalContainer(portalName);
        return pcontainer;
    }
}

