/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.webui.popup;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.jcr.Session;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.webui.FAQUtils;
import org.exoplatform.faq.webui.popup.UIImportForm;
import org.exoplatform.faq.webui.popup.UIPopupComponent;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormUploadInput;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/faq/webui/popup/UIImportForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class})})
public class UIImportForm
extends UIForm
implements UIPopupComponent {
    private final String FILE_UPLOAD = "FileUpload";
    private String categoryId_ = new String();

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public UIImportForm() {
        int sizeLimit = FAQUtils.getLimitUploadSize();
        if (sizeLimit >= 0) {
            this.addChild((UIComponent)new UIFormUploadInput("FileUpload", "FileUpload", sizeLimit));
        } else {
            this.addChild((UIComponent)new UIFormUploadInput("FileUpload", "FileUpload"));
        }
    }

    public void setCategoryId(String categoryId) {
        this.categoryId_ = categoryId;
    }

    private boolean impotFromZipFile(ZipInputStream zipStream, Session session, FAQService service, SessionProvider sProvider) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] data = new byte[5120];
        ZipEntry entry = zipStream.getNextEntry();
        ByteArrayInputStream inputStream = null;
        while (entry != null) {
            out = new ByteArrayOutputStream();
            int available = -1;
            while ((available = zipStream.read(data, 0, 1024)) > -1) {
                out.write(data, 0, available);
            }
            zipStream.closeEntry();
            out.close();
            if (entry.getName().indexOf("Category") >= 0) {
                inputStream = new ByteArrayInputStream(out.toByteArray());
                DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
                Document doc = docBuilder.parse(inputStream);
                NodeList list = doc.getChildNodes();
                String categoryId = list.item(0).getAttributes().getNamedItem("sv:name").getTextContent();
                if (service.categoryAlreadyExist(categoryId, sProvider)) {
                    return false;
                }
            }
            inputStream = new ByteArrayInputStream(out.toByteArray());
            if (entry.getName().indexOf("Question") < 0) {
                service.importData(this.categoryId_, session, (InputStream)inputStream, true, sProvider);
            } else {
                service.importData(null, session, (InputStream)inputStream, false, sProvider);
            }
            entry = zipStream.getNextEntry();
        }
        zipStream.close();
        sProvider.close();
        return true;
    }

    static /* synthetic */ String access$000(UIImportForm x0) {
        return x0.categoryId_;
    }

    static /* synthetic */ boolean access$100(UIImportForm x0, ZipInputStream x1, Session x2, FAQService x3, SessionProvider x4) throws Exception {
        return x0.impotFromZipFile(x1, x2, x3, x4);
    }
}

