/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.webui.popup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.faq.service.Answer;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.FAQSetting;
import org.exoplatform.faq.service.Question;
import org.exoplatform.faq.service.QuestionLanguage;
import org.exoplatform.faq.webui.FAQUtils;
import org.exoplatform.faq.webui.popup.UIPopupComponent;
import org.exoplatform.faq.webui.popup.UIResponseForm;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.wysiwyg.UIFormWYSIWYGInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/faq/webui/popup/UIResponseForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}), @EventConfig(listeners={AddRelationActionListener.class}), @EventConfig(listeners={RemoveRelationActionListener.class}), @EventConfig(listeners={ChangeQuestionActionListener.class})})
public class UIResponseForm
extends UIForm
implements UIPopupComponent {
    private static final String QUESTION_LANGUAGE = "Language";
    private static final String RESPONSE_CONTENT = "QuestionRespone";
    private static final String SHOW_ANSWER = "QuestionShowAnswer";
    private static final String IS_APPROVED = "IsApproved";
    private static Question question_ = null;
    private Answer answer_ = null;
    private static FAQService faqService = (FAQService)PortalContainer.getInstance().getComponentInstanceOfType(FAQService.class);
    private String questionDetail = new String();
    private String questionContent = new String();
    private UIFormSelectBox questionLanguages_;
    private UIFormWYSIWYGInput inputResponseQuestion_;
    private UIFormCheckBoxInput checkShowAnswer_;
    private UIFormCheckBoxInput<Boolean> isApproved_;
    public String questionId_ = new String();
    private List<String> listRelationQuestion = new ArrayList();
    private List<String> listQuestIdRela = new ArrayList();
    Map<String, Answer> mapAnswers = new HashMap();
    private List<SelectItemOption<String>> listLanguageToReponse = new ArrayList();
    private String questionChanged_ = new String();
    private String responseContent_ = new String();
    private String languageIsResponsed = "";
    private String link_ = "";
    private boolean isChildren_ = false;
    private FAQSetting faqSetting_;
    private boolean cateIsApprovedAnswer_ = true;
    private long currentDate = new Date().getTime();

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public String getLink() {
        return this.link_;
    }

    public void setLink(String link) {
        this.link_ = link;
    }

    public void setFAQSetting(FAQSetting faqSetting) {
        this.faqSetting_ = faqSetting;
    }

    public UIResponseForm() throws Exception {
        this.inputResponseQuestion_ = new UIFormWYSIWYGInput(RESPONSE_CONTENT, RESPONSE_CONTENT, "");
        this.checkShowAnswer_ = new UIFormCheckBoxInput(SHOW_ANSWER, SHOW_ANSWER, (Object)false);
        this.isApproved_ = new UIFormCheckBoxInput(IS_APPROVED, IS_APPROVED, (Object)false);
        this.setActions(new String[]{"Save", "Cancel"});
    }

    private void setListRelation() throws Exception {
        String[] relations = question_.getRelations();
        this.setListIdQuesRela(Arrays.asList(relations));
        if (relations != null && relations.length > 0) {
            SessionProvider sessionProvider = FAQUtils.getSystemProvider();
            for (String relation : relations) {
                this.listRelationQuestion.add(faqService.getQuestionById(relation, sessionProvider).getQuestion());
            }
            sessionProvider.close();
        }
    }

    public void setAnswerInfor(Question question, Answer answer, String language) {
        this.setQuestionId(question, language, answer.getApprovedAnswers().booleanValue());
        this.answer_ = answer;
        this.inputResponseQuestion_.setValue((Object)answer.getResponses());
        this.questionLanguages_.setDisabled(true);
        this.questionLanguages_.setOnChange("");
    }

    public void setQuestionId(Question question, String languageViewed, boolean cateIsApprovedAnswer) {
        this.cateIsApprovedAnswer_ = cateIsApprovedAnswer;
        SessionProvider sessionProvider = FAQUtils.getSystemProvider();
        try {
            this.questionDetail = question.getDetail();
            this.questionContent = question.getQuestion();
            if (this.listQuestIdRela != null && !this.listQuestIdRela.isEmpty()) {
                this.listRelationQuestion.clear();
                this.listQuestIdRela.clear();
            }
            question_ = question;
            this.languageIsResponsed = languageViewed != null && languageViewed.trim().length() > 0 ? languageViewed : question.getLanguage();
            this.setListRelation(sessionProvider);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.questionId_ = question.getId();
        this.listLanguageToReponse.add(new SelectItemOption(question.getLanguage() + " ( default) ", (Object)question.getLanguage()));
        try {
            for (QuestionLanguage language : faqService.getQuestionLanguages(this.questionId_, sessionProvider)) {
                if (language.getLanguage().equals(this.languageIsResponsed)) {
                    this.questionDetail = language.getDetail();
                    this.questionContent = language.getQuestion();
                }
                this.listLanguageToReponse.add(new SelectItemOption(language.getLanguage(), (Object)language.getLanguage()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.checkShowAnswer_.setChecked(question_.isActivated());
        this.isApproved_.setChecked(question_.isApproved());
        this.questionLanguages_ = new UIFormSelectBox(QUESTION_LANGUAGE, QUESTION_LANGUAGE, this.getListLanguageToReponse());
        this.questionLanguages_.setSelectedValues(new String[]{this.languageIsResponsed});
        this.questionLanguages_.setOnChange("ChangeQuestion");
        this.addChild((UIComponent)this.inputResponseQuestion_);
        this.addChild((UIComponent)this.questionLanguages_);
        this.addChild((UIComponent)this.isApproved_);
        this.addChild((UIComponent)this.checkShowAnswer_);
        sessionProvider.close();
    }

    private String getValue(String id) {
        if (id.equals("QuestionTitle")) {
            return this.questionContent;
        }
        return this.questionDetail;
    }

    private String getLanguageIsResponse() {
        return this.languageIsResponsed;
    }

    private void setListRelation(SessionProvider sessionProvider) throws Exception {
        String[] relations = question_.getRelations();
        this.setListIdQuesRela(Arrays.asList(relations));
        if (relations != null && relations.length > 0) {
            for (String relation : relations) {
                this.listRelationQuestion.add(faqService.getQuestionById(relation, sessionProvider).getQuestion());
            }
        }
    }

    public List<String> getListRelation() {
        return this.listRelationQuestion;
    }

    private List<SelectItemOption<String>> getListLanguageToReponse() {
        return this.listLanguageToReponse;
    }

    public List<String> getListIdQuesRela() {
        return this.listQuestIdRela;
    }

    public void setListIdQuesRela(List<String> listId) {
        if (!this.listQuestIdRela.isEmpty()) {
            this.listQuestIdRela.clear();
        }
        this.listQuestIdRela.addAll(listId);
    }

    public void setListRelationQuestion(List<String> listQuestionContent) {
        this.listRelationQuestion.clear();
        this.listRelationQuestion.addAll(listQuestionContent);
    }

    private List<String> getListRelationQuestion() {
        return this.listRelationQuestion;
    }

    public void setIsChildren(boolean isChildren) {
        this.isChildren_ = isChildren;
        this.removeChildById(RESPONSE_CONTENT);
        this.removeChildById(QUESTION_LANGUAGE);
        this.removeChildById(IS_APPROVED);
        this.removeChildById(SHOW_ANSWER);
        this.inputResponseQuestion_.setValue((Object)"");
        this.listLanguageToReponse.clear();
        this.listQuestIdRela.clear();
        this.listRelationQuestion.clear();
    }

    private boolean compareTowArraies(String[] array1, String[] array2) {
        ArrayList<String> list1 = new ArrayList<String>();
        list1.addAll(Arrays.asList(array1));
        int count = 0;
        for (String str : array2) {
            if (!list1.contains(str)) continue;
            ++count;
        }
        return count == array1.length && count == array2.length;
    }

    private double[] getMarkVoteAnswer(List<Double> listMarkResponse) {
        double[] markVoteResponse = new double[listMarkResponse.size()];
        int i = 0;
        for (Double d : listMarkResponse) {
            markVoteResponse[i++] = d;
        }
        return markVoteResponse;
    }

    public String getPathService(String categoryId) throws Exception {
        String oldPath = "";
        String path = "FAQService";
        if (categoryId != null && !categoryId.equals("null")) {
            SessionProvider sessionProvider = FAQUtils.getSystemProvider();
            List listPath = FAQUtils.getFAQService().getCategoryPath(sessionProvider, categoryId);
            sessionProvider.close();
            for (int i = listPath.size() - 1; i >= 0; --i) {
                oldPath = oldPath + "/" + (String)listPath.get(i);
            }
            path = path + oldPath;
            oldPath = path.substring(0, path.lastIndexOf("/"));
        } else {
            oldPath = path;
        }
        return oldPath;
    }

    private void updateDiscussForum(String linkForum, String url, SessionProvider sessionProvider) throws Exception {
        ForumService forumService;
        Topic topic;
        String topicId;
        if (this.faqSetting_.getIsDiscussForum() && (topicId = question_.getTopicIdDiscuss()) != null && topicId.length() > 0 && (topic = (Topic)(forumService = (ForumService)PortalContainer.getInstance().getComponentInstanceOfType(ForumService.class)).getObjectNameById(sessionProvider, topicId, Utils.TOPIC)) != null) {
            String[] ids = topic.getPath().split("/");
            int t = ids.length;
            System.out.println("\n\n ======> " + ids[t - 3] + " / " + ids[t - 2] + " / " + topicId);
            linkForum = linkForum.replaceFirst("OBJECTID", topicId);
            linkForum = url + linkForum;
            int l = question_.getAnswers().length;
            for (int i = 0; i < l; ++i) {
                String postId = question_.getAnswers()[i].getPostId();
                try {
                    Post post;
                    if (postId != null && postId.length() > 0) {
                        post = forumService.getPost(sessionProvider, ids[t - 3], ids[t - 2], topicId, postId);
                        if (post == null) {
                            post = new Post();
                            post.setOwner(question_.getAnswers()[i].getResponseBy());
                            post.setName("Re: " + question_.getQuestion());
                            post.setIcon("ViewIcon");
                            question_.getAnswers()[i].setPostId(post.getId());
                            post.setMessage(question_.getAnswers()[i].getResponses());
                            post.setLink(linkForum);
                            post.setIsApproved(false);
                            forumService.savePost(sessionProvider, ids[t - 3], ids[t - 2], topicId, post, true, "");
                            continue;
                        }
                        post.setMessage(question_.getAnswers()[i].getResponses());
                        forumService.savePost(sessionProvider, ids[t - 3], ids[t - 2], topicId, post, false, "");
                        continue;
                    }
                    post = new Post();
                    post.setOwner(question_.getAnswers()[i].getResponseBy());
                    post.setName("Re: " + question_.getQuestion());
                    post.setIcon("ViewIcon");
                    post.setMessage(question_.getAnswers()[i].getResponses());
                    post.setLink(linkForum);
                    post.setIsApproved(false);
                    forumService.savePost(sessionProvider, ids[t - 3], ids[t - 2], topicId, post, true, "");
                    question_.getAnswers()[i].setPostId(post.getId());
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    static /* synthetic */ UIFormWYSIWYGInput access$000(UIResponseForm x0) {
        return x0.inputResponseQuestion_;
    }

    static /* synthetic */ String access$100(UIResponseForm x0) {
        return x0.languageIsResponsed;
    }

    static /* synthetic */ Answer access$200(UIResponseForm x0) {
        return x0.answer_;
    }

    static /* synthetic */ boolean access$300(UIResponseForm x0) {
        return x0.cateIsApprovedAnswer_;
    }

    static /* synthetic */ Question access$400() {
        return question_;
    }

    static /* synthetic */ FAQService access$500() {
        return faqService;
    }

    static /* synthetic */ FAQSetting access$600(UIResponseForm x0) {
        return x0.faqSetting_;
    }

    static /* synthetic */ void access$700(UIResponseForm x0, String x1, String x2, SessionProvider x3) throws Exception {
        x0.updateDiscussForum(x1, x2, x3);
    }

    static /* synthetic */ boolean access$800(UIResponseForm x0) {
        return x0.isChildren_;
    }

    static /* synthetic */ List access$900(UIResponseForm x0) {
        return x0.listQuestIdRela;
    }

    static /* synthetic */ List access$1000(UIResponseForm x0) {
        return x0.listRelationQuestion;
    }

    static /* synthetic */ UIFormSelectBox access$1100(UIResponseForm x0) {
        return x0.questionLanguages_;
    }

    static /* synthetic */ String access$102(UIResponseForm x0, String x1) {
        x0.languageIsResponsed = x1;
        return x0.languageIsResponsed;
    }

    static /* synthetic */ String access$1202(UIResponseForm x0, String x1) {
        x0.questionDetail = x1;
        return x0.questionDetail;
    }

    static /* synthetic */ String access$1302(UIResponseForm x0, String x1) {
        x0.questionContent = x1;
        return x0.questionContent;
    }
}

