/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.webui.popup;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.jcr.Node;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.faq.service.Category;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.FAQSetting;
import org.exoplatform.faq.service.Question;
import org.exoplatform.faq.webui.FAQUtils;
import org.exoplatform.faq.webui.popup.UIAddRelationForm;
import org.exoplatform.faq.webui.popup.UIPopupComponent;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/faq/webui/popup/UIAddRelationForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class})})
public class UIAddRelationForm
extends UIForm
implements UIPopupComponent {
    private String homeCategoryName = "";
    private List<Question> listQuestion = new ArrayList();
    private List<String> quesIdsSelect = new ArrayList();
    private String questionId_;
    private FAQSetting faqSetting_ = new FAQSetting();
    private static List<String> listCateSelected = new ArrayList();
    private List<Cate> listCate = new ArrayList();
    private static FAQService faqService = (FAQService)PortalContainer.getInstance().getComponentInstanceOfType(FAQService.class);

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    private List<Cate> getListCate() {
        return this.listCate;
    }

    public UIAddRelationForm() throws Exception {
        this.setActions(new String[]{"Save", "Cancel"});
        FAQUtils.getPorletPreference((FAQSetting)this.faqSetting_);
        SessionProvider sessionProvider = FAQUtils.getSystemProvider();
        faqService.getUserSetting(sessionProvider, FAQUtils.getCurrentUser(), this.faqSetting_);
        Node homeNode = faqService.getCategoryNodeById(null, sessionProvider);
        if (homeNode.hasProperty("exo:name")) {
            this.homeCategoryName = homeNode.getProperty("exo:name").getString();
        } else {
            WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
            ResourceBundle res = context.getApplicationResourceBundle();
            this.homeCategoryName = res.getString("UIAddRelationForm.title.RootCategory");
        }
        sessionProvider.close();
        this.setListCate();
    }

    public void setFAQSetting(FAQSetting faqSetting) {
        this.faqSetting_ = faqSetting;
    }

    public void setRelationed(List<String> listRelation) {
        this.quesIdsSelect = listRelation;
        try {
            this.initPage();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setQuestionId(String questionId) {
        this.questionId_ = questionId;
    }

    private void initPage() throws Exception {
        SessionProvider sessionProvider = FAQUtils.getSystemProvider();
        this.listQuestion = faqService.getAllQuestions(sessionProvider).getAll();
        for (Question question : this.listQuestion) {
            UIFormCheckBoxInput checkQuestion = this.quesIdsSelect.contains(question.getId()) ? new UIFormCheckBoxInput(question.getId(), question.getId(), (Object)false).setChecked(true) : new UIFormCheckBoxInput(question.getId(), question.getId(), (Object)false);
            if (question.getId().equals(this.questionId_)) {
                checkQuestion.setEnable(false);
            }
            this.addChild((UIComponent)checkQuestion);
        }
        sessionProvider.close();
    }

    private void setListCate() throws Exception {
        ArrayList<Cate> listCate = new ArrayList<Cate>();
        Cate parentCate = null;
        Cate childCate = null;
        SessionProvider sessionProvider = FAQUtils.getSystemProvider();
        for (Category category : faqService.getSubCategories(null, sessionProvider, this.faqSetting_)) {
            if (category == null) continue;
            Cate cate = new Cate(this);
            cate.setCategory(category);
            cate.setDeft(0);
            listCate.add(cate);
        }
        while (!listCate.isEmpty()) {
            parentCate = new Cate(this);
            parentCate = (Cate)listCate.get(0);
            listCate.remove(0);
            this.listCate.add(parentCate);
            int i = 0;
            for (Category category : faqService.getSubCategories(parentCate.getCategory().getId(), sessionProvider, this.faqSetting_)) {
                if (category == null) continue;
                childCate = new Cate(this);
                childCate.setCategory(category);
                childCate.setDeft(parentCate.getDeft() + 1);
                listCate.add(i++, childCate);
            }
        }
        sessionProvider.close();
    }

    private List<Question> getQuestions(String cateId) {
        SessionProvider sessionProvider = FAQUtils.getSystemProvider();
        try {
            List listQues = faqService.getQuestionsByCatetory(cateId, sessionProvider, this.faqSetting_).getAll();
            sessionProvider.close();
            return listQues;
        }
        catch (Exception e) {
            e.printStackTrace();
            sessionProvider.close();
            return null;
        }
    }

    static /* synthetic */ List access$000(UIAddRelationForm x0) {
        return x0.listQuestion;
    }

    static /* synthetic */ FAQService access$100() {
        return faqService;
    }
}

