/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.webui.popup;

import javax.jcr.Node;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.faq.service.Comment;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.FAQSetting;
import org.exoplatform.faq.service.Question;
import org.exoplatform.faq.service.QuestionLanguage;
import org.exoplatform.faq.service.impl.MultiLanguages;
import org.exoplatform.faq.webui.FAQUtils;
import org.exoplatform.faq.webui.popup.UICommentForm;
import org.exoplatform.faq.webui.popup.UIPopupComponent;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.wysiwyg.UIFormWYSIWYGInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/faq/webui/popup/UICommentForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class})})
public class UICommentForm
extends UIForm
implements UIPopupComponent {
    private String languageSelected = null;
    private Question question_ = new Question();
    private Comment comment = new Comment();
    private String questionContent = new String();
    private String questionDetail = new String();
    private String currentUser_ = FAQUtils.getCurrentUser();
    private final String TITLE_USERNAME = "UserName";
    private final String COMMENT_CONTENT = "CommentContent";
    private boolean isAddNew = false;
    private FAQSetting faqSetting_ = null;
    private String link_ = "";

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public UICommentForm() throws Exception {
        this.addChild((UIComponent)new UIFormStringInput("UserName", "UserName", this.currentUser_).setEditable(false));
        this.addChild((UIComponent)new UIFormWYSIWYGInput("CommentContent", "CommentContent", ""));
    }

    public String getQuestionContent() {
        return this.questionContent;
    }

    public String getQuestionDetail() {
        return this.questionDetail;
    }

    public void setInfor(Question question, String commentId, FAQSetting faqSetting, String languageView) throws Exception {
        this.languageSelected = languageView.trim().length() > 0 ? languageView : question.getLanguage();
        this.question_ = question;
        this.questionContent = question.getQuestion();
        this.questionDetail = question.getDetail();
        this.faqSetting_ = faqSetting;
        FAQUtils.getEmailSetting((FAQSetting)this.faqSetting_, (boolean)false, (boolean)false);
        FAQService faqService = (FAQService)PortalContainer.getInstance().getComponentInstanceOfType(FAQService.class);
        SessionProvider sProvider = FAQUtils.getSystemProvider();
        if (languageView.trim().length() < 1 || languageView.equals(question.getLanguage())) {
            if (!commentId.equals("new")) {
                this.comment = faqService.getCommentById(sProvider, question.getId(), commentId);
                this.isAddNew = false;
            } else {
                this.comment = new Comment();
                this.comment.setNew(true);
                this.comment.setCommentBy(FAQUtils.getCurrentUser());
                this.isAddNew = true;
            }
        } else {
            MultiLanguages multiLanguages = new MultiLanguages();
            Node questionNode = faqService.getQuestionNodeById(question.getId(), sProvider);
            QuestionLanguage questionLanguage = multiLanguages.getQuestionLanguageByLanguage(questionNode, languageView);
            this.questionContent = questionLanguage.getQuestion();
            this.questionDetail = questionLanguage.getDetail();
            if (!commentId.equals("new")) {
                this.comment = multiLanguages.getCommentById(questionNode, commentId, languageView);
                this.isAddNew = false;
            } else {
                this.comment = new Comment();
                this.comment.setNew(true);
                this.comment.setCommentBy(FAQUtils.getCurrentUser());
                this.isAddNew = true;
            }
        }
        ((UIFormWYSIWYGInput)this.getChildById("CommentContent")).setValue((Object)this.comment.getComments());
        sProvider.close();
    }

    public void setLink(String link) {
        this.link_ = link;
    }

    public String getLink() {
        return this.link_;
    }

    static /* synthetic */ Question access$002(UICommentForm x0, Question x1) {
        x0.question_ = x1;
        return x0.question_;
    }

    static /* synthetic */ Question access$000(UICommentForm x0) {
        return x0.question_;
    }

    static /* synthetic */ Comment access$100(UICommentForm x0) {
        return x0.comment;
    }

    static /* synthetic */ boolean access$200(UICommentForm x0) {
        return x0.isAddNew;
    }

    static /* synthetic */ String access$300(UICommentForm x0) {
        return x0.currentUser_;
    }

    static /* synthetic */ String access$400(UICommentForm x0) {
        return x0.languageSelected;
    }

    static /* synthetic */ FAQSetting access$500(UICommentForm x0) {
        return x0.faqSetting_;
    }
}

