/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.webui.popup;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.faq.service.Category;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.FAQSetting;
import org.exoplatform.faq.service.JCRPageList;
import org.exoplatform.faq.service.Question;
import org.exoplatform.faq.webui.FAQUtils;
import org.exoplatform.faq.webui.UIFAQPageIterator;
import org.exoplatform.faq.webui.popup.UIPopupComponent;
import org.exoplatform.faq.webui.popup.UIUserWatchManager;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.UIFormTabPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/faq/webui/popup/UIUserWatchManager.gtmpl", events={@EventConfig(listeners={LinkActionListener.class}), @EventConfig(listeners={UnWatchActionListener.class}), @EventConfig(listeners={ChangeTabActionListener.class}), @EventConfig(listeners={CancelActionListener.class})})
public class UIUserWatchManager
extends UIFormTabPane
implements UIPopupComponent {
    private FAQSetting faqSetting_ = null;
    private UIFAQPageIterator pageIteratorCate;
    private JCRPageList pageListCate;
    private UIFAQPageIterator pageIteratorQues;
    private UIFAQPageIterator pageIteratorCates;
    private JCRPageList pageListQues;
    private JCRPageList pageListCates;
    private String LIST_QUESTIONS_WATCHED = "listQuestionsWatch";
    private String LIST_CATES_WATCHED = "listCatesWatch";
    private int tabSelect = 0;
    private String emailAddress;
    private String[] tabs = new String[]{"watchCategoryTab", "watchQuestionTab"};
    private static FAQService faqService_ = (FAQService)PortalContainer.getInstance().getComponentInstanceOfType(FAQService.class);

    public UIUserWatchManager() throws Exception {
        super("UIUswerWatchManager");
        this.addChild(UIFAQPageIterator.class, null, this.LIST_QUESTIONS_WATCHED);
        this.addChild(UIFAQPageIterator.class, null, this.LIST_CATES_WATCHED);
        this.emailAddress = FAQUtils.getEmailUser((String)FAQUtils.getCurrentUser());
        this.setActions(new String[]{"Cancel"});
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public int getTabSelect() {
        return this.tabSelect;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public List<Category> getListCategory() throws Exception {
        return this.getListCategoriesWatch();
    }

    public String getPathService(String categoryId) throws Exception {
        String oldPath = "";
        SessionProvider sessionProvider = FAQUtils.getSystemProvider();
        List listPath = FAQUtils.getFAQService().getCategoryPath(sessionProvider, categoryId);
        for (int i = listPath.size() - 1; i >= 0; --i) {
            Category category = FAQUtils.getFAQService().getCategoryById((String)listPath.get(i), sessionProvider);
            oldPath = oldPath.equals("") ? category.getName() : oldPath + " > " + category.getName();
        }
        sessionProvider.close();
        return oldPath;
    }

    public static String getSubString(String str, int max) {
        int l;
        if (!FAQUtils.isFieldEmpty((String)str) && (l = str.length()) > max) {
            int comma = (str = str.substring(0, max - 3)).lastIndexOf(",");
            str = comma > 0 ? str.substring(0, comma) + "..." : str + "...";
        }
        return str;
    }

    public void setFAQSetting(FAQSetting setting) {
        this.faqSetting_ = setting;
    }

    private List<Category> getListCategoriesWatch() {
        SessionProvider sessionProvider = FAQUtils.getSystemProvider();
        try {
            if (this.pageListCates == null) {
                this.pageListCates = faqService_.getListCategoriesWatch(FAQUtils.getCurrentUser(), sessionProvider);
                this.pageListCates.setPageSize(5L);
                this.pageIteratorCates = (UIFAQPageIterator)this.getChildById(this.LIST_CATES_WATCHED);
                this.pageIteratorCates.updatePageList(this.pageListCates);
            }
            long pageSelect = this.pageIteratorCates.getPageSelected();
            ArrayList<Category> listCategories = new ArrayList<Category>();
            try {
                listCategories.addAll(this.pageListCates.getPageResultCategoriesSearch(pageSelect, null));
                if (listCategories.isEmpty()) {
                    UIFAQPageIterator pageIterator = null;
                    while (listCategories.isEmpty() && pageSelect > 1L) {
                        pageIterator = (UIFAQPageIterator)this.getChildById(this.LIST_CATES_WATCHED);
                        listCategories.addAll(this.pageListCates.getPageResultCategoriesSearch(--pageSelect, null));
                        pageIterator.setSelectPage(pageSelect);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            sessionProvider.close();
            return listCategories;
        }
        catch (Exception e) {
            e.printStackTrace();
            sessionProvider.close();
            return null;
        }
    }

    private List<Question> getListQuestionsWatch() {
        SessionProvider sessionProvider = FAQUtils.getSystemProvider();
        try {
            if (this.pageListQues == null) {
                this.pageListQues = faqService_.getListQuestionsWatch(this.faqSetting_, FAQUtils.getCurrentUser(), sessionProvider);
                this.pageListQues.setPageSize(5L);
                this.pageIteratorQues = (UIFAQPageIterator)this.getChildById(this.LIST_QUESTIONS_WATCHED);
                this.pageIteratorQues.updatePageList(this.pageListQues);
            }
            long pageSelect = this.pageIteratorQues.getPageSelected();
            ArrayList<Question> listQuestion_ = new ArrayList<Question>();
            try {
                listQuestion_.addAll(this.pageListQues.getPage(pageSelect, null));
                if (listQuestion_.isEmpty()) {
                    UIFAQPageIterator pageIterator = null;
                    while (listQuestion_.isEmpty() && pageSelect > 1L) {
                        pageIterator = (UIFAQPageIterator)this.getChildById(this.LIST_QUESTIONS_WATCHED);
                        listQuestion_.addAll(this.pageListQues.getPage(--pageSelect, null));
                        pageIterator.setSelectPage(pageSelect);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            sessionProvider.close();
            return listQuestion_;
        }
        catch (Exception e) {
            e.printStackTrace();
            sessionProvider.close();
            return null;
        }
    }

    private long getTotalpages(String pageInteratorId) {
        UIFAQPageIterator pageIterator = (UIFAQPageIterator)this.getChildById(pageInteratorId);
        try {
            return (Long)pageIterator.getInfoPage().get(3);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1L;
        }
    }

    static /* synthetic */ FAQService access$000() {
        return faqService_;
    }

    static /* synthetic */ int access$102(UIUserWatchManager x0, int x1) {
        x0.tabSelect = x1;
        return x0.tabSelect;
    }
}

