/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.webui.popup;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.download.DownloadResource;
import org.exoplatform.download.DownloadService;
import org.exoplatform.download.InputStreamDownloadResource;
import org.exoplatform.faq.service.Answer;
import org.exoplatform.faq.service.Comment;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.FAQSetting;
import org.exoplatform.faq.service.FileAttachment;
import org.exoplatform.faq.service.Question;
import org.exoplatform.faq.service.Utils;
import org.exoplatform.faq.webui.FAQUtils;
import org.exoplatform.faq.webui.popup.UIPopupComponent;
import org.exoplatform.faq.webui.popup.UIPrintAllQuestions;
import org.exoplatform.ks.common.bbcode.BBCode;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.UIForm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/faq/webui/popup/UIPrintAllQuestions.gtmpl", events={@EventConfig(listeners={CloseActionListener.class})})
public class UIPrintAllQuestions
extends UIForm
implements UIPopupComponent {
    private String[] sizes_ = new String[]{"bytes", "KB", "MB"};
    private String categoryId = null;
    private String currentUser_;
    private boolean canEditQuestion = false;
    private FAQService faqService_ = null;
    private FAQSetting faqSetting_ = null;
    private boolean viewAuthorInfor = true;
    private List<BBCode> listBBCode = new ArrayList();

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public UIPrintAllQuestions() {
        try {
            this.currentUser_ = FAQUtils.getCurrentUser();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getQuestionRelationById(String questionId) {
        Question question = new Question();
        try {
            question = this.faqService_.getQuestionById(questionId);
            if (question != null) {
                return question.getCategoryId() + "/" + question.getId() + "/" + question.getQuestion();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    private String getFileSource(InputStream input, String fileName, DownloadService dservice) throws Exception {
        byte[] imageBytes = null;
        if (input != null) {
            imageBytes = new byte[input.available()];
            input.read(imageBytes);
            ByteArrayInputStream byteImage = new ByteArrayInputStream(imageBytes);
            InputStreamDownloadResource dresource = new InputStreamDownloadResource((InputStream)byteImage, "image");
            dresource.setDownloadName(fileName);
            return dservice.getDownloadLink(dservice.addDownloadResource((DownloadResource)dresource));
        }
        return null;
    }

    public String getRepository() throws Exception {
        RepositoryService rService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        return rService.getCurrentRepository().getConfiguration().getName();
    }

    public String getPortalName() {
        PortalContainer pcontainer = PortalContainer.getInstance();
        return pcontainer.getPortalContainerInfo().getContainerName();
    }

    private String getAvatarUrl(String userId) {
        try {
            String url = FAQUtils.getFileSource((FileAttachment)this.faqService_.getUserAvatar(userId), null);
            if (FAQUtils.isFieldEmpty((String)url)) {
                url = "/faq/skin/DefaultSkin/webui/background/Avatar1.gif";
            }
            return url;
        }
        catch (Exception exception) {
            return "/faq/skin/DefaultSkin/webui/background/Avatar1.gif";
        }
    }

    private String convertSize(long size) {
        String result = "";
        long residual = 0L;
        int i = 0;
        while (size >= 1000L) {
            ++i;
            residual = size % 1024L;
            size /= 1024L;
        }
        if (residual > 500L) {
            String str = residual + "";
            result = size + 1L + " " + this.sizes_[i];
        } else {
            result = size + " " + this.sizes_[i];
        }
        return result;
    }

    public void setCategoryId(String cateId, FAQService service, FAQSetting setting, boolean canEdit) {
        this.categoryId = cateId;
        this.faqService_ = service;
        this.faqSetting_ = setting;
        this.canEditQuestion = this.faqSetting_.isAdmin();
        if (!this.canEditQuestion) {
            this.canEditQuestion = canEdit;
        }
        List bbcName = new ArrayList();
        ArrayList<BBCode> bbcs = new ArrayList<BBCode>();
        try {
            bbcName = this.faqService_.getActiveBBCode();
        }
        catch (Exception e) {
            // empty catch block
        }
        boolean isAdd = true;
        for (String string : bbcName) {
            isAdd = true;
            for (BBCode bbc : this.listBBCode) {
                if (!bbc.getTagName().equals(string) && (!bbc.getTagName().equals(string.replaceFirst("=", "")) || !bbc.isOption())) continue;
                bbcs.add(bbc);
                isAdd = false;
                break;
            }
            if (!isAdd) continue;
            BBCode bbCode = new BBCode();
            if (string.indexOf("=") >= 0) {
                bbCode.setOption(true);
                string = string.replaceFirst("=", "");
                bbCode.setId(string + "_option");
            } else {
                bbCode.setId(string);
            }
            bbCode.setTagName(string);
            bbcs.add(bbCode);
        }
        this.listBBCode.clear();
        this.listBBCode.addAll(bbcs);
    }

    private String getReplaceByBBCode(String s) throws Exception {
        try {
            s = Utils.getReplacementByBBcode((String)s, (List)this.listBBCode, (FAQService)this.faqService_);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return s;
    }

    public List<Question> getListQuestion() {
        try {
            return this.faqService_.getQuestionsByCatetory(this.categoryId, this.faqSetting_).getAll();
        }
        catch (Exception e) {
            return new ArrayList<Question>();
        }
    }

    public List<Answer> getListAnswers(String questionId) {
        try {
            return this.faqService_.getPageListAnswer(questionId, Boolean.valueOf(false)).getPageItem(0L);
        }
        catch (Exception e) {
            return new ArrayList<Answer>();
        }
    }

    public List<Comment> getListComments(String questionId) {
        try {
            return this.faqService_.getPageListComment(questionId).getPageItem(0L);
        }
        catch (Exception e) {
            return new ArrayList<Comment>();
        }
    }
}

