/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.webui.popup;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.download.DownloadResource;
import org.exoplatform.download.DownloadService;
import org.exoplatform.download.InputStreamDownloadResource;
import org.exoplatform.faq.rendering.RenderHelper;
import org.exoplatform.faq.rendering.RenderingException;
import org.exoplatform.faq.service.Answer;
import org.exoplatform.faq.service.Comment;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.FAQSetting;
import org.exoplatform.faq.service.FileAttachment;
import org.exoplatform.faq.service.Question;
import org.exoplatform.faq.webui.FAQUtils;
import org.exoplatform.faq.webui.popup.UIPrintAllQuestions;
import org.exoplatform.ks.common.Utils;
import org.exoplatform.ks.common.webui.BaseUIForm;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/faq/webui/popup/UIPrintAllQuestions.gtmpl", events={@EventConfig(listeners={CloseActionListener.class})})
public class UIPrintAllQuestions
extends BaseUIForm
implements UIPopupComponent {
    private String[] sizes_ = new String[]{"bytes", "KB", "MB"};
    private String categoryId = null;
    private String currentUser_;
    private boolean canEditQuestion = false;
    private FAQService faqService_ = null;
    private FAQSetting faqSetting_ = null;
    private boolean viewAuthorInfor = true;
    private RenderHelper renderHelper = new RenderHelper();

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public UIPrintAllQuestions() {
        try {
            this.currentUser_ = FAQUtils.getCurrentUser();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getQuestionRelationById(String questionId) {
        Question question = new Question();
        try {
            question = this.faqService_.getQuestionById(questionId);
            if (question != null) {
                return question.getCategoryId() + "/" + question.getId() + "/" + question.getQuestion();
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Can not get Question Relation by Id, exception: " + e.getMessage()));
        }
        return "";
    }

    private String getFileSource(InputStream input, String fileName, DownloadService dservice) throws Exception {
        byte[] imageBytes = null;
        if (input != null) {
            imageBytes = new byte[input.available()];
            input.read(imageBytes);
            ByteArrayInputStream byteImage = new ByteArrayInputStream(imageBytes);
            InputStreamDownloadResource dresource = new InputStreamDownloadResource((InputStream)byteImage, "image");
            dresource.setDownloadName(fileName);
            return dservice.getDownloadLink(dservice.addDownloadResource((DownloadResource)dresource));
        }
        return null;
    }

    public String getImageUrl(String imagePath) throws Exception {
        String url = "";
        try {
            url = Utils.getImageUrl((String)imagePath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return url;
    }

    private String getAvatarUrl(String userId) {
        try {
            String url = FAQUtils.getFileSource((FileAttachment)this.faqService_.getUserAvatar(userId), null);
            if (FAQUtils.isFieldEmpty((String)url)) {
                url = "/faq/skin/DefaultSkin/webui/background/Avatar1.gif";
            }
            return url;
        }
        catch (Exception exception) {
            return "/faq/skin/DefaultSkin/webui/background/Avatar1.gif";
        }
    }

    private String convertSize(long size) {
        String result = "";
        long residual = 0L;
        int i = 0;
        while (size >= 1000L) {
            ++i;
            residual = size % 1024L;
            size /= 1024L;
        }
        if (residual > 500L) {
            String str = residual + "";
            result = size + 1L + " " + this.sizes_[i];
        } else {
            result = size + " " + this.sizes_[i];
        }
        return result;
    }

    public void setCategoryId(String cateId, FAQService service, FAQSetting setting, boolean canEdit) throws Exception {
        this.categoryId = cateId;
        this.faqService_ = service;
        this.faqSetting_ = setting;
        this.viewAuthorInfor = this.faqService_.isViewAuthorInfo(this.categoryId);
        this.canEditQuestion = this.faqSetting_.isAdmin();
        if (!this.canEditQuestion) {
            this.canEditQuestion = canEdit;
        }
    }

    public String render(Object obj) throws RenderingException {
        if (obj instanceof Question) {
            return this.renderHelper.renderQuestion((Question)obj);
        }
        if (obj instanceof Answer) {
            return this.renderHelper.renderAnswer((Answer)obj);
        }
        if (obj instanceof Comment) {
            return this.renderHelper.renderComment((Comment)obj);
        }
        return "";
    }

    public List<Question> getListQuestion() {
        try {
            return this.faqService_.getQuestionsByCatetory(this.categoryId, this.faqSetting_).getAll();
        }
        catch (Exception e) {
            return new ArrayList<Question>();
        }
    }

    public String answer(Comment comment) {
        return comment.getComments();
    }

    public List<Answer> getListAnswers(String questionId) {
        try {
            return this.faqService_.getPageListAnswer(questionId, Boolean.valueOf(false)).getPageItem(0L);
        }
        catch (Exception e) {
            return new ArrayList<Answer>();
        }
    }

    public List<Comment> getListComments(String questionId) {
        try {
            return this.faqService_.getPageListComment(questionId).getPageItem(0L);
        }
        catch (Exception e) {
            return new ArrayList<Comment>();
        }
    }
}

