/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.webui.popup;

import java.util.ArrayList;
import java.util.Arrays;
import org.exoplatform.faq.service.Category;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.webui.BaseUIFAQForm;
import org.exoplatform.faq.webui.FAQUtils;
import org.exoplatform.faq.webui.popup.UICategoryForm;
import org.exoplatform.ks.common.webui.UISelector;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputWithActions;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.PositiveNumberFormatValidator;

@ComponentConfigs(value={@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={SelectPermissionActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddValuesUserActionListener.class}, phase=Event.Phase.DECODE)}), @ComponentConfig(id="UICategoryUserPopupWindow", type=UIPopupWindow.class, template="system:/groovy/webui/core/UIPopupWindow.gtmpl", events={@EventConfig(listeners={ClosePopupActionListener.class}, name="ClosePopup"), @EventConfig(listeners={AddActionListener.class}, name="Add", phase=Event.Phase.DECODE), @EventConfig(listeners={CloseActionListener.class}, name="Close", phase=Event.Phase.DECODE)})})
public class UICategoryForm
extends BaseUIFAQForm
implements UIPopupComponent,
UISelector {
    private String categoryId_ = "";
    private String parentId_;
    private static final String CATEGORY_DETAIL_TAB = "UIAddCategoryForm";
    private static final String FIELD_NAME_INPUT = "eventCategoryName";
    private static final String FIELD_DESCRIPTION_INPUT = "description";
    private static final String FIELD_USERPRIVATE_INPUT = "userPrivate";
    private static final String FIELD_MODERATOR_INPUT = "moderator";
    private static final String FIELD_INDEX_INPUT = "index";
    private static final String FIELD_MODERATEQUESTIONS_CHECKBOX = "moderatequestions";
    public static final String VIEW_AUTHOR_INFOR = "ViewAuthorInfor".intern();
    private static final String FIELD_MODERATE_ANSWERS_CHECKBOX = "moderateAnswers";
    private static final String USER_SELECTOR_POPUPWINDOW = "UICategoryUserPopupWindow";
    private boolean isAddNew_ = true;
    private String oldName_ = "";
    private long oldIndex_ = 0L;
    private Category currentCategory_;
    private long maxIndex = 1L;

    public UICategoryForm() throws Exception {
        this.setActions(new String[]{"Save", "Cancel"});
    }

    public void updateAddNew(boolean isAddNew) throws Exception {
        this.isAddNew_ = isAddNew;
        UIFormInputWithActions inputset = new UIFormInputWithActions(CATEGORY_DETAIL_TAB);
        inputset.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_NAME_INPUT, FIELD_NAME_INPUT, null).addValidator(MandatoryValidator.class, new Object[0]));
        UIFormStringInput index = new UIFormStringInput(FIELD_INDEX_INPUT, FIELD_INDEX_INPUT, null);
        index.addValidator(PositiveNumberFormatValidator.class, new Object[0]);
        this.maxIndex = this.getFAQService().getMaxindexCategory(this.parentId_) + 1L;
        if (isAddNew) {
            index.setValue((Object)String.valueOf(this.maxIndex));
        }
        inputset.addUIFormInput((UIFormInput)index);
        inputset.addUIFormInput((UIFormInput)new UIFormTextAreaInput(FIELD_USERPRIVATE_INPUT, FIELD_USERPRIVATE_INPUT, null));
        inputset.addUIFormInput((UIFormInput)new UIFormTextAreaInput(FIELD_DESCRIPTION_INPUT, FIELD_DESCRIPTION_INPUT, null));
        inputset.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(FIELD_MODERATEQUESTIONS_CHECKBOX, FIELD_MODERATEQUESTIONS_CHECKBOX, (Object)false));
        inputset.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(VIEW_AUTHOR_INFOR, VIEW_AUTHOR_INFOR, (Object)false));
        inputset.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(FIELD_MODERATE_ANSWERS_CHECKBOX, FIELD_MODERATE_ANSWERS_CHECKBOX, (Object)false));
        UIFormTextAreaInput moderator = new UIFormTextAreaInput(FIELD_MODERATOR_INPUT, FIELD_MODERATOR_INPUT, null);
        if (isAddNew) {
            moderator.setValue((Object)FAQUtils.getCurrentUser());
        }
        moderator.addValidator(MandatoryValidator.class, new Object[0]);
        inputset.addUIFormInput((UIFormInput)moderator);
        String[] strings = new String[]{"SelectUser", "SelectMemberShip", "SelectGroup"};
        String[] files = new String[]{FIELD_USERPRIVATE_INPUT, FIELD_MODERATOR_INPUT};
        for (int i = 0; i < files.length; ++i) {
            int j = 0;
            ArrayList<UIFormInputWithActions.ActionData> actionData = new ArrayList<UIFormInputWithActions.ActionData>();
            for (String string : strings) {
                UIFormInputWithActions.ActionData ad = new UIFormInputWithActions.ActionData();
                ad.setActionName(string);
                if (j == 0) {
                    ad.setActionListener("AddValuesUser");
                } else {
                    ad.setActionListener("SelectPermission");
                }
                ad.setActionType(0);
                ad.setCssIconClass(string + "Icon");
                ad.setActionParameter(files[i] + "," + String.valueOf(j));
                actionData.add(ad);
                ++j;
            }
            inputset.setActionField(files[i], actionData);
        }
        this.addChild((UIComponent)inputset);
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public String getParentId() {
        return this.parentId_;
    }

    public void setParentId(String s) {
        this.parentId_ = s;
    }

    public void updateSelect(String selectField, String value) throws Exception {
        UIFormTextAreaInput fieldInput = this.getUIFormTextAreaInput(selectField);
        String oldValue = (String)fieldInput.getValue();
        oldValue = oldValue != null && oldValue.trim().length() > 0 ? oldValue + "," + value : value;
        fieldInput.setValue((Object)oldValue);
    }

    public void setCategoryValue(Category cat, boolean isUpdate) throws Exception {
        if (isUpdate) {
            this.isAddNew_ = false;
            this.categoryId_ = cat.getPath();
            this.currentCategory_ = cat;
            this.oldName_ = cat.getName();
            this.oldIndex_ = cat.getIndex();
            if (this.oldName_ != null && this.oldName_.trim().length() > 0) {
                this.getUIStringInput(FIELD_NAME_INPUT).setValue((Object)this.oldName_);
            } else {
                this.getUIStringInput(FIELD_NAME_INPUT).setValue((Object)"Root");
            }
            String userPrivate = null;
            if (cat.getUserPrivate() != null) {
                for (String str : cat.getUserPrivate()) {
                    userPrivate = userPrivate != null ? userPrivate + ", " + str : str;
                }
            }
            this.getUIFormTextAreaInput(FIELD_USERPRIVATE_INPUT).setDefaultValue(userPrivate);
            this.getUIStringInput(FIELD_INDEX_INPUT).setValue((Object)String.valueOf(cat.getIndex()));
            this.getUIFormTextAreaInput(FIELD_DESCRIPTION_INPUT).setDefaultValue((Object)cat.getDescription());
            this.getUIFormCheckBoxInput(FIELD_MODERATEQUESTIONS_CHECKBOX).setChecked(cat.isModerateQuestions());
            this.getUIFormCheckBoxInput(FIELD_MODERATE_ANSWERS_CHECKBOX).setChecked(cat.isModerateAnswers());
            this.getUIFormCheckBoxInput(VIEW_AUTHOR_INFOR).setChecked(cat.isViewAuthorInfor());
            String moderator = "";
            if (cat.getModerators() != null && cat.getModerators().length > 0) {
                for (String str : cat.getModerators()) {
                    if (moderator != null && moderator.trim().length() > 0) {
                        moderator = moderator + ",";
                    }
                    moderator = moderator + str;
                }
            }
            if (moderator.trim().length() > 0) {
                this.getUIFormTextAreaInput(FIELD_MODERATOR_INPUT).setValue((Object)moderator);
            } else {
                this.getUIFormTextAreaInput(FIELD_MODERATOR_INPUT).setValue((Object)FAQUtils.getCurrentUser());
            }
        }
    }

    public String cutColonCaret(String name) {
        StringBuffer string = new StringBuffer();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == ':' || c == '/') continue;
            string.append(c);
        }
        return string.toString();
    }

    private String getUserSelect(String vls, String values) throws Exception {
        try {
            if (!FAQUtils.isFieldEmpty((String)vls)) {
                values = values + "," + vls;
                ArrayList<String> list = new ArrayList<String>();
                for (String string : Arrays.asList(values.split(","))) {
                    if (list.contains(string) || string.trim().length() <= 0) continue;
                    list.add(string);
                }
                values = ((Object)list).toString().replace("[", "").replace("]", "").replaceAll(", ", ",");
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Fail to get user selector: ", (Throwable)e);
        }
        return values;
    }

    static /* synthetic */ boolean access$000(UICategoryForm x0) {
        return x0.isAddNew_;
    }

    static /* synthetic */ String access$100(UICategoryForm x0) {
        return x0.parentId_;
    }

    static /* synthetic */ FAQService access$200(UICategoryForm x0) {
        return x0.getFAQService();
    }

    static /* synthetic */ void access$300(UICategoryForm x0, String x1) {
        x0.warning(x1);
    }

    static /* synthetic */ String access$400(UICategoryForm x0) {
        return x0.oldName_;
    }

    static /* synthetic */ FAQService access$500(UICategoryForm x0) {
        return x0.getFAQService();
    }

    static /* synthetic */ void access$600(UICategoryForm x0, String x1) {
        x0.warning(x1);
    }

    static /* synthetic */ long access$700(UICategoryForm x0) {
        return x0.oldIndex_;
    }

    static /* synthetic */ long access$802(UICategoryForm x0, long x1) {
        x0.maxIndex = x1;
        return x0.maxIndex;
    }

    static /* synthetic */ FAQService access$900(UICategoryForm x0) {
        return x0.getFAQService();
    }

    static /* synthetic */ long access$800(UICategoryForm x0) {
        return x0.maxIndex;
    }

    static /* synthetic */ void access$1000(UICategoryForm x0, String x1) {
        x0.warning(x1);
    }

    static /* synthetic */ void access$1100(UICategoryForm x0, String x1, String[] x2) {
        x0.warning(x1, x2);
    }

    static /* synthetic */ void access$1200(UICategoryForm x0, String x1, String[] x2) {
        x0.warning(x1, x2);
    }

    static /* synthetic */ Category access$1300(UICategoryForm x0) {
        return x0.currentCategory_;
    }

    static /* synthetic */ FAQService access$1400(UICategoryForm x0) {
        return x0.getFAQService();
    }

    static /* synthetic */ String access$1500(UICategoryForm x0) {
        return x0.categoryId_;
    }

    static /* synthetic */ FAQService access$1600(UICategoryForm x0) {
        return x0.getFAQService();
    }

    static /* synthetic */ String access$1700(UICategoryForm x0, String x1, String x2) throws Exception {
        return x0.getUserSelect(x1, x2);
    }
}

