/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.webui;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.faq.rendering.RenderHelper;
import org.exoplatform.faq.rendering.RenderingException;
import org.exoplatform.faq.service.Answer;
import org.exoplatform.faq.service.Comment;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.FAQSetting;
import org.exoplatform.faq.service.FileAttachment;
import org.exoplatform.faq.service.JCRPageList;
import org.exoplatform.faq.service.Question;
import org.exoplatform.faq.service.QuestionLanguage;
import org.exoplatform.faq.webui.FAQUtils;
import org.exoplatform.faq.webui.UIAnswersContainer;
import org.exoplatform.faq.webui.UIAnswersPageIterator;
import org.exoplatform.faq.webui.UIAnswersPortlet;
import org.exoplatform.faq.webui.UIQuestions;
import org.exoplatform.faq.webui.popup.UIResponseForm;
import org.exoplatform.ks.common.Utils;
import org.exoplatform.ks.common.webui.UIPopupAction;
import org.exoplatform.ks.common.webui.UIPopupContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.event.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/templates/faq/webui/UIQuestions.gtmpl", events={@EventConfig(listeners={DownloadAttachActionListener.class}), @EventConfig(listeners={DeleteCategoryActionListener.class}, confirm="UIQuestions.msg.confirm-delete-category"), @EventConfig(listeners={ChangeStatusAnswerActionListener.class}), @EventConfig(listeners={AddCategoryActionListener.class}), @EventConfig(listeners={AddNewQuestionActionListener.class}), @EventConfig(listeners={SettingActionListener.class}), @EventConfig(listeners={QuestionManagamentActionListener.class}), @EventConfig(listeners={ViewQuestionActionListener.class}), @EventConfig(listeners={OpenQuestionActionListener.class}), @EventConfig(listeners={CloseQuestionActionListener.class}), @EventConfig(listeners={ViewUserProfileActionListener.class}), @EventConfig(listeners={ResponseQuestionActionListener.class}), @EventConfig(listeners={EditAnswerActionListener.class}), @EventConfig(listeners={EditQuestionActionListener.class}), @EventConfig(listeners={DeleteQuestionActionListener.class}), @EventConfig(listeners={MoveQuestionActionListener.class}), @EventConfig(listeners={SendQuestionActionListener.class}), @EventConfig(listeners={CommentQuestionActionListener.class}), @EventConfig(listeners={DeleteCommentActionListener.class}, confirm="UIQuestions.msg.confirm-delete-comment"), @EventConfig(listeners={DeleteAnswerActionListener.class}, confirm="UIQuestions.msg.confirm-delete-answer"), @EventConfig(listeners={UnVoteQuestionActionListener.class}, confirm="UIQuestions.msg.confirm-unvote-question"), @EventConfig(listeners={CommentToAnswerActionListener.class}), @EventConfig(listeners={VoteQuestionActionListener.class}), @EventConfig(listeners={ChangeLanguageActionListener.class}), @EventConfig(listeners={SortAnswerActionListener.class}), @EventConfig(listeners={ExportActionListener.class}), @EventConfig(listeners={ImportActionListener.class}), @EventConfig(listeners={EditCategoryActionListener.class}), @EventConfig(listeners={VoteAnswerActionListener.class}), @EventConfig(listeners={PrintAllQuestionActionListener.class}), @EventConfig(listeners={DiscussForumActionListener.class})})
public class UIQuestions
extends UIContainer {
    private static Log log = ExoLogger.getLogger(UIQuestions.class);
    private static String SEARCH_INPUT = "SearchInput";
    private static String COMMENT_ITER = "CommentIter";
    private static String ANSWER_ITER = "AnswerIter";
    public static final String OBJECT_ITERATOR = "object_iter";
    private FAQSetting faqSetting_ = null;
    private Map<String, Question> questionMap_ = new LinkedHashMap();
    public JCRPageList pageList;
    private boolean canEditQuestion = false;
    private Boolean isSortAnswerUp = null;
    public String categoryId_ = null;
    public String viewingQuestionId_ = "";
    private String currentUser_ = "";
    private String link_ = "";
    private FAQService faqService_ = null;
    private Map<String, QuestionLanguage> languageMap = new HashMap();
    public boolean isChangeLanguage = false;
    public List<String> listLanguage = new ArrayList();
    public String backPath_ = null;
    private String language_ = FAQUtils.getDefaultLanguage();
    private String discussId = "";
    private String[] firstTollbar_ = new String[]{"AddNewQuestion", "QuestionManagament"};
    private String[] menuCateManager = new String[]{"EditCategory", "AddCategory", "DeleteCategory", "Export", "Import"};
    private String[] userActionsCate_ = new String[]{"AddNewQuestion", "Watch"};
    private String[] moderatorActionQues_ = new String[]{"CommentQuestion", "ResponseQuestion", "EditQuestion", "DeleteQuestion", "MoveQuestion", "SendQuestion"};
    private String[] moderatorActionQues2_ = new String[]{"ResponseQuestion", "EditQuestion", "DeleteQuestion", "MoveQuestion", "SendQuestion"};
    private String[] userActionQues_ = new String[]{"CommentQuestion", "ResponseQuestion", "SendQuestion"};
    private String[] userActionQues2_ = new String[]{"SendQuestion"};
    private String[] userActionQues3_ = new String[]{"ResponseQuestion", "SendQuestion"};
    private String[] sizes_ = new String[]{"bytes", "KB", "MB"};
    private boolean isViewRootCate = true;
    public boolean viewAuthorInfor = false;
    private RenderHelper renderHelper = new RenderHelper();
    public UIAnswersPageIterator pageIterator = null;
    public long pageSelect = 0L;

    public UIQuestions() throws Exception {
        this.currentUser_ = FAQUtils.getCurrentUser();
        this.addChild(UIAnswersPageIterator.class, null, OBJECT_ITERATOR);
        if (this.faqService_ == null) {
            this.faqService_ = (FAQService)PortalContainer.getInstance().getComponentInstanceOfType(FAQService.class);
        }
        if (FAQUtils.isFieldEmpty((String)this.getId())) {
            this.setId("UIQuestions");
        }
    }

    private boolean isCategoryHome() {
        return this.categoryId_ == null || this.categoryId_.equals("categories");
    }

    public boolean isViewRootCate() {
        return this.isViewRootCate;
    }

    public void setViewRootCate() {
        try {
            boolean b = ((UIAnswersContainer)this.getParent()).isRenderCategory(this.categoryId_);
            if (b != this.isViewRootCate) {
                this.isViewRootCate = b;
            }
            this.setListObject();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean isAddQuestion() {
        if (this.isViewRootCate && (this.currentUser_ != null || this.currentUser_ == null && this.faqSetting_.isEnableAnonymousSubmitQuestion())) {
            return !this.isCategoryHome() || this.faqSetting_.isPostQuestionInRootCategory();
        }
        return false;
    }

    public String getRSSLink() {
        String catepath = this.categoryId_.substring(this.categoryId_.lastIndexOf("/") + 1);
        return Utils.getRSSLink((String)"faq", (String)this.getPortalName(), (String)catepath);
    }

    public String getPortalName() {
        PortalContainer pcontainer = PortalContainer.getInstance();
        return pcontainer.getPortalContainerInfo().getContainerName();
    }

    public String getImageUrl(String imagePath) throws Exception {
        String url = "";
        try {
            url = Utils.getImageUrl((String)imagePath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return url;
    }

    private boolean isDiscussForum() throws Exception {
        return this.faqSetting_.getIsDiscussForum();
    }

    public void setListObject() throws Exception {
        try {
            String objectId = null;
            if (this.pageList != null) {
                objectId = this.pageList.getObjectId();
            }
            if (this.isViewRootCate) {
                this.pageList = this.faqService_.getQuestionsByCatetory(this.categoryId_, this.faqSetting_);
                this.pageList.setPageSize(10L);
                if (objectId != null && objectId.trim().length() > 0) {
                    this.pageList.setObjectId(objectId);
                }
                this.pageIterator = (UIAnswersPageIterator)this.getChildById(OBJECT_ITERATOR);
                this.pageIterator.updatePageList(this.pageList);
            } else {
                this.pageList = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Answer[] getPageListAnswer(String questionId) throws Exception {
        if (this.isSortAnswerUp != null) {
            Answer[] answers = ((QuestionLanguage)this.languageMap.get(this.language_)).getAnswers();
            for (int i = 0; i < answers.length - 1; ++i) {
                for (int j = i + 1; j < answers.length; ++j) {
                    Answer temp;
                    if (this.isSortAnswerUp.booleanValue()) {
                        if (answers[j].getMarkVotes() >= answers[i].getMarkVotes()) continue;
                        temp = answers[i];
                        answers[i] = answers[j];
                        answers[j] = temp;
                        continue;
                    }
                    if (answers[j].getMarkVotes() <= answers[i].getMarkVotes()) continue;
                    temp = answers[i];
                    answers[i] = answers[j];
                    answers[j] = temp;
                }
            }
            return answers;
        }
        return ((QuestionLanguage)this.languageMap.get(this.language_)).getAnswers();
    }

    private Comment[] getPageListComment(String questionId) throws Exception {
        return ((QuestionLanguage)this.languageMap.get(this.language_)).getComments();
    }

    private String[] getActionTollbar() {
        return this.firstTollbar_;
    }

    private String[] getMenuCateManager() {
        return this.menuCateManager;
    }

    public FAQSetting getFAQSetting() {
        return this.faqSetting_;
    }

    private String[] getActionCategoryWithUser() {
        if (this.currentUser_ != null) {
            return this.userActionsCate_;
        }
        if (this.faqSetting_.isEnableAutomaticRSS()) {
            return new String[]{this.userActionsCate_[0], "RSSFAQ"};
        }
        return new String[]{this.userActionsCate_[0]};
    }

    private String[] getActionQuestion() {
        return this.canEditQuestion ? (this.faqSetting_.isEnanbleVotesAndComments() ? this.moderatorActionQues_ : this.moderatorActionQues2_) : (FAQUtils.isFieldEmpty((String)this.currentUser_) ? this.userActionQues2_ : (this.faqSetting_.isEnanbleVotesAndComments() ? this.userActionQues_ : this.userActionQues3_));
    }

    public void updateCurrentQuestionList() throws Exception {
        this.questionMap_.clear();
        if (this.pageList != null) {
            this.pageSelect = this.pageIterator.getPageSelected();
            for (Question question : this.pageList.getPage(this.pageSelect, null)) {
                this.questionMap_.put(question.getId(), question);
            }
            this.pageSelect = this.pageList.getCurrentPage();
            this.pageIterator.setSelectPage(this.pageSelect);
        }
    }

    public void setFAQSetting(FAQSetting setting) {
        this.faqSetting_ = setting;
    }

    public void setFAQService(FAQService service) {
        this.faqService_ = service;
    }

    public void setLanguageView(String language) {
        this.language_ = language;
    }

    private String getQuestionContent() {
        if (this.languageMap.containsKey(this.language_)) {
            return ((QuestionLanguage)this.languageMap.get(this.language_)).getQuestion();
        }
        return "";
    }

    private Question getQuestionDetail() {
        Question question = new Question();
        if (this.languageMap.containsKey(this.language_)) {
            question.setDetail(((QuestionLanguage)this.languageMap.get(this.language_)).getDetail());
        }
        return question;
    }

    private void setIsModerators() throws Exception {
        this.canEditQuestion = this.faqSetting_.isAdmin() || this.faqService_.isCategoryModerator(this.categoryId_, this.currentUser_);
    }

    public String getVoteScore(Question question) {
        double vote = question.getMarkVote();
        vote = vote < 0.0 ? 0.0 : vote;
        DecimalFormat df = new DecimalFormat("0");
        return df.format(vote);
    }

    private boolean canVote(Question question) {
        if (question.getUsersVote() != null) {
            for (String user : question.getUsersVote()) {
                if (!user.contains(this.currentUser_ + "/")) continue;
                return false;
            }
        }
        return true;
    }

    public void setDefaultLanguage() {
        String language = FAQUtils.getDefaultLanguage();
        if (this.languageMap.containsKey(language) || FAQUtils.isFieldEmpty((String)this.language_)) {
            this.language_ = language;
        }
    }

    private String convertSize(long size) {
        String result = "";
        long residual = 0L;
        int i = 0;
        while (size >= 1000L) {
            ++i;
            residual = size % 1024L;
            size /= 1024L;
        }
        result = residual > 500L ? size + 1L + " " + this.sizes_[i] : size + " " + this.sizes_[i];
        return result;
    }

    private Question[] getListQuestion() {
        try {
            this.updateCurrentQuestionList();
        }
        catch (Exception e) {
            log.debug((Object)"Failed to update current question list.", (Throwable)e);
        }
        return this.questionMap_.values().toArray(new Question[0]);
    }

    private boolean getCanEditQuestion() {
        return this.canEditQuestion;
    }

    private String getQuestionView() {
        return this.viewingQuestionId_;
    }

    private String[] getQuestionLangauges(String questionPath) {
        return this.languageMap.keySet().toArray(new String[0]);
    }

    private String getAvatarUrl(String userId) {
        try {
            String url = FAQUtils.getFileSource((FileAttachment)this.faqService_.getUserAvatar(userId), null);
            if (FAQUtils.isFieldEmpty((String)url)) {
                url = "/faq/skin/DefaultSkin/webui/background/Avatar1.gif";
            }
            return url;
        }
        catch (Exception exception) {
            return "/faq/skin/DefaultSkin/webui/background/Avatar1.gif";
        }
    }

    public String getCategoryId() {
        return this.categoryId_;
    }

    public void setCategoryId(String categoryId) throws Exception {
        this.viewAuthorInfor = this.faqService_.isViewAuthorInfo(categoryId);
        this.categoryId_ = categoryId;
        this.setViewRootCate();
        this.setListObject();
    }

    public void viewQuestion(Question question) throws Exception {
        if (!this.questionMap_.containsKey(question.getLanguage())) {
            List languages = this.faqService_.getQuestionLanguages(question.getPath());
            this.languageMap.clear();
            for (QuestionLanguage lang : languages) {
                this.languageMap.put(lang.getLanguage(), lang);
            }
            if (!this.questionMap_.containsKey(question.getId())) {
                this.questionMap_.put(question.getLanguage(), question);
            }
            this.viewingQuestionId_ = question.getPath();
        }
    }

    public void updateCurrentLanguage() throws Exception {
        if (this.viewingQuestionId_ != null && this.viewingQuestionId_.length() > 0) {
            try {
                this.languageMap.put(this.language_, this.faqService_.getQuestionLanguageByLanguage(this.viewingQuestionId_, this.language_));
            }
            catch (Exception exception) {}
        } else {
            this.languageMap.clear();
        }
    }

    public void updateQuestionLanguageByLanguage(String questionPath, String language) throws Exception {
        this.languageMap.put(language, this.faqService_.getQuestionLanguageByLanguage(questionPath, language));
    }

    public void updateLanguageMap() throws Exception {
        try {
            this.languageMap.clear();
            if (this.viewingQuestionId_ != null && this.viewingQuestionId_.length() > 0) {
                List languages = this.faqService_.getQuestionLanguages(this.viewingQuestionId_);
                for (QuestionLanguage lang : languages) {
                    this.languageMap.put(lang.getLanguage(), lang);
                }
            }
        }
        catch (Exception e) {
            this.viewingQuestionId_ = "";
            log.debug((Object)"Failed to update map language by viewing question", (Throwable)e);
        }
    }

    private String getQuestionRelationById(String questionId) {
        try {
            List ids = new ArrayList<String>();
            ids.add(questionId);
            ids = this.faqService_.getQuestionContents(ids);
            if (ids != null && ids.size() > 0) {
                return (String)ids.get(0);
            }
        }
        catch (Exception e) {
            log.debug((Object)("Failed to get question relation by id: " + questionId), (Throwable)e);
        }
        return "";
    }

    private String getLink() {
        return this.link_;
    }

    private String getBackPath() {
        return this.backPath_;
    }

    private void setLink(String link) {
        this.link_ = link;
    }

    public String render(Object obj) throws RenderingException {
        if (obj instanceof Question) {
            return this.renderHelper.renderQuestion((Question)obj);
        }
        if (obj instanceof Answer) {
            return this.renderHelper.renderAnswer((Answer)obj);
        }
        if (obj instanceof Comment) {
            return this.renderHelper.renderComment((Comment)obj);
        }
        return "";
    }

    private String calculateTimeMessageOfLastActivity(long time) {
        long current = GregorianCalendar.getInstance().getTimeInMillis();
        long interval = current - time;
        if (interval < 3600000L) {
            String msg = FAQUtils.getResourceBundle((String)(this.getId() + ".label.last-act-time-minute"));
            int mins = (int)interval / 60000;
            msg = msg.replace("{0}", String.valueOf(mins));
            return msg;
        }
        if (interval < 86400000L) {
            String msg = FAQUtils.getResourceBundle((String)(this.getId() + ".label.last-act-time-hour"));
            int hours = (int)interval / 3600000;
            msg = msg.replace("{0}", String.valueOf(hours));
            return msg;
        }
        return FAQUtils.getLongDateFormat((Date)new Date(time));
    }

    private boolean checkQuestionToView(Question question, UIApplication uiApplication, Event<UIQuestions> event) {
        if (!question.isActivated() || !question.isApproved() && this.faqSetting_.getDisplayMode().equals(FAQUtils.DISPLAYAPPROVED)) {
            uiApplication.addMessage(new ApplicationMessage("UIQuestions.msg.question-pending", null, 1));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApplication.getUIPopupMessages());
            event.getRequestContext().addUIComponentToUpdateByAjax(this.getAncestorOfType(UIAnswersContainer.class));
            return true;
        }
        return false;
    }

    public void setLanguage(String language) {
        this.language_ = language;
    }

    private void processResponseQuestionAction(Event<UIQuestions> event, String questionId) throws Exception {
        boolean isAnswerApproved = false;
        try {
            Question question = this.faqService_.getQuestionById(questionId);
            isAnswerApproved = !this.faqService_.isModerateAnswer(questionId);
            UIAnswersPortlet portlet = (UIAnswersPortlet)this.getAncestorOfType(UIAnswersPortlet.class);
            UIPopupAction popupAction = (UIPopupAction)portlet.getChild(UIPopupAction.class);
            UIPopupContainer popupContainer = (UIPopupContainer)popupAction.createUIComponent(UIPopupContainer.class, null, null);
            UIResponseForm responseForm = (UIResponseForm)popupContainer.addChild(UIResponseForm.class, null, null);
            responseForm.setModertator(this.canEditQuestion);
            if (questionId.equals(this.viewingQuestionId_)) {
                responseForm.setQuestionId(question, this.language_, isAnswerApproved);
            } else {
                responseForm.setQuestionId(question, "", isAnswerApproved);
            }
            responseForm.setFAQSetting(this.faqSetting_);
            popupContainer.setId("FAQResponseQuestion");
            popupAction.activate((UIComponent)popupContainer, 900, 500);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)popupAction);
        }
        catch (Exception e) {
            UIApplication uiApplication = (UIApplication)this.getAncestorOfType(UIApplication.class);
            uiApplication.addMessage(new ApplicationMessage("UIQuestions.msg.question-id-deleted", null, 1));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApplication.getUIPopupMessages());
            this.updateCurrentQuestionList();
            event.getRequestContext().addUIComponentToUpdateByAjax(this.getAncestorOfType(UIAnswersContainer.class));
            return;
        }
    }

    static /* synthetic */ FAQSetting access$000(UIQuestions x0) {
        return x0.faqSetting_;
    }

    static /* synthetic */ FAQService access$100(UIQuestions x0) {
        return x0.faqService_;
    }

    static /* synthetic */ boolean access$200(UIQuestions x0) {
        return x0.canEditQuestion;
    }

    static /* synthetic */ Boolean access$300(UIQuestions x0) {
        return x0.isSortAnswerUp;
    }

    static /* synthetic */ Boolean access$302(UIQuestions x0, Boolean x1) {
        x0.isSortAnswerUp = x1;
        return x0.isSortAnswerUp;
    }

    static /* synthetic */ String access$400(UIQuestions x0) {
        return x0.language_;
    }

    static /* synthetic */ String access$402(UIQuestions x0, String x1) {
        x0.language_ = x1;
        return x0.language_;
    }

    static /* synthetic */ boolean access$500(UIQuestions x0, Question x1, UIApplication x2, Event x3) {
        return x0.checkQuestionToView(x1, x2, x3);
    }

    static /* synthetic */ void access$600(UIQuestions x0, Event x1, String x2) throws Exception {
        x0.processResponseQuestionAction(x1, x2);
    }

    static /* synthetic */ Log access$700() {
        return log;
    }

    static /* synthetic */ Map access$800(UIQuestions x0) {
        return x0.questionMap_;
    }

    static /* synthetic */ String access$900(UIQuestions x0) {
        return x0.getLink();
    }

    static /* synthetic */ Map access$1000(UIQuestions x0) {
        return x0.languageMap;
    }

    static /* synthetic */ String access$1102(UIQuestions x0, String x1) {
        x0.discussId = x1;
        return x0.discussId;
    }
}

