/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.webui;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.portlet.PortletPreferences;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.download.DownloadResource;
import org.exoplatform.download.DownloadService;
import org.exoplatform.download.InputStreamDownloadResource;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.FAQSetting;
import org.exoplatform.faq.service.FileAttachment;
import org.exoplatform.faq.service.JcrInputProperty;
import org.exoplatform.faq.webui.UIAnswersContainer;
import org.exoplatform.faq.webui.UIBreadcumbs;
import org.exoplatform.faq.webui.UICategories;
import org.exoplatform.faq.webui.UIQuestions;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.ks.common.Utils;
import org.exoplatform.ks.common.user.CommonContact;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.form.UIFormDateTimeInput;
import org.exoplatform.webui.form.UIFormInputBase;
import org.exoplatform.webui.form.UIFormMultiValueInputSet;
import org.exoplatform.webui.form.UIFormUploadInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class FAQUtils {
    public static String DISPLAYAPPROVED = "approved";
    public static String DISPLAYBOTH = "both";
    public static String UPLOAD_FILE_SIZE = "uploadFileSizeLimitMB";
    public static String UPLOAD_AVATAR_SIZE = "uploadAvatarSizeLimitMB";
    public static final int DEFAULT_VALUE_UPLOAD_PORTAL = -1;
    private static Log log = ExoLogger.getLogger(FAQUtils.class);

    public static FAQService getFAQService() throws Exception {
        return (FAQService)PortalContainer.getComponent(FAQService.class);
    }

    public static String getDefaultLanguage() {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        return context.getLocale().getDisplayLanguage();
    }

    public static List<String> getAllLanguages(UIComponent component) {
        LocaleConfigService configService = (LocaleConfigService)component.getApplicationComponent(LocaleConfigService.class);
        ArrayList<String> languages = new ArrayList<String>();
        for (LocaleConfig localeConfig : configService.getLocalConfigs()) {
            languages.add(localeConfig.getLocale().getDisplayLanguage());
        }
        return languages;
    }

    public static void findCateExist(FAQService faqService_, UIAnswersContainer fAQContainer) throws Exception {
        UIBreadcumbs breadcumbs = (UIBreadcumbs)fAQContainer.findFirstComponentOfType(UIBreadcumbs.class);
        String pathCate = "";
        for (String path : ((String)breadcumbs.pathList_.get(breadcumbs.pathList_.size() - 1)).split("/")) {
            if (path.equals("FAQService")) {
                pathCate = path;
                continue;
            }
            try {
                faqService_.getCategoryById(path);
                if (pathCate.trim().length() > 0) {
                    pathCate = pathCate + "/";
                }
                pathCate = pathCate + path;
            }
            catch (Exception pathExc) {
                UIQuestions questions = (UIQuestions)fAQContainer.findFirstComponentOfType(UIQuestions.class);
                try {
                    breadcumbs.setUpdataPath(pathCate);
                }
                catch (Exception exc) {
                    log.debug((Object)("Setting update path fail: " + exc.getMessage()), (Throwable)exc);
                }
                if (pathCate.indexOf("/") > 0) {
                    questions.setCategoryId(pathCate.substring(pathCate.lastIndexOf("/") + 1));
                } else {
                    questions.categoryId_ = null;
                    questions.setListObject();
                }
                ((UICategories)fAQContainer.findFirstComponentOfType(UICategories.class)).setPathCategory(pathCate);
                break;
            }
        }
    }

    public static boolean checkSpecial(String text) {
        if (!FAQUtils.isFieldEmpty((String)text)) {
            String[] specialString = new String[]{"?", "[", "(", "|", ")", "*", "\\", "+", "}", "{", "^", "$", "#", "%", ":", "&", ">", "<", "'", "\"", "`", "!", "~", "]", "/"};
            for (int i = 0; i < specialString.length; ++i) {
                if (text.indexOf(specialString[i]) < 0) continue;
                return true;
            }
        }
        return false;
    }

    public static InternetAddress[] getInternetAddress(String addressList) throws Exception {
        if (FAQUtils.isFieldEmpty((String)addressList)) {
            return new InternetAddress[1];
        }
        try {
            return InternetAddress.parse((String)addressList);
        }
        catch (Exception e) {
            return new InternetAddress[1];
        }
    }

    public static void setCommonContactInfor(String userId, CommonContact contact, FAQService faqService, DownloadService dservice) throws Exception {
        String urlAvt;
        OrganizationService organizationService = (OrganizationService)PortalContainer.getComponent(OrganizationService.class);
        org.exoplatform.services.organization.UserProfile profile = organizationService.getUserProfileHandler().findUserProfileByName(userId);
        if (profile.getAttribute("user.bdate") != null) {
            contact.setBirthday(profile.getAttribute("user.bdate"));
        }
        if (profile.getAttribute("user.gender") != null) {
            contact.setGender(profile.getAttribute("user.gender"));
        }
        if (profile.getAttribute("user.jobtitle") != null) {
            contact.setJob(profile.getAttribute("user.jobtitle"));
        }
        if (profile.getAttribute("user.business-info.online.email") != null) {
            contact.setEmailAddress(profile.getAttribute("user.business-info.online.email"));
        }
        if (profile.getAttribute("user.business-info.postal.city") != null) {
            contact.setCity(profile.getAttribute("user.business-info.postal.city"));
        }
        if (profile.getAttribute("user.business-info.postal.country") != null) {
            contact.setCountry(profile.getAttribute("user.business-info.postal.country"));
        }
        if (profile.getAttribute("user.business-info.telecom.mobile.number") != null) {
            contact.setMobile(profile.getAttribute("user.business-info.telecom.mobile.number"));
        }
        if (profile.getAttribute("user.business-info.telecom.telephone.number") != null) {
            contact.setPhone(profile.getAttribute("user.business-info.telecom.telephone.number"));
        }
        if (profile.getAttribute("user.home-info.online.uri") != null) {
            contact.setWebSite(profile.getAttribute("user.home-info.online.uri"));
        }
        if ((urlAvt = FAQUtils.getUserAvatar((String)userId)).indexOf("/faq/skin/DefaultSkin/webui/background/Avatar1.gif") >= 0 && profile.getAttribute("user.other-info.avatar.url") != null) {
            contact.setAvatarUrl(profile.getAttribute("user.other-info.avatar.url"));
        } else {
            contact.setAvatarUrl(urlAvt);
        }
    }

    public static String[] splitForFAQ(String str) throws Exception {
        if (str != null && str.length() > 0) {
            String[] temp;
            if (str.contains(",")) {
                temp = str.trim().split(",");
            } else if (str.contains(";")) {
                temp = str.split(";");
            } else {
                return new String[]{str};
            }
            ArrayList<String> ids = new ArrayList<String>();
            for (String id : temp) {
                ids.add(id.trim());
            }
            return ids.toArray(new String[ids.size()]);
        }
        return new String[0];
    }

    public static String getCurrentUser() throws Exception {
        return Util.getPortalRequestContext().getRemoteUser();
    }

    public static String getEmailUser(String userName) throws Exception {
        OrganizationService organizationService = (OrganizationService)PortalContainer.getComponent(OrganizationService.class);
        User user = organizationService.getUserHandler().findUserByName(userName);
        String email = user.getEmail();
        return email;
    }

    public static String getFullName(String userName) throws Exception {
        try {
            OrganizationService organizationService = (OrganizationService)PortalContainer.getComponent(OrganizationService.class);
            User user = organizationService.getUserHandler().findUserByName(userName);
            String fullName = user.getFullName();
            if (FAQUtils.isFieldEmpty((String)fullName)) {
                fullName = userName;
            }
            return fullName;
        }
        catch (Exception e) {
            return FAQUtils.getScreenName((String)userName, (String)"");
        }
    }

    public static String getScreenName(String userName, String fullName) {
        return userName.contains(org.exoplatform.faq.service.Utils.DELETED) ? "<s>" + (FAQUtils.isFieldEmpty((String)fullName) ? userName.substring(0, userName.indexOf(org.exoplatform.faq.service.Utils.DELETED)) : fullName) + "</s>" : userName;
    }

    public static boolean isFieldEmpty(String s) {
        return s == null || s.trim().length() <= 0;
    }

    public static boolean isValidEmailAddresses(String addressList) throws Exception {
        if (FAQUtils.isFieldEmpty((String)addressList)) {
            return true;
        }
        boolean isInvalid = true;
        try {
            InternetAddress[] iAdds = InternetAddress.parse((String)addressList, (boolean)true);
            String emailRegex = "[_A-Za-z0-9-]+(\\.[_A-Za-z0-9-]+)*@[_A-Za-z0-9-.]+\\.[A-Za-z]{2,5}";
            for (int i = 0; i < iAdds.length; ++i) {
                if (iAdds[i].getAddress().matches(emailRegex)) continue;
                isInvalid = false;
            }
        }
        catch (AddressException e) {
            return false;
        }
        return isInvalid;
    }

    public static String getResourceBundle(String resourceBundl) {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        ResourceBundle res = context.getApplicationResourceBundle();
        return res.getString(resourceBundl);
    }

    public static Map prepareMap(List inputs, Map properties) throws Exception {
        HashMap<String, JcrInputProperty> rawinputs = new HashMap<String, JcrInputProperty>();
        HashMap<String, JcrInputProperty> hasMap = new HashMap<String, JcrInputProperty>();
        for (int i = 0; i < inputs.size(); ++i) {
            JcrInputProperty property = null;
            if (inputs.get(i) instanceof UIFormMultiValueInputSet) {
                String inputName = ((UIFormMultiValueInputSet)inputs.get(i)).getName();
                if (!hasMap.containsKey(inputName)) {
                    List values = ((UIFormMultiValueInputSet)inputs.get(i)).getValue();
                    property = (JcrInputProperty)properties.get(inputName);
                    if (property != null) {
                        property.setValue((Object)values.toArray(new String[values.size()]));
                    }
                }
                hasMap.put(inputName, property);
                continue;
            }
            UIFormInputBase input = (UIFormInputBase)inputs.get(i);
            property = (JcrInputProperty)properties.get(input.getName());
            if (property == null) continue;
            if (input instanceof UIFormUploadInput) {
                byte[] content = ((UIFormUploadInput)input).getUploadData();
                property.setValue((Object)content);
                continue;
            }
            if (input instanceof UIFormDateTimeInput) {
                property.setValue((Object)((UIFormDateTimeInput)input).getCalendar());
                continue;
            }
            property.setValue(input.getValue());
        }
        for (JcrInputProperty property : properties.values()) {
            rawinputs.put(property.getJcrPath(), property);
        }
        return rawinputs;
    }

    public static String getSubString(String str, int max) {
        if (str.length() > max) {
            String newStr = str.substring(0, max - 3);
            return newStr.trim() + "...";
        }
        return str;
    }

    public static String getTitle(String text) {
        return StringUtils.replace((String)text, (String)"\"", (String)"&quot;");
    }

    public static List<String> getCategoriesIdFAQPortlet() throws Exception {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        String str = portletPref.getValue("displayCategories", "");
        ArrayList<String> list = new ArrayList<String>();
        if (!FAQUtils.isFieldEmpty((String)str)) {
            list.addAll(Arrays.asList(str.split(",")));
        }
        return list;
    }

    public static boolean getUseAjaxFAQPortlet() {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        return Boolean.parseBoolean(portletPref.getValue("useAjax", ""));
    }

    public static void saveFAQPortletPreference(List<String> list, boolean useAjax) throws Exception {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        String str = list.toString();
        str = str.replace("[", "").replace("]", "").replaceAll(" ", "");
        portletPref.setValue("displayCategories", str);
        portletPref.setValue("useAjax", String.valueOf(useAjax));
        portletPref.store();
    }

    public static void getPorletPreference(FAQSetting faqSetting) {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        faqSetting.setEnableViewAvatar(Boolean.parseBoolean(portletPref.getValue("enableViewAvatar", "")));
        faqSetting.setEnableAutomaticRSS(Boolean.parseBoolean(portletPref.getValue("enableAutomaticRSS", "")));
        faqSetting.setEnanbleVotesAndComments(Boolean.parseBoolean(portletPref.getValue("enanbleVotesAndComments", "")));
        faqSetting.setEnableAnonymousSubmitQuestion(Boolean.parseBoolean(portletPref.getValue("enableAnonymousSubmitQuestion", "")));
        faqSetting.setDisplayMode(portletPref.getValue("display", ""));
        faqSetting.setOrderBy(portletPref.getValue("orderBy", ""));
        faqSetting.setOrderType(portletPref.getValue("orderType", ""));
        faqSetting.setIsDiscussForum(Boolean.parseBoolean(portletPref.getValue("isDiscussForum", "")));
        faqSetting.setIdNameCategoryForum(portletPref.getValue("idNameCategoryForum", ""));
        faqSetting.setEmailMoveQuestion(portletPref.getValue("emailMoveQuestion", ""));
        faqSetting.setPostQuestionInRootCategory(Boolean.parseBoolean(portletPref.getValue("isPostQuestionInRootCategory", "true")));
    }

    public static void getEmailSetting(FAQSetting faqSetting, boolean isNew, boolean isSettingForm) {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        String emailContent = "";
        if (isNew) {
            emailContent = portletPref.getValue("SendMailAddNewQuestion", "");
        } else if (isSettingForm) {
            emailContent = portletPref.getValue("SendMailEditResponseQuestion", "");
        }
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        ResourceBundle res = context.getApplicationResourceBundle();
        if (emailContent == null || emailContent.trim().length() < 1) {
            emailContent = isNew ? res.getString("SendEmail.AddNewQuestion.Default") : (isSettingForm ? res.getString("SendEmail.EditQuestion.Default") : res.getString("SendEmail.ResponseQuestion.Default"));
        }
        faqSetting.setEmailSettingSubject(res.getString("SendEmail.Default.Subject"));
        faqSetting.setEmailSettingContent(emailContent);
    }

    public static String getEmailMoveQuestion(FAQSetting faqSetting) {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        String str = portletPref.getValue("emailMoveQuestion", "");
        if (FAQUtils.isFieldEmpty((String)str)) {
            WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
            ResourceBundle res = context.getApplicationResourceBundle();
            str = res.getString("SendEmail.MoveQuetstion.Default");
        }
        faqSetting.setEmailMoveQuestion(str);
        return str;
    }

    public static void savePortletPreference(FAQSetting setting, String emailAddNewQuestion, String emailEditResponseQuestion) {
        try {
            PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
            PortletPreferences portletPref = pcontext.getRequest().getPreferences();
            portletPref.setValue("display", setting.getDisplayMode());
            portletPref.setValue("orderBy", setting.getOrderBy());
            portletPref.setValue("orderType", setting.getOrderType());
            portletPref.setValue("isDiscussForum", String.valueOf(setting.getIsDiscussForum()));
            portletPref.setValue("idNameCategoryForum", setting.getIdNameCategoryForum());
            portletPref.setValue("enableAutomaticRSS", setting.isEnableAutomaticRSS() + "");
            portletPref.setValue("enableViewAvatar", setting.isEnableViewAvatar() + "");
            portletPref.setValue("enanbleVotesAndComments", setting.isEnanbleVotesAndComments() + "");
            portletPref.setValue("enableAnonymousSubmitQuestion", setting.isEnableAnonymousSubmitQuestion() + "");
            portletPref.setValue("SendMailAddNewQuestion", emailAddNewQuestion);
            portletPref.setValue("SendMailEditResponseQuestion", emailEditResponseQuestion);
            portletPref.setValue("emailMoveQuestion", setting.getEmailMoveQuestion());
            portletPref.setValue("isPostQuestionInRootCategory", setting.isPostQuestionInRootCategory() + "");
            portletPref.store();
        }
        catch (Exception e) {
            log.error((Object)"Fail to save portlet preferences: ", (Throwable)e);
        }
    }

    private static String getFormatDate(int dateFormat, Date myDate) {
        if (myDate == null) {
            return "";
        }
        String format = dateFormat == 1 ? "DDD,MMM dd,yyyy" : "MM/dd/yyyy";
        try {
            String userName = FAQUtils.getCurrentUser();
            if (!FAQUtils.isFieldEmpty((String)userName)) {
                ForumService forumService = (ForumService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ForumService.class);
                UserProfile profile = forumService.getUserSettingProfile(userName);
                format = dateFormat == 1 ? profile.getLongDateFormat() : profile.getShortDateFormat();
            }
        }
        catch (Exception e) {
            log.debug((Object)("No forum settings found for date format. Will use format " + format));
        }
        if (!FAQUtils.isFieldEmpty((String)format)) {
            if (format.indexOf("DDDD") >= 0) {
                format = format.replaceAll("DDDD", "EEEE");
            }
            if (format.indexOf("DDD") >= 0) {
                format = format.replaceAll("DDD", "EEE");
            }
        }
        PortalRequestContext portalContext = Util.getPortalRequestContext();
        SimpleDateFormat formatter = new SimpleDateFormat(format, portalContext.getLocale());
        return formatter.format((Object)myDate);
    }

    public static String getLongDateFormat(Date myDate) {
        return FAQUtils.getFormatDate((int)1, (Date)myDate);
    }

    public static String getShortDateFormat(Date myDate) {
        return FAQUtils.getFormatDate((int)3, (Date)myDate);
    }

    public static String getUserAvatar(String userName) throws Exception {
        String url = "";
        try {
            FAQService service = FAQUtils.getFAQService();
            FileAttachment avatar = service.getUserAvatar(userName);
            if (avatar != null) {
                url = Utils.getImageUrl((String)avatar.getPath()) + "?size=" + avatar.getSize();
            }
        }
        catch (Exception e) {
            log.debug((Object)("Failed to get user avatar of user: " + userName), (Throwable)e);
        }
        return FAQUtils.isFieldEmpty((String)url) ? "/faq/skin/DefaultSkin/webui/background/Avatar1.gif" : url;
    }

    public static String getFileSource(FileAttachment attachment) throws Exception {
        DownloadService dservice = (DownloadService)PortalContainer.getComponent(DownloadService.class);
        try {
            InputStream input = attachment.getInputStream();
            String fileName = attachment.getName();
            byte[] imageBytes = null;
            if (input != null) {
                imageBytes = new byte[input.available()];
                input.read(imageBytes);
                ByteArrayInputStream byteImage = new ByteArrayInputStream(imageBytes);
                InputStreamDownloadResource dresource = new InputStreamDownloadResource((InputStream)byteImage, "image");
                dresource.setDownloadName(fileName);
                return dservice.getDownloadLink(dservice.addDownloadResource((DownloadResource)dresource));
            }
        }
        catch (Exception e) {
            log.error((Object)("Can not get File Source, exception: " + e.getMessage()));
        }
        return "";
    }

    public static String getLink(String link, String componentId, String componentIdhasAction, String action, String actionRep, String objectId) {
        PortalRequestContext portalContext = Util.getPortalRequestContext();
        String url = portalContext.getRequest().getRequestURL().toString();
        url = url.substring(0, url.indexOf("/", 8));
        link = link.replaceFirst(componentId, componentIdhasAction).replaceFirst(action, actionRep).replaceFirst("OBJECTID", objectId).replaceAll("amp;", "");
        link = url + link;
        return link;
    }

    public static String getLinkDiscuss(String topicId) throws Exception {
        PortalRequestContext portalContext = Util.getPortalRequestContext();
        String link = portalContext.getRequest().getRequestURL().toString();
        try {
            String selectedNode = Util.getUIPortal().getSelectedUserNode().getURI();
            String portalName = "/" + Util.getUIPortal().getName();
            if (link.indexOf(portalName) > 0 && link.indexOf(portalName + "/" + selectedNode) < 0) {
                link = link.replaceFirst(portalName, portalName + "/" + selectedNode);
            }
            link = link.substring(0, link.indexOf(selectedNode) + selectedNode.length());
            link = link.replaceAll(selectedNode, "forum") + "/" + org.exoplatform.forum.service.Utils.TOPIC + "/" + topicId;
        }
        catch (Exception e) {
            log.error((Object)"Fail to get link discuss: ", (Throwable)e);
        }
        return link;
    }

    public static int getLimitUploadSize(boolean isAvatar) {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        int limitMB = -1;
        try {
            limitMB = isAvatar ? Integer.parseInt(portletPref.getValue(UPLOAD_AVATAR_SIZE, "").trim()) : Integer.parseInt(portletPref.getValue(UPLOAD_FILE_SIZE, "").trim());
        }
        catch (Exception e) {
            // empty catch block
        }
        return limitMB;
    }
}

