/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.webui;

import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.FAQSetting;
import org.exoplatform.faq.service.Utils;
import org.exoplatform.faq.webui.FAQUtils;
import org.exoplatform.faq.webui.UIAnswersContainer;
import org.exoplatform.faq.webui.UIBreadcumbs;
import org.exoplatform.faq.webui.UICategories;
import org.exoplatform.faq.webui.UIQuestions;
import org.exoplatform.faq.webui.popup.UISettingForm;
import org.exoplatform.ks.common.webui.UIPopupAction;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;
import org.exoplatform.webui.form.UIFormInputInfo;

@ComponentConfig(lifecycle=UIApplicationLifecycle.class, template="app:/templates/faq/webui/UIAnswersPortlet.gtmpl")
public class UIAnswersPortlet
extends UIPortletApplication {
    private static final String SPACE_URL = "SPACE_URL".intern();
    private static final String SLASH = "/".intern();
    private boolean isFirstTime = true;
    private UIFormInputInfo changeModeMessage = new UIFormInputInfo("UIMessageEditMode", "UIMessageEditMode", "");
    private PortletMode portletMode;

    public UIAnswersPortlet() throws Exception {
        this.changeModeMessage.setRendered(false);
        this.addChild((UIComponent)this.changeModeMessage);
        this.addChild(UIAnswersContainer.class, null, null);
        UIPopupAction uiPopup = (UIPopupAction)this.addChild(UIPopupAction.class, null, null);
        uiPopup.setId("UIAnswersPopupAction");
        ((UIPopupWindow)uiPopup.getChild(UIPopupWindow.class)).setId("UIAnswersPopupWindow");
    }

    public String getSpaceCategoryId() {
        try {
            PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
            PortletPreferences pref = pcontext.getRequest().getPreferences();
            if (pref.getValue(SPACE_URL, null) != null) {
                SpaceService sService = (SpaceService)this.getApplicationComponent(SpaceService.class);
                FAQService fService = (FAQService)this.getApplicationComponent(FAQService.class);
                String url = pref.getValue(SPACE_URL, null);
                Space space = sService.getSpaceByUrl(url);
                String categoryId = Utils.CATE_SPACE_ID_PREFIX + space.getPrettyName();
                if (fService.isExisting("categories" + SLASH + categoryId)) {
                    return categoryId;
                }
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void processRender(WebuiApplication app, WebuiRequestContext context) throws Exception {
        PortletRequestContext portletReqContext = (PortletRequestContext)context;
        this.portletMode = portletReqContext.getApplicationMode();
        if (this.portletMode == PortletMode.VIEW) {
            this.changeModeMessage.setRendered(false);
            this.isFirstTime = true;
            if (this.getChild(UIAnswersContainer.class) == null) {
                if (this.getChild(UISettingForm.class) != null) {
                    this.removeChild(UISettingForm.class);
                }
                this.addChild(UIAnswersContainer.class, null, null);
            }
            this.renderPortletById();
        } else if (this.portletMode == PortletMode.EDIT) {
            try {
                this.changeModeMessage.setValue((Object)context.getApplicationResourceBundle().getString("UIAnswersPortlet.label.deny-access-edit-mode"));
                if (this.isFirstTime) {
                    this.isFirstTime = false;
                    UIQuestions questions = (UIQuestions)((UIAnswersContainer)this.getChild(UIAnswersContainer.class)).getChild(UIQuestions.class);
                    FAQSetting faqSetting = questions.getFAQSetting();
                    this.removeChild(UIAnswersContainer.class);
                    if (this.getChild(UISettingForm.class) == null) {
                        if (faqSetting.isAdmin()) {
                            UISettingForm settingForm = (UISettingForm)this.addChild(UISettingForm.class, null, "FAQPortletSetting");
                            settingForm.setRendered(true);
                            settingForm.setIsEditPortlet(true);
                            settingForm.init();
                        } else {
                            this.changeModeMessage.setRendered(true);
                        }
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)"\nFail to render a WebUIApplication\n", (Throwable)e);
            }
        }
        super.processRender(app, context);
    }

    private void renderPortletById() throws Exception {
        try {
            String cateId = this.getSpaceCategoryId();
            PortalRequestContext context = Util.getPortalRequestContext();
            if (!FAQUtils.isFieldEmpty((String)cateId) && context.getRequestParameter("objectId") == null && !"true".equals("" + context.getRequestParameter("ajaxRequest"))) {
                UIBreadcumbs uiBreadcums = (UIBreadcumbs)this.findFirstComponentOfType(UIBreadcumbs.class);
                UIQuestions uiQuestions = (UIQuestions)this.findFirstComponentOfType(UIQuestions.class);
                UICategories categories = (UICategories)this.findFirstComponentOfType(UICategories.class);
                uiBreadcums.setUpdataPath("categories/" + cateId);
                uiBreadcums.setRenderSearch(true);
                uiQuestions.setCategoryId("categories/" + cateId);
                categories.setPathCategory("categories/" + cateId);
            }
        }
        catch (Exception e) {
            log.error((Object)"can not render the selected category", (Throwable)e);
        }
    }

    public void cancelAction() throws Exception {
        WebuiRequestContext context = (WebuiRequestContext)RequestContext.getCurrentInstance();
        UIPopupAction popupAction = (UIPopupAction)this.getChild(UIPopupAction.class);
        popupAction.deActivate();
        context.addUIComponentToUpdateByAjax((UIComponent)popupAction);
    }

    public static String getPreferenceDisplay() {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        String repository = portletPref.getValue("display", "");
        return repository;
    }
}

