/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.webui.popup;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.faq.service.Cate;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.FAQSetting;
import org.exoplatform.faq.webui.FAQUtils;
import org.exoplatform.faq.webui.popup.UIFAQSettingForm;
import org.exoplatform.ks.common.webui.BaseUIForm;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormInputWithActions;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.input.UICheckBoxInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/faq/webui/popup/UIFAQSettingForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={SelectTabActionListener.class})})
public class UIFAQSettingForm
extends BaseUIForm
implements UIPopupComponent {
    public static final String SELECT_CATEGORY_TAB = "SelectCategoryTab";
    public static final String EDIT_TEMPLATE_TAB = "EditTemplateTab";
    public static final String PREFERENCE_TAB = "PreferenceTab";
    public static final String FIELD_TEMPLATE_TEXTARE = "ContentTemplate";
    public static final String FIELD_USEAJAX_CHECKBOX = "UseAjax";
    private FAQSetting faqSetting_;
    private List<Cate> listCate = new ArrayList();
    private FAQService faqService_;
    private int id_ = 0;
    private boolean useAjax = false;
    private List<String> categoriesId = new ArrayList();
    private String homeCategoryName = "";

    public UIFAQSettingForm() throws Exception {
        this.faqService_ = (FAQService)PortalContainer.getInstance().getComponentInstanceOfType(FAQService.class);
        UIFormInputWithActions selectCategoryTab = new UIFormInputWithActions(SELECT_CATEGORY_TAB);
        UIFormInputWithActions editTemplateTab = new UIFormInputWithActions(EDIT_TEMPLATE_TAB);
        UIFormInputWithActions preferenceTab = new UIFormInputWithActions(PREFERENCE_TAB);
        UIFormTextAreaInput textAreaInput = new UIFormTextAreaInput(FIELD_TEMPLATE_TEXTARE, FIELD_TEMPLATE_TEXTARE, null);
        editTemplateTab.addUIFormInput((UIFormInput)textAreaInput);
        this.homeCategoryName = this.faqService_.getCategoryNameOf("categories");
        this.initSettingForm();
        UICheckBoxInput checkBoxInput = null;
        for (Cate cate : this.listCate) {
            checkBoxInput = new UICheckBoxInput(cate.getCategory().getId(), cate.getCategory().getId(), Boolean.valueOf(false));
            checkBoxInput.setChecked(cate.getCategory().isView());
            selectCategoryTab.addChild((UIComponent)checkBoxInput);
        }
        UICheckBoxInput useAjaxCheckBox = new UICheckBoxInput(FIELD_USEAJAX_CHECKBOX, FIELD_USEAJAX_CHECKBOX, Boolean.valueOf(false));
        useAjaxCheckBox.setChecked(this.useAjax);
        preferenceTab.addChild((UIComponent)useAjaxCheckBox);
        this.addUIFormInput((UIFormInputSet)selectCategoryTab);
        this.addUIFormInput((UIFormInputSet)editTemplateTab);
        this.addUIFormInput((UIFormInputSet)preferenceTab);
        this.setTemplateEdit();
        this.setActions(new String[]{"Save"});
    }

    public List<String> getCategoriesId() {
        return this.categoriesId;
    }

    private boolean getIsSelected(int id) {
        return this.id_ == id;
    }

    private void setTemplateEdit() throws Exception {
        byte[] data = this.faqService_.getTemplate();
        String template = new String(data);
        if (FAQUtils.isFieldEmpty((String)template)) {
            // empty if block
        }
        UIFormInputWithActions withActions = (UIFormInputWithActions)this.getChildById(EDIT_TEMPLATE_TAB);
        withActions.getUIFormTextAreaInput(FIELD_TEMPLATE_TEXTARE).setValue((Object)template);
    }

    private List<Cate> getListCate() {
        return this.listCate;
    }

    public void initSettingForm() throws Exception {
        this.categoriesId = FAQUtils.getCategoriesIdFAQPortlet();
        this.useAjax = FAQUtils.getUseAjaxFAQPortlet();
        this.listCate.addAll(this.faqService_.listingCategoryTree());
        this.faqSetting_ = new FAQSetting();
        String orderType = this.faqSetting_.getOrderType();
        if (orderType == null || orderType.equals("asc")) {
            this.faqSetting_.setOrderType("desc");
        } else {
            this.faqSetting_.setOrderType("asc");
        }
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    private List<String> getCheckedId() throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        UIFormInputWithActions selectCateTab = (UIFormInputWithActions)this.getChildById(SELECT_CATEGORY_TAB);
        List children = selectCateTab.getChildren();
        for (UIComponent child : children) {
            if (!(child instanceof UICheckBoxInput) || !((UICheckBoxInput)child).isChecked()) continue;
            list.add(child.getId());
        }
        UIFormInputWithActions withActions = (UIFormInputWithActions)this.getChildById(PREFERENCE_TAB);
        UICheckBoxInput useAjaxCheckBox = withActions.getUICheckBoxInput(FIELD_USEAJAX_CHECKBOX);
        this.useAjax = useAjaxCheckBox.isChecked();
        return list;
    }

    static /* synthetic */ int access$000(UIFAQSettingForm x0) {
        return x0.id_;
    }

    static /* synthetic */ FAQService access$100(UIFAQSettingForm x0) {
        return x0.faqService_;
    }

    static /* synthetic */ void access$200(UIFAQSettingForm x0) throws Exception {
        x0.setTemplateEdit();
    }

    static /* synthetic */ List access$302(UIFAQSettingForm x0, List x1) {
        x0.categoriesId = x1;
        return x0.categoriesId;
    }

    static /* synthetic */ List access$400(UIFAQSettingForm x0) throws Exception {
        return x0.getCheckedId();
    }

    static /* synthetic */ List access$300(UIFAQSettingForm x0) {
        return x0.categoriesId;
    }

    static /* synthetic */ boolean access$500(UIFAQSettingForm x0) {
        return x0.useAjax;
    }

    static /* synthetic */ int access$002(UIFAQSettingForm x0, int x1) {
        x0.id_ = x1;
        return x0.id_;
    }
}

