/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.exoplatform.commons.utils.ISO8601;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForumEventQuery {
    long userPermission = 0L;
    List<String> listOfUser = null;
    private String type;
    private String keyValue;
    private String valueIn;
    private String path;
    private String byUser;
    private String isLock;
    private String isClosed;
    private String topicCountMin;
    private String postCountMin;
    private String viewCountMin;
    private String moderator;
    private String remain;
    private Calendar fromDateCreated;
    private Calendar toDateCreated;
    private Calendar fromDateCreatedLastPost;
    private Calendar toDateCreatedLastPost;
    private boolean isAnd = false;
    private boolean isEmpty = true;

    public void setListOfUser(List<String> listOfUser) {
        this.listOfUser = new ArrayList<String>();
        this.listOfUser.addAll(listOfUser);
    }

    public long getUserPermission() {
        return this.userPermission;
    }

    public void setUserPermission(long userPermission) {
        this.userPermission = userPermission;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getKeyValue() {
        return this.keyValue;
    }

    public void setKeyValue(String keyValue) {
        this.keyValue = keyValue;
    }

    public String getValueIn() {
        return this.valueIn;
    }

    public void setValueIn(String valueIn) {
        this.valueIn = valueIn;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getByUser() {
        return this.byUser;
    }

    public void setByUser(String byUser) {
        this.byUser = byUser;
    }

    public String getIsLock() {
        return this.isLock;
    }

    public void setIsLock(String isLock) {
        this.isLock = isLock;
    }

    public String getIsClose() {
        return this.isClosed;
    }

    public void setIsClose(String isClosed) {
        this.isClosed = isClosed;
    }

    public String getTopicCountMin() {
        return this.topicCountMin;
    }

    public void setTopicCountMin(String topicCountMin) {
        this.topicCountMin = topicCountMin;
    }

    public String getPostCountMin() {
        return this.postCountMin;
    }

    public void setPostCountMin(String postCountMin) {
        this.postCountMin = postCountMin;
    }

    public String getViewCountMin() {
        return this.viewCountMin;
    }

    public void setViewCountMin(String viewCountMin) {
        this.viewCountMin = viewCountMin;
    }

    public String getModerator() {
        return this.moderator;
    }

    public void setModerator(String moderator) {
        this.moderator = moderator;
    }

    public String getRemain() {
        return this.remain;
    }

    public void setRemain(String remain) {
        this.remain = remain;
    }

    public Calendar getFromDateCreated() {
        return this.fromDateCreated;
    }

    public void setFromDateCreated(Calendar fromDateCreated) {
        this.fromDateCreated = fromDateCreated;
    }

    public Calendar getToDateCreated() {
        return this.toDateCreated;
    }

    public void setToDateCreated(Calendar toDateCreated) {
        this.toDateCreated = toDateCreated;
    }

    public Calendar getFromDateCreatedLastPost() {
        return this.fromDateCreatedLastPost;
    }

    public void setFromDateCreatedLastPost(Calendar fromDateCreatedLastPost) {
        this.fromDateCreatedLastPost = fromDateCreatedLastPost;
    }

    public Calendar getToDateCreatedLastPost() {
        return this.toDateCreatedLastPost;
    }

    public void setToDateCreatedLastPost(Calendar toDateCreatedLastPost) {
        this.toDateCreatedLastPost = toDateCreatedLastPost;
    }

    public boolean getIsEmpty() {
        return this.isEmpty;
    }

    public String getPathQuery() {
        String temp;
        this.isAnd = false;
        this.isEmpty = true;
        StringBuffer queryString = new StringBuffer();
        if (this.path != null && this.path.length() > 0) {
            queryString.append("/jcr:root").append(this.path).append("//element(*,exo:").append(this.type).append(")");
        } else {
            queryString.append("//element(*,exo:").append(this.type).append(")");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        if (this.valueIn.equals("title")) {
            if (this.keyValue != null && this.keyValue.length() > 0) {
                stringBuffer.append("(jcr:contains(@exo:name, '").append(this.keyValue).append("'))");
                this.isAnd = true;
            }
        } else if (this.keyValue != null && this.keyValue.length() > 0) {
            stringBuffer.append("(jcr:contains(., '").append(this.keyValue).append("'))");
            this.isAnd = true;
        }
        if (this.byUser != null && this.byUser.length() > 0) {
            if (this.isAnd) {
                stringBuffer.append(" and ");
            }
            stringBuffer.append("(");
            this.byUser = this.byUser.replaceAll(";", ",");
            String[] users = this.byUser.split(",");
            int i = 0;
            for (String string : users) {
                string = string.trim();
                if (i > 0) {
                    stringBuffer.append(" or ");
                }
                stringBuffer.append("(@exo:owner='").append(string).append("')");
                ++i;
            }
            stringBuffer.append(")");
            this.isAnd = true;
        }
        if (this.isAnd) {
            this.isEmpty = false;
        }
        if (this.isClosed != null && this.isClosed.length() > 0) {
            if (this.userPermission == 1L) {
                if (this.type.equals("forum")) {
                    if (this.isAnd) {
                        stringBuffer.append(" and ");
                    }
                    if (this.isClosed.equals("all")) {
                        stringBuffer.append("(@exo:isClosed='false'");
                        for (String str : this.listOfUser) {
                            stringBuffer.append(" or @exo:moderators='").append(str).append("'");
                        }
                        stringBuffer.append(")");
                    } else if (this.isClosed.equals("false")) {
                        stringBuffer.append("(@exo:isClosed='").append(this.isClosed).append("')");
                    } else if (this.isClosed.equals("true")) {
                        stringBuffer.append("(@exo:isClosed='").append(this.isClosed).append("' and (@exo:moderators='").append(this.listOfUser.get(0)).append("'");
                        for (String str : this.listOfUser) {
                            stringBuffer.append(" or @exo:moderators='").append(str).append("'");
                        }
                        stringBuffer.append("))");
                    }
                    this.isAnd = true;
                } else if (!this.isClosed.equals("all")) {
                    if (this.isAnd) {
                        stringBuffer.append(" and ");
                    }
                    stringBuffer.append("(@exo:isClosed='").append(this.isClosed).append("')");
                    this.isAnd = true;
                }
            } else if (!this.isClosed.equals("all")) {
                if (this.isAnd) {
                    stringBuffer.append(" and ");
                }
                stringBuffer.append("(@exo:isClosed='").append(this.isClosed).append("')");
                this.isAnd = true;
            }
        }
        if (this.isLock != null && this.isLock.length() > 0 && !this.isLock.equals("all")) {
            if (this.isAnd) {
                stringBuffer.append(" and ");
            }
            stringBuffer.append("(@exo:isLock='").append(this.isLock).append("')");
            this.isAnd = true;
            this.isEmpty = false;
        }
        if (this.remain != null && this.remain.length() > 0) {
            if (this.isAnd) {
                stringBuffer.append(" and ");
            }
            stringBuffer.append("(").append(this.remain).append(")");
            this.isAnd = true;
        }
        if (this.moderator != null && this.moderator.length() > 0) {
            if (this.isAnd) {
                stringBuffer.append(" and ");
            }
            stringBuffer.append("(@exo:moderators='").append(this.moderator).append("')");
            this.isAnd = true;
            this.isEmpty = false;
        }
        if ((temp = this.setValueMin(this.topicCountMin, "topicCount")) != null && temp.length() > 0) {
            stringBuffer.append(temp);
        }
        if ((temp = this.setValueMin(this.postCountMin, "postCount")) != null && temp.length() > 0) {
            stringBuffer.append(temp);
        }
        if ((temp = this.setValueMin(this.viewCountMin, "viewCount")) != null && temp.length() > 0) {
            stringBuffer.append(temp);
        }
        if ((temp = this.setDateFromTo(this.fromDateCreated, this.toDateCreated, "createdDate")) != null && temp.length() > 0) {
            stringBuffer.append(temp);
        }
        if ((temp = this.setDateFromTo(this.fromDateCreatedLastPost, this.toDateCreatedLastPost, "lastPostDate")) != null && temp.length() > 0) {
            stringBuffer.append(temp);
        }
        if (this.type.equals("topic") && this.userPermission > 1L) {
            if (this.isAnd) {
                stringBuffer.append(" and ");
            }
            stringBuffer.append("(@exo:isApproved='true' and @exo:isActive='true' and @exo:isWaiting='false' and @exo:isActiveByForum='true')");
        } else if (this.type.equals("post")) {
            if (this.isAnd) {
                stringBuffer.append(" and ");
            }
            stringBuffer.append("(@exo:userPrivate='exoUserPri'");
            for (String currentUser : this.listOfUser) {
                stringBuffer.append(" or @exo:userPrivate='").append(currentUser).append("'");
            }
            stringBuffer.append(") and (@exo:isFirstPost='false')");
            if (this.userPermission > 1L) {
                stringBuffer.append(" and (@exo:isApproved='true' and @exo:isActiveByTopic='true' and @exo:isHidden='false')");
            }
        }
        stringBuffer.append("]");
        if (this.isAnd) {
            queryString.append(stringBuffer.toString());
        }
        return queryString.toString();
    }

    private String setValueMin(String min, String property) {
        StringBuffer queryString = new StringBuffer();
        if (Integer.parseInt(min) > 0) {
            if (this.isAnd) {
                queryString.append(" and ");
            }
            queryString.append("(@exo:").append(property).append(">=").append(min).append(")");
            this.isAnd = true;
            this.isEmpty = false;
        }
        return queryString.toString();
    }

    private String setDateFromTo(Calendar fromDate, Calendar toDate, String property) {
        StringBuffer queryString = new StringBuffer();
        if (fromDate != null && toDate != null) {
            if (this.isAnd) {
                queryString.append(" and ");
            }
            queryString.append("((@exo:").append(property).append(" >= xs:dateTime('").append(ISO8601.format((Calendar)fromDate)).append("')) and ");
            queryString.append("(@exo:").append(property).append(" <= xs:dateTime('").append(ISO8601.format((Calendar)toDate)).append("'))) ");
            this.isAnd = true;
            this.isEmpty = false;
        } else if (fromDate != null) {
            if (this.isAnd) {
                queryString.append(" and ");
            }
            queryString.append("(@exo:").append(property).append(" >= xs:dateTime('").append(ISO8601.format((Calendar)fromDate)).append("'))");
            this.isAnd = true;
            this.isEmpty = false;
        } else if (toDate != null) {
            if (this.isAnd) {
                queryString.append(" and ");
            }
            queryString.append("(@exo:").append(property).append(" <= xs:dateTime('").append(ISO8601.format((Calendar)toDate)).append("'))");
            this.isAnd = true;
            this.isEmpty = false;
        }
        return queryString.toString();
    }
}

