/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service;

import java.util.List;
import org.exoplatform.forum.service.ForumSearch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JCRPageList {
    private long pageSize_;
    protected long available_ = 0L;
    protected long availablePage_ = 1L;
    protected long currentPage_ = 1L;
    protected List currentListPage_;
    protected long pageSelected = 1L;

    public JCRPageList(long pageSize) {
        this.pageSize_ = pageSize;
    }

    public long getPageSelected() {
        return this.pageSelected;
    }

    public long getPageSize() {
        return this.pageSize_;
    }

    public void setPageSize(long pageSize) {
        this.pageSize_ = pageSize;
        this.setAvailablePage(this.available_);
    }

    public long getCurrentPage() {
        return this.currentPage_;
    }

    public long getAvailable() {
        return this.available_;
    }

    public long getAvailablePage() {
        return this.availablePage_;
    }

    public List currentPage() throws Exception {
        if (this.currentListPage_ == null) {
            this.populateCurrentPage(this.currentPage_);
        }
        return this.currentListPage_;
    }

    protected abstract void populateCurrentPage(long var1) throws Exception;

    public List getPage(long page) throws Exception {
        this.checkAndSetPage(page);
        this.populateCurrentPage(this.currentPage_);
        this.pageSelected = page;
        return this.currentListPage_;
    }

    protected abstract void populateCurrentPage(String var1) throws Exception;

    public List getpage(String valueSearch) throws Exception {
        this.populateCurrentPage(valueSearch);
        return this.currentListPage_;
    }

    protected abstract void populateCurrentPageSearch(long var1, List var3) throws Exception;

    public List getPageSearch(long page, List<ForumSearch> list) throws Exception {
        this.checkAndSetPage(page);
        this.populateCurrentPageSearch(page, list);
        return this.currentListPage_;
    }

    protected abstract void populateCurrentPageList(long var1, List<String> var3) throws Exception;

    public List getPageList(long page, List<String> list) throws Exception {
        this.checkAndSetPage(page);
        this.populateCurrentPageList(page, list);
        return this.currentListPage_;
    }

    protected void checkAndSetPage(long page) throws Exception {
        if (page < 0L) {
            page = 1L;
        } else if (page > this.availablePage_) {
            page = this.availablePage_;
        }
        this.currentPage_ = page;
    }

    protected void setAvailablePage(long available) {
        this.available_ = available;
        if (available == 0L) {
            this.availablePage_ = 1L;
            this.currentPage_ = 1L;
        } else {
            long pages = available / this.pageSize_;
            if (available % this.pageSize_ > 0L) {
                ++pages;
            }
            this.availablePage_ = pages;
        }
    }
}

