/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumAdministration;
import org.exoplatform.forum.service.ForumAttachment;
import org.exoplatform.forum.service.ForumEventQuery;
import org.exoplatform.forum.service.ForumLinkData;
import org.exoplatform.forum.service.ForumPrivateMessage;
import org.exoplatform.forum.service.ForumSearch;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.ForumStatistic;
import org.exoplatform.forum.service.JCRPageList;
import org.exoplatform.forum.service.Poll;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.Tag;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.forum.service.Watch;
import org.exoplatform.forum.service.conf.SendMessageInfo;
import org.exoplatform.forum.service.impl.JCRDataStorage;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForumServiceImpl
implements ForumService,
Startable {
    private JCRDataStorage storage_;
    private final Map<String, String> onlineUsers_ = new ConcurrentHashMap<String, String>();
    private String lastLogin_ = "";

    public ForumServiceImpl(NodeHierarchyCreator nodeHierarchyCreator, InitParams params) throws Exception {
        this.storage_ = new JCRDataStorage(nodeHierarchyCreator);
    }

    @Override
    public void addPlugin(ComponentPlugin plugin) throws Exception {
        this.storage_.addPlugin(plugin);
    }

    @Override
    public void addRolePlugin(ComponentPlugin plugin) throws Exception {
        this.storage_.addRolePlugin(plugin);
    }

    @Override
    public void addInitialDataPlugin(ComponentPlugin plugin) throws Exception {
        this.storage_.addInitialDataPlugin(plugin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        SessionProvider systemSession = SessionProvider.createSystemProvider();
        try {
            this.storage_.initCategoryListener();
            this.updateForumStatistic(systemSession);
        }
        catch (Exception e) {
        }
        finally {
            systemSession.close();
        }
        systemSession = SessionProvider.createSystemProvider();
        try {
            this.initUserProfile(systemSession);
        }
        catch (Exception e) {
        }
        finally {
            systemSession.close();
        }
        try {
            this.storage_.initDefaultData();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        systemSession = SessionProvider.createSystemProvider();
        try {
            this.storage_.evaluateActiveUsers(systemSession, "");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            systemSession.close();
        }
    }

    public void stop() {
    }

    @Override
    public void updateForumStatistic(SessionProvider systemSession) throws Exception {
        ForumStatistic forumStatistic = this.getForumStatistic(systemSession);
        if (forumStatistic.getActiveUsers() == 0L) {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            OrganizationService organizationService = (OrganizationService)container.getComponentInstanceOfType(OrganizationService.class);
            PageList pageList = organizationService.getUserHandler().getUserPageList(0);
            List userList = pageList.getAll();
            Collections.sort(userList, new Utils.DatetimeComparatorDESC());
            forumStatistic.setMembersCount(userList.size());
            forumStatistic.setNewMembers(((User)userList.get(0)).getUserName());
            this.saveForumStatistic(systemSession, forumStatistic);
        }
    }

    private void initUserProfile(SessionProvider sysSession) throws Exception {
        Node profileHome = this.storage_.getUserProfileHome(sysSession);
        if (profileHome.getNodes().getSize() == 0L) {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            OrganizationService organizationService = (OrganizationService)container.getComponentInstanceOfType(OrganizationService.class);
            PageList pageList = organizationService.getUserHandler().getUserPageList(0);
            List userList = pageList.getAll();
            for (User user : userList) {
                this.createUserProfile(sysSession, user);
            }
        }
    }

    @Override
    public void createUserProfile(SessionProvider sysSession, User user) throws Exception {
        Node profileHome = this.storage_.getUserProfileHome(sysSession);
        if (!profileHome.hasNode(user.getUserName())) {
            Node profile = profileHome.addNode(user.getUserName(), Utils.USER_PROFILES_TYPE);
            Calendar cal = this.storage_.getGreenwichMeanTime();
            profile.setProperty("exo:userId", user.getUserName());
            profile.setProperty("exo:lastLoginDate", cal);
            profile.setProperty("exo:email", user.getEmail());
            profile.setProperty("exo:fullName", user.getFullName());
            cal.setTime(user.getCreatedDate());
            profile.setProperty("exo:joinedDate", cal);
            if (this.isAdminRole(user.getUserName())) {
                profile.setProperty("exo:userTitle", "Administrator");
                profile.setProperty("exo:userRole", 0L);
            }
            if (profileHome.isNew()) {
                profileHome.getSession().save();
            } else {
                profileHome.save();
            }
        }
    }

    @Override
    public void saveCategory(SessionProvider sProvider, Category category, boolean isNew) throws Exception {
        this.storage_.saveCategory(sProvider, category, isNew);
    }

    @Override
    public Category getCategory(SessionProvider sProvider, String categoryId) throws Exception {
        return this.storage_.getCategory(sProvider, categoryId);
    }

    @Override
    public List<Category> getCategories(SessionProvider sProvider) throws Exception {
        return this.storage_.getCategories(sProvider);
    }

    @Override
    public Category removeCategory(SessionProvider sProvider, String categoryId) throws Exception {
        return this.storage_.removeCategory(sProvider, categoryId);
    }

    @Override
    public void modifyForum(SessionProvider sProvider, Forum forum, int type) throws Exception {
        this.storage_.modifyForum(sProvider, forum, type);
    }

    @Override
    public void saveForum(SessionProvider sProvider, String categoryId, Forum forum, boolean isNew) throws Exception {
        this.storage_.saveForum(sProvider, categoryId, forum, isNew);
    }

    @Override
    public void saveModerateOfForums(SessionProvider sProvider, List<String> forumPaths, String userName, boolean isDelete) throws Exception {
        this.storage_.saveModerateOfForums(sProvider, forumPaths, userName, isDelete);
    }

    @Override
    public void moveForum(SessionProvider sProvider, List<Forum> forums, String destCategoryPath) throws Exception {
        this.storage_.moveForum(sProvider, forums, destCategoryPath);
    }

    @Override
    public Forum getForum(SessionProvider sProvider, String categoryId, String forumId) throws Exception {
        return this.storage_.getForum(sProvider, categoryId, forumId);
    }

    @Override
    public List<Forum> getForums(SessionProvider sProvider, String categoryId, String strQuery) throws Exception {
        return this.storage_.getForums(sProvider, categoryId, strQuery);
    }

    @Override
    public Forum removeForum(SessionProvider sProvider, String categoryId, String forumId) throws Exception {
        return this.storage_.removeForum(sProvider, categoryId, forumId);
    }

    @Override
    public void modifyTopic(SessionProvider sProvider, List<Topic> topics, int type) throws Exception {
        this.storage_.modifyTopic(sProvider, topics, type);
    }

    @Override
    public void saveTopic(SessionProvider sProvider, String categoryId, String forumId, Topic topic, boolean isNew, boolean isMove, String defaultEmailContent) throws Exception {
        this.storage_.saveTopic(sProvider, categoryId, forumId, topic, isNew, isMove, defaultEmailContent);
    }

    @Override
    public Topic getTopic(SessionProvider sProvider, String categoryId, String forumId, String topicId, String userRead) throws Exception {
        return this.storage_.getTopic(sProvider, categoryId, forumId, topicId, userRead);
    }

    @Override
    public Topic getTopicByPath(SessionProvider sProvider, String topicPath, boolean isLastPost) throws Exception {
        return this.storage_.getTopicByPath(sProvider, topicPath, isLastPost);
    }

    @Override
    public JCRPageList getPageTopic(SessionProvider sProvider, String categoryId, String forumId, String strQuery, String strOrderBy) throws Exception {
        return this.storage_.getPageTopic(sProvider, categoryId, forumId, strQuery, strOrderBy);
    }

    @Override
    public List<Topic> getTopics(SessionProvider sProvider, String categoryId, String forumId) throws Exception {
        return this.storage_.getTopics(sProvider, categoryId, forumId);
    }

    @Override
    public void moveTopic(SessionProvider sProvider, List<Topic> topics, String destForumPath, String mailContent, String link) throws Exception {
        this.storage_.moveTopic(sProvider, topics, destForumPath, mailContent, link);
    }

    @Override
    public Topic removeTopic(SessionProvider sProvider, String categoryId, String forumId, String topicId) throws Exception {
        return this.storage_.removeTopic(sProvider, categoryId, forumId, topicId);
    }

    @Override
    public Post getPost(SessionProvider sProvider, String categoryId, String forumId, String topicId, String postId) throws Exception {
        return this.storage_.getPost(sProvider, categoryId, forumId, topicId, postId);
    }

    @Override
    public JCRPageList getPosts(SessionProvider sProvider, String categoryId, String forumId, String topicId, String isApproved, String isHidden, String strQuery, String userLogin) throws Exception {
        return this.storage_.getPosts(sProvider, categoryId, forumId, topicId, isApproved, isHidden, strQuery, userLogin);
    }

    @Override
    public long getAvailablePost(SessionProvider sProvider, String categoryId, String forumId, String topicId, String isApproved, String isHidden, String userLogin) throws Exception {
        return this.storage_.getAvailablePost(sProvider, categoryId, forumId, topicId, isApproved, isHidden, userLogin);
    }

    @Override
    public void savePost(SessionProvider sProvider, String categoryId, String forumId, String topicId, Post post, boolean isNew, String defaultEmailContent) throws Exception {
        this.storage_.savePost(sProvider, categoryId, forumId, topicId, post, isNew, defaultEmailContent);
    }

    @Override
    public void modifyPost(SessionProvider sProvider, List<Post> posts, int type) throws Exception {
        this.storage_.modifyPost(sProvider, posts, type);
    }

    @Override
    public void movePost(SessionProvider sProvider, List<Post> posts, String destTopicPath, boolean isCreatNewTopic, String mailContent, String link) throws Exception {
        this.storage_.movePost(sProvider, posts, destTopicPath, isCreatNewTopic, mailContent, link);
    }

    @Override
    public Post removePost(SessionProvider sProvider, String categoryId, String forumId, String topicId, String postId) throws Exception {
        return this.storage_.removePost(sProvider, categoryId, forumId, topicId, postId);
    }

    @Override
    public Object getObjectNameByPath(SessionProvider sProvider, String path) throws Exception {
        return this.storage_.getObjectNameByPath(sProvider, path);
    }

    @Override
    public Object getObjectNameById(SessionProvider sProvider, String path, String type) throws Exception {
        return this.storage_.getObjectNameById(sProvider, path, type);
    }

    @Override
    public List<ForumLinkData> getAllLink(SessionProvider sProvider, String strQueryCate, String strQueryForum) throws Exception {
        return this.storage_.getAllLink(sProvider, strQueryCate, strQueryForum);
    }

    @Override
    public String getForumHomePath(SessionProvider sProvider) throws Exception {
        return this.storage_.getForumHomeNode(sProvider).getPath();
    }

    @Override
    public Poll getPoll(SessionProvider sProvider, String categoryId, String forumId, String topicId) throws Exception {
        return this.storage_.getPoll(sProvider, categoryId, forumId, topicId);
    }

    @Override
    public Poll removePoll(SessionProvider sProvider, String categoryId, String forumId, String topicId) throws Exception {
        return this.storage_.removePoll(sProvider, categoryId, forumId, topicId);
    }

    @Override
    public void savePoll(SessionProvider sProvider, String categoryId, String forumId, String topicId, Poll poll, boolean isNew, boolean isVote) throws Exception {
        this.storage_.savePoll(sProvider, categoryId, forumId, topicId, poll, isNew, isVote);
    }

    @Override
    public void setClosedPoll(SessionProvider sProvider, String categoryId, String forumId, String topicId, Poll poll) throws Exception {
        this.storage_.setClosedPoll(sProvider, categoryId, forumId, topicId, poll);
    }

    @Override
    public void addTopicInTag(SessionProvider sProvider, String tagId, String topicPath) throws Exception {
        this.storage_.addTopicInTag(sProvider, tagId, topicPath);
    }

    @Override
    public void removeTopicInTag(SessionProvider sProvider, String tagId, String topicPath) throws Exception {
        this.storage_.removeTopicInTag(sProvider, tagId, topicPath);
    }

    @Override
    public Tag getTag(SessionProvider sProvider, String tagId) throws Exception {
        return this.storage_.getTag(sProvider, tagId);
    }

    @Override
    public List<Tag> getTagsByUser(SessionProvider sProvider, String userName) throws Exception {
        return this.storage_.getTagsByUser(sProvider, userName);
    }

    @Override
    public List<Tag> getTags(SessionProvider sProvider) throws Exception {
        return this.storage_.getTags(sProvider);
    }

    @Override
    public List<Tag> getTagsByTopic(SessionProvider sProvider, String[] tagIds) throws Exception {
        return this.storage_.getTagsByTopic(sProvider, tagIds);
    }

    @Override
    public JCRPageList getTopicsByTag(SessionProvider sProvider, String tagId, String strOrderBy) throws Exception {
        return this.storage_.getTopicsByTag(sProvider, tagId, strOrderBy);
    }

    @Override
    public void saveTag(SessionProvider sProvider, Tag newTag, boolean isNew) throws Exception {
        this.storage_.saveTag(sProvider, newTag, isNew);
    }

    @Override
    public void removeTag(SessionProvider sProvider, String tagId) throws Exception {
        this.storage_.removeTag(sProvider, tagId);
    }

    @Override
    public void saveUserProfile(SessionProvider sProvider, UserProfile userProfile, boolean isOption, boolean isBan) throws Exception {
        this.storage_.saveUserProfile(sProvider, userProfile, isOption, isBan);
    }

    @Override
    public UserProfile getUserInfo(SessionProvider sProvider, String userName) throws Exception {
        return this.storage_.getUserInfo(sProvider, userName);
    }

    @Override
    public UserProfile getUserProfileManagement(SessionProvider sProvider, String userName) throws Exception {
        return this.storage_.getUserProfileManagement(sProvider, userName);
    }

    @Override
    public void saveUserBookmark(SessionProvider sProvider, String userName, String bookMark, boolean isNew) throws Exception {
        this.storage_.saveUserBookmark(sProvider, userName, bookMark, isNew);
    }

    @Override
    public JCRPageList getPageListUserProfile(SessionProvider sProvider) throws Exception {
        return this.storage_.getPageListUserProfile(sProvider);
    }

    @Override
    public JCRPageList getPrivateMessage(SessionProvider sProvider, String userName, String type) throws Exception {
        return this.storage_.getPrivateMessage(sProvider, userName, type);
    }

    @Override
    public long getNewPrivateMessage(SessionProvider sProvider, String userName) throws Exception {
        return this.storage_.getNewPrivateMessage(sProvider, userName);
    }

    @Override
    public void removePrivateMessage(SessionProvider sProvider, String messageId, String userName, String type) throws Exception {
        this.storage_.removePrivateMessage(sProvider, messageId, userName, type);
    }

    @Override
    public void saveReadMessage(SessionProvider sProvider, String messageId, String userName, String type) throws Exception {
        this.storage_.saveReadMessage(sProvider, messageId, userName, type);
    }

    @Override
    public void savePrivateMessage(SessionProvider sProvider, ForumPrivateMessage privateMessage) throws Exception {
        this.storage_.savePrivateMessage(sProvider, privateMessage);
    }

    @Override
    public JCRPageList getPageTopicOld(SessionProvider sProvider, long date) throws Exception {
        return this.storage_.getPageTopicOld(sProvider, date);
    }

    @Override
    public JCRPageList getPageTopicByUser(SessionProvider sProvider, String userName, boolean isMod, String strOrderBy) throws Exception {
        return this.storage_.getPageTopicByUser(sProvider, userName, isMod, strOrderBy);
    }

    @Override
    public JCRPageList getPagePostByUser(SessionProvider sProvider, String userName, String userId, boolean isMod, String strOrderBy) throws Exception {
        return this.storage_.getPagePostByUser(sProvider, userName, userId, isMod, strOrderBy);
    }

    @Override
    public ForumStatistic getForumStatistic(SessionProvider sProvider) throws Exception {
        return this.storage_.getForumStatistic(sProvider);
    }

    @Override
    public void saveForumStatistic(SessionProvider sProvider, ForumStatistic forumStatistic) throws Exception {
        this.storage_.saveForumStatistic(sProvider, forumStatistic);
    }

    @Override
    public void updateStatisticCounts(long topicCount, long postCount) throws Exception {
        this.storage_.updateStatisticCounts(topicCount, postCount);
    }

    @Override
    public List<ForumSearch> getQuickSearch(SessionProvider sProvider, String textQuery, String type, String pathQuery, String userId, List<String> listCateIds, List<String> listForumIds, List<String> forumIdsOfModerator) throws Exception {
        return this.storage_.getQuickSearch(sProvider, textQuery, type, pathQuery, userId, listCateIds, listForumIds, forumIdsOfModerator);
    }

    @Override
    public List<ForumSearch> getAdvancedSearch(SessionProvider sProvider, ForumEventQuery eventQuery) throws Exception {
        return this.storage_.getAdvancedSearch(sProvider, eventQuery);
    }

    @Override
    public ForumAdministration getForumAdministration(SessionProvider sProvider) throws Exception {
        return this.storage_.getForumAdministration(sProvider);
    }

    @Override
    public void saveForumAdministration(SessionProvider sProvider, ForumAdministration forumAdministration) throws Exception {
        this.storage_.saveForumAdministration(sProvider, forumAdministration);
    }

    @Override
    public void addWatch(SessionProvider sProvider, int watchType, String path, List<String> values, String currentUser) throws Exception {
        this.storage_.addWatch(sProvider, watchType, path, values, currentUser);
    }

    @Override
    public void removeWatch(SessionProvider sProvider, int watchType, String path, List<String> values) throws Exception {
        this.storage_.removeWatch(sProvider, watchType, path, values);
    }

    @Override
    public List<ForumSearch> getJobWattingForModerator(SessionProvider sProvider, String[] paths) throws Exception {
        return this.storage_.getJobWattingForModerator(sProvider, paths);
    }

    @Override
    public int getTotalJobWattingForModerator(SessionProvider sProvider, String userId) throws Exception {
        return this.storage_.getTotalJobWattingForModerator(sProvider, userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void userLogin(String userId, String userName) throws Exception {
        this.lastLogin_ = userId;
        this.onlineUsers_.put(userId, userName);
        SessionProvider sysProvider = SessionProvider.createSystemProvider();
        try {
            Node userProfileHome = this.storage_.getUserProfileHome(sysProvider);
            userProfileHome.getNode(userId).setProperty("exo:lastLoginDate", this.storage_.getGreenwichMeanTime());
            userProfileHome.save();
            Node statisticNode = this.storage_.getForumHomeNode(sysProvider).getNode(Utils.FORUM_STATISTIC);
            String[] array = statisticNode.getProperty("exo:mostUsersOnline").getString().split(",");
            if (array.length > 1) {
                int ol = this.onlineUsers_.size();
                if (ol > Integer.parseInt(array[0].trim())) {
                    statisticNode.setProperty("exo:mostUsersOnline", String.valueOf(ol) + ", at " + GregorianCalendar.getInstance().getTime().toString());
                    statisticNode.save();
                }
            } else {
                statisticNode.setProperty("exo:mostUsersOnline", "1, at " + GregorianCalendar.getInstance().getTime().toString());
                statisticNode.save();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sysProvider.close();
        }
    }

    @Override
    public void userLogout(String userId) throws Exception {
        this.onlineUsers_.remove(userId);
    }

    @Override
    public boolean isOnline(String userId) throws Exception {
        try {
            if (this.onlineUsers_.containsKey(userId) && this.onlineUsers_.get(userId) != null) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public List<String> getOnlineUsers() throws Exception {
        ArrayList<String> users = new ArrayList<String>();
        Set<String> keys = this.onlineUsers_.keySet();
        for (String key : keys) {
            users.add(this.onlineUsers_.get(key));
        }
        return users;
    }

    @Override
    public String getLastLogin() throws Exception {
        return this.lastLogin_;
    }

    @Override
    public SendMessageInfo getMessageInfo(String name) throws Exception {
        return this.storage_.getMessageInfo(name);
    }

    @Override
    public JCRPageList searchUserProfile(SessionProvider sessionProvider, String userSearch) throws Exception {
        return this.storage_.searchUserProfile(sessionProvider, userSearch);
    }

    @Override
    public boolean isAdminRole(String userName) throws Exception {
        return this.storage_.isAdminRole(userName);
    }

    @Override
    public List<Post> getNewPosts(int number) throws Exception {
        ArrayList<Post> list = null;
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        Node forumHomeNode = this.storage_.getForumHomeNode(sProvider);
        QueryManager qm = forumHomeNode.getSession().getWorkspace().getQueryManager();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("/jcr:root").append(forumHomeNode.getPath()).append("//element(*,exo:post) [((@exo:isApproved='true') and (@exo:isHidden='false') and (@exo:isActiveByTopic='true') and (@exo:userPrivate='exoUserPri'))] order by @exo:createdDate descending");
        Query query = qm.createQuery(stringBuffer.toString(), "xpath");
        QueryResult result = query.execute();
        NodeIterator iter = result.getNodes();
        int count = 0;
        while (iter.hasNext() && count++ < number) {
            if (list == null) {
                list = new ArrayList<Post>();
            }
            Post p = this.storage_.getPost(iter.nextNode());
            list.add(p);
        }
        return list;
    }

    @Override
    public NodeIterator search(String queryString, SessionProvider sessionProvider) throws Exception {
        return this.storage_.search(queryString, sessionProvider);
    }

    @Override
    public void evaluateActiveUsers(SessionProvider sysProvider, String query) throws Exception {
        this.storage_.evaluateActiveUsers(sysProvider, query);
    }

    @Override
    public void updateTopicAccess(String userId, String topicId) throws Exception {
        this.storage_.updateTopicAccess(userId, topicId);
    }

    @Override
    public void updateForumAccess(String userId, String forumId) throws Exception {
        this.storage_.updateForumAccess(userId, forumId);
    }

    @Override
    public Object exportXML(String categoryId, String forumId, String nodePath, ByteArrayOutputStream bos, SessionProvider sessionProvider) throws Exception {
        return this.storage_.exportXML(categoryId, forumId, nodePath, bos, sessionProvider);
    }

    @Override
    public List<UserProfile> getQuickProfiles(SessionProvider sProvider, List<String> userList) throws Exception {
        return this.storage_.getQuickProfiles(sProvider, userList);
    }

    @Override
    public UserProfile getQuickProfile(SessionProvider sProvider, String userName) throws Exception {
        return this.storage_.getQuickProfile(sProvider, userName);
    }

    @Override
    public UserProfile getUserInformations(SessionProvider sProvider, UserProfile userProfile) throws Exception {
        return this.storage_.getUserInformations(sProvider, userProfile);
    }

    @Override
    public UserProfile getDefaultUserProfile(SessionProvider sProvider, String userName, String ip) throws Exception {
        return this.storage_.getDefaultUserProfile(sProvider, userName, ip);
    }

    @Override
    public List<String> getBookmarks(SessionProvider sProvider, String userName) throws Exception {
        return this.storage_.getBookmarks(sProvider, userName);
    }

    @Override
    public UserProfile getUserSettingProfile(SessionProvider sProvider, String userName) throws Exception {
        return this.storage_.getUserSettingProfile(sProvider, userName);
    }

    @Override
    public void saveUserSettingProfile(SessionProvider sProvider, UserProfile userProfile) throws Exception {
        this.storage_.saveUserSettingProfile(sProvider, userProfile);
    }

    @Override
    public void importXML(String nodePath, ByteArrayInputStream bis, int typeImport, SessionProvider sessionProvider) throws Exception {
        this.storage_.importXML(nodePath, bis, typeImport, sessionProvider);
    }

    @Override
    public void updateForum(String path) throws Exception {
        this.storage_.updateForum(path);
    }

    @Override
    public List<String> getBanList() throws Exception {
        return this.storage_.getBanList();
    }

    @Override
    public boolean addBanIP(String ip) throws Exception {
        return this.storage_.addBanIP(ip);
    }

    @Override
    public void removeBan(String ip) throws Exception {
        this.storage_.removeBan(ip);
    }

    @Override
    public JCRPageList getListPostsByIP(String ip, String strOrderBy, SessionProvider sProvider) throws Exception {
        return this.storage_.getListPostsByIP(ip, strOrderBy, sProvider);
    }

    @Override
    public List<String> getForumBanList(String forumId) throws Exception {
        return this.storage_.getForumBanList(forumId);
    }

    @Override
    public boolean addBanIPForum(SessionProvider sProvider, String ip, String forumId) throws Exception {
        return this.storage_.addBanIPForum(sProvider, ip, forumId);
    }

    @Override
    public void removeBanIPForum(SessionProvider sProvider, String ip, String forumId) throws Exception {
        this.storage_.removeBanIPForum(sProvider, ip, forumId);
    }

    @Override
    public void registerListenerForCategory(SessionProvider sessionProvider, String categoryId) throws Exception {
        this.storage_.registerListenerForCategory(sessionProvider, categoryId);
    }

    @Override
    public void unRegisterListenerForCategory(String path) throws Exception {
        this.storage_.unRegisterListenerForCategory(path);
    }

    @Override
    public ForumAttachment getUserAvatar(String userName, SessionProvider sessionProvider) throws Exception {
        return this.storage_.getUserAvatar(userName, sessionProvider);
    }

    @Override
    public void saveUserAvatar(String userId, ForumAttachment fileAttachment, SessionProvider sessionProvider) throws Exception {
        this.storage_.saveUserAvatar(userId, fileAttachment, sessionProvider);
    }

    @Override
    public void setDefaultAvatar(String userName, SessionProvider sessionProvider) throws Exception {
        this.storage_.setDefaultAvatar(userName, sessionProvider);
    }

    @Override
    public List<Watch> getWatchByUser(String userId, SessionProvider sessionProvider) throws Exception {
        return this.storage_.getWatchByUser(userId, sessionProvider);
    }
}

