/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.bench;

import java.text.MessageFormat;
import java.util.List;
import org.apache.commons.logging.Log;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.forum.bench.ForumDataProvider;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.picocontainer.Startable;

public class ForumDataInitializer
implements Startable {
    private static Log log = ExoLogger.getLogger(ForumDataInitializer.class);
    private ForumService forumService;
    private ForumDataProvider provider;

    public ForumDataInitializer(InitParams initParams, ForumService forumService, ForumDataProvider provider) {
        this.provider = provider;
        this.forumService = forumService;
    }

    public void start() {
        log.info((Object)"Initializing Forum data loader...");
        try {
            this.initCategories();
        }
        catch (Exception e) {
            log.error((Object)("Failed to init : " + e.getMessage()), (Throwable)e);
        }
        log.info((Object)"Forum data loaded!");
    }

    private void initCategories() throws Exception {
        if (this.provider.isInitialized()) {
            log.info((Object)"Categories seem to be already initialized. Skipping.");
            return;
        }
        long topicsCount = 0L;
        long forumsCount = 0L;
        long postCount = 0L;
        long categoriesWeight = 0L;
        List<Category> categories = this.provider.findCategories();
        long categoriesCount = 0L;
        for (Category category : categories) {
            SessionProvider spcat = SessionProvider.createSystemProvider();
            this.forumService.saveCategory(spcat, category, true);
            String categoryId = category.getId();
            List<Forum> forums = this.provider.findForumsByCategory(categoryId);
            log.info((Object)("Category " + ++categoriesCount + "/" + categories.size() + " with " + forums.size() + " forums"));
            long forumsWeight = 0L;
            forumsCount += (long)forums.size();
            int forumNum = 0;
            for (Forum forum : forums) {
                SessionProvider spf = SessionProvider.createSystemProvider();
                this.forumService.saveForum(spf, categoryId, forum, true);
                String forumId = forum.getId();
                long topicsWeight = 0L;
                List<Topic> topics = this.provider.findTopicsByForum(forum);
                log.info((Object)("\tForum " + ++forumNum + "/" + forums.size() + " with " + topics.size() + " topics"));
                int topicNum = 0;
                for (Topic topic : topics) {
                    SessionProvider sptop = SessionProvider.createSystemProvider();
                    this.forumService.saveTopic(sptop, categoryId, forumId, topic, true, false, "");
                    String topicId = topic.getId();
                    List<Post> posts = this.provider.fingPostsByTopic(topic);
                    postCount += (long)posts.size();
                    long postsWeight = 0L;
                    long t1 = System.currentTimeMillis();
                    for (Post post : posts) {
                        SessionProvider spp = SessionProvider.createSystemProvider();
                        this.forumService.savePost(spp, categoryId, forumId, topicId, post, true, "");
                        long messageWeight = post.getMessage().length() * 2;
                        postsWeight += messageWeight;
                        spp.close();
                    }
                    double elapsed = System.currentTimeMillis() - t1;
                    double rate = (double)(postsWeight / 1024L) / (elapsed / 1000.0);
                    String srate = MessageFormat.format("({0,number,#.#} K/s)", rate);
                    log.info((Object)("\t\tTopic " + ++topicNum + "/" + topics.size() + "\t" + posts.size() + " posts in " + elapsed + "ms " + srate));
                    topicsWeight += postsWeight;
                    sptop.close();
                }
                log.info((Object)("\t\t " + topics.size() + " topics " + MessageFormat.format("({0,number,#.#} K)", topicsWeight / 1024L) + " total posts=" + postCount));
                forumsWeight += topicsWeight;
                topicsCount += (long)topics.size();
                spf.close();
            }
            log.info((Object)("\t" + forums.size() + " forums " + MessageFormat.format("({0,number,#.#} K)", forumsWeight / 1024L) + " total posts=" + postCount));
            categoriesWeight += forumsWeight;
            spcat.close();
        }
        log.info((Object)("INITIALIZED : categories=" + categories.size() + " / forums=" + forumsCount + " / topics=" + topicsCount + " / posts=" + postCount + MessageFormat.format(" ({0,number,#.#} K)", categoriesWeight / 1024L)));
    }

    public void stop() {
    }
}

