/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.List;
import javax.jcr.NodeIterator;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumAdministration;
import org.exoplatform.forum.service.ForumAttachment;
import org.exoplatform.forum.service.ForumEventQuery;
import org.exoplatform.forum.service.ForumLinkData;
import org.exoplatform.forum.service.ForumPrivateMessage;
import org.exoplatform.forum.service.ForumSearch;
import org.exoplatform.forum.service.ForumServiceLegacy;
import org.exoplatform.forum.service.ForumStatistic;
import org.exoplatform.forum.service.ForumSubscription;
import org.exoplatform.forum.service.JCRPageList;
import org.exoplatform.forum.service.LazyPageList;
import org.exoplatform.forum.service.Poll;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.PruneSetting;
import org.exoplatform.forum.service.Tag;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.service.TopicType;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.service.Watch;
import org.exoplatform.forum.service.conf.SendMessageInfo;
import org.exoplatform.ks.common.bbcode.BBCode;
import org.exoplatform.services.organization.User;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface ForumService
extends ForumServiceLegacy {
    public void addPlugin(ComponentPlugin var1) throws Exception;

    public void addRolePlugin(ComponentPlugin var1) throws Exception;

    public void addInitialDataPlugin(ComponentPlugin var1) throws Exception;

    public void addInitBBCodePlugin(ComponentPlugin var1) throws Exception;

    public void addInitRssPlugin(ComponentPlugin var1) throws Exception;

    public List<Category> getCategories() throws Exception;

    public Category getCategory(String var1) throws Exception;

    public String[] getPermissionTopicByCategory(String var1, String var2) throws Exception;

    public void saveCategory(Category var1, boolean var2) throws Exception;

    public void calculateModerator(String var1, boolean var2) throws Exception;

    public void saveModOfCategory(List<String> var1, String var2, boolean var3);

    public Category removeCategory(String var1) throws Exception;

    public List<Forum> getForums(String var1, String var2) throws Exception;

    public Forum getForum(String var1, String var2) throws Exception;

    public void modifyForum(Forum var1, int var2) throws Exception;

    public void saveForum(String var1, Forum var2, boolean var3) throws Exception;

    public void saveModerateOfForums(List<String> var1, String var2, boolean var3) throws Exception;

    public Forum removeForum(String var1, String var2) throws Exception;

    public void moveForum(List<Forum> var1, String var2) throws Exception;

    public JCRPageList getPageTopic(String var1, String var2, String var3, String var4) throws Exception;

    public JCRPageList getPageTopicByUser(String var1, boolean var2, String var3) throws Exception;

    public JCRPageList getPageTopicOld(long var1, String var3) throws Exception;

    public List<Topic> getAllTopicsOld(long var1, String var3) throws Exception;

    public long getTotalTopicOld(long var1, String var3);

    public List<Topic> getTopics(String var1, String var2) throws Exception;

    public Topic getTopic(String var1, String var2, String var3, String var4) throws Exception;

    public Topic getTopicByPath(String var1, boolean var2) throws Exception;

    public Topic getTopicSummary(String var1) throws Exception;

    public void modifyTopic(List<Topic> var1, int var2) throws Exception;

    public void saveTopic(String var1, String var2, Topic var3, boolean var4, boolean var5, String var6) throws Exception;

    public Topic removeTopic(String var1, String var2, String var3) throws Exception;

    public void moveTopic(List<Topic> var1, String var2, String var3, String var4) throws Exception;

    public JCRPageList getPosts(String var1, String var2, String var3, String var4, String var5, String var6, String var7) throws Exception;

    public long getAvailablePost(String var1, String var2, String var3, String var4, String var5, String var6) throws Exception;

    public long getLastReadIndex(String var1, String var2, String var3, String var4) throws Exception;

    public JCRPageList getPagePostByUser(String var1, String var2, boolean var3, String var4) throws Exception;

    public Post getPost(String var1, String var2, String var3, String var4) throws Exception;

    public void savePost(String var1, String var2, String var3, Post var4, boolean var5, String var6) throws Exception;

    public void modifyPost(List<Post> var1, int var2) throws Exception;

    public Post removePost(String var1, String var2, String var3, String var4) throws Exception;

    public void movePost(List<Post> var1, String var2, boolean var3, String var4, String var5) throws Exception;

    public Poll getPoll(String var1, String var2, String var3) throws Exception;

    public void savePoll(String var1, String var2, String var3, Poll var4, boolean var5, boolean var6) throws Exception;

    public Poll removePoll(String var1, String var2, String var3) throws Exception;

    public void setClosedPoll(String var1, String var2, String var3, Poll var4) throws Exception;

    public Object getObjectNameByPath(String var1) throws Exception;

    public Object getObjectNameById(String var1, String var2) throws Exception;

    public List<ForumLinkData> getAllLink(String var1, String var2) throws Exception;

    public String getForumHomePath() throws Exception;

    public void addTag(List<Tag> var1, String var2, String var3) throws Exception;

    public void unTag(String var1, String var2, String var3) throws Exception;

    public Tag getTag(String var1) throws Exception;

    public List<String> getAllTagName(String var1, String var2) throws Exception;

    public List<String> getTagNameInTopic(String var1) throws Exception;

    public List<Tag> getAllTags() throws Exception;

    public List<Tag> getMyTagInTopic(String[] var1) throws Exception;

    public JCRPageList getTopicByMyTag(String var1, String var2) throws Exception;

    public void saveTag(Tag var1) throws Exception;

    public void saveUserProfile(UserProfile var1, boolean var2, boolean var3) throws Exception;

    public void saveEmailUserProfile(String var1, String var2) throws Exception;

    public void saveUserModerator(String var1, List<String> var2, boolean var3) throws Exception;

    public JCRPageList searchUserProfile(String var1) throws Exception;

    public UserProfile getUserInfo(String var1) throws Exception;

    public List<String> getUserModerator(String var1, boolean var2) throws Exception;

    public void saveUserBookmark(String var1, String var2, boolean var3) throws Exception;

    public void saveLastPostIdRead(String var1, String[] var2, String[] var3) throws Exception;

    public void saveCollapsedCategories(String var1, String var2, boolean var3) throws Exception;

    public JCRPageList getPageListUserProfile() throws Exception;

    public void saveForumStatistic(ForumStatistic var1) throws Exception;

    public ForumStatistic getForumStatistic() throws Exception;

    public List<ForumSearch> getQuickSearch(String var1, String var2, String var3, String var4, List<String> var5, List<String> var6, List<String> var7) throws Exception;

    public String getScreenName(String var1) throws Exception;

    public List<ForumSearch> getAdvancedSearch(ForumEventQuery var1, List<String> var2, List<String> var3) throws Exception;

    public void saveForumAdministration(ForumAdministration var1) throws Exception;

    public ForumAdministration getForumAdministration() throws Exception;

    public void userLogin(String var1) throws Exception;

    public void userLogout(String var1) throws Exception;

    public boolean isOnline(String var1) throws Exception;

    public List<String> getOnlineUsers() throws Exception;

    public String getLastLogin() throws Exception;

    public JCRPageList getPrivateMessage(String var1, String var2) throws Exception;

    public long getNewPrivateMessage(String var1) throws Exception;

    public void savePrivateMessage(ForumPrivateMessage var1) throws Exception;

    public void saveReadMessage(String var1, String var2, String var3) throws Exception;

    public void removePrivateMessage(String var1, String var2, String var3) throws Exception;

    public ForumSubscription getForumSubscription(String var1) throws Exception;

    public void saveForumSubscription(ForumSubscription var1, String var2) throws Exception;

    public void addWatch(int var1, String var2, List<String> var3, String var4) throws Exception;

    public void removeWatch(int var1, String var2, String var3) throws Exception;

    public List<ForumSearch> getJobWattingForModerator(String[] var1) throws Exception;

    public int getJobWattingForModeratorByUser(String var1) throws Exception;

    public SendMessageInfo getMessageInfo(String var1) throws Exception;

    public boolean isAdminRole(String var1) throws Exception;

    public List<Post> getNewPosts(int var1) throws Exception;

    public NodeIterator search(String var1) throws Exception;

    public void updateForumStatistic() throws Exception;

    public void evaluateActiveUsers(String var1) throws Exception;

    public void createUserProfile(User var1) throws Exception;

    public void updateTopicAccess(String var1, String var2) throws Exception;

    public void updateForumAccess(String var1, String var2) throws Exception;

    public Object exportXML(String var1, String var2, List<String> var3, String var4, ByteArrayOutputStream var5, boolean var6) throws Exception;

    public void importXML(String var1, ByteArrayInputStream var2, int var3) throws Exception;

    public void updateDataImported() throws Exception;

    public List<UserProfile> getQuickProfiles(List<String> var1) throws Exception;

    public UserProfile getQuickProfile(String var1) throws Exception;

    public UserProfile getUserInformations(UserProfile var1) throws Exception;

    public UserProfile getDefaultUserProfile(String var1, String var2) throws Exception;

    public UserProfile updateUserProfileSetting(UserProfile var1) throws Exception;

    public List<String> getBookmarks(String var1) throws Exception;

    public UserProfile getUserSettingProfile(String var1) throws Exception;

    public UserProfile getUserProfileManagement(String var1) throws Exception;

    public void saveUserSettingProfile(UserProfile var1) throws Exception;

    public void updateForum(String var1) throws Exception;

    public List<String> getBanList() throws Exception;

    public boolean addBanIP(String var1) throws Exception;

    public void removeBan(String var1) throws Exception;

    public List<String> getForumBanList(String var1) throws Exception;

    public boolean addBanIPForum(String var1, String var2) throws Exception;

    public void removeBanIPForum(String var1, String var2) throws Exception;

    public JCRPageList getListPostsByIP(String var1, String var2) throws Exception;

    public void updateStatisticCounts(long var1, long var3) throws Exception;

    public void registerListenerForCategory(String var1) throws Exception;

    public void unRegisterListenerForCategory(String var1) throws Exception;

    public ForumAttachment getUserAvatar(String var1) throws Exception;

    public void saveUserAvatar(String var1, ForumAttachment var2) throws Exception;

    public void setDefaultAvatar(String var1) throws Exception;

    public List<Watch> getWatchByUser(String var1) throws Exception;

    public void updateEmailWatch(List<String> var1, String var2, String var3) throws Exception;

    public void saveBBCode(List<BBCode> var1) throws Exception;

    public List<BBCode> getAllBBCode() throws Exception;

    public List<String> getActiveBBCode() throws Exception;

    public BBCode getBBcode(String var1) throws Exception;

    public void removeBBCode(String var1) throws Exception;

    public List<PruneSetting> getAllPruneSetting() throws Exception;

    public PruneSetting getPruneSetting(String var1) throws Exception;

    public void savePruneSetting(PruneSetting var1) throws Exception;

    public void runPrune(PruneSetting var1) throws Exception;

    public void runPrune(String var1) throws Exception;

    public long checkPrune(PruneSetting var1) throws Exception;

    public List<TopicType> getTopicTypes() throws Exception;

    public TopicType getTopicType(String var1) throws Exception;

    public void saveTopicType(TopicType var1) throws Exception;

    public void removeTopicType(String var1) throws Exception;

    public JCRPageList getPageTopicByType(String var1) throws Exception;

    public LazyPageList<Topic> getTopicList(String var1, String var2, String var3, String var4, int var5) throws Exception;

    public List<Forum> getForumSummaries(String var1, String var2) throws Exception;
}

