/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service.impl;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Value;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.apache.commons.logging.Log;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumAdministration;
import org.exoplatform.forum.service.ForumAttachment;
import org.exoplatform.forum.service.ForumEventQuery;
import org.exoplatform.forum.service.ForumLinkData;
import org.exoplatform.forum.service.ForumPrivateMessage;
import org.exoplatform.forum.service.ForumSearch;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.ForumStatistic;
import org.exoplatform.forum.service.ForumSubscription;
import org.exoplatform.forum.service.JCRPageList;
import org.exoplatform.forum.service.LazyPageList;
import org.exoplatform.forum.service.Poll;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.PruneSetting;
import org.exoplatform.forum.service.Tag;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.service.TopicType;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.forum.service.Watch;
import org.exoplatform.forum.service.conf.InitializeForumPlugin;
import org.exoplatform.forum.service.conf.SendMessageInfo;
import org.exoplatform.forum.service.impl.ForumServiceManaged;
import org.exoplatform.forum.service.impl.JCRDataStorage;
import org.exoplatform.forum.service.impl.JobManager;
import org.exoplatform.ks.common.bbcode.BBCode;
import org.exoplatform.ks.common.bbcode.BBCodeOperator;
import org.exoplatform.ks.common.bbcode.InitBBCodePlugin;
import org.exoplatform.ks.common.conf.ManagedPlugin;
import org.exoplatform.ks.common.conf.RoleRulesPlugin;
import org.exoplatform.management.annotations.ManagedBy;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.scheduler.JobSchedulerService;
import org.picocontainer.Startable;
import org.quartz.JobDetail;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagedBy(value=ForumServiceManaged.class)
public class ForumServiceImpl
implements ForumService,
Startable {
    private static final Log log = ExoLogger.getLogger(ForumServiceImpl.class);
    JCRDataStorage storage_;
    BBCodeOperator bbcodeObject_;
    ForumServiceManaged managed;
    final List<String> onlineUserList_ = new CopyOnWriteArrayList<String>();
    private String lastLogin_ = "";

    public ForumServiceImpl(NodeHierarchyCreator nodeHierarchyCreator, RepositoryService rService, InitParams params) throws Exception {
        this.storage_ = new JCRDataStorage(nodeHierarchyCreator, rService);
        this.bbcodeObject_ = new BBCodeOperator(nodeHierarchyCreator, rService);
    }

    @Override
    public void addInitRssPlugin(ComponentPlugin plugin) throws Exception {
        this.storage_.addInitRssPlugin(plugin);
    }

    @Override
    public void addPlugin(ComponentPlugin plugin) throws Exception {
        this.storage_.addPlugin(plugin);
    }

    @Override
    public void addRolePlugin(ComponentPlugin plugin) throws Exception {
        this.storage_.addRolePlugin(plugin);
    }

    @Override
    public void addInitialDataPlugin(ComponentPlugin plugin) throws Exception {
        this.storage_.addInitialDataPlugin(plugin);
    }

    @Override
    public void addInitBBCodePlugin(ComponentPlugin plugin) throws Exception {
        this.bbcodeObject_.addInitBBCodePlugin(plugin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        SessionProvider systemSession = SessionProvider.createSystemProvider();
        try {
            log.info((Object)"initializing category listeners...");
            this.storage_.initCategoryListener();
            log.info((Object)"updating forum stats...");
            this.updateForumStatistic(systemSession);
        }
        catch (Exception e) {
        }
        finally {
            systemSession.close();
        }
        systemSession = SessionProvider.createSystemProvider();
        try {
            log.info((Object)"initializing user profiles...");
            this.initUserProfile(systemSession);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            systemSession.close();
        }
        try {
            log.info((Object)"initializing RSS listeners...");
            this.storage_.addRSSEventListenner();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            log.info((Object)"initializing default data...");
            this.storage_.initDefaultData();
            log.info((Object)"initializing default BBCodes...");
            this.bbcodeObject_.initDefaultBBCode();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            log.info((Object)"Calculating active users...");
            this.storage_.evaluateActiveUsers("");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            log.info((Object)"initializing Calculate Moderators listeners...");
            this.storage_.addCalculateModeratorEventListenner();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            log.info((Object)"initializing prune schedulers...");
            this.storage_.initAutoPruneSchedules();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.managePlugins();
            this.manageStorage();
            this.manageJobs();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void manageStorage() {
        this.managed.registerStorageManager(this.storage_);
    }

    private void manageJobs() {
        try {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            JobSchedulerService schedulerService = (JobSchedulerService)container.getComponentInstanceOfType(JobSchedulerService.class);
            String groupName = "KnowledgeSuite-forum";
            List jobs = schedulerService.getAllJobs();
            for (JobDetail jobDetail : jobs) {
                this.managed.registerJobManager(new JobManager(jobDetail));
            }
        }
        catch (Exception e) {
            log.error((Object)"failed to register jobs manager", (Throwable)e);
        }
    }

    private void managePlugins() {
        List<RoleRulesPlugin> plugins = this.storage_.rulesPlugins_;
        for (RoleRulesPlugin plugin2 : plugins) {
            this.managed.registerPlugin((ManagedPlugin)plugin2);
        }
        List<InitializeForumPlugin> defaultPlugins = this.storage_.defaultPlugins_;
        for (InitializeForumPlugin plugin2 : defaultPlugins) {
            this.managed.registerPlugin(plugin2);
        }
        List<InitBBCodePlugin> defaultBBCodePlugins = this.storage_.defaultBBCodePlugins_;
        for (InitBBCodePlugin plugin2 : defaultBBCodePlugins) {
            this.managed.registerPlugin((ManagedPlugin)plugin2);
        }
    }

    public void stop() {
    }

    @Override
    public void updateForumStatistic(SessionProvider sProvider) throws Exception {
        sProvider.close();
        this.updateForumStatistic();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateForumStatistic() throws Exception {
        SessionProvider systemSession = SessionProvider.createSystemProvider();
        try {
            ForumStatistic forumStatistic = this.getForumStatistic(SessionProvider.createSystemProvider());
            Node profileHome = this.storage_.getUserProfileHome(systemSession);
            QueryManager qm = profileHome.getSession().getWorkspace().getQueryManager();
            StringBuilder pathQuery = new StringBuilder();
            pathQuery.append("/jcr:root").append(profileHome.getPath()).append("//element(*,exo:forumUserProfile)[ @exo:lastLoginDate ] order by @exo:joinedDate descending");
            Query query = qm.createQuery(pathQuery.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            if (iter.getSize() > 0L) {
                forumStatistic.setMembersCount(iter.getSize());
                Node node = iter.nextNode();
                String id = node.getProperty("exo:userId").getString();
                forumStatistic.setNewMembers(id);
                this.saveForumStatistic(systemSession, forumStatistic);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            systemSession.close();
        }
    }

    private void initUserProfile(SessionProvider sysSession) throws Exception {
        Node profileHome = this.storage_.getUserProfileHome(sysSession);
        if (profileHome.getNodes().getSize() == 0L) {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            OrganizationService organizationService = (OrganizationService)container.getComponentInstanceOfType(OrganizationService.class);
            PageList pageList = organizationService.getUserHandler().getUserPageList(10);
            List userList = new ArrayList();
            for (int i = 1; i <= pageList.getAvailablePage(); ++i) {
                userList = pageList.getPage(i);
                for (User user : userList) {
                    this.createUserProfile(sysSession, user);
                }
            }
        }
    }

    @Override
    public void createUserProfile(SessionProvider sProvider, User user) throws Exception {
        sProvider.close();
        this.createUserProfile(user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createUserProfile(User user) throws Exception {
        SessionProvider sysSession = SessionProvider.createSystemProvider();
        try {
            Node profileHome = this.storage_.getUserProfileHome(sysSession);
            if (!profileHome.hasNode(user.getUserName())) {
                Node profile = profileHome.addNode(user.getUserName(), Utils.USER_PROFILES_TYPE);
                Calendar cal = this.storage_.getGreenwichMeanTime();
                profile.setProperty("exo:userId", user.getUserName());
                profile.setProperty("exo:lastLoginDate", cal);
                profile.setProperty("exo:email", user.getEmail());
                profile.setProperty("exo:fullName", user.getFullName());
                profile.setProperty("exo:firstName", user.getFirstName());
                profile.setProperty("exo:lastName", user.getLastName());
                cal.setTime(user.getCreatedDate());
                profile.setProperty("exo:joinedDate", cal);
                if (this.isAdminRole(user.getUserName())) {
                    profile.setProperty("exo:userTitle", "Administrator");
                    profile.setProperty("exo:userRole", 0L);
                }
                if (profileHome.isNew()) {
                    profileHome.getSession().save();
                } else {
                    profileHome.save();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sysSession.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveEmailUserProfile(String userId, String email) throws Exception {
        SessionProvider sysSession = SessionProvider.createSystemProvider();
        try {
            Node profileHome = this.storage_.getUserProfileHome(sysSession);
            Node profile = profileHome.getNode(userId);
            profile.setProperty("exo:email", email);
            profileHome.save();
        }
        catch (Exception e) {
        }
        finally {
            sysSession.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateUserProfile(User user) throws Exception {
        SessionProvider sysSession = SessionProvider.createSystemProvider();
        try {
            Node profileHome = this.storage_.getUserProfileHome(sysSession);
            Node profile = profileHome.getNode(user.getUserName());
            profile.setProperty("exo:email", user.getEmail());
            profile.setProperty("exo:firstName", user.getFirstName());
            profile.setProperty("exo:lastName", user.getLastName());
            profile.save();
        }
        catch (PathNotFoundException e) {
            this.createUserProfile(user);
        }
        finally {
            sysSession.close();
        }
    }

    @Override
    public void saveCategory(SessionProvider sProvider, Category category, boolean isNew) throws Exception {
        sProvider.close();
        this.saveCategory(category, isNew);
    }

    @Override
    public void saveCategory(Category category, boolean isNew) throws Exception {
        this.storage_.saveCategory(category, isNew);
    }

    @Override
    public void calculateModerator(String categoryPath, boolean isNew) throws Exception {
        this.storage_.calculateModerator(categoryPath, false);
    }

    @Override
    public Category getCategory(SessionProvider sProvider, String categoryId) throws Exception {
        sProvider.close();
        return this.getCategory(categoryId);
    }

    @Override
    public Category getCategory(String categoryId) throws Exception {
        return this.storage_.getCategory(categoryId);
    }

    @Override
    public String[] getPermissionTopicByCategory(String categoryId, String type) throws Exception {
        return this.storage_.getPermissionTopicByCategory(categoryId, type);
    }

    @Override
    public List<Category> getCategories(SessionProvider sProvider) throws Exception {
        sProvider.close();
        return this.getCategories();
    }

    @Override
    public List<Category> getCategories() throws Exception {
        return this.storage_.getCategories();
    }

    @Override
    public Category removeCategory(SessionProvider sProvider, String categoryId) throws Exception {
        sProvider.close();
        return this.removeCategory(categoryId);
    }

    @Override
    public Category removeCategory(String categoryId) throws Exception {
        return this.storage_.removeCategory(categoryId);
    }

    @Override
    public void saveModOfCategory(List<String> moderatorCate, String userId, boolean isAdd) {
        this.storage_.saveModOfCategory(moderatorCate, userId, isAdd);
    }

    @Override
    public void modifyForum(SessionProvider sProvider, Forum forum, int type) throws Exception {
        sProvider.close();
        this.modifyForum(forum, type);
    }

    @Override
    public void modifyForum(Forum forum, int type) throws Exception {
        this.storage_.modifyForum(forum, type);
    }

    @Override
    public void saveForum(SessionProvider sProvider, String categoryId, Forum forum, boolean isNew) throws Exception {
        sProvider.close();
        this.saveForum(categoryId, forum, isNew);
    }

    @Override
    public void saveForum(String categoryId, Forum forum, boolean isNew) throws Exception {
        this.storage_.saveForum(categoryId, forum, isNew);
    }

    @Override
    public void saveModerateOfForums(SessionProvider sProvider, List<String> forumPaths, String userName, boolean isDelete) throws Exception {
        sProvider.close();
        this.saveModerateOfForums(forumPaths, userName, isDelete);
    }

    @Override
    public void saveModerateOfForums(List<String> forumPaths, String userName, boolean isDelete) throws Exception {
        this.storage_.saveModerateOfForums(forumPaths, userName, isDelete);
    }

    @Override
    public void moveForum(SessionProvider sProvider, List<Forum> forums, String destCategoryPath) throws Exception {
        sProvider.close();
        this.moveForum(forums, destCategoryPath);
    }

    @Override
    public void moveForum(List<Forum> forums, String destCategoryPath) throws Exception {
        this.storage_.moveForum(forums, destCategoryPath);
    }

    @Override
    public Forum getForum(SessionProvider sProvider, String categoryId, String forumId) throws Exception {
        sProvider.close();
        return this.getForum(categoryId, forumId);
    }

    @Override
    public Forum getForum(String categoryId, String forumId) throws Exception {
        return this.storage_.getForum(categoryId, forumId);
    }

    @Override
    public List<Forum> getForums(SessionProvider sProvider, String categoryId, String strQuery) throws Exception {
        sProvider.close();
        return this.getForums(categoryId, strQuery);
    }

    @Override
    public List<Forum> getForums(String categoryId, String strQuery) throws Exception {
        return this.storage_.getForums(categoryId, strQuery);
    }

    @Override
    public List<Forum> getForumSummaries(String categoryId, String strQuery) throws Exception {
        return this.storage_.getForumSummaries(categoryId, strQuery);
    }

    @Override
    public Forum removeForum(SessionProvider sProvider, String categoryId, String forumId) throws Exception {
        sProvider.close();
        return this.removeForum(categoryId, forumId);
    }

    @Override
    public Forum removeForum(String categoryId, String forumId) throws Exception {
        return this.storage_.removeForum(categoryId, forumId);
    }

    @Override
    public void modifyTopic(SessionProvider sProvider, List<Topic> topics, int type) throws Exception {
        sProvider.close();
        this.modifyTopic(topics, type);
    }

    @Override
    public void modifyTopic(List<Topic> topics, int type) throws Exception {
        this.storage_.modifyTopic(topics, type);
    }

    @Override
    public void saveTopic(SessionProvider sProvider, String categoryId, String forumId, Topic topic, boolean isNew, boolean isMove, String defaultEmailContent) throws Exception {
        sProvider.close();
        this.saveTopic(categoryId, forumId, topic, isNew, isMove, defaultEmailContent);
    }

    @Override
    public void saveTopic(String categoryId, String forumId, Topic topic, boolean isNew, boolean isMove, String defaultEmailContent) throws Exception {
        this.storage_.saveTopic(categoryId, forumId, topic, isNew, isMove, defaultEmailContent);
    }

    @Override
    public Topic getTopic(SessionProvider sProvider, String categoryId, String forumId, String topicId, String userRead) throws Exception {
        sProvider.close();
        return this.getTopic(categoryId, forumId, topicId, userRead);
    }

    @Override
    public Topic getTopic(String categoryId, String forumId, String topicId, String userRead) throws Exception {
        return this.storage_.getTopic(categoryId, forumId, topicId, userRead);
    }

    @Override
    public void setViewCountTopic(String path, String userRead) throws Exception {
        this.storage_.setViewCountTopic(path, userRead);
    }

    @Override
    public Topic getTopicByPath(SessionProvider sProvider, String topicPath, boolean isLastPost) throws Exception {
        sProvider.close();
        return this.getTopicByPath(topicPath, isLastPost);
    }

    @Override
    public Topic getTopicSummary(String topicPath) throws Exception {
        return this.storage_.getTopicSummary(topicPath, true);
    }

    @Override
    public Topic getTopicByPath(String topicPath, boolean isLastPost) throws Exception {
        return this.storage_.getTopicByPath(topicPath, isLastPost);
    }

    @Override
    public JCRPageList getPageTopic(SessionProvider sProvider, String categoryId, String forumId, String strQuery, String strOrderBy) throws Exception {
        sProvider.close();
        return this.getPageTopic(categoryId, forumId, strQuery, strOrderBy);
    }

    @Override
    public LazyPageList<Topic> getTopicList(String categoryId, String forumId, String strQuery, String strOrderBy, int pageSize) throws Exception {
        return this.storage_.getTopicList(categoryId, forumId, strQuery, strOrderBy, pageSize);
    }

    @Override
    public JCRPageList getPageTopic(String categoryId, String forumId, String strQuery, String strOrderBy) throws Exception {
        return this.storage_.getPageTopic(categoryId, forumId, strQuery, strOrderBy);
    }

    @Override
    public List<Topic> getTopics(SessionProvider sProvider, String categoryId, String forumId) throws Exception {
        sProvider.close();
        return this.getTopics(categoryId, forumId);
    }

    @Override
    public List<Topic> getTopics(String categoryId, String forumId) throws Exception {
        return this.storage_.getTopics(categoryId, forumId);
    }

    @Override
    public void moveTopic(SessionProvider sProvider, List<Topic> topics, String destForumPath, String mailContent, String link) throws Exception {
        sProvider.close();
        this.moveTopic(topics, destForumPath, mailContent, link);
    }

    @Override
    public void moveTopic(List<Topic> topics, String destForumPath, String mailContent, String link) throws Exception {
        this.storage_.moveTopic(topics, destForumPath, mailContent, link);
    }

    @Override
    public Topic removeTopic(SessionProvider sProvider, String categoryId, String forumId, String topicId) throws Exception {
        sProvider.close();
        return this.removeTopic(categoryId, forumId, topicId);
    }

    @Override
    public Topic removeTopic(String categoryId, String forumId, String topicId) throws Exception {
        return this.storage_.removeTopic(categoryId, forumId, topicId);
    }

    @Override
    public Post getPost(SessionProvider sProvider, String categoryId, String forumId, String topicId, String postId) throws Exception {
        sProvider.close();
        return this.getPost(categoryId, forumId, topicId, postId);
    }

    @Override
    public Post getPost(String categoryId, String forumId, String topicId, String postId) throws Exception {
        return this.storage_.getPost(categoryId, forumId, topicId, postId);
    }

    @Override
    public long getLastReadIndex(String path, String isApproved, String isHidden, String userLogin) throws Exception {
        return this.storage_.getLastReadIndex(path, isApproved, isHidden, userLogin);
    }

    @Override
    public JCRPageList getPostForSplitTopic(String topicPath) throws Exception {
        return this.storage_.getPostForSplitTopic(topicPath);
    }

    @Override
    public JCRPageList getPosts(SessionProvider sProvider, String categoryId, String forumId, String topicId, String isApproved, String isHidden, String strQuery, String userLogin) throws Exception {
        sProvider.close();
        return this.getPosts(categoryId, forumId, topicId, isApproved, isHidden, strQuery, userLogin);
    }

    @Override
    public JCRPageList getPosts(String categoryId, String forumId, String topicId, String isApproved, String isHidden, String strQuery, String userLogin) throws Exception {
        return this.storage_.getPosts(categoryId, forumId, topicId, isApproved, isHidden, strQuery, userLogin);
    }

    @Override
    public long getAvailablePost(SessionProvider sProvider, String categoryId, String forumId, String topicId, String isApproved, String isHidden, String userLogin) throws Exception {
        sProvider.close();
        return this.getAvailablePost(categoryId, forumId, topicId, isApproved, isHidden, userLogin);
    }

    @Override
    public long getAvailablePost(String categoryId, String forumId, String topicId, String isApproved, String isHidden, String userLogin) throws Exception {
        return this.storage_.getAvailablePost(categoryId, forumId, topicId, isApproved, isHidden, userLogin);
    }

    @Override
    public void savePost(SessionProvider sProvider, String categoryId, String forumId, String topicId, Post post, boolean isNew, String defaultEmailContent) throws Exception {
        sProvider.close();
        this.savePost(categoryId, forumId, topicId, post, isNew, defaultEmailContent);
    }

    @Override
    public void savePost(String categoryId, String forumId, String topicId, Post post, boolean isNew, String defaultEmailContent) throws Exception {
        this.storage_.savePost(categoryId, forumId, topicId, post, isNew, defaultEmailContent);
    }

    @Override
    public void modifyPost(SessionProvider sProvider, List<Post> posts, int type) throws Exception {
        sProvider.close();
        this.modifyPost(posts, type);
    }

    @Override
    public void modifyPost(List<Post> posts, int type) throws Exception {
        this.storage_.modifyPost(posts, type);
    }

    @Override
    public void movePost(SessionProvider sProvider, List<Post> posts, String destTopicPath, boolean isCreatNewTopic, String mailContent, String link) throws Exception {
        sProvider.close();
        String[] postPaths = new String[posts.size()];
        int i = 0;
        for (Post p : posts) {
            postPaths[i] = p.getPath();
            ++i;
        }
        this.movePost(postPaths, destTopicPath, isCreatNewTopic, mailContent, link);
    }

    @Override
    public void movePost(List<Post> posts, String destTopicPath, boolean isCreatNewTopic, String mailContent, String link) throws Exception {
        String[] postPaths = new String[posts.size()];
        int i = 0;
        for (Post p : posts) {
            postPaths[i] = p.getPath();
            ++i;
        }
        this.movePost(postPaths, destTopicPath, isCreatNewTopic, mailContent, link);
    }

    @Override
    public void movePost(String[] postPaths, String destTopicPath, boolean isCreatNewTopic, String mailContent, String link) throws Exception {
        this.storage_.movePost(postPaths, destTopicPath, isCreatNewTopic, mailContent, link);
    }

    @Override
    public void mergeTopic(String srcTopicPath, String destTopicPath, String mailContent, String link) throws Exception {
        this.storage_.mergeTopic(srcTopicPath, destTopicPath, mailContent, link);
    }

    public Post removePost(SessionProvider sProvider, String categoryId, String forumId, String topicId, String postId) throws Exception {
        sProvider.close();
        return this.removePost(categoryId, forumId, topicId, postId);
    }

    @Override
    public Post removePost(String categoryId, String forumId, String topicId, String postId) throws Exception {
        return this.storage_.removePost(categoryId, forumId, topicId, postId);
    }

    @Override
    public Object getObjectNameByPath(SessionProvider sProvider, String path) throws Exception {
        sProvider.close();
        return this.getObjectNameByPath(path);
    }

    @Override
    public Object getObjectNameByPath(String path) throws Exception {
        return this.storage_.getObjectNameByPath(path);
    }

    @Override
    public Object getObjectNameById(SessionProvider sProvider, String path, String type) throws Exception {
        sProvider.close();
        return this.getObjectNameById(path, type);
    }

    @Override
    public Object getObjectNameById(String path, String type) throws Exception {
        return this.storage_.getObjectNameById(path, type);
    }

    @Override
    public List<ForumLinkData> getAllLink(SessionProvider sProvider, String strQueryCate, String strQueryForum) throws Exception {
        sProvider.close();
        return this.getAllLink(strQueryCate, strQueryForum);
    }

    @Override
    public List<ForumLinkData> getAllLink(String strQueryCate, String strQueryForum) throws Exception {
        return this.storage_.getAllLink(strQueryCate, strQueryForum);
    }

    @Override
    public String getForumHomePath(SessionProvider sProvider) throws Exception {
        sProvider.close();
        return this.getForumHomePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getForumHomePath() throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            String string = this.storage_.getForumHomeNode(sProvider).getPath();
            return string;
        }
        finally {
            sProvider.close();
        }
    }

    @Override
    public Poll getPoll(SessionProvider sProvider, String categoryId, String forumId, String topicId) throws Exception {
        sProvider.close();
        return this.getPoll(categoryId, forumId, topicId);
    }

    @Override
    public Poll getPoll(String categoryId, String forumId, String topicId) throws Exception {
        return this.storage_.getPoll(categoryId, forumId, topicId);
    }

    @Override
    public Poll removePoll(SessionProvider sProvider, String categoryId, String forumId, String topicId) throws Exception {
        sProvider.close();
        return this.removePoll(categoryId, forumId, topicId);
    }

    @Override
    public Poll removePoll(String categoryId, String forumId, String topicId) throws Exception {
        return this.storage_.removePoll(categoryId, forumId, topicId);
    }

    @Override
    public void savePoll(SessionProvider sProvider, String categoryId, String forumId, String topicId, Poll poll, boolean isNew, boolean isVote) throws Exception {
        sProvider.close();
        this.savePoll(categoryId, forumId, topicId, poll, isNew, isVote);
    }

    @Override
    public void savePoll(String categoryId, String forumId, String topicId, Poll poll, boolean isNew, boolean isVote) throws Exception {
        this.storage_.savePoll(categoryId, forumId, topicId, poll, isNew, isVote);
    }

    @Override
    public void setClosedPoll(SessionProvider sProvider, String categoryId, String forumId, String topicId, Poll poll) throws Exception {
        sProvider.close();
        this.setClosedPoll(categoryId, forumId, topicId, poll);
    }

    @Override
    public void setClosedPoll(String categoryId, String forumId, String topicId, Poll poll) throws Exception {
        this.storage_.setClosedPoll(categoryId, forumId, topicId, poll);
    }

    @Override
    public void addTag(List<Tag> tags, String userName, String topicPath) throws Exception {
        this.storage_.addTag(tags, userName, topicPath);
    }

    @Override
    public List<Tag> getAllTags() throws Exception {
        return this.storage_.getAllTags();
    }

    @Override
    public List<Tag> getMyTagInTopic(String[] tagIds) throws Exception {
        return this.storage_.getMyTagInTopic(tagIds);
    }

    @Override
    public Tag getTag(String tagId) throws Exception {
        return this.storage_.getTag(tagId);
    }

    @Override
    public List<String> getAllTagName(String strQuery, String userAndTopicId) throws Exception {
        return this.storage_.getAllTagName(strQuery, userAndTopicId);
    }

    @Override
    public List<String> getTagNameInTopic(String userAndTopicId) throws Exception {
        return this.storage_.getTagNameInTopic(userAndTopicId);
    }

    @Override
    public JCRPageList getTopicByMyTag(String userIdAndtagId, String strOrderBy) throws Exception {
        return this.storage_.getTopicByMyTag(userIdAndtagId, strOrderBy);
    }

    @Override
    public void saveTag(Tag newTag) throws Exception {
        this.storage_.saveTag(newTag);
    }

    @Override
    public void unTag(String tagId, String userName, String topicPath) throws Exception {
        this.storage_.unTag(tagId, userName, topicPath);
    }

    @Override
    public void addTag(SessionProvider sProvider, List<Tag> tags, String userName, String topicPath) throws Exception {
        sProvider.close();
        this.addTag(tags, userName, topicPath);
    }

    @Override
    public List<Tag> getAllTags(SessionProvider sProvider) throws Exception {
        sProvider.close();
        return this.getAllTags();
    }

    @Override
    public List<Tag> getMyTagInTopic(SessionProvider sProvider, String[] tagIds) throws Exception {
        sProvider.close();
        return this.getMyTagInTopic(tagIds);
    }

    @Override
    public Tag getTag(SessionProvider sProvider, String tagId) throws Exception {
        sProvider.close();
        return this.getTag(tagId);
    }

    @Override
    public JCRPageList getTopicByMyTag(SessionProvider sProvider, String userIdAndtagId, String strOrderBy) throws Exception {
        sProvider.close();
        return this.getTopicByMyTag(userIdAndtagId, strOrderBy);
    }

    @Override
    public void saveTag(SessionProvider sProvider, Tag newTag) throws Exception {
        sProvider.close();
        this.saveTag(newTag);
    }

    @Override
    public void unTag(SessionProvider sProvider, String tagId, String userName, String topicPath) throws Exception {
        sProvider.close();
        this.unTag(tagId, userName, topicPath);
    }

    @Override
    public void saveUserModerator(String userName, List<String> ids, boolean isModeCate) throws Exception {
        this.storage_.saveUserModerator(userName, ids, isModeCate);
    }

    @Override
    public void saveUserProfile(SessionProvider sProvider, UserProfile userProfile, boolean isOption, boolean isBan) throws Exception {
        sProvider.close();
        this.saveUserProfile(userProfile, isOption, isBan);
    }

    @Override
    public void saveUserProfile(UserProfile userProfile, boolean isOption, boolean isBan) throws Exception {
        this.storage_.saveUserProfile(userProfile, isOption, isBan);
    }

    @Override
    public UserProfile getUserInfo(SessionProvider sProvider, String userName) throws Exception {
        sProvider.close();
        return this.getUserInfo(userName);
    }

    @Override
    public UserProfile getUserInfo(String userName) throws Exception {
        return this.storage_.getUserInfo(userName);
    }

    @Override
    public List<String> getUserModerator(String userName, boolean isModeCate) throws Exception {
        return this.storage_.getUserModerator(userName, isModeCate);
    }

    @Override
    public UserProfile getUserProfileManagement(SessionProvider sProvider, String userName) throws Exception {
        sProvider.close();
        return this.getUserProfileManagement(userName);
    }

    @Override
    public UserProfile getUserProfileManagement(String userName) throws Exception {
        return this.storage_.getUserProfileManagement(userName);
    }

    @Override
    public void saveLastPostIdRead(String userId, String[] lastReadPostOfForum, String[] lastReadPostOfTopic) throws Exception {
        this.storage_.saveLastPostIdRead(userId, lastReadPostOfForum, lastReadPostOfTopic);
    }

    @Override
    public void saveUserBookmark(SessionProvider sProvider, String userName, String bookMark, boolean isNew) throws Exception {
        sProvider.close();
        this.saveUserBookmark(userName, bookMark, isNew);
    }

    @Override
    public void saveUserBookmark(String userName, String bookMark, boolean isNew) throws Exception {
        this.storage_.saveUserBookmark(userName, bookMark, isNew);
    }

    @Override
    public void saveCollapsedCategories(SessionProvider sProvider, String userName, String categoryId, boolean isAdd) throws Exception {
        sProvider.close();
        this.saveCollapsedCategories(userName, categoryId, isAdd);
    }

    @Override
    public void saveCollapsedCategories(String userName, String categoryId, boolean isAdd) throws Exception {
        this.storage_.saveCollapsedCategories(userName, categoryId, isAdd);
    }

    @Override
    public JCRPageList getPageListUserProfile(SessionProvider sProvider) throws Exception {
        sProvider.close();
        return this.getPageListUserProfile();
    }

    @Override
    public JCRPageList getPageListUserProfile() throws Exception {
        return this.storage_.getPageListUserProfile();
    }

    @Override
    public JCRPageList getPrivateMessage(SessionProvider sProvider, String userName, String type) throws Exception {
        sProvider.close();
        return this.getPrivateMessage(userName, type);
    }

    @Override
    public JCRPageList getPrivateMessage(String userName, String type) throws Exception {
        return this.storage_.getPrivateMessage(userName, type);
    }

    @Override
    public long getNewPrivateMessage(SessionProvider sProvider, String userName) throws Exception {
        sProvider.close();
        return this.getNewPrivateMessage(userName);
    }

    @Override
    public long getNewPrivateMessage(String userName) throws Exception {
        return this.storage_.getNewPrivateMessage(userName);
    }

    @Override
    public void removePrivateMessage(SessionProvider sProvider, String messageId, String userName, String type) throws Exception {
        sProvider.close();
        this.removePrivateMessage(messageId, userName, type);
    }

    @Override
    public void removePrivateMessage(String messageId, String userName, String type) throws Exception {
        this.storage_.removePrivateMessage(messageId, userName, type);
    }

    @Override
    public void saveReadMessage(SessionProvider sProvider, String messageId, String userName, String type) throws Exception {
        sProvider.close();
        this.saveReadMessage(messageId, userName, type);
    }

    @Override
    public void saveReadMessage(String messageId, String userName, String type) throws Exception {
        this.storage_.saveReadMessage(messageId, userName, type);
    }

    @Override
    public void savePrivateMessage(SessionProvider sProvider, ForumPrivateMessage privateMessage) throws Exception {
        sProvider.close();
        this.savePrivateMessage(privateMessage);
    }

    @Override
    public void savePrivateMessage(ForumPrivateMessage privateMessage) throws Exception {
        this.storage_.savePrivateMessage(privateMessage);
    }

    @Override
    public ForumSubscription getForumSubscription(String userId) throws Exception {
        return this.storage_.getForumSubscription(userId);
    }

    @Override
    public void saveForumSubscription(ForumSubscription forumSubscription, String userId) throws Exception {
        this.storage_.saveForumSubscription(forumSubscription, userId);
    }

    @Override
    public JCRPageList getPageTopicOld(SessionProvider sProvider, long date, String forumPatch) throws Exception {
        sProvider.close();
        return this.getPageTopicOld(date, forumPatch);
    }

    @Override
    public JCRPageList getPageTopicOld(long date, String forumPatch) throws Exception {
        return this.storage_.getPageTopicOld(date, forumPatch);
    }

    @Override
    public List<Topic> getAllTopicsOld(long date, String forumPatch) throws Exception {
        return this.storage_.getAllTopicsOld(date, forumPatch);
    }

    @Override
    public List<Topic> getAllTopicsOld(SessionProvider sProvider, long date, String forumPatch) throws Exception {
        sProvider.close();
        return this.getAllTopicsOld(date, forumPatch);
    }

    @Override
    public long getTotalTopicOld(SessionProvider sProvider, long date, String forumPatch) throws Exception {
        sProvider.close();
        return this.getTotalTopicOld(date, forumPatch);
    }

    @Override
    public long getTotalTopicOld(long date, String forumPatch) {
        return this.storage_.getTotalTopicOld(date, forumPatch);
    }

    @Override
    public JCRPageList getPageTopicByUser(SessionProvider sProvider, String userName, boolean isMod, String strOrderBy) throws Exception {
        sProvider.close();
        return this.getPageTopicByUser(userName, isMod, strOrderBy);
    }

    @Override
    public JCRPageList getPageTopicByUser(String userName, boolean isMod, String strOrderBy) throws Exception {
        return this.storage_.getPageTopicByUser(userName, isMod, strOrderBy);
    }

    @Override
    public JCRPageList getPagePostByUser(SessionProvider sProvider, String userName, String userId, boolean isMod, String strOrderBy) throws Exception {
        sProvider.close();
        return this.getPagePostByUser(userName, userId, isMod, strOrderBy);
    }

    @Override
    public JCRPageList getPagePostByUser(String userName, String userId, boolean isMod, String strOrderBy) throws Exception {
        return this.storage_.getPagePostByUser(userName, userId, isMod, strOrderBy);
    }

    @Override
    public ForumStatistic getForumStatistic(SessionProvider sProvider) throws Exception {
        sProvider.close();
        return this.getForumStatistic();
    }

    @Override
    public ForumStatistic getForumStatistic() throws Exception {
        return this.storage_.getForumStatistic();
    }

    @Override
    public void saveForumStatistic(SessionProvider sProvider, ForumStatistic forumStatistic) throws Exception {
        sProvider.close();
        this.saveForumStatistic(forumStatistic);
    }

    @Override
    public void saveForumStatistic(ForumStatistic forumStatistic) throws Exception {
        this.storage_.saveForumStatistic(forumStatistic);
    }

    @Override
    public void updateStatisticCounts(long topicCount, long postCount) throws Exception {
        this.storage_.updateStatisticCounts(topicCount, postCount);
    }

    @Override
    public List<ForumSearch> getQuickSearch(SessionProvider sProvider, String textQuery, String type, String pathQuery, String userId, List<String> listCateIds, List<String> listForumIds, List<String> forumIdsOfModerator) throws Exception {
        sProvider.close();
        return this.getQuickSearch(textQuery, type, pathQuery, userId, listCateIds, listForumIds, forumIdsOfModerator);
    }

    @Override
    public List<ForumSearch> getQuickSearch(String textQuery, String type, String pathQuery, String userId, List<String> listCateIds, List<String> listForumIds, List<String> forumIdsOfModerator) throws Exception {
        return this.storage_.getQuickSearch(textQuery, type, pathQuery, userId, listCateIds, listForumIds, forumIdsOfModerator);
    }

    @Override
    public List<ForumSearch> getAdvancedSearch(SessionProvider sProvider, ForumEventQuery eventQuery, List<String> listCateIds, List<String> listForumIds) throws Exception {
        sProvider.close();
        return this.getAdvancedSearch(eventQuery, listCateIds, listForumIds);
    }

    @Override
    public List<ForumSearch> getAdvancedSearch(ForumEventQuery eventQuery, List<String> listCateIds, List<String> listForumIds) throws Exception {
        return this.storage_.getAdvancedSearch(eventQuery, listCateIds, listForumIds);
    }

    @Override
    public ForumAdministration getForumAdministration(SessionProvider sProvider) throws Exception {
        sProvider.close();
        return this.getForumAdministration();
    }

    @Override
    public ForumAdministration getForumAdministration() throws Exception {
        return this.storage_.getForumAdministration();
    }

    @Override
    public void saveForumAdministration(SessionProvider sProvider, ForumAdministration forumAdministration) throws Exception {
        sProvider.close();
        this.saveForumAdministration(forumAdministration);
    }

    @Override
    public void saveForumAdministration(ForumAdministration forumAdministration) throws Exception {
        this.storage_.saveForumAdministration(forumAdministration);
    }

    @Override
    public void addWatch(SessionProvider sProvider, int watchType, String path, List<String> values, String currentUser) throws Exception {
        sProvider.close();
        this.addWatch(watchType, path, values, currentUser);
    }

    @Override
    public void addWatch(int watchType, String path, List<String> values, String currentUser) throws Exception {
        this.storage_.addWatch(watchType, path, values, currentUser);
    }

    @Override
    public void removeWatch(SessionProvider sProvider, int watchType, String path, String values) throws Exception {
        sProvider.close();
        this.removeWatch(watchType, path, values);
    }

    @Override
    public void removeWatch(int watchType, String path, String values) throws Exception {
        this.storage_.removeWatch(watchType, path, values);
    }

    @Override
    public List<ForumSearch> getJobWattingForModerator(SessionProvider sProvider, String[] paths) throws Exception {
        sProvider.close();
        return this.getJobWattingForModerator(paths);
    }

    @Override
    public List<ForumSearch> getJobWattingForModerator(String[] paths) throws Exception {
        return this.storage_.getJobWattingForModerator(paths);
    }

    @Override
    public int getJobWattingForModeratorByUser(SessionProvider sProvider, String userId) throws Exception {
        sProvider.close();
        return this.getJobWattingForModeratorByUser(userId);
    }

    @Override
    public int getJobWattingForModeratorByUser(String userId) throws Exception {
        return this.storage_.getJobWattingForModeratorByUser(userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeProfile(String userId) throws Exception {
        SessionProvider sysProvider = SessionProvider.createSystemProvider();
        try {
            Node userProfileHome = this.storage_.getUserProfileHome(sysProvider);
            userProfileHome.getNode(userId).getProperty("exo:lastLoginDate").setValue((Value)null);
            userProfileHome.save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sysProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void userLogin(String userId) throws Exception {
        this.lastLogin_ = userId;
        if (!this.onlineUserList_.contains(userId)) {
            this.onlineUserList_.add(userId);
        }
        SessionProvider sysProvider = SessionProvider.createSystemProvider();
        try {
            Node userProfileHome = this.storage_.getUserProfileHome(sysProvider);
            userProfileHome.getNode(userId).setProperty("exo:lastLoginDate", this.storage_.getGreenwichMeanTime());
            userProfileHome.save();
            Node statisticNode = this.storage_.getStatisticHome(sysProvider).getNode(Utils.FORUM_STATISTIC);
            String[] array = statisticNode.getProperty("exo:mostUsersOnline").getString().split(",");
            if (array.length > 1) {
                int ol = this.onlineUserList_.size();
                if (ol > Integer.parseInt(array[0].trim())) {
                    statisticNode.setProperty("exo:mostUsersOnline", String.valueOf(ol) + ", at " + this.storage_.getGreenwichMeanTime().getTimeInMillis());
                    statisticNode.save();
                }
            } else {
                statisticNode.setProperty("exo:mostUsersOnline", "1, at " + this.storage_.getGreenwichMeanTime().getTimeInMillis());
                statisticNode.save();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sysProvider.close();
        }
    }

    @Override
    public void userLogout(String userId) throws Exception {
        if (this.onlineUserList_.contains(userId)) {
            this.onlineUserList_.remove(userId);
        }
    }

    @Override
    public boolean isOnline(String userId) throws Exception {
        try {
            if (this.onlineUserList_.contains(userId)) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public List<String> getOnlineUsers() throws Exception {
        return this.onlineUserList_;
    }

    @Override
    public String getLastLogin() throws Exception {
        return this.lastLogin_;
    }

    @Override
    public SendMessageInfo getMessageInfo(String name) throws Exception {
        return this.storage_.getMessageInfo(name);
    }

    @Override
    public JCRPageList searchUserProfile(SessionProvider sProvider, String userSearch) throws Exception {
        sProvider.close();
        return this.searchUserProfile(userSearch);
    }

    @Override
    public JCRPageList searchUserProfile(String userSearch) throws Exception {
        return this.storage_.searchUserProfile(userSearch);
    }

    @Override
    public boolean isAdminRole(String userName) throws Exception {
        return this.storage_.isAdminRole(userName);
    }

    @Override
    public List<Post> getNewPosts(int number) throws Exception {
        ArrayList<Post> list = null;
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        Node forumHomeNode = this.storage_.getForumHomeNode(sProvider);
        QueryManager qm = forumHomeNode.getSession().getWorkspace().getQueryManager();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("/jcr:root").append(forumHomeNode.getPath()).append("//element(*,exo:post) [((@exo:isApproved='true') and (@exo:isHidden='false') and (@exo:isActiveByTopic='true') and (@exo:userPrivate='exoUserPri'))] order by @exo:createdDate descending");
        Query query = qm.createQuery(stringBuffer.toString(), "xpath");
        QueryResult result = query.execute();
        NodeIterator iter = result.getNodes();
        int count = 0;
        while (iter.hasNext() && count++ < number) {
            if (list == null) {
                list = new ArrayList<Post>();
            }
            Post p = this.storage_.getPost(iter.nextNode());
            list.add(p);
        }
        return list;
    }

    @Override
    public NodeIterator search(String queryString, SessionProvider sProvider) throws Exception {
        sProvider.close();
        return this.search(queryString);
    }

    @Override
    public NodeIterator search(String queryString) throws Exception {
        return this.storage_.search(queryString);
    }

    @Override
    public void evaluateActiveUsers(SessionProvider sProvider, String query) throws Exception {
        sProvider.close();
        this.evaluateActiveUsers(query);
    }

    @Override
    public void evaluateActiveUsers(String query) throws Exception {
        this.storage_.evaluateActiveUsers(query);
    }

    @Override
    public void updateTopicAccess(String userId, String topicId) throws Exception {
        this.storage_.updateTopicAccess(userId, topicId);
    }

    @Override
    public void updateForumAccess(String userId, String forumId) throws Exception {
        this.storage_.updateForumAccess(userId, forumId);
    }

    @Override
    public Object exportXML(String categoryId, String forumId, List<String> objectIds, String nodePath, ByteArrayOutputStream bos, boolean isExportAll, SessionProvider sProvider) throws Exception {
        sProvider.close();
        return this.exportXML(categoryId, forumId, objectIds, nodePath, bos, isExportAll);
    }

    @Override
    public Object exportXML(String categoryId, String forumId, List<String> objectIds, String nodePath, ByteArrayOutputStream bos, boolean isExportAll) throws Exception {
        return this.storage_.exportXML(categoryId, forumId, objectIds, nodePath, bos, isExportAll);
    }

    @Override
    public List<UserProfile> getQuickProfiles(SessionProvider sProvider, List<String> userList) throws Exception {
        return this.getQuickProfiles(userList);
    }

    @Override
    public List<UserProfile> getQuickProfiles(List<String> userList) throws Exception {
        return this.storage_.getQuickProfiles(userList);
    }

    @Override
    public UserProfile getQuickProfile(SessionProvider sProvider, String userName) throws Exception {
        sProvider.close();
        return this.getQuickProfile(userName);
    }

    @Override
    public UserProfile getQuickProfile(String userName) throws Exception {
        return this.storage_.getQuickProfile(userName);
    }

    @Override
    public String getScreenName(String userName) throws Exception {
        return this.storage_.getScreenName(userName);
    }

    @Override
    public UserProfile getUserInformations(SessionProvider sProvider, UserProfile userProfile) throws Exception {
        sProvider.close();
        return this.getUserInformations(userProfile);
    }

    @Override
    public UserProfile getUserInformations(UserProfile userProfile) throws Exception {
        return this.storage_.getUserInformations(userProfile);
    }

    @Override
    public UserProfile getDefaultUserProfile(SessionProvider sProvider, String userName, String ip) throws Exception {
        sProvider.close();
        return this.getDefaultUserProfile(userName, ip);
    }

    @Override
    public UserProfile getDefaultUserProfile(String userName, String ip) throws Exception {
        return this.storage_.getDefaultUserProfile(userName, ip);
    }

    @Override
    public UserProfile updateUserProfileSetting(UserProfile userProfile) throws Exception {
        return this.storage_.updateUserProfileSetting(userProfile);
    }

    @Override
    public List<String> getBookmarks(SessionProvider sProvider, String userName) throws Exception {
        sProvider.close();
        return this.getBookmarks(userName);
    }

    @Override
    public List<String> getBookmarks(String userName) throws Exception {
        return this.storage_.getBookmarks(userName);
    }

    @Override
    public UserProfile getUserSettingProfile(SessionProvider sProvider, String userName) throws Exception {
        sProvider.close();
        return this.getUserSettingProfile(userName);
    }

    @Override
    public UserProfile getUserSettingProfile(String userName) throws Exception {
        return this.storage_.getUserSettingProfile(userName);
    }

    @Override
    public void saveUserSettingProfile(SessionProvider sProvider, UserProfile userProfile) throws Exception {
        sProvider.close();
        this.saveUserSettingProfile(userProfile);
    }

    @Override
    public void saveUserSettingProfile(UserProfile userProfile) throws Exception {
        this.storage_.saveUserSettingProfile(userProfile);
    }

    @Override
    public void importXML(String nodePath, InputStream is, String mimeType, SessionProvider sProvider) throws Exception {
        sProvider.close();
        this.storage_.importXML(nodePath, is, mimeType);
    }

    @Override
    public void importXML(String nodePath, InputStream is, String mimeType) throws Exception {
        this.storage_.importXML(nodePath, is, mimeType);
    }

    @Override
    public void updateDataImported() throws Exception {
    }

    @Override
    public void updateForum(String path) throws Exception {
        this.storage_.updateForum(path);
    }

    @Override
    public List<String> getBanList() throws Exception {
        return this.storage_.getBanList();
    }

    @Override
    public boolean addBanIP(String ip) throws Exception {
        return this.storage_.addBanIP(ip);
    }

    @Override
    public void removeBan(String ip) throws Exception {
        this.storage_.removeBan(ip);
    }

    @Override
    public JCRPageList getListPostsByIP(String ip, String strOrderBy, SessionProvider sProvider) throws Exception {
        sProvider.close();
        return this.getListPostsByIP(ip, strOrderBy);
    }

    @Override
    public JCRPageList getListPostsByIP(String ip, String strOrderBy) throws Exception {
        return this.storage_.getListPostsByIP(ip, strOrderBy);
    }

    @Override
    public List<String> getForumBanList(String forumId) throws Exception {
        return this.storage_.getForumBanList(forumId);
    }

    @Override
    public boolean addBanIPForum(SessionProvider sProvider, String ip, String forumId) throws Exception {
        sProvider.close();
        return this.addBanIPForum(ip, forumId);
    }

    @Override
    public boolean addBanIPForum(String ip, String forumId) throws Exception {
        return this.storage_.addBanIPForum(ip, forumId);
    }

    @Override
    public void removeBanIPForum(SessionProvider sProvider, String ip, String forumId) throws Exception {
        sProvider.close();
        this.removeBanIPForum(ip, forumId);
    }

    @Override
    public void removeBanIPForum(String ip, String forumId) throws Exception {
        this.storage_.removeBanIPForum(ip, forumId);
    }

    @Override
    public void registerListenerForCategory(SessionProvider sProvider, String categoryId) throws Exception {
        sProvider.close();
        this.registerListenerForCategory(categoryId);
    }

    @Override
    public void registerListenerForCategory(String categoryId) throws Exception {
        this.storage_.registerListenerForCategory(categoryId);
    }

    @Override
    public void unRegisterListenerForCategory(String path) throws Exception {
        this.storage_.unRegisterListenerForCategory(path);
    }

    @Override
    public ForumAttachment getUserAvatar(String userName, SessionProvider sProvider) throws Exception {
        sProvider.close();
        return this.getUserAvatar(userName);
    }

    @Override
    public ForumAttachment getUserAvatar(String userName) throws Exception {
        return this.storage_.getUserAvatar(userName);
    }

    @Override
    public void saveUserAvatar(String userId, ForumAttachment fileAttachment, SessionProvider sProvider) throws Exception {
        sProvider.close();
        this.saveUserAvatar(userId, fileAttachment);
    }

    @Override
    public void saveUserAvatar(String userId, ForumAttachment fileAttachment) throws Exception {
        this.storage_.saveUserAvatar(userId, fileAttachment);
    }

    @Override
    public void setDefaultAvatar(String userName, SessionProvider sProvider) throws Exception {
        sProvider.close();
        this.setDefaultAvatar(userName);
    }

    @Override
    public void setDefaultAvatar(String userName) throws Exception {
        this.storage_.setDefaultAvatar(userName);
    }

    @Override
    public List<Watch> getWatchByUser(String userId, SessionProvider sProvider) throws Exception {
        sProvider.close();
        return this.getWatchByUser(userId);
    }

    @Override
    public List<Watch> getWatchByUser(String userId) throws Exception {
        return this.storage_.getWatchByUser(userId);
    }

    @Override
    public void updateEmailWatch(List<String> listNodeId, String newEmailAdd, String userId, SessionProvider sProvider) throws Exception {
        sProvider.close();
        this.updateEmailWatch(listNodeId, newEmailAdd, userId);
    }

    @Override
    public void updateEmailWatch(List<String> listNodeId, String newEmailAdd, String userId) throws Exception {
        this.storage_.updateEmailWatch(listNodeId, newEmailAdd, userId);
    }

    @Override
    public void saveBBCode(List<BBCode> bbcodes) throws Exception {
        this.bbcodeObject_.saveBBCode(bbcodes);
    }

    @Override
    public List<BBCode> getAllBBCode() throws Exception {
        return this.bbcodeObject_.getAllBBCode();
    }

    @Override
    public List<String> getActiveBBCode() throws Exception {
        return this.bbcodeObject_.getActiveBBCode();
    }

    @Override
    public BBCode getBBcode(String id) throws Exception {
        return this.bbcodeObject_.getBBcode(id);
    }

    @Override
    public void removeBBCode(String bbcodeId) throws Exception {
        this.bbcodeObject_.removeBBCode(bbcodeId);
    }

    @Override
    public List<PruneSetting> getAllPruneSetting() throws Exception {
        return this.storage_.getAllPruneSetting();
    }

    @Override
    public List<PruneSetting> getAllPruneSetting(SessionProvider sProvider) throws Exception {
        sProvider.close();
        return this.getAllPruneSetting();
    }

    @Override
    public void savePruneSetting(PruneSetting pruneSetting) throws Exception {
        this.storage_.savePruneSetting(pruneSetting);
    }

    @Override
    public void savePruneSetting(SessionProvider sProvider, PruneSetting pruneSetting) throws Exception {
        sProvider.close();
        this.savePruneSetting(pruneSetting);
    }

    @Override
    public PruneSetting getPruneSetting(String forumPath) throws Exception {
        return this.storage_.getPruneSetting(forumPath);
    }

    @Override
    public PruneSetting getPruneSetting(SessionProvider sProvider, String forumPath) throws Exception {
        sProvider.close();
        return this.getPruneSetting(forumPath);
    }

    @Override
    public void runPrune(PruneSetting pSetting) throws Exception {
        this.storage_.runPrune(pSetting);
    }

    @Override
    public void runPrune(String forumPath) throws Exception {
        this.storage_.runPrune(forumPath);
    }

    @Override
    public long checkPrune(PruneSetting pSetting) throws Exception {
        return this.storage_.checkPrune(pSetting);
    }

    @Override
    public JCRPageList getPageTopicByType(String type) throws Exception {
        return this.storage_.getPageTopicByType(type);
    }

    @Override
    public TopicType getTopicType(String Id) throws Exception {
        return this.storage_.getTopicType(Id);
    }

    @Override
    public List<TopicType> getTopicTypes() throws Exception {
        return this.storage_.getTopicTypes();
    }

    @Override
    public void removeTopicType(String topicTypeId) throws Exception {
        this.storage_.removeTopicType(topicTypeId);
    }

    @Override
    public void saveTopicType(TopicType topicType) throws Exception {
        this.storage_.saveTopicType(topicType);
    }

    @Override
    public void updateUserProfileInfo(String name) throws Exception {
        this.storage_.updateUserProfileInfo(name);
    }
}

