/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.forum.service.impl.ForumServiceImpl;
import org.exoplatform.forum.service.impl.JCRDataStorage;
import org.exoplatform.forum.service.impl.JobManager;
import org.exoplatform.ks.common.conf.ManagedPlugin;
import org.exoplatform.ks.common.conf.RoleRulesPlugin;
import org.exoplatform.ks.common.user.ContactProvider;
import org.exoplatform.management.ManagementAware;
import org.exoplatform.management.ManagementContext;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Managed
@NameTemplate(value={@Property(key="service", value="forum")})
@ManagedDescription(value="Forum management")
public class ForumServiceManaged
implements ManagementAware {
    private static final Log log = ExoLogger.getLogger(ForumServiceManaged.class);
    private ForumServiceImpl forumService;
    private ManagementContext context;

    public ForumServiceManaged(ForumServiceImpl forumService) {
        this.forumService = forumService;
        this.forumService.managed = this;
    }

    public void setContext(ManagementContext context) {
        this.context = context;
    }

    @Managed
    @ManagedDescription(value="list of currently connected users")
    public List<String> getOnlineUsers() throws Exception {
        return this.forumService.onlineUserList_;
    }

    @Managed
    @ManagedDescription(value="number of currently connected users")
    public int countOnlineUsers() throws Exception {
        return this.forumService.onlineUserList_.size();
    }

    @Managed
    @ManagedDescription(value="rules that define administrators")
    public List<String> getAdminRules() {
        ArrayList<String> adminRules = new ArrayList<String>();
        List<RoleRulesPlugin> plugins = this.forumService.storage_.rulesPlugins_;
        for (RoleRulesPlugin plugin : plugins) {
            Collection allrules = plugin.getAllRules().values();
            for (List rules : allrules) {
                if (rules == null) continue;
                adminRules.addAll(rules);
            }
        }
        return adminRules;
    }

    @Managed
    @ManagedDescription(value="evaluate is a user has administrator role")
    public boolean hasForumAdminRole(String username) throws Exception {
        return this.forumService.storage_.isAdminRole(username);
    }

    @Managed
    @ManagedDescription(value="recalculate forum statistics")
    public void updateStatistics() throws Exception {
        this.forumService.updateForumStatistic();
    }

    @Managed
    @ManagedDescription(value="get the configuration of the mail service used for notifications in KS")
    public Map<String, String> getMailServiceConfig() {
        return this.forumService.storage_.serverConfig_;
    }

    @Managed
    @ManagedDescription(value="Get the ContactProvider implementation")
    public String getContactProvider() {
        return ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ContactProvider.class).toString();
    }

    @Managed
    @ManagedDescription(value="Set the ContactProvider implementation")
    public void setContactProvider(String fqn) {
        Class<?> instance = null;
        try {
            instance = Class.forName(fqn);
        }
        catch (Exception e) {
            log.error((Object)("Failed to register contact provider for " + fqn + ": " + e.getMessage()));
            return;
        }
        ExoContainerContext.getContainerByName((String)"portal").registerComponentInstance(ContactProvider.class, instance);
    }

    public void registerPlugin(ManagedPlugin plugin) {
        if (this.context != null) {
            this.context.register((Object)plugin);
        }
    }

    public void registerStorageManager(JCRDataStorage storage) {
        if (this.context != null) {
            this.context.register((Object)storage);
        }
    }

    public void registerJobManager(JobManager jobManager) {
        if (this.context != null) {
            this.context.register((Object)jobManager);
        }
    }
}

