/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service.conf;

import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.scheduler.JobInfo;
import org.exoplatform.services.scheduler.JobSchedulerService;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class UpdateDataJob
implements Job {
    private static Log log_ = ExoLogger.getLogger((String)"job.RecordsJob");

    public void execute(JobExecutionContext context) throws JobExecutionException {
        try {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            ForumService forumService = (ForumService)container.getComponentInstanceOfType(ForumService.class);
            String name = context.getJobDetail().getName();
            JobDataMap jdatamap = context.getJobDetail().getJobDataMap();
            String path = jdatamap.getString("path");
            forumService.updateForum(path);
            JobSchedulerService schedulerService = (JobSchedulerService)container.getComponentInstanceOfType(JobSchedulerService.class);
            JobInfo info = new JobInfo(name, "KnowledgeSuite-forum", context.getJobDetail().getJobClass());
            if (log_.isDebugEnabled()) {
                log_.debug((Object)"\n\nForum statistic updated");
            }
            schedulerService.removeJob(info);
        }
        catch (Exception e) {
            log_.error((Object)"Failed to update forum statistics.", (Throwable)e);
        }
    }
}

