/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service.conf;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.conf.SendMessageInfo;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.mail.MailService;
import org.exoplatform.services.mail.Message;
import org.exoplatform.services.scheduler.JobInfo;
import org.exoplatform.services.scheduler.JobSchedulerService;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class SendMailJob
implements Job {
    private static Log log_ = ExoLogger.getLogger((String)"job.forum.SendMailJob");

    public void execute(JobExecutionContext context) throws JobExecutionException {
        try {
            MailService mailService = (MailService)PortalContainer.getInstance().getComponentInstanceOfType(MailService.class);
            ForumService forumService = (ForumService)PortalContainer.getInstance().getComponentInstanceOfType(ForumService.class);
            JobSchedulerService schedulerService = (JobSchedulerService)PortalContainer.getInstance().getComponentInstanceOfType(JobSchedulerService.class);
            String name = context.getJobDetail().getName();
            SendMessageInfo messageInfo = forumService.getMessageInfo(name);
            List<String> emailAddresses = messageInfo.getEmailAddresses();
            Message message = messageInfo.getMessage();
            JobInfo info = new JobInfo(name, "KnowledgeSuite-forum", context.getJobDetail().getJobClass());
            if (message != null && emailAddresses != null && emailAddresses.size() > 0) {
                ArrayList<String> sentMessages = new ArrayList<String>();
                int countEmail = 0;
                for (String address : emailAddresses) {
                    if (sentMessages.contains(address)) continue;
                    message.setTo(address);
                    mailService.sendMessage(message);
                    sentMessages.add(address);
                    ++countEmail;
                }
                if (log_.isDebugEnabled()) {
                    log_.debug((Object)("\n\nEmail notifications for Thread Save Question have been sent to " + countEmail + " addresses"));
                }
            }
            schedulerService.removeJob(info);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

