/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.bench;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.forum.bench.ForumDataProvider;
import org.exoplatform.forum.bench.LoremIpsum4J;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.services.idgenerator.IDGeneratorService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomForumDataProvider
implements ForumDataProvider {
    private static Log log = ExoLogger.getLogger(RandomForumDataProvider.class);
    private LoremIpsum4J textGen;
    private Random rand;
    private List<String> users;
    private int maxCategories = 10;
    private int maxForums = 5;
    private int maxTopics = 20;
    private int maxPosts = 20;
    private String fistCategoryId = Utils.CATEGORY + "randomId412849127491";
    private boolean randomize = false;
    private ForumService forumService;

    public RandomForumDataProvider(InitParams initParams, ForumService forumService, IDGeneratorService uidGenerator, OrganizationService organizationService) {
        this.forumService = forumService;
        this.initRandomizers();
        this.initParams(initParams);
    }

    private void initParams(InitParams initParams) {
        try {
            this.maxCategories = Integer.parseInt(initParams.getValueParam("maxCategories").getValue());
            this.maxForums = Integer.parseInt(initParams.getValueParam("maxForums").getValue());
            this.maxTopics = Integer.parseInt(initParams.getValueParam("maxTopics").getValue());
            this.maxPosts = Integer.parseInt(initParams.getValueParam("maxPosts").getValue());
            this.randomize = Boolean.parseBoolean(initParams.getValueParam("randomize").getValue());
            log.debug((Object)("initializing : " + initParams));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not initialize ", e);
        }
    }

    private void initRandomizers() {
        this.textGen = new LoremIpsum4J();
        this.rand = new Random();
    }

    private String randomWords(int i) {
        int wordCount = this.rand.nextInt(i + 1) + 1;
        String words = this.textGen.getWords(wordCount);
        return words;
    }

    private String randomParagraphs(int i) {
        int paragraphCount = this.rand.nextInt(i + 1) + 1;
        String paragraphs = this.textGen.getParagraphs(paragraphCount);
        return paragraphs.replaceAll("\\n\\n", "<br/><br/>");
    }

    @Override
    public List<Category> findCategories() {
        ArrayList<Category> result = new ArrayList<Category>();
        try {
            Category init = this.newCategory(null);
            init.setId(this.fistCategoryId);
            result.add(init);
            Category previous = init;
            for (int i = 0; i < this.getMaxCategory(); ++i) {
                Category category = this.newCategory(previous);
                result.add(category);
                previous = category;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    private int getMaxCategory() {
        return this.randomize ? this.rand.nextInt(this.maxCategories) : this.maxCategories;
    }

    private Forum newForum(Forum previous) {
        if (previous == null) {
            previous = new Forum();
        }
        Forum forum = new Forum();
        forum.setCreatedDate(new Date());
        forum.setDescription(this.randomWords(10));
        forum.setForumName(this.randomWords(5));
        forum.setForumOrder(previous.getForumOrder() + 1);
        forum.setOwner("root");
        return forum;
    }

    private Category newCategory(Category previous) {
        if (previous == null) {
            previous = new Category();
        }
        Category category = new Category();
        category.setCategoryName(this.randomWords(10));
        category.setCategoryOrder(previous.getCategoryOrder() + 1L);
        category.setCreatedDate(new Date());
        category.setDescription(this.randomWords(10));
        category.setModifiedBy("root");
        category.setModifiedDate(new Date());
        category.setOwner("root");
        return category;
    }

    @Override
    public List<Forum> findForumsByCategory(String categoryId) {
        ArrayList<Forum> result = new ArrayList<Forum>();
        try {
            Forum previous = null;
            int forumCount = this.maxForums();
            for (int i = 0; i < forumCount; ++i) {
                Forum forum = this.newForum(previous);
                result.add(forum);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    private int maxForums() {
        return this.randomize ? this.rand.nextInt(this.maxForums) + 1 : this.maxForums;
    }

    @Override
    public boolean isInitialized() {
        try {
            Category initialized = this.forumService.getCategory(this.fistCategoryId);
            return initialized != null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<Topic> findTopicsByForum(Forum forum) {
        ArrayList<Topic> result = new ArrayList<Topic>();
        try {
            Topic previous = null;
            int topicCount = this.maxTopics();
            for (int i = 0; i < topicCount; ++i) {
                Topic topic = this.newTopic(previous);
                result.add(topic);
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private int maxTopics() {
        return this.randomize ? this.rand.nextInt(this.maxTopics) + 1 : this.maxTopics;
    }

    private Topic newTopic(Topic previous) {
        if (previous == null) {
            previous = new Topic();
        }
        Topic topic = new Topic();
        topic.setCreatedDate(new Date());
        topic.setDescription(this.randomWords(10));
        topic.setOwner("root");
        topic.setTopicName(this.randomWords(5));
        topic.setIcon("Shield");
        return topic;
    }

    @Override
    public List<Post> fingPostsByTopic(Topic topic) {
        ArrayList<Post> result = new ArrayList<Post>();
        try {
            Post previous = null;
            int postCount = this.maxPosts();
            for (int i = 0; i < postCount; ++i) {
                Post post = this.newPost(previous);
                result.add(post);
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private int maxPosts() {
        return this.randomize ? this.rand.nextInt(this.maxPosts) + 1 : this.maxPosts;
    }

    private Post newPost(Post previous) {
        if (previous == null) {
            previous = new Post();
        }
        Post post = new Post();
        post.setName(this.randomWords(10));
        String content = this.randomParagraphs(5);
        post.setMessage(content);
        post.setOwner("root");
        post.setIcon("Shield");
        return post;
    }
}

