/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service.conf;

import org.exoplatform.container.ExoContainer;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.ks.common.Utils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.scheduler.JobInfo;
import org.exoplatform.services.scheduler.JobSchedulerService;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class UpdateUserProfileJob
implements Job {
    private static Log log_ = ExoLogger.getLogger(UpdateUserProfileJob.class);

    public void execute(JobExecutionContext context) throws JobExecutionException {
        try {
            ExoContainer exoContainer = Utils.getExoContainer((JobExecutionContext)context);
            ForumService forumService = (ForumService)exoContainer.getComponentInstanceOfType(ForumService.class);
            String name = context.getJobDetail().getName();
            JobSchedulerService schedulerService = (JobSchedulerService)exoContainer.getComponentInstanceOfType(JobSchedulerService.class);
            JobInfo info = new JobInfo(name, "KnowledgeSuite-forum", context.getJobDetail().getJobClass());
            forumService.updateUserProfileInfo(name);
            if (log_.isDebugEnabled()) {
                log_.debug((Object)"\n\nNumber of deleted posts, topics updated to Forum statistics and user's profile");
            }
            schedulerService.removeJob(info);
        }
        catch (Exception e) {
            log_.trace((Object)("User profile could not updated: \n" + e.getCause()));
        }
    }
}

