/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service.conf;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.conf.SendMessageInfo;
import org.exoplatform.ks.common.Utils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.mail.MailService;
import org.exoplatform.services.mail.Message;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class SendMailJob
implements Job {
    private static Log log_ = ExoLogger.getLogger((String)"job.forum.SendMailJob");

    public void execute(JobExecutionContext context) throws JobExecutionException {
        try {
            ExoContainer exoContainer = Utils.getExoContainer((JobExecutionContext)context);
            MailService mailService = (MailService)exoContainer.getComponentInstanceOfType(MailService.class);
            ForumService forumService = (ForumService)exoContainer.getComponentInstanceOfType(ForumService.class);
            int countEmail = 0;
            Iterator<SendMessageInfo> iter = forumService.getPendingMessages();
            while (iter.hasNext()) {
                try {
                    SendMessageInfo messageInfo = iter.next();
                    List<String> emailAddresses = messageInfo.getEmailAddresses();
                    Message message = messageInfo.getMessage();
                    message.setFrom(this.makeNotificationSender(message.getFrom()));
                    if (message == null || emailAddresses == null || emailAddresses.size() <= 0) continue;
                    ArrayList<String> sentMessages = new ArrayList<String>();
                    for (String address : emailAddresses) {
                        if (sentMessages.contains(address)) continue;
                        message.setTo(address);
                        mailService.sendMessage(message);
                        sentMessages.add(address);
                        ++countEmail;
                    }
                }
                catch (Exception e) {
                    log_.error((Object)"Could not send email notification", (Throwable)e);
                }
            }
            if (log_.isInfoEnabled() && countEmail > 0) {
                log_.info((Object)("\n\nEmail notifications has been sent to " + countEmail + " addresses"));
            }
        }
        catch (Exception e) {
            log_.warn((Object)"\n\n Unable send email notification ");
        }
    }

    public String makeNotificationSender(String from) {
        InternetAddress addr = null;
        if (from == null) {
            return null;
        }
        try {
            addr = new InternetAddress(from);
        }
        catch (AddressException e) {
            if (log_.isDebugEnabled()) {
                log_.debug((Object)"value of 'from' field in message made by forum notification feature is not in format of mail address", (Throwable)e);
            }
            return null;
        }
        Properties props = new Properties(System.getProperties());
        String mailAddr = props.getProperty("gatein.email.smtp.from");
        if (mailAddr == null || mailAddr.length() == 0) {
            mailAddr = props.getProperty("mail.from");
        }
        if (mailAddr != null) {
            try {
                InternetAddress serMailAddr = new InternetAddress(mailAddr);
                addr.setAddress(serMailAddr.getAddress());
                return addr.toUnicodeString();
            }
            catch (AddressException e) {
                if (log_.isDebugEnabled()) {
                    log_.debug((Object)"value of 'gatein.email.smtp.from' or 'mail.from' in configuration file is not in format of mail address", (Throwable)e);
                }
                return null;
            }
        }
        return null;
    }
}

