/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.bench;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.Stack;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.forum.bench.ForumDataRandom;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.MessageBuilder;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.services.bench.DataInjector;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForumDataInjector
extends DataInjector {
    private static Log log = ExoLogger.getLogger(ForumDataInjector.class);
    private Random rand;
    private int maxCategories = 10;
    private int maxForums = 5;
    private int maxTopics = 20;
    private int maxPosts = 20;
    private String fistCategoryId = Utils.CATEGORY + "randomId412849127491";
    private boolean randomize = false;
    private ForumService forumService;
    private Stack<String> catesStack = new Stack();

    public ForumDataInjector(InitParams params, ForumService forumService) {
        this.forumService = forumService;
        this.initRandomizers();
        this.initParams(params);
    }

    public void initParams(InitParams initParams) {
        try {
            ValueParam param = initParams.getValueParam("mC");
            if (param != null) {
                this.maxCategories = Integer.parseInt(param.getValue());
            }
            if ((param = initParams.getValueParam("mF")) != null) {
                this.maxForums = Integer.parseInt(param.getValue());
            }
            if ((param = initParams.getValueParam("mT")) != null) {
                this.maxTopics = Integer.parseInt(param.getValue());
            }
            if ((param = initParams.getValueParam("mP")) != null) {
                this.maxPosts = Integer.parseInt(param.getValue());
            }
            if ((param = initParams.getValueParam("rand")) != null) {
                this.randomize = Boolean.parseBoolean(param.getValue());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not initialize ", e);
        }
    }

    public Log getLog() {
        return log;
    }

    public void inject() throws Exception {
        long topicsCount = 0L;
        long forumsCount = 0L;
        long postCount = 0L;
        long categoriesWeight = 0L;
        List<Category> categories = this.findCategories();
        long categoriesCount = 0L;
        for (Category category : categories) {
            this.forumService.saveCategory(category, true);
            this.catesStack.push(category.getId());
            String categoryId = category.getId();
            List<Forum> forums = this.findForumsByCategory(categoryId);
            log.info((Object)("Category " + ++categoriesCount + "/" + categories.size() + " with " + forums.size() + " forums"));
            long forumsWeight = 0L;
            forumsCount += (long)forums.size();
            int forumNum = 0;
            for (Forum forum : forums) {
                this.forumService.saveForum(categoryId, forum, true);
                String forumId = forum.getId();
                long topicsWeight = 0L;
                List<Topic> topics = this.findTopicsByForum(forum);
                log.info((Object)("\tForum " + ++forumNum + "/" + forums.size() + " with " + topics.size() + " topics"));
                int topicNum = 0;
                for (Topic topic : topics) {
                    this.forumService.saveTopic(categoryId, forumId, topic, true, false, new MessageBuilder());
                    String topicId = topic.getId();
                    List<Post> posts = this.fingPostsByTopic(topic);
                    postCount += (long)posts.size();
                    long postsWeight = 0L;
                    long t1 = System.currentTimeMillis();
                    for (Post post : posts) {
                        this.forumService.savePost(categoryId, forumId, topicId, post, true, new MessageBuilder());
                        long messageWeight = post.getMessage().length() * 2;
                        postsWeight += messageWeight;
                    }
                    double elapsed = System.currentTimeMillis() - t1;
                    double rate = (double)(postsWeight / 1024L) / (elapsed / 1000.0);
                    String srate = MessageFormat.format("({0,number,#.#} K/s)", rate);
                    log.info((Object)("\t\tTopic " + ++topicNum + "/" + topics.size() + "\t" + posts.size() + " posts in " + elapsed + "ms " + srate));
                    topicsWeight += postsWeight;
                }
                log.info((Object)("\t\t " + topics.size() + " topics " + MessageFormat.format("({0,number,#.#} K)", topicsWeight / 1024L) + " total posts=" + postCount));
                forumsWeight += topicsWeight;
                topicsCount += (long)topics.size();
            }
            log.info((Object)("\t" + forums.size() + " forums " + MessageFormat.format("({0,number,#.#} K)", forumsWeight / 1024L) + " total posts=" + postCount));
            categoriesWeight += forumsWeight;
        }
        log.info((Object)("INITIALIZED : categories=" + categories.size() + " / forums=" + forumsCount + " / topics=" + topicsCount + " / posts=" + postCount + MessageFormat.format(" ({0,number,#.#} K)", categoriesWeight / 1024L)));
        try {
            Category category = this.forumService.getCategory(this.fistCategoryId);
            category.setDescription(this.catesStack.toString());
            this.forumService.saveCategory(category, false);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public boolean isInitialized() {
        return false;
    }

    public void reject() throws Exception {
        if (this.catesStack.isEmpty()) {
            this.initHistoryInject();
        }
        log.info((Object)String.format("Remove %s categories in forum..... ", this.catesStack.size()));
        while (!this.catesStack.isEmpty()) {
            String cateId = this.catesStack.pop();
            this.forumService.removeCategory(cateId);
        }
    }

    private void initHistoryInject() {
        try {
            Category category = this.forumService.getCategory(this.fistCategoryId);
            this.catesStack.addAll(this.convertStringToList(category.getDescription()));
        }
        catch (Exception e) {
            log.info((Object)"Failed to get history inject....");
        }
    }

    public List<String> convertStringToList(String s) {
        s = s.replace("[", "").replace("]", "");
        s = s.trim().replaceAll("(,\\s*)", ",").replaceAll("(\\s*,)", ",");
        String[] strs = s.split(",");
        return new ArrayList<String>(Arrays.asList(strs));
    }

    private void initRandomizers() {
        this.rand = new Random();
    }

    public List<Category> findCategories() {
        ArrayList<Category> result = new ArrayList<Category>();
        try {
            int maxCat = this.getMaxItem(this.maxCategories);
            Category previous = this.forumService.getCategory(this.fistCategoryId);
            if (previous == null) {
                previous = this.newCategory(null);
                --maxCat;
                previous.setId(this.fistCategoryId);
                result.add(previous);
            } else {
                this.catesStack.clear();
                this.catesStack.addAll(this.convertStringToList(previous.getDescription()));
            }
            for (int i = 0; i < maxCat; ++i) {
                previous = this.newCategory(previous);
                result.add(previous);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    private Forum newForum(Forum previous) {
        if (previous == null) {
            previous = new Forum();
        }
        Forum forum = new Forum();
        forum.setCreatedDate(new Date());
        forum.setDescription(this.randomWords(10));
        forum.setForumName(this.randomWords(5));
        forum.setForumOrder(previous.getForumOrder() + 1);
        forum.setOwner(this.randomUser());
        return forum;
    }

    private Category newCategory(Category previous) {
        Category category = new Category();
        if (previous == null) {
            previous = new Category();
        }
        category.setCategoryName(this.randomWords(10));
        category.setCategoryOrder(previous.getCategoryOrder() + 1L);
        category.setCreatedDate(new Date());
        category.setDescription(this.randomWords(10));
        category.setModifiedBy(this.randomUser());
        category.setModifiedDate(new Date());
        category.setOwner(this.randomUser());
        return category;
    }

    public List<Forum> findForumsByCategory(String categoryId) {
        ArrayList<Forum> result = new ArrayList<Forum>();
        try {
            Forum previous = null;
            int forumCount = this.getMaxItem(this.maxForums);
            for (int i = 0; i < forumCount; ++i) {
                Forum forum = this.newForum(previous);
                result.add(forum);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public List<Topic> findTopicsByForum(Forum forum) {
        ArrayList<Topic> result = new ArrayList<Topic>();
        try {
            Topic previous = null;
            int topicCount = this.getMaxItem(this.maxTopics);
            for (int i = 0; i < topicCount; ++i) {
                Topic topic = this.newTopic(previous);
                result.add(topic);
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private int getMaxItem(int type) {
        return this.randomize ? this.rand.nextInt(type) + 1 : type;
    }

    private Topic newTopic(Topic previous) {
        if (previous == null) {
            previous = new Topic();
        }
        Topic topic = new Topic();
        topic.setCreatedDate(new Date());
        topic.setDescription(this.randomWords(10));
        topic.setOwner(this.randomUser());
        topic.setTopicName(this.randomWords(5));
        topic.setIcon(ForumDataRandom.getClassIcon());
        return topic;
    }

    public List<Post> fingPostsByTopic(Topic topic) {
        ArrayList<Post> result = new ArrayList<Post>();
        try {
            Post previous = null;
            int postCount = this.getMaxItem(this.maxPosts);
            for (int i = 0; i < postCount; ++i) {
                Post post = this.newPost(previous);
                result.add(post);
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Post newPost(Post previous) {
        if (previous == null) {
            previous = new Post();
        }
        Post post = new Post();
        post.setName(this.randomWords(10));
        String content = this.randomParagraphs(5);
        post.setMessage(content);
        post.setOwner(this.randomUser());
        post.setIcon(ForumDataRandom.getClassIcon());
        return post;
    }
}

