/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.jcr.Node;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.ks.common.jcr.KSDataLocation;
import org.exoplatform.ks.common.jcr.SessionManager;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForumServiceUtils {
    private static final String ANY = "*".intern();
    private static final String COLON = ":".intern();
    private static final String SLASH = "/".intern();

    public static boolean hasPermission(String[] userGroupMembership, String userId) throws Exception {
        IdentityRegistry identityRegistry = (IdentityRegistry)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(IdentityRegistry.class);
        Identity identity = identityRegistry.getIdentity(userId);
        if (identity == null) {
            OrganizationService oService = (OrganizationService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(OrganizationService.class);
            Collection memberships = oService.getMembershipHandler().findMembershipsByUser(userId);
            identity = new Identity(userId, memberships);
        }
        if (userGroupMembership == null || userGroupMembership.length <= 0 || userGroupMembership[0].equals(" ")) {
            return false;
        }
        for (String item : userGroupMembership) {
            String username;
            String group;
            String membershipType;
            String[] array;
            String group2;
            String expr = item.trim();
            if (!(ForumServiceUtils.isMembershipExpression(expr) ? identity.isMemberOf(group2 = (array = expr.split(COLON))[1], membershipType = array[0]) : (ForumServiceUtils.isGroupExpression(expr) ? identity.isMemberOf(group = expr) : (username = expr).equals(userId)))) continue;
            return true;
        }
        return false;
    }

    public static boolean isGroupExpression(String expr) {
        return expr.indexOf(SLASH) >= 0 && expr.indexOf(COLON) < 0;
    }

    public static boolean isMembershipExpression(String expr) {
        return expr.indexOf(SLASH) >= 0 && expr.indexOf(COLON) >= 0;
    }

    private static ListAccess<User> getUserByGroup(UserHandler userHandler, String group) {
        try {
            return userHandler.findUsersByGroupId(group);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static List<String> getUserByMembershipType(OrganizationService organizationService, String memberShip) throws Exception {
        List<String> users = ForumServiceUtils.getFromCache(new String[]{memberShip});
        if (users != null) {
            return users;
        }
        users = new ArrayList<String>();
        String[] array = memberShip.trim().split(COLON);
        UserHandler userHandler = organizationService.getUserHandler();
        if (array[0].length() > 1) {
            List<String> usersOfGroup = ForumServiceUtils.getUserByGroupId(userHandler, array[1]);
            MembershipHandler membershipHandler = organizationService.getMembershipHandler();
            for (String userName : usersOfGroup) {
                if (membershipHandler.findMembershipByUserGroupAndType(userName, array[1], array[0]) == null) continue;
                users.add(userName);
            }
        } else if (ANY.equals(array[0])) {
            users.addAll(ForumServiceUtils.getUserByGroupId(userHandler, array[1]));
        }
        ForumServiceUtils.storeInCache(new String[]{memberShip}, users);
        return users;
    }

    private static List<String> getUserByGroupId(UserHandler userHandler, String groupId) throws Exception {
        List<String> users = ForumServiceUtils.getFromCache(new String[]{groupId});
        if (users != null) {
            return users;
        }
        users = new ArrayList<String>();
        ListAccess<User> pageList = ForumServiceUtils.getUserByGroup(userHandler, groupId);
        if (pageList == null) {
            return users;
        }
        User[] userArray = (User[])pageList.load(0, pageList.getSize());
        for (int i = 0; i < pageList.getSize(); ++i) {
            users.add(userArray[i].getUserName());
        }
        ForumServiceUtils.storeInCache(new String[]{groupId}, users);
        return users;
    }

    public static List<String> getUserPermission(String[] userGroupMembership) throws Exception {
        if (userGroupMembership == null || userGroupMembership.length <= 0 || userGroupMembership.length == 1 && userGroupMembership[0].equals(" ")) {
            return new ArrayList<String>();
        }
        List<String> list = ForumServiceUtils.getFromCache(userGroupMembership);
        if (list != null) {
            return list;
        }
        OrganizationService organizationService = (OrganizationService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(OrganizationService.class);
        HashSet<String> users = new HashSet<String>();
        for (int j = 0; j < userGroupMembership.length; ++j) {
            String str = userGroupMembership[j].trim();
            if (ForumServiceUtils.isMembershipExpression(str)) {
                users.addAll(ForumServiceUtils.getUserByMembershipType(organizationService, str));
                continue;
            }
            if (ForumServiceUtils.isGroupExpression(str)) {
                users.addAll(ForumServiceUtils.getUserByGroupId(organizationService.getUserHandler(), str));
                continue;
            }
            users.add(str);
        }
        ForumServiceUtils.storeInCache(userGroupMembership, new ArrayList<String>(users));
        return new ArrayList<String>(users);
    }

    private static void storeInCache(String[] userGroupMembership, List<String> users) throws Exception {
        ExoCache<Serializable, List<String>> cache = ForumServiceUtils.getCache();
        Serializable cacheKey = ForumServiceUtils.getCacheKey(userGroupMembership);
        cache.put(cacheKey, users);
    }

    private static List<String> getFromCache(String[] userGroupMembership) {
        ExoCache<Serializable, List<String>> cache = ForumServiceUtils.getCache();
        Serializable cacheKey = ForumServiceUtils.getCacheKey(userGroupMembership);
        return (List)cache.get(cacheKey);
    }

    private static Serializable getCacheKey(String[] userGroupMembership) {
        StringBuilder sb = new StringBuilder();
        for (String item : userGroupMembership) {
            sb.append("#").append(item);
        }
        return sb.toString();
    }

    private static ExoCache<Serializable, List<String>> getCache() {
        CacheService cacheService = (CacheService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(CacheService.class);
        return cacheService.getCacheInstance("org.exoplatform.forum.ForumPermissionsUsers");
    }

    public static void reparePermissions(Node node, String owner) throws Exception {
        ExtendedNode extNode = (ExtendedNode)node;
        if (extNode.canAddMixin("exo:privilegeable")) {
            extNode.addMixin("exo:privilegeable");
        }
        String[] arrayPers = new String[]{"read", "add_node", "set_property", "remove"};
        extNode.setPermission(owner, arrayPers);
        List permsList = extNode.getACL().getPermissionEntries();
        for (AccessControlEntry accessControlEntry : permsList) {
            extNode.setPermission(accessControlEntry.getIdentity(), arrayPers);
        }
    }

    public static SessionManager getSessionManager() {
        KSDataLocation location = (KSDataLocation)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(KSDataLocation.class);
        return location.getSessionManager();
    }
}

