/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.forum.ForumSessionUtils;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.ForumStatistic;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/templates/forum/webui/UICategoryInfo.gtmpl")
public class UICategoryInfo
extends UIContainer {
    private ForumService forumService = (ForumService)PortalContainer.getInstance().getComponentInstanceOfType(ForumService.class);
    private long mostUserOnline_ = 0L;

    private List<String> getUserOnline() throws Exception {
        List list = this.forumService.getOnlineUsers();
        this.mostUserOnline_ = list.size();
        return list;
    }

    public Calendar getInstanceTempCalendar() {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setLenient(false);
        int gmtoffset = calendar.get(16) + calendar.get(15);
        calendar.setTimeInMillis(System.currentTimeMillis() + (long)gmtoffset);
        return calendar;
    }

    public ForumStatistic getForumStatistic() throws Exception {
        ForumStatistic forumStatistic = this.forumService.getForumStatistic(ForumSessionUtils.getSystemProvider());
        boolean isSave = false;
        long mumberUserOnline = 0L;
        String mostUserOnlines = forumStatistic.getMostUsersOnline();
        Date date = this.getInstanceTempCalendar().getTime();
        if (!ForumUtils.isEmpty((String)mostUserOnlines)) {
            mumberUserOnline = Long.parseLong(mostUserOnlines.split(",")[0]);
            if (this.mostUserOnline_ > mumberUserOnline) {
                mostUserOnlines = this.mostUserOnline_ + ", at " + ForumUtils.getFormatDate((String)"MM-dd-yyyy, hh:mm a", (Date)date) + " GMT+0";
                forumStatistic.setMostUsersOnline(mostUserOnlines);
                isSave = true;
            }
        } else {
            mostUserOnlines = this.mostUserOnline_ + ", at " + ForumUtils.getFormatDate((String)"MM-dd-yyyy, hh:mm a", (Date)date) + " GMT+0";
            forumStatistic.setMostUsersOnline(mostUserOnlines);
            isSave = true;
        }
        if (isSave) {
            this.forumService.saveForumStatistic(ForumSessionUtils.getSystemProvider(), forumStatistic);
        }
        return forumStatistic;
    }
}

