/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui;

import org.exoplatform.container.PortalContainer;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIContainer;

@ComponentConfig(template="app:/templates/forum/webui/UIForumDescription.gtmpl")
public class UIForumDescription
extends UIContainer {
    private String forumId;
    private String categoryId;
    private Forum forum = null;
    private boolean isForum = false;

    public void setForum(Forum forum) {
        this.forum = forum;
        this.isForum = false;
    }

    public void setForumIds(String categoryId, String forumId) {
        this.isForum = true;
        this.forumId = forumId;
        this.categoryId = categoryId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Forum getForum() throws Exception {
        if (this.forum == null || this.isForum) {
            ForumService forumService = (ForumService)PortalContainer.getInstance().getComponentInstanceOfType(ForumService.class);
            SessionProvider sProvider = SessionProviderFactory.createSystemProvider();
            try {
                Forum forum = forumService.getForum(sProvider, this.categoryId, this.forumId);
                return forum;
            }
            catch (Exception e) {
                e.printStackTrace();
                Forum forum = null;
                return forum;
            }
            finally {
                sProvider.close();
            }
        }
        return this.forum;
    }
}

