/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui;

import java.util.Date;
import javax.portlet.PortletPreferences;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.forum.ForumSessionUtils;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.webui.UIBreadcumbs;
import org.exoplatform.forum.webui.UICategoryContainer;
import org.exoplatform.forum.webui.UIForumContainer;
import org.exoplatform.forum.webui.UIForumLinks;
import org.exoplatform.forum.webui.UISearchForm;
import org.exoplatform.forum.webui.UITopicsTag;
import org.exoplatform.forum.webui.popup.UIPopupAction;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupMessages;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;

@ComponentConfig(lifecycle=UIApplicationLifecycle.class, template="app:/templates/forum/webui/UIForumPortlet.gtmpl")
public class UIForumPortlet
extends UIPortletApplication {
    private boolean isCategoryRendered = true;
    private boolean isForumRendered = false;
    private boolean isTagRendered = false;
    private boolean isSearchRendered = false;
    private boolean isJumpRendered = false;
    private UserProfile userProfile = null;
    private boolean enableIPLogging = false;

    public UIForumPortlet() throws Exception {
        this.addChild(UIBreadcumbs.class, null, null);
        ((UICategoryContainer)this.addChild(UICategoryContainer.class, null, null)).setRendered(this.isCategoryRendered);
        ((UIForumContainer)this.addChild(UIForumContainer.class, null, null)).setRendered(this.isForumRendered);
        ((UITopicsTag)this.addChild(UITopicsTag.class, null, null)).setRendered(this.isTagRendered);
        ((UISearchForm)this.addChild(UISearchForm.class, null, null)).setRendered(this.isSearchRendered);
        ((UIForumLinks)this.addChild(UIForumLinks.class, null, null)).setRendered(this.isJumpRendered);
        this.addChild(UIPopupAction.class, null, "UIForumPopupAction");
        this.loadPreferences();
    }

    public void updateIsRendered(String selected) throws Exception {
        if (selected == ForumUtils.CATEGORIES) {
            this.isCategoryRendered = true;
            this.isForumRendered = false;
            this.isTagRendered = false;
            this.isSearchRendered = false;
        } else if (selected == ForumUtils.FORUM) {
            this.isForumRendered = true;
            this.isCategoryRendered = false;
            this.isTagRendered = false;
            this.isSearchRendered = false;
        } else if (selected == ForumUtils.TAG) {
            this.isTagRendered = true;
            this.isForumRendered = false;
            this.isCategoryRendered = false;
            this.isSearchRendered = false;
        } else {
            this.isTagRendered = false;
            this.isForumRendered = false;
            this.isCategoryRendered = false;
            this.isSearchRendered = true;
        }
        if (this.userProfile == null) {
            this.updateUserProfileInfo();
        }
        this.isJumpRendered = this.userProfile.getIsShowForumJump();
        UICategoryContainer categoryContainer = (UICategoryContainer)((UICategoryContainer)this.getChild(UICategoryContainer.class)).setRendered(this.isCategoryRendered);
        if (this.isCategoryRendered) {
            categoryContainer.setIsRenderJump(this.isJumpRendered);
        } else {
            ((UIForumLinks)this.getChild(UIForumLinks.class)).setRendered(this.isJumpRendered);
        }
        ((UIForumContainer)this.getChild(UIForumContainer.class)).setRendered(this.isForumRendered);
        ((UITopicsTag)this.getChild(UITopicsTag.class)).setRendered(this.isTagRendered);
        ((UISearchForm)this.getChild(UISearchForm.class)).setRendered(this.isSearchRendered);
    }

    private void loadPreferences() throws Exception {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        try {
            this.enableIPLogging = Boolean.parseBoolean(portletPref.getValue("enableIPLogging", ""));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isEnableIPLogging() {
        return this.enableIPLogging;
    }

    public void renderPopupMessages() throws Exception {
        UIPopupMessages popupMess = this.getUIPopupMessages();
        if (popupMess == null) {
            return;
        }
        WebuiRequestContext context = (WebuiRequestContext)RequestContext.getCurrentInstance();
        popupMess.processRender(context);
    }

    public void cancelAction() throws Exception {
        WebuiRequestContext context = (WebuiRequestContext)RequestContext.getCurrentInstance();
        UIPopupAction popupAction = (UIPopupAction)this.getChild(UIPopupAction.class);
        popupAction.deActivate();
        context.addUIComponentToUpdateByAjax((UIComponent)popupAction);
    }

    public UserProfile getUserProfile() throws Exception {
        if (this.userProfile == null) {
            this.updateUserProfileInfo();
        }
        return this.userProfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateUserProfileInfo() throws Exception {
        String userId = "";
        try {
            userId = ForumSessionUtils.getCurrentUser();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Date date = null;
        if (this.userProfile != null) {
            date = this.userProfile.getLastLoginDate();
        }
        SessionProvider sProvider = ForumSessionUtils.getSystemProvider();
        try {
            ForumService forumService = (ForumService)PortalContainer.getInstance().getComponentInstanceOfType(ForumService.class);
            this.userProfile = forumService.getDefaultUserProfile(sProvider, userId);
        }
        finally {
            sProvider.close();
        }
        this.userProfile.setIsOnline(true);
        if (date != null) {
            this.userProfile.setLastLoginDate(date);
        }
    }
}

