/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.forum.ForumSessionUtils;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.ForumServiceUtils;
import org.exoplatform.forum.service.Tag;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.webui.UIBreadcumbs;
import org.exoplatform.forum.webui.UIForumContainer;
import org.exoplatform.forum.webui.UIForumInfos;
import org.exoplatform.forum.webui.UIForumKeepStickPageIterator;
import org.exoplatform.forum.webui.UIForumPortlet;
import org.exoplatform.forum.webui.UITopicContainer;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/UITopicContainer.gtmpl", events={@EventConfig(listeners={SearchFormActionListener.class}), @EventConfig(listeners={GoNumberPageActionListener.class}), @EventConfig(listeners={AddTopicActionListener.class}), @EventConfig(listeners={OpenTopicActionListener.class}), @EventConfig(listeners={OpenTopicsTagActionListener.class}), @EventConfig(listeners={ApproveTopicsActionListener.class}), @EventConfig(listeners={EditForumActionListener.class}), @EventConfig(listeners={SetLockedForumActionListener.class}), @EventConfig(listeners={SetUnLockForumActionListener.class}), @EventConfig(listeners={SetOpenForumActionListener.class}), @EventConfig(listeners={SetCloseForumActionListener.class}), @EventConfig(listeners={MoveForumActionListener.class}), @EventConfig(listeners={RemoveForumActionListener.class}, confirm="UITopicContainer.confirm.RemoveForum"), @EventConfig(listeners={WatchOptionActionListener.class}), @EventConfig(listeners={EditTopicActionListener.class}), @EventConfig(listeners={SetOpenTopicActionListener.class}), @EventConfig(listeners={SetCloseTopicActionListener.class}), @EventConfig(listeners={SetLockedTopicActionListener.class}), @EventConfig(listeners={SetUnLockTopicActionListener.class}), @EventConfig(listeners={SetStickTopicActionListener.class}), @EventConfig(listeners={SetUnStickTopicActionListener.class}), @EventConfig(listeners={SetMoveTopicActionListener.class}), @EventConfig(listeners={MergeTopicActionListener.class}), @EventConfig(listeners={SetDeleteTopicActionListener.class}), @EventConfig(listeners={SetUnWaitingActionListener.class}), @EventConfig(listeners={SetOrderByActionListener.class}), @EventConfig(listeners={AddWatchingActionListener.class}), @EventConfig(listeners={AddBookMarkActionListener.class}), @EventConfig(listeners={ExportForumActionListener.class}), @EventConfig(listeners={UIForumKeepStickPageIterator.GoPageActionListener.class}), @EventConfig(listeners={AdvancedSearchActionListener.class})})
public class UITopicContainer
extends UIForumKeepStickPageIterator {
    private ForumService forumService = (ForumService)PortalContainer.getInstance().getComponentInstanceOfType(ForumService.class);
    private String forumId = "";
    private String categoryId = "";
    private Forum forum;
    private List<Topic> topicList;
    private boolean isUpdate = false;
    private boolean isModerator = false;
    private boolean canAddNewThread = true;
    private UserProfile userProfile = null;
    private String strOrderBy = "";
    private boolean isLogin = false;
    private boolean isNull = false;

    public boolean isNull() {
        return this.isNull;
    }

    public void setNull(boolean isNull) {
        this.isNull = isNull;
    }

    public boolean isLogin() {
        return this.isLogin;
    }

    public void setLogin(boolean isLogin) {
        this.isLogin = isLogin;
    }

    public UITopicContainer() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormStringInput(ForumUtils.GOPAGE_ID_T, null));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(ForumUtils.GOPAGE_ID_B, null));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(ForumUtils.SEARCHFORM_ID, null));
        if (ForumSessionUtils.getCurrentUser() != null) {
            this.isLogin = true;
        }
    }

    private UserProfile getUserProfile() {
        return this.userProfile;
    }

    public void setUpdateForum(String categoryId, Forum forum) throws Exception {
        this.forum = forum;
        this.forumId = forum.getId();
        this.categoryId = categoryId;
        this.pageSelect = 1L;
        UIForumPortlet forumPortlet = (UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class);
        this.userProfile = forumPortlet.getUserProfile();
        ((UIBreadcumbs)forumPortlet.getChild(UIBreadcumbs.class)).setUpdataPath(categoryId + "/" + this.forumId);
        this.cleanCheckedList();
    }

    public void setIdUpdate(boolean isUpdate) {
        this.isUpdate = isUpdate;
    }

    public void updateByBreadcumbs(String categoryId, String forumId, boolean isBreadcumbs) throws Exception {
        this.forumId = forumId;
        this.categoryId = categoryId;
        this.isUpdate = true;
        this.pageSelect = 1L;
        UIForumPortlet forumPortlet = (UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class);
        this.userProfile = forumPortlet.getUserProfile();
        if (!isBreadcumbs) {
            ((UIBreadcumbs)forumPortlet.getChild(UIBreadcumbs.class)).setUpdataPath(categoryId + "/" + forumId);
        }
        this.cleanCheckedList();
    }

    public boolean getCanAddNewThread() {
        return this.canAddNewThread;
    }

    private Forum getForum() throws Exception {
        if (this.isUpdate) {
            this.forum = this.forumService.getForum(ForumSessionUtils.getSystemProvider(), this.categoryId, this.forumId);
            this.isUpdate = false;
        }
        UIForumContainer forumContainer = (UIForumContainer)this.getParent();
        if (this.forum != null) {
            ((UIForumInfos)forumContainer.findFirstComponentOfType(UIForumInfos.class)).setForum(this.forum);
        }
        return this.forum;
    }

    private void initPage() throws Exception {
        this.canAddNewThread = true;
        if (this.userProfile == null) {
            this.userProfile = new UserProfile();
        }
        StringBuffer strQuery = new StringBuffer();
        long role = this.userProfile.getUserRole();
        String userId = this.userProfile.getUserId();
        String[] strings = this.forum.getCreateTopicRole();
        if (strings != null && strings.length > 0) {
            this.canAddNewThread = ForumServiceUtils.hasPermission((String[])strings, (String)userId);
        }
        this.isModerator = false;
        if (role == 0L || ForumServiceUtils.hasPermission((String[])this.forum.getModerators(), (String)userId)) {
            this.isModerator = true;
        } else {
            strQuery.append("@exo:isClosed='false' and @exo:isWaiting='false'");
            boolean isView = ForumServiceUtils.hasPermission((String[])this.forum.getPoster(), (String)userId);
            if (!isView) {
                isView = ForumServiceUtils.hasPermission((String[])this.forum.getViewer(), (String)userId);
            }
            if (!isView) {
                strQuery.append(" and (@exo:owner='").append(userId).append("' or @exo:canView=' ' or @exo:canPost=' '");
                for (String string : ForumSessionUtils.getAllGroupAndMembershipOfUser((String)userId)) {
                    strQuery.append(" or @exo:canView='" + string + "' or @exo:canPost='" + string + "'");
                }
                strQuery.append(")");
            }
        }
        if (!this.isModerator && this.forum.getIsModerateTopic()) {
            if (!ForumUtils.isEmpty((String)strQuery.toString())) {
                strQuery.append(" and ");
            }
            strQuery.append("@exo:isApproved='true'");
        }
        this.pageList = this.forumService.getPageTopic(ForumSessionUtils.getSystemProvider(), this.categoryId, this.forumId, strQuery.toString(), this.strOrderBy);
        long maxTopic = this.userProfile.getMaxTopicInPage();
        if (maxTopic <= 0L) {
            maxTopic = 10L;
        }
        try {
            this.pageList.setPageSize(maxTopic);
        }
        catch (NullPointerException e) {
            this.isNull = true;
        }
    }

    private String[] getActionMenuForum() throws Exception {
        String[] actions = new String[]{"EditForum", "SetUnLockForum", "SetLockedForum", "SetOpenForum", "SetCloseForum", "MoveForum", "RemoveForum", "ExportForum", "WatchOption"};
        return actions;
    }

    private String[] getActionMenuTopic() throws Exception {
        String[] actions = new String[]{"EditTopic", "SetOpenTopic", "SetCloseTopic", "SetLockedTopic", "SetUnLockTopic", "SetStickTopic", "SetUnStickTopic", "SetMoveTopic", "SetDeleteTopic", "MergeTopic", "SetUnWaiting", "ApproveTopics"};
        return actions;
    }

    private List<Topic> getTopicPageLits() throws Exception {
        this.maxPage = this.pageList.getAvailablePage();
        if (this.pageSelect > this.maxPage) {
            this.pageSelect = this.maxPage;
        }
        ArrayList topics = this.pageList.getPage(this.pageSelect);
        this.pageSelect = this.pageList.getCurrentPage();
        if (topics == null) {
            topics = new ArrayList();
        }
        this.topicList = topics;
        for (Topic topic : this.topicList) {
            if (this.getUIFormCheckBoxInput(topic.getId()) != null) {
                this.getUIFormCheckBoxInput(topic.getId()).setChecked(false);
                continue;
            }
            UIFormCheckBoxInput checkItem = new UIFormCheckBoxInput(topic.getId(), topic.getId(), (Object)false);
            this.addChild((UIComponent)checkItem);
        }
        return this.topicList;
    }

    private Topic getTopicByAll(String topicId) throws Exception {
        List listTopic = this.pageList.getPage(0L);
        for (Topic topic : listTopic) {
            if (!topic.getId().equals(topicId)) continue;
            return topic;
        }
        return null;
    }

    private Topic getTopic(String topicId) throws Exception {
        for (Topic topic : this.topicList) {
            if (!topic.getId().equals(topicId)) continue;
            return topic;
        }
        return null;
    }

    private long getSizePost(Topic topic) throws Exception {
        long maxPost = this.userProfile.getMaxPostInPage();
        if (maxPost <= 0L) {
            maxPost = 10L;
        }
        if (topic.getPostCount() > maxPost) {
            long availablePost = 0L;
            if (this.isModerator) {
                availablePost = topic.getPostCount() + 1L;
            } else {
                String isApprove = "";
                String userLogin = this.userProfile.getUserId();
                if ((this.forum.getIsModeratePost() || topic.getIsModeratePost()) && !topic.getOwner().equals(userLogin)) {
                    isApprove = "true";
                }
                availablePost = this.forumService.getAvailablePost(ForumSessionUtils.getSystemProvider(), this.categoryId, this.forumId, topic.getId(), isApprove, "false", userLogin);
            }
            long value = availablePost / maxPost;
            if (value * maxPost < availablePost) {
                ++value;
            }
            return value;
        }
        return 1L;
    }

    private String[] getStarNumber(Topic topic) throws Exception {
        double voteRating = topic.getVoteRating();
        return ForumUtils.getStarNumber((double)voteRating);
    }

    private List<Tag> getTagsByTopic(String[] tagIds) throws Exception {
        return this.forumService.getTagsByTopic(ForumSessionUtils.getSystemProvider(), tagIds);
    }

    static /* synthetic */ Forum access$000(UITopicContainer x0) {
        return x0.forum;
    }

    static /* synthetic */ boolean access$100(UITopicContainer x0) {
        return x0.isModerator;
    }

    static /* synthetic */ UserProfile access$200(UITopicContainer x0) {
        return x0.getUserProfile();
    }

    static /* synthetic */ String access$300(UITopicContainer x0) {
        return x0.categoryId;
    }

    static /* synthetic */ String access$400(UITopicContainer x0) {
        return x0.forumId;
    }

    static /* synthetic */ Topic access$500(UITopicContainer x0, String x1) throws Exception {
        return x0.getTopic(x1);
    }

    static /* synthetic */ Forum access$600(UITopicContainer x0) throws Exception {
        return x0.getForum();
    }

    static /* synthetic */ UserProfile access$700(UITopicContainer x0) {
        return x0.userProfile;
    }

    static /* synthetic */ boolean access$802(UITopicContainer x0, boolean x1) {
        x0.isUpdate = x1;
        return x0.isUpdate;
    }

    static /* synthetic */ ForumService access$900(UITopicContainer x0) {
        return x0.forumService;
    }

    static /* synthetic */ Topic access$1000(UITopicContainer x0, String x1) throws Exception {
        return x0.getTopicByAll(x1);
    }

    static /* synthetic */ String access$1100(UITopicContainer x0) {
        return x0.strOrderBy;
    }

    static /* synthetic */ String access$1102(UITopicContainer x0, String x1) {
        x0.strOrderBy = x1;
        return x0.strOrderBy;
    }
}

