/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui.popup;

import java.util.ArrayList;
import org.exoplatform.forum.ForumTransformHTML;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.webui.popup.UICategoryForm;
import org.exoplatform.forum.webui.popup.UIPopupComponent;
import org.exoplatform.forum.webui.popup.UISelector;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormInputWithActions;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.PositiveNumberFormatValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/popup/UIFormForum.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={AddPrivateActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UICategoryForm
extends UIForm
implements UIPopupComponent,
UISelector {
    private String categoryId = "";
    public static final String CATEGORY_FORM = "category";
    public static final String FIELD_CATEGORYTITLE_INPUT = "CategoryTitle";
    public static final String FIELD_CATEGORYORDER_INPUT = "CategoryOrder";
    public static final String FIELD_DESCRIPTION_INPUT = "Description";
    public static final String FIELD_USERPRIVATE_MULTIVALUE = "UserPrivate";

    public UICategoryForm() throws Exception {
        UIFormStringInput categoryTitle = new UIFormStringInput(FIELD_CATEGORYTITLE_INPUT, FIELD_CATEGORYTITLE_INPUT, null);
        categoryTitle.addValidator(MandatoryValidator.class, new Object[0]);
        UIFormStringInput categoryOrder = new UIFormStringInput(FIELD_CATEGORYORDER_INPUT, FIELD_CATEGORYORDER_INPUT, "0");
        categoryOrder.addValidator(PositiveNumberFormatValidator.class, new Object[0]);
        UIFormTextAreaInput description = new UIFormTextAreaInput(FIELD_DESCRIPTION_INPUT, FIELD_DESCRIPTION_INPUT, null);
        UIFormTextAreaInput userPrivate = new UIFormTextAreaInput(FIELD_USERPRIVATE_MULTIVALUE, FIELD_USERPRIVATE_MULTIVALUE, null);
        UIFormInputWithActions uicategory = new UIFormInputWithActions(CATEGORY_FORM);
        uicategory.addUIFormInput((UIFormInput)categoryTitle);
        uicategory.addUIFormInput((UIFormInput)categoryOrder);
        uicategory.addUIFormInput((UIFormInput)userPrivate);
        uicategory.addUIFormInput((UIFormInput)description);
        String[] strings = new String[]{"SelectUser", "SelectMemberShip", "SelectGroup"};
        ArrayList<UIFormInputWithActions.ActionData> actions = new ArrayList<UIFormInputWithActions.ActionData>();
        int i = 0;
        for (String string : strings) {
            UIFormInputWithActions.ActionData ad = new UIFormInputWithActions.ActionData();
            ad.setActionListener("AddPrivate");
            ad.setActionParameter(String.valueOf(i));
            ad.setCssIconClass(string + "Icon");
            ad.setActionName(string);
            actions.add(ad);
            ++i;
        }
        uicategory.setActionField(FIELD_USERPRIVATE_MULTIVALUE, actions);
        this.addUIFormInput((UIFormInputSet)uicategory);
        this.setActions(new String[]{"Save", "Cancel"});
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public void setCategoryValue(Category category, boolean isUpdate) throws Exception {
        if (isUpdate) {
            this.categoryId = category.getId();
            this.getUIStringInput(FIELD_CATEGORYTITLE_INPUT).setValue((Object)ForumTransformHTML.unCodeHTML((String)category.getCategoryName()));
            this.getUIStringInput(FIELD_CATEGORYORDER_INPUT).setValue((Object)Long.toString(category.getCategoryOrder()));
            this.getUIFormTextAreaInput(FIELD_DESCRIPTION_INPUT).setDefaultValue((Object)ForumTransformHTML.unCodeHTML((String)category.getDescription()));
            String userPrivate = ForumUtils.unSplitForForum((String[])category.getUserPrivate());
            this.getUIFormTextAreaInput(FIELD_USERPRIVATE_MULTIVALUE).setValue((Object)userPrivate);
        }
    }

    public void updateSelect(String selectField, String value) throws Exception {
        UIFormStringInput fieldInput = this.getUIStringInput(selectField);
        String values = (String)fieldInput.getValue();
        if (!ForumUtils.isEmpty((String)values)) {
            if (!ForumUtils.isStringInStrings((String[])(values = ForumUtils.removeSpaceInString((String)values)).split(","), (String)value)) {
                if (values.lastIndexOf(",") != values.length() - 1) {
                    values = values + ",";
                }
                values = values + value;
            }
        } else {
            values = value;
        }
        fieldInput.setValue((Object)values);
    }

    static /* synthetic */ String access$000(UICategoryForm x0) {
        return x0.categoryId;
    }
}

