/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui.popup;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.JCRPageList;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.webui.UIForumPageIterator;
import org.exoplatform.forum.webui.UIForumPortlet;
import org.exoplatform.forum.webui.popup.UIPageListTopicByUser;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/templates/forum/webui/popup/UIPageListTopicByUser.gtmpl", events={@EventConfig(listeners={OpenTopicActionListener.class}), @EventConfig(listeners={SetOrderByActionListener.class}), @EventConfig(listeners={DeleteTopicActionListener.class}, confirm="UITopicDetail.confirm.DeleteThisTopic")})
public class UIPageListTopicByUser
extends UIContainer {
    private ForumService forumService;
    private UserProfile userProfile;
    private JCRPageList pageList;
    private String strOrderBy = "";
    private String userName = new String();

    public UIPageListTopicByUser() throws Exception {
        this.forumService = (ForumService)PortalContainer.getInstance().getComponentInstanceOfType(ForumService.class);
        this.addChild(UIForumPageIterator.class, null, "PageListTopicByUser");
    }

    private UserProfile getUserProfile() throws Exception {
        this.userProfile = ((UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class)).getUserProfile();
        return this.userProfile;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Topic> getTopicsByUser() throws Exception {
        UIForumPageIterator forumPageIterator = (UIForumPageIterator)this.getChild(UIForumPageIterator.class);
        ArrayList<Topic> topics = new ArrayList();
        SessionProvider sProvider = SessionProviderFactory.createSystemProvider();
        try {
            boolean isMod = false;
            if (this.userProfile.getUserRole() == 0L) {
                isMod = true;
            }
            this.pageList = this.forumService.getPageTopicByUser(sProvider, this.userName, isMod, this.strOrderBy);
            forumPageIterator.updatePageList(this.pageList);
            if (this.pageList != null) {
                this.pageList.setPageSize(6L);
            }
            topics = this.pageList.getPage(forumPageIterator.getPageSelected());
            forumPageIterator.setSelectPage(this.pageList.getCurrentPage());
        }
        finally {
            sProvider.close();
        }
        return topics;
    }

    public Topic getTopicById(String topicId) throws Exception {
        List topics = this.pageList.getPage(0L);
        for (Topic topic : topics) {
            if (!topic.getId().equals(topicId)) continue;
            return topic;
        }
        return null;
    }

    private String[] getStarNumber(Topic topic) throws Exception {
        double voteRating = topic.getVoteRating();
        return ForumUtils.getStarNumber((double)voteRating);
    }

    static /* synthetic */ ForumService access$000(UIPageListTopicByUser x0) {
        return x0.forumService;
    }

    static /* synthetic */ UserProfile access$100(UIPageListTopicByUser x0) {
        return x0.userProfile;
    }

    static /* synthetic */ String access$200(UIPageListTopicByUser x0) {
        return x0.strOrderBy;
    }

    static /* synthetic */ String access$202(UIPageListTopicByUser x0, String x1) {
        x0.strOrderBy = x1;
        return x0.strOrderBy;
    }
}

