/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.forum.ForumSessionUtils;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.webui.UIBreadcumbs;
import org.exoplatform.forum.webui.UICategoryContainer;
import org.exoplatform.forum.webui.UIForumContainer;
import org.exoplatform.forum.webui.UIForumLinks;
import org.exoplatform.forum.webui.UISearchForm;
import org.exoplatform.forum.webui.UITopicsTag;
import org.exoplatform.forum.webui.popup.UIPopupAction;
import org.exoplatform.forum.webui.popup.UISettingEditModeForm;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.PortletRequestImp;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupMessages;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIApplicationLifecycle.class, template="app:/templates/forum/webui/UIForumPortlet.gtmpl")
public class UIForumPortlet
extends UIPortletApplication {
    private ForumService forumService;
    private boolean isCategoryRendered = true;
    private boolean isForumRendered = false;
    private boolean isTagRendered = false;
    private boolean isSearchRendered = false;
    private boolean isJumpRendered = false;
    private UserProfile userProfile = null;
    private boolean enableIPLogging = false;
    private boolean enableBanIP = false;
    private boolean useAjax = true;
    private int dayForumNewPost = 0;
    private List<String> invisibleForums = new ArrayList();
    private List<String> invisibleCategories = new ArrayList();

    public UIForumPortlet() throws Exception {
        this.forumService = (ForumService)PortalContainer.getInstance().getComponentInstanceOfType(ForumService.class);
        this.addChild(UIBreadcumbs.class, null, null);
        ((UICategoryContainer)this.addChild(UICategoryContainer.class, null, null)).setRendered(this.isCategoryRendered);
        ((UIForumContainer)this.addChild(UIForumContainer.class, null, null)).setRendered(this.isForumRendered);
        ((UITopicsTag)this.addChild(UITopicsTag.class, null, null)).setRendered(this.isTagRendered);
        ((UISearchForm)this.addChild(UISearchForm.class, null, null)).setRendered(this.isSearchRendered);
        ((UIForumLinks)this.addChild(UIForumLinks.class, null, null)).setRendered(this.isJumpRendered);
        this.addChild(UIPopupAction.class, null, "UIForumPopupAction");
        this.loadPreferences();
    }

    public void processRender(WebuiApplication app, WebuiRequestContext context) throws Exception {
        PortletRequestContext portletReqContext = (PortletRequestContext)context;
        if (portletReqContext.getApplicationMode() == PortletMode.VIEW) {
            if (this.getChild(UIBreadcumbs.class) == null) {
                if (this.getChild(UISettingEditModeForm.class) != null) {
                    this.removeChild(UISettingEditModeForm.class);
                }
                this.addChild(UIBreadcumbs.class, null, null);
                ((UICategoryContainer)this.addChild(UICategoryContainer.class, null, null)).setRendered(this.isCategoryRendered);
                ((UIForumContainer)this.addChild(UIForumContainer.class, null, null)).setRendered(this.isForumRendered);
                ((UITopicsTag)this.addChild(UITopicsTag.class, null, null)).setRendered(this.isTagRendered);
                ((UISearchForm)this.addChild(UISearchForm.class, null, null)).setRendered(this.isSearchRendered);
                ((UIForumLinks)this.addChild(UIForumLinks.class, null, null)).setRendered(this.isJumpRendered);
            }
        } else if (portletReqContext.getApplicationMode() == PortletMode.EDIT && this.getChild(UISettingEditModeForm.class) == null) {
            UISettingEditModeForm editModeForm = (UISettingEditModeForm)this.addChild(UISettingEditModeForm.class, null, null);
            editModeForm.setUserProfile(this.getUserProfile());
            if (this.getChild(UIBreadcumbs.class) != null) {
                this.removeChild(UIBreadcumbs.class);
                this.removeChild(UICategoryContainer.class);
                this.removeChild(UIForumContainer.class);
                this.removeChild(UITopicsTag.class);
                this.removeChild(UISearchForm.class);
                this.removeChild(UIForumLinks.class);
            }
        }
        super.processRender(app, context);
    }

    public void updateIsRendered(String selected) throws Exception {
        if (selected == ForumUtils.CATEGORIES) {
            this.isCategoryRendered = true;
            this.isForumRendered = false;
            this.isTagRendered = false;
            this.isSearchRendered = false;
        } else if (selected == ForumUtils.FORUM) {
            this.isForumRendered = true;
            this.isCategoryRendered = false;
            this.isTagRendered = false;
            this.isSearchRendered = false;
        } else if (selected == ForumUtils.TAG) {
            this.isTagRendered = true;
            this.isForumRendered = false;
            this.isCategoryRendered = false;
            this.isSearchRendered = false;
        } else {
            this.isTagRendered = false;
            this.isForumRendered = false;
            this.isCategoryRendered = false;
            this.isSearchRendered = true;
        }
        if (this.userProfile == null) {
            this.updateUserProfileInfo();
        }
        this.isJumpRendered = this.userProfile.getIsShowForumJump();
        UICategoryContainer categoryContainer = (UICategoryContainer)((UICategoryContainer)this.getChild(UICategoryContainer.class)).setRendered(this.isCategoryRendered);
        if (this.isCategoryRendered) {
            categoryContainer.setIsRenderJump(this.isJumpRendered);
        } else {
            ((UIForumLinks)this.getChild(UIForumLinks.class)).setRendered(this.isJumpRendered);
        }
        ((UIForumContainer)this.getChild(UIForumContainer.class)).setRendered(this.isForumRendered);
        ((UITopicsTag)this.getChild(UITopicsTag.class)).setRendered(this.isTagRendered);
        ((UISearchForm)this.getChild(UISearchForm.class)).setRendered(this.isSearchRendered);
    }

    public void loadPreferences() throws Exception {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        this.invisibleCategories.clear();
        this.invisibleForums.clear();
        try {
            this.dayForumNewPost = Integer.parseInt(portletPref.getValue("forumNewPost", ""));
            this.useAjax = Boolean.parseBoolean(portletPref.getValue("useAjax", ""));
            this.enableIPLogging = Boolean.parseBoolean(portletPref.getValue("enableIPLogging", ""));
            this.enableBanIP = Boolean.parseBoolean(portletPref.getValue("enableIPFiltering", ""));
            this.invisibleCategories.addAll(this.getListInValus(portletPref.getValue("invisibleCategories", "")));
            this.invisibleForums.addAll(this.getListInValus(portletPref.getValue("invisibleForums", "")));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private List<String> getListInValus(String value) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        if (!ForumUtils.isEmpty((String)value)) {
            list.addAll(Arrays.asList(ForumUtils.addStringToString((String)value, (String)value)));
        }
        return list;
    }

    public List<String> getInvisibleForums() {
        return this.invisibleForums;
    }

    public List<String> getInvisibleCategories() {
        return this.invisibleCategories;
    }

    public boolean isEnableIPLogging() {
        return this.enableIPLogging;
    }

    public boolean isEnableBanIp() {
        return this.enableBanIP;
    }

    public boolean isUseAjax() {
        return this.useAjax;
    }

    public int getDayForumNewPost() {
        return this.dayForumNewPost;
    }

    public void renderPopupMessages() throws Exception {
        UIPopupMessages popupMess = this.getUIPopupMessages();
        if (popupMess == null) {
            return;
        }
        WebuiRequestContext context = (WebuiRequestContext)RequestContext.getCurrentInstance();
        popupMess.processRender(context);
    }

    public void cancelAction() throws Exception {
        WebuiRequestContext context = (WebuiRequestContext)RequestContext.getCurrentInstance();
        UIPopupAction popupAction = (UIPopupAction)this.getChild(UIPopupAction.class);
        popupAction.deActivate();
        context.addUIComponentToUpdateByAjax((UIComponent)popupAction);
    }

    public UserProfile getUserProfile() throws Exception {
        if (this.userProfile == null) {
            this.updateUserProfileInfo();
        }
        return this.userProfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAccessTopic(String topicId) throws Exception {
        String userId = ForumSessionUtils.getCurrentUser();
        if (userId != null && userId.length() > 0) {
            SessionProvider sProvider = ForumSessionUtils.getSystemProvider();
            try {
                this.forumService.updateTopicAccess(userId, topicId);
            }
            finally {
                sProvider.close();
            }
        }
        this.userProfile.setLastTimeAccessTopic(topicId, ForumUtils.getInstanceTempCalendar().getTimeInMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAccessForum(String forumId) throws Exception {
        String userId = ForumSessionUtils.getCurrentUser();
        if (userId != null && userId.length() > 0) {
            SessionProvider sProvider = ForumSessionUtils.getSystemProvider();
            try {
                this.forumService.updateForumAccess(userId, forumId);
            }
            finally {
                sProvider.close();
            }
        }
        this.userProfile.setLastTimeAccessForum(forumId, ForumUtils.getInstanceTempCalendar().getTimeInMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateUserProfileInfo() throws Exception {
        String userId = "";
        try {
            userId = ForumSessionUtils.getCurrentUser();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SessionProvider sProvider = ForumSessionUtils.getSystemProvider();
        try {
            ForumService forumService = (ForumService)PortalContainer.getInstance().getComponentInstanceOfType(ForumService.class);
            if (this.enableBanIP) {
                WebuiRequestContext context = (WebuiRequestContext)RequestContext.getCurrentInstance();
                PortletRequestImp request = (PortletRequestImp)context.getRequest();
                this.userProfile = forumService.getDefaultUserProfile(sProvider, userId, request.getRemoteAddr());
            } else {
                this.userProfile = forumService.getDefaultUserProfile(sProvider, userId, null);
            }
            if (!ForumUtils.isEmpty((String)userId)) {
                this.userProfile.setEmail(ForumSessionUtils.getUserByUserId((String)userId).getEmail());
            }
        }
        finally {
            sProvider.close();
        }
    }
}

