/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.forum.ForumSessionUtils;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.ForumServiceUtils;
import org.exoplatform.forum.service.Tag;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.webui.UIForumKeepStickPageIterator;
import org.exoplatform.forum.webui.UIForumPortlet;
import org.exoplatform.forum.webui.UITopicsTag;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/UITopicsTag.gtmpl", events={@EventConfig(listeners={OpenTopicActionListener.class}), @EventConfig(listeners={EditTagActionListener.class}), @EventConfig(listeners={OpenTopicsTagActionListener.class}), @EventConfig(listeners={RemoveTopicActionListener.class}), @EventConfig(listeners={RemoveTagActionListener.class}), @EventConfig(listeners={AddWatchingActionListener.class}), @EventConfig(listeners={AddBookMarkActionListener.class}), @EventConfig(listeners={SetOrderByActionListener.class}), @EventConfig(listeners={UIForumKeepStickPageIterator.GoPageActionListener.class})})
public class UITopicsTag
extends UIForumKeepStickPageIterator {
    private ForumService forumService;
    private String tagId = "";
    private Tag tag;
    private boolean isUpdateTag = true;
    private String strOrderBy = "";
    private UserProfile userProfile = null;
    private Map<String, Long> mapNumberPagePost = new HashMap();

    public UITopicsTag() throws Exception {
        this.forumService = (ForumService)PortalContainer.getInstance().getComponentInstanceOfType(ForumService.class);
    }

    public void setIdTag(String tagId) throws Exception {
        this.tagId = tagId;
        this.isUpdateTag = true;
        this.mapNumberPagePost.clear();
        this.userProfile = ((UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class)).getUserProfile();
    }

    public void setTag(Tag tag) throws Exception {
        this.tag = tag;
        this.tagId = tag.getId();
        this.isUpdateTag = false;
        this.mapNumberPagePost.clear();
        this.userProfile = ((UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class)).getUserProfile();
    }

    private UserProfile getUserProfile() {
        return this.userProfile;
    }

    private long getSizePost(String Id) throws Exception {
        if (this.mapNumberPagePost.containsKey(Id)) {
            return (Long)this.mapNumberPagePost.get(Id);
        }
        String[] Ids = Id.split("/");
        Topic topic = this.getTopic(Ids[Ids.length - 1]);
        long maxPost = this.getUserProfile().getMaxPostInPage();
        if (maxPost <= 0L) {
            maxPost = 10L;
        }
        if (topic != null && topic.getPostCount() > maxPost) {
            long availablePost;
            long value;
            String isApprove = "";
            String isHidden = "";
            String userLogin = this.userProfile.getUserId();
            long role = this.userProfile.getUserRole();
            if (role >= 2L) {
                isHidden = "false";
            }
            Forum forum = this.forumService.getForum(ForumSessionUtils.getSystemProvider(), Ids[Ids.length - 3], Ids[Ids.length - 2]);
            if (role == 1L && !ForumServiceUtils.hasPermission((String[])forum.getModerators(), (String)userLogin)) {
                isHidden = "false";
            }
            if ((forum.getIsModeratePost() || topic.getIsModeratePost()) && isHidden.equals("false") && !topic.getOwner().equals(userLogin)) {
                isApprove = "true";
            }
            if ((value = (availablePost = this.forumService.getAvailablePost(ForumSessionUtils.getSystemProvider(), Ids[Ids.length - 3], Ids[Ids.length - 2], Ids[Ids.length - 1], isApprove, isHidden, userLogin)) / maxPost) * maxPost < availablePost) {
                ++value;
            }
            this.mapNumberPagePost.put(Id, value);
            return value;
        }
        this.mapNumberPagePost.put(Id, 1L);
        return 1L;
    }

    private List<Topic> getTopicsTag() throws Exception {
        this.pageList = this.forumService.getTopicsByTag(ForumSessionUtils.getSystemProvider(), this.tagId, this.strOrderBy);
        long maxTopic = this.userProfile.getMaxTopicInPage();
        if (maxTopic <= 0L) {
            maxTopic = 10L;
        }
        this.pageList.setPageSize(maxTopic);
        this.maxPage = this.pageList.getAvailablePage();
        ArrayList<Topic> topics = this.pageList.getPage(this.pageSelect);
        this.pageSelect = this.pageList.getCurrentPage();
        if (topics == null) {
            topics = new ArrayList<Topic>();
        }
        for (Topic topic : topics) {
            if (this.getUIFormCheckBoxInput(topic.getId()) != null) {
                this.getUIFormCheckBoxInput(topic.getId()).setChecked(false);
                continue;
            }
            this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(topic.getId(), topic.getId(), (Object)false));
        }
        return topics;
    }

    private Tag getTagById() throws Exception {
        if (this.isUpdateTag) {
            SessionProvider sProvider = SessionProviderFactory.createSystemProvider();
            try {
                this.tag = this.forumService.getTag(sProvider, this.tagId);
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                sProvider.close();
            }
            this.isUpdateTag = false;
        }
        return this.tag;
    }

    private String[] getStarNumber(Topic topic) throws Exception {
        double voteRating = topic.getVoteRating();
        return ForumUtils.getStarNumber((double)voteRating);
    }

    private List<Tag> getTagsByTopic(String[] tagIds) throws Exception {
        ArrayList<Tag> tags = new ArrayList();
        SessionProvider sProvider = SessionProviderFactory.createSystemProvider();
        try {
            tags = this.forumService.getTagsByTopic(sProvider, tagIds);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            sProvider.close();
        }
        return tags;
    }

    private Topic getTopic(String topicId) throws Exception {
        List listTopic = this.pageList.getPage(0L);
        for (Topic topic : listTopic) {
            if (!topic.getId().equals(topicId)) continue;
            return topic;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Forum getForum(String categoryId, String forumId) throws Exception {
        Forum forum = null;
        SessionProvider sProvider = SessionProviderFactory.createSystemProvider();
        try {
            forum = this.forumService.getForum(sProvider, categoryId, forumId);
        }
        finally {
            sProvider.close();
        }
        return forum;
    }

    static /* synthetic */ Topic access$000(UITopicsTag x0, String x1) throws Exception {
        return x0.getTopic(x1);
    }

    static /* synthetic */ UserProfile access$100(UITopicsTag x0) {
        return x0.userProfile;
    }

    static /* synthetic */ Forum access$200(UITopicsTag x0, String x1, String x2) throws Exception {
        return x0.getForum(x1, x2);
    }

    static /* synthetic */ Tag access$300(UITopicsTag x0) {
        return x0.tag;
    }

    static /* synthetic */ String access$400(UITopicsTag x0) {
        return x0.tagId;
    }

    static /* synthetic */ ForumService access$500(UITopicsTag x0) {
        return x0.forumService;
    }

    static /* synthetic */ boolean access$602(UITopicsTag x0, boolean x1) {
        x0.isUpdateTag = x1;
        return x0.isUpdateTag;
    }

    static /* synthetic */ String access$700(UITopicsTag x0) {
        return x0.strOrderBy;
    }

    static /* synthetic */ String access$702(UITopicsTag x0, String x1) {
        x0.strOrderBy = x1;
        return x0.strOrderBy;
    }
}

