/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui;

import java.io.Writer;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.form.UIFormInputBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIFormDateTimePicker
extends UIFormInputBase<String> {
    private DateFormat dateFormat_;
    private boolean isDisplayTime_;
    private String titleShowCalendar = "Show Calendar";

    public UIFormDateTimePicker(String name, String bindField, Date date, boolean isDisplayTime, String titleShowCalendar) {
        super(name, bindField, String.class);
        this.setDisplayTime(isDisplayTime);
        this.setTitleShowCalendar(titleShowCalendar);
        if (date != null) {
            this.value_ = this.dateFormat_.format(date);
        }
    }

    public UIFormDateTimePicker(String name, String bindField, Date date) {
        this(name, bindField, date, true, "");
    }

    public void setDisplayTime(boolean isDisplayTime) {
        this.isDisplayTime_ = isDisplayTime;
        this.dateFormat_ = this.isDisplayTime_ ? new SimpleDateFormat("MM/dd/yyyy HH:mm:ss") : new SimpleDateFormat("MM/dd/yyyy");
    }

    public void setCalendar(Calendar date) {
        this.value_ = this.dateFormat_.format(date.getTime());
    }

    public Calendar getCalendar() {
        try {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(this.dateFormat_.parse((String)this.value_ + " 0:0:0"));
            return calendar;
        }
        catch (ParseException e) {
            return null;
        }
    }

    public void setTitleShowCalendar(String titleShowCalendar) {
        this.titleShowCalendar = titleShowCalendar;
    }

    public String getTitleShowCalendar() {
        return this.titleShowCalendar;
    }

    public void decode(Object input, WebuiRequestContext context) throws Exception {
        if (input != null) {
            this.value_ = ((String)input).trim();
        }
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        context.getJavascriptManager().importJavascript("eXo.ks.UIDateTimePicker", "/ksResources/javascript/");
        Writer w = context.getWriter();
        w.write("<input type='text' class='DateTimeInput'");
        w.write("name='");
        w.write(this.getName());
        w.write(39);
        if (this.value_ != null && ((String)this.value_).length() > 0) {
            w.write(" value='");
            w.write(((String)this.value_).toString());
            w.write(39);
        }
        w.write("/>");
        w.write("<div class='CalendarIcons' onclick='eXo.ks.UIDateTimePicker.init(this,");
        w.write(String.valueOf(this.isDisplayTime_) + ");' title='" + this.getTitleShowCalendar() + "'><span></span></div>");
    }
}

