/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui.popup;

import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import org.exoplatform.forum.ForumTransformHTML;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.service.Tag;
import org.exoplatform.forum.webui.UIFormSelectBoxForum;
import org.exoplatform.forum.webui.popup.UIAddTagForm;
import org.exoplatform.forum.webui.popup.UIPopupComponent;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/popup/UIFormForum.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UIAddTagForm
extends UIForm
implements UIPopupComponent {
    public static final String FIELD_TAGNAME_INPUT = "TagName";
    public static final String FIELD_TAGDESCRIPTION_TEXTAREA = "TagDescription";
    public static final String FIELD_TAGCOLOR_SELECTBOX = "TagColor";
    private String[] colors = new String[]{"Blue", "DarkGoldenRod", "Green", "Yellow", "BlueViolet", "Orange", "DarkBlue", "IndianRed", "DarkCyan", "LawnGreen", "Violet", "Red"};
    private boolean isUpdate = false;
    private String tagId = "";
    private boolean isTopicTag = false;

    public UIAddTagForm() throws Exception {
        if (ForumUtils.isEmpty((String)this.getId())) {
            this.setId("UIAddTagForm");
        }
        UIFormStringInput tagName = new UIFormStringInput(FIELD_TAGNAME_INPUT, FIELD_TAGNAME_INPUT, null);
        tagName.addValidator(MandatoryValidator.class, new Object[0]);
        UIFormTextAreaInput description = new UIFormTextAreaInput(FIELD_TAGDESCRIPTION_TEXTAREA, FIELD_TAGDESCRIPTION_TEXTAREA, null);
        ArrayList<SelectItemOption> list = new ArrayList<SelectItemOption>();
        Map newMap = this.getColorName();
        for (String string : this.colors) {
            list.add(new SelectItemOption((String)newMap.get(string) + "/" + "Color " + string, (Object)string));
        }
        UIFormSelectBoxForum tagColor = new UIFormSelectBoxForum(FIELD_TAGCOLOR_SELECTBOX, FIELD_TAGCOLOR_SELECTBOX, list);
        tagColor.setDefaultValue((Object)"blue");
        this.addUIFormInput((UIFormInput)tagName);
        this.addUIFormInput((UIFormInput)tagColor);
        this.addUIFormInput((UIFormInput)description);
    }

    public void setUpdateTag(Tag tag) {
        this.isUpdate = true;
        this.tagId = tag.getId();
        this.getUIStringInput(FIELD_TAGNAME_INPUT).setValue((Object)ForumTransformHTML.unCodeHTML((String)tag.getName()));
        this.getUIFormTextAreaInput(FIELD_TAGDESCRIPTION_TEXTAREA).setValue((Object)ForumTransformHTML.unCodeHTML((String)tag.getDescription()));
        this.getUIFormSelectBoxForum(FIELD_TAGCOLOR_SELECTBOX).setValue(tag.getColor());
    }

    private Map<String, String> getColorName() throws Exception {
        TreeMap<String, String> map = new TreeMap<String, String>();
        String[] listColor = this.getLabel("ColorsList").split(",");
        if (listColor[0].equals("ColorsList")) {
            listColor = new String[]{};
        }
        int l = listColor.length;
        for (int j = 0; j < this.colors.length; ++j) {
            if (j < l) {
                map.put(this.colors[j], listColor[j].trim());
                continue;
            }
            map.put(this.colors[j], this.colors[j]);
        }
        return map;
    }

    public void setIsTopicTag(boolean b) {
        this.isTopicTag = b;
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public UIFormSelectBoxForum getUIFormSelectBoxForum(String name) {
        return (UIFormSelectBoxForum)this.findComponentById(name);
    }

    static /* synthetic */ boolean access$000(UIAddTagForm x0) {
        return x0.isUpdate;
    }

    static /* synthetic */ String access$100(UIAddTagForm x0) {
        return x0.tagId;
    }

    static /* synthetic */ boolean access$200(UIAddTagForm x0) {
        return x0.isTopicTag;
    }

    static /* synthetic */ boolean access$202(UIAddTagForm x0, boolean x1) {
        x0.isTopicTag = x1;
        return x0.isTopicTag;
    }
}

