/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui.popup;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.forum.ForumSessionUtils;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.ForumServiceUtils;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.webui.UIForumPortlet;
import org.exoplatform.forum.webui.popup.UIMovePostForm;
import org.exoplatform.forum.webui.popup.UIPopupComponent;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/popup/UIMovePostForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UIMovePostForm
extends UIForm
implements UIPopupComponent {
    private ForumService forumService = (ForumService)PortalContainer.getInstance().getComponentInstanceOfType(ForumService.class);
    private String topicId;
    private List<Post> posts;
    private UserProfile userProfile;
    private List<Category> categories;
    private String link;

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public void updatePost(String topicId, List<Post> posts) throws Exception {
        this.topicId = topicId;
        this.posts = posts;
        this.setCategories();
    }

    public UserProfile getUserProfile() throws Exception {
        return this.userProfile;
    }

    public void setUserProfile(UserProfile userProfile) throws Exception {
        this.userProfile = userProfile;
        if (this.userProfile == null) {
            this.userProfile = ((UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class)).getUserProfile();
        }
    }

    private void setCategories() throws Exception {
        this.categories = new ArrayList();
        for (Category category : this.forumService.getCategories(ForumSessionUtils.getSystemProvider())) {
            String[] list;
            if (this.userProfile.getUserRole() == 1L && (list = category.getUserPrivate()) != null && list.length > 0 && !list[0].equals(" ") && !ForumUtils.isStringInStrings((String[])list, (String)this.userProfile.getUserId())) continue;
            this.categories.add(category);
        }
    }

    private List<Category> getCategories() throws Exception {
        return this.categories;
    }

    private boolean getSelectForum(String forumId) throws Exception {
        return ((Post)this.posts.get(0)).getPath().contains(forumId);
    }

    private List<Forum> getForums(String categoryId) throws Exception {
        ArrayList<Forum> forums = new ArrayList<Forum>();
        for (Forum forum : this.forumService.getForums(ForumSessionUtils.getSystemProvider(), categoryId, "")) {
            String[] moderators;
            if (this.userProfile.getUserRole() == 1L && !ForumServiceUtils.hasPermission((String[])(moderators = forum.getModerators()), (String)this.userProfile.getUserId())) continue;
            forums.add(forum);
        }
        return forums;
    }

    private List<Topic> getTopics(String categoryId, String forumId, boolean isMode) throws Exception {
        ArrayList<Topic> topics = new ArrayList<Topic>();
        List topics_ = this.forumService.getTopics(ForumSessionUtils.getSystemProvider(), categoryId, forumId);
        for (Topic topic : topics_) {
            if (topic.getId().equalsIgnoreCase(this.topicId) || this.userProfile.getUserRole() == 1L && !isMode && (!topic.getIsActive() || !topic.getIsActiveByForum() || !topic.getIsApproved() || topic.getIsClosed() || topic.getIsLock() || topic.getIsWaiting() || topic.getCanPost().length > 0 && !ForumUtils.isStringInStrings((String[])topic.getCanPost(), (String)this.userProfile.getUserId()))) continue;
            topics.add(topic);
        }
        return topics;
    }

    static /* synthetic */ List access$000(UIMovePostForm x0) {
        return x0.posts;
    }

    static /* synthetic */ ForumService access$100(UIMovePostForm x0) {
        return x0.forumService;
    }
}

