/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui;

import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.PathNotFoundException;
import javax.portlet.ActionResponse;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.download.DownloadService;
import org.exoplatform.forum.ForumSessionUtils;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.info.ForumParameter;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumAdministration;
import org.exoplatform.forum.service.ForumAttachment;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.ForumServiceUtils;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.Tag;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.forum.service.Watch;
import org.exoplatform.forum.service.user.ForumContact;
import org.exoplatform.forum.webui.UIBreadcumbs;
import org.exoplatform.forum.webui.UIForumKeepStickPageIterator;
import org.exoplatform.forum.webui.UIForumPortlet;
import org.exoplatform.forum.webui.UIPostRules;
import org.exoplatform.forum.webui.UITopicDetail;
import org.exoplatform.ks.common.bbcode.BBCode;
import org.exoplatform.ks.rss.RSS;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/UITopicDetail.gtmpl", events={@EventConfig(listeners={AddPostActionListener.class}), @EventConfig(listeners={RatingTopicActionListener.class}), @EventConfig(listeners={AddTagTopicActionListener.class}), @EventConfig(listeners={UnTagTopicActionListener.class}), @EventConfig(listeners={OpenTopicsTagActionListener.class}), @EventConfig(listeners={GoNumberPageActionListener.class}), @EventConfig(listeners={SearchFormActionListener.class}), @EventConfig(listeners={PrintActionListener.class}), @EventConfig(listeners={EditActionListener.class}), @EventConfig(listeners={DeleteActionListener.class}, confirm="UITopicDetail.confirm.DeleteThisPost"), @EventConfig(listeners={PrivatePostActionListener.class}), @EventConfig(listeners={QuoteActionListener.class}), @EventConfig(listeners={EditTopicActionListener.class}), @EventConfig(listeners={PrintPageActionListener.class}), @EventConfig(listeners={AddPollActionListener.class}), @EventConfig(listeners={SetOpenTopicActionListener.class}), @EventConfig(listeners={SetCloseTopicActionListener.class}), @EventConfig(listeners={SetLockedTopicActionListener.class}), @EventConfig(listeners={SetUnLockTopicActionListener.class}), @EventConfig(listeners={SetMoveTopicActionListener.class}), @EventConfig(listeners={SetStickTopicActionListener.class}), @EventConfig(listeners={SetUnStickTopicActionListener.class}), @EventConfig(listeners={SplitTopicActionListener.class}), @EventConfig(listeners={SetApproveTopicActionListener.class}), @EventConfig(listeners={SetUnApproveTopicActionListener.class}), @EventConfig(listeners={SetDeleteTopicActionListener.class}, confirm="UITopicDetail.confirm.DeleteThisTopic"), @EventConfig(listeners={MergePostActionListener.class}), @EventConfig(listeners={MovePostActionListener.class}), @EventConfig(listeners={SetApprovePostActionListener.class}), @EventConfig(listeners={SetHiddenPostActionListener.class}), @EventConfig(listeners={SetUnHiddenPostActionListener.class}), @EventConfig(listeners={DeletePostActionListener.class}), @EventConfig(listeners={QuickReplyActionListener.class}), @EventConfig(listeners={PreviewReplyActionListener.class}), @EventConfig(listeners={ViewPostedByUserActionListener.class}), @EventConfig(listeners={ViewPublicUserInfoActionListener.class}), @EventConfig(listeners={ViewThreadByUserActionListener.class}), @EventConfig(listeners={WatchOptionActionListener.class}), @EventConfig(listeners={PrivateMessageActionListener.class}), @EventConfig(listeners={DownloadAttachActionListener.class}), @EventConfig(listeners={UIForumKeepStickPageIterator.GoPageActionListener.class}), @EventConfig(listeners={AdvancedSearchActionListener.class}), @EventConfig(listeners={BanIPAllForumActionListener.class}), @EventConfig(listeners={BanIPThisForumActionListener.class}), @EventConfig(listeners={AddBookMarkActionListener.class}), @EventConfig(listeners={RSSActionListener.class}), @EventConfig(listeners={UnWatchActionListener.class}), @EventConfig(listeners={AddWatchingActionListener.class})})
public class UITopicDetail
extends UIForumKeepStickPageIterator {
    private ForumService forumService;
    private String categoryId;
    private String forumId;
    private String topicId = "";
    private String link = "";
    private Forum forum;
    private Topic topic = new Topic();
    private boolean isEditTopic = false;
    private String IdPostView = "false";
    private String IdLastPost = "false";
    private UserProfile userProfile = null;
    private String userName = " ";
    private boolean isModeratePost = false;
    private boolean isMod = false;
    private boolean enableIPLogging = true;
    private boolean isCanPost = false;
    private boolean canCreateTopic;
    private boolean isGetSv = true;
    private boolean isShowQuickReply = true;
    private boolean isShowRule = true;
    private boolean isDoubleClickQuickReply = false;
    private String lastPoistIdSave = "";
    private String lastPostId = "";
    private String isApprove = "";
    private String isHidden = "";
    private List<String> listContactsGotten = new ArrayList();
    private List<BBCode> listBBCode = new ArrayList();
    private List<Watch> listWatches = new ArrayList();
    private Map<String, Integer> pagePostRemember = new HashMap();
    private Map<String, UserProfile> mapUserProfile = new HashMap();
    private Map<String, ForumContact> mapContact = new HashMap();
    public static final String FIELD_MESSAGE_TEXTAREA = "Message";
    public static final String FIELD_ADD_TAG = "AddTag";

    public UITopicDetail() throws Exception {
        this.forumService = (ForumService)PortalContainer.getInstance().getComponentInstanceOfType(ForumService.class);
        this.addUIFormInput((UIFormInput)new UIFormStringInput(ForumUtils.GOPAGE_ID_T, null));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(ForumUtils.GOPAGE_ID_B, null));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(ForumUtils.SEARCHFORM_ID, null));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_ADD_TAG, null));
        this.addUIFormInput((UIFormInput)new UIFormTextAreaInput(FIELD_MESSAGE_TEXTAREA, FIELD_MESSAGE_TEXTAREA, null));
        this.addChild(UIPostRules.class, null, null);
        this.setSubmitAction("GoNumberPage");
        this.setActions(new String[]{"PreviewReply", "QuickReply"});
        this.isLink = true;
    }

    private boolean isShowQuickReply() {
        return this.isShowQuickReply;
    }

    public String getLastPostId() {
        return this.lastPostId;
    }

    public void setLastPostId(String lastPost) {
        this.lastPostId = lastPost;
    }

    public String getRSSLink(String cateId) {
        PortalContainer pcontainer = PortalContainer.getInstance();
        return RSS.getRSSLink((String)"forum", (String)pcontainer.getPortalContainerInfo().getContainerName(), (String)cateId);
    }

    public UserProfile getUserProfile() {
        return this.userProfile;
    }

    public void setUserProfile(UserProfile userProfile) throws Exception {
        this.userProfile = userProfile;
    }

    public boolean getHasEnableIPLogging() {
        return this.enableIPLogging;
    }

    private boolean isIPBaned(String ip) {
        List ipBaneds = this.forum.getBanIP();
        return ipBaneds != null && ipBaneds.size() > 0 && ipBaneds.contains(ip);
    }

    private boolean isOnline(String userId) throws Exception {
        return this.forumService.isOnline(userId);
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    private int getPagePostRemember(String topicId) {
        if (this.pagePostRemember.containsKey(topicId)) {
            return (Integer)this.pagePostRemember.get(topicId);
        }
        return 1;
    }

    private boolean isNotLogin() throws Exception {
        return this.userProfile.getUserId().equals("user_gest_uoom") && !this.forum.getIsLock() && !this.topic.getIsLock();
    }

    public void setUpdateTopic(String categoryId, String forumId, String topicId) throws Exception {
        this.categoryId = categoryId;
        this.forumId = forumId;
        this.topicId = topicId;
        UIForumPortlet forumPortlet = (UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class);
        this.isShowQuickReply = forumPortlet.isShowQuickReply();
        this.isShowRule = forumPortlet.isShowRules();
        this.enableIPLogging = forumPortlet.isEnableIPLogging();
        forumPortlet.updateAccessTopic(topicId);
        this.userProfile = forumPortlet.getUserProfile();
        this.userName = this.userProfile.getUserId();
        this.cleanCheckedList();
        ((UIBreadcumbs)forumPortlet.getChild(UIBreadcumbs.class)).setUpdataPath(categoryId + "/" + forumId + "/" + topicId);
        this.isUseAjax = forumPortlet.isUseAjax();
        this.listWatches = forumPortlet.getWatchinhByCurrentUser();
        this.topic = this.forumService.getTopic(categoryId, forumId, topicId, this.userName);
        this.setRenderInfoPorlet();
    }

    public void setTopicFromCate(String categoryId, String forumId, Topic topic, int page) throws Exception {
        this.categoryId = categoryId;
        this.forumId = forumId;
        this.topicId = topic.getId();
        this.pageSelect = page > 0 ? page : this.getPagePostRemember(this.topicId);
        UIForumPortlet forumPortlet = (UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class);
        this.isShowQuickReply = forumPortlet.isShowQuickReply();
        this.isShowRule = forumPortlet.isShowRules();
        this.enableIPLogging = forumPortlet.isEnableIPLogging();
        this.cleanCheckedList();
        this.topic = ForumUtils.isEmpty((String)topic.getDescription()) ? this.forumService.getTopic(categoryId, forumId, topic.getId(), this.userName) : topic;
        forumPortlet.updateAccessTopic(this.topicId);
        ((UIBreadcumbs)forumPortlet.getChild(UIBreadcumbs.class)).setUpdataPath(categoryId + "/" + forumId + "/" + this.topicId);
        this.isUseAjax = forumPortlet.isUseAjax();
        this.userProfile = forumPortlet.getUserProfile();
        this.listWatches = forumPortlet.getWatchinhByCurrentUser();
        this.userName = this.userProfile.getUserId();
        this.setRenderInfoPorlet();
    }

    public void hasPoll(boolean hasPoll) throws Exception {
        this.topic.setIsPoll(hasPoll);
        if (hasPoll) {
            this.setRenderInfoPorlet();
        }
    }

    public void setUpdateContainer(String categoryId, String forumId, Topic topic, int numberPage) throws Exception {
        this.categoryId = categoryId;
        this.forumId = forumId;
        this.topicId = topic.getId();
        this.pageSelect = numberPage;
        this.isEditTopic = false;
        if (this.pageSelect == 0) {
            this.pageSelect = this.getPagePostRemember(this.topicId);
        }
        UIForumPortlet forumPortlet = (UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class);
        this.isShowQuickReply = forumPortlet.isShowQuickReply();
        this.isShowRule = forumPortlet.isShowRules();
        this.enableIPLogging = forumPortlet.isEnableIPLogging();
        this.cleanCheckedList();
        this.topic = ForumUtils.isEmpty((String)topic.getDescription()) ? this.forumService.getTopic(categoryId, forumId, topic.getId(), this.userName) : topic;
        forumPortlet.getUserProfile().setLastTimeAccessTopic(topic.getId(), ForumUtils.getInstanceTempCalendar().getTimeInMillis());
        ((UIBreadcumbs)forumPortlet.getChild(UIBreadcumbs.class)).setUpdataPath(categoryId + "/" + forumId + "/" + this.topicId);
        this.isUseAjax = forumPortlet.isUseAjax();
        this.userProfile = forumPortlet.getUserProfile();
        this.listWatches = forumPortlet.getWatchinhByCurrentUser();
        this.userName = this.userProfile.getUserId();
        this.setRenderInfoPorlet();
    }

    public void setRenderInfoPorlet() throws Exception {
        this.isMod = false;
        if (this.userProfile.getUserRole() == 0L) {
            this.isMod = true;
        }
        if (!this.isMod) {
            this.isMod = ForumServiceUtils.hasPermission((String[])this.forum.getModerators(), (String)this.userName);
        }
        try {
            PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
            ActionResponse actionRes = (ActionResponse)pcontext.getResponse();
            ForumParameter param = new ForumParameter();
            param.setCategoryId(this.categoryId);
            param.setForumId(this.forumId);
            param.setTopicId(this.topicId);
            param.setRenderPoll(this.topic.getIsPoll());
            actionRes.setEvent(new QName("ForumPollEvent"), (Serializable)param);
            param = new ForumParameter();
            try {
                this.isCanPost = this.isCanPostReply();
            }
            catch (Exception e) {
                this.isCanPost = false;
            }
            param.setRenderQuickReply(this.isCanPost);
            param.setModerator(this.isMod);
            param.setCategoryId(this.categoryId);
            param.setForumId(this.forumId);
            param.setTopicId(this.topicId);
            actionRes.setEvent(new QName("QuickReplyEvent"), (Serializable)param);
            param = new ForumParameter();
            List list = param.getInfoRules();
            if (this.forum.getIsClosed() || this.forum.getIsLock()) {
                list.set(0, "true");
            } else {
                list.set(0, "");
            }
            list.set(1, String.valueOf(this.getCanCreateTopic()));
            list.set(2, String.valueOf(this.isCanPost));
            param.setInfoRules(list);
            param.setRenderRule(true);
            actionRes.setEvent(new QName("ForumRuleEvent"), (Serializable)param);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setIsGetSv(boolean isGetSv) {
        this.isGetSv = isGetSv;
    }

    private String getReplaceByBBCode(String s) throws Exception {
        List bbcName = new ArrayList();
        if (this.isGetSv) {
            ArrayList<BBCode> bbcs = new ArrayList<BBCode>();
            try {
                bbcName = this.forumService.getActiveBBCode();
                this.isGetSv = false;
                boolean isAdd = true;
                for (String string : bbcName) {
                    isAdd = true;
                    for (BBCode bbc : this.listBBCode) {
                        if (!bbc.getTagName().equals(string) && (!bbc.getTagName().equals(string.replaceFirst("=", "")) || !bbc.isOption())) continue;
                        bbcs.add(bbc);
                        isAdd = false;
                        break;
                    }
                    if (!isAdd) continue;
                    BBCode bbCode = new BBCode();
                    if (string.indexOf("=") >= 0) {
                        bbCode.setOption(true);
                        string = string.replaceFirst("=", "");
                        bbCode.setId(string + "_option");
                    } else {
                        bbCode.setId(string);
                    }
                    bbCode.setTagName(string);
                    bbcs.add(bbCode);
                }
                this.listBBCode.clear();
                this.listBBCode.addAll(bbcs);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (!this.listBBCode.isEmpty()) {
            try {
                s = Utils.getReplacementByBBcode((String)s, (List)this.listBBCode, (ForumService)this.forumService);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return s;
    }

    private boolean getCanCreateTopic() throws Exception {
        String[] strings = this.forum.getCreateTopicRole();
        this.canCreateTopic = this.isMod;
        if (!this.canCreateTopic) {
            this.canCreateTopic = this.isIPBaned(this.getIPRemoter()) ? false : (strings == null || strings.length == 0 || strings.length == 1 && strings[0].equals(" ") ? true : ForumServiceUtils.hasPermission((String[])strings, (String)this.userName));
        }
        return this.canCreateTopic;
    }

    public boolean getCanPost() throws Exception {
        if (this.isEditTopic) {
            this.isCanPost = this.isCanPostReply();
        }
        return this.isCanPost;
    }

    public void setUpdateForum(Forum forum) throws Exception {
        this.forum = forum;
    }

    private boolean isCanPostReply() throws Exception {
        if (this.userProfile.getUserRole() == 3L) {
            return false;
        }
        if (this.forum.getIsClosed() || this.forum.getIsLock() || this.topic.getIsClosed() || this.topic.getIsLock()) {
            return false;
        }
        if (this.userProfile.getIsBanned()) {
            return false;
        }
        if (this.isMod) {
            return true;
        }
        if (this.isIPBaned(this.getIPRemoter())) {
            return false;
        }
        if (!this.topic.getIsActive() || !this.topic.getIsActiveByForum() || this.topic.getIsWaiting()) {
            return false;
        }
        ArrayList<String> listUser = new ArrayList<String>();
        String[] canPost = this.topic.getCanPost();
        if (canPost != null && canPost.length > 0 && !canPost[0].equals(" ")) {
            listUser.addAll(Arrays.asList(canPost));
            canPost = this.forum.getPoster();
            if (canPost != null && canPost.length > 0 && !canPost[0].equals(" ")) {
                listUser.addAll(Arrays.asList(canPost));
            }
        }
        if (!listUser.isEmpty()) {
            return ForumServiceUtils.hasPermission((String[])listUser.toArray(new String[0]), (String)this.userName);
        }
        return true;
    }

    private String getIPRemoter() throws Exception {
        if (this.enableIPLogging) {
            try {
                WebuiRequestContext context = (WebuiRequestContext)RequestContext.getCurrentInstance();
                HttpServletRequest request = (HttpServletRequest)context.getRequest();
                return request.getRemoteAddr();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "";
    }

    private Forum getForum() throws Exception {
        return this.forum;
    }

    private String getIdPostView() {
        if (this.IdPostView.equals("lastpost")) {
            this.IdPostView = "normal";
            return this.IdLastPost;
        }
        if (this.IdPostView.equals("top")) {
            this.IdPostView = "normal";
            return "top";
        }
        String temp = this.IdPostView;
        this.IdPostView = "normal";
        return temp;
    }

    public void setIdPostView(String IdPostView) {
        this.IdPostView = IdPostView;
    }

    public void setIsEditTopic(boolean isEditTopic) {
        this.isEditTopic = isEditTopic;
    }

    private Topic getTopic() throws Exception {
        try {
            if (this.isEditTopic || this.topic == null) {
                this.topic = this.forumService.getTopic(this.categoryId, this.forumId, this.topicId, "user_gest_uoom");
                this.isEditTopic = false;
            }
            return this.topic;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private boolean userCanView() throws Exception {
        if (this.isMod) {
            return true;
        }
        if (this.forum.getIsClosed() || this.topic.getIsClosed() || !this.topic.getIsActive() || !this.topic.getIsActiveByForum() || this.topic.getIsWaiting()) {
            return false;
        }
        if (this.getCanPost()) {
            return true;
        }
        ArrayList<String> listUser = new ArrayList<String>();
        String[] canPost = this.topic.getCanView();
        if (canPost != null && canPost.length > 0 && !canPost[0].equals(" ")) {
            listUser.addAll(Arrays.asList(canPost));
            canPost = this.forum.getViewer();
            if (canPost != null && canPost.length > 0 && !canPost[0].equals(" ")) {
                listUser.addAll(Arrays.asList(canPost));
            }
        }
        if (listUser.size() > 0) {
            return ForumServiceUtils.hasPermission((String[])listUser.toArray(new String[0]), (String)this.userName);
        }
        return true;
    }

    public String getPortalName() {
        PortalContainer pcontainer = PortalContainer.getInstance();
        return pcontainer.getPortalContainerInfo().getContainerName();
    }

    public String getRepository() throws Exception {
        RepositoryService rService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        return rService.getCurrentRepository().getConfiguration().getName();
    }

    private String getFileSource(ForumAttachment attachment) throws Exception {
        DownloadService dservice = (DownloadService)this.getApplicationComponent(DownloadService.class);
        try {
            InputStream input = attachment.getInputStream();
            String fileName = attachment.getName();
            return ForumSessionUtils.getFileSource((InputStream)input, (String)fileName, (DownloadService)dservice);
        }
        catch (PathNotFoundException e) {
            return null;
        }
    }

    private ForumContact getPersonalContact(String userId) throws Exception {
        ForumContact contact;
        if (this.mapContact.containsKey(userId) && this.listContactsGotten.contains(userId)) {
            contact = (ForumContact)this.mapContact.get(userId);
        } else {
            contact = ForumSessionUtils.getPersonalContact((String)userId);
            this.mapContact.put(userId, contact);
            this.listContactsGotten.add(userId);
        }
        if (contact == null) {
            contact = new ForumContact();
        }
        return contact;
    }

    private String getAvatarUrl(ForumContact contact, String userId) throws Exception {
        DownloadService dservice = (DownloadService)this.getApplicationComponent(DownloadService.class);
        return ForumSessionUtils.getUserAvatarURL((String)userId, (ForumService)this.forumService, (DownloadService)dservice);
    }

    private void initPage() throws Exception {
        this.objectId = this.topicId;
        this.isDoubleClickQuickReply = false;
        this.isGetSv = true;
        this.listContactsGotten = new ArrayList();
        try {
            this.isApprove = "";
            this.isHidden = "";
            if (!this.isMod) {
                this.isHidden = "false";
            }
            if (this.forum.getIsModeratePost() || this.topic.getIsModeratePost()) {
                this.isModeratePost = true;
                if (!this.isMod && !this.topic.getOwner().equals(this.userName)) {
                    this.isApprove = "true";
                }
            }
            this.pageList = this.forumService.getPosts(this.categoryId, this.forumId, this.topicId, this.isApprove, this.isHidden, "", this.userName);
            int maxPost = this.userProfile.getMaxPostInPage().intValue();
            if (maxPost <= 0) {
                maxPost = 10;
            }
            this.pageList.setPageSize(maxPost);
            this.maxPage = this.pageList.getAvailablePage();
            if (this.IdPostView.equals("lastpost")) {
                this.pageSelect = this.maxPage;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean getIsModeratePost() {
        return this.isModeratePost;
    }

    private List<Post> getPostPageList() throws Exception {
        List<Object> posts;
        block18: {
            posts = new ArrayList<Post>();
            if (this.pageList == null) {
                return posts;
            }
            try {
                try {
                    if (!ForumUtils.isEmpty((String)this.lastPostId)) {
                        int maxPost = this.userProfile.getMaxPostInPage().intValue();
                        Long index = this.forumService.getLastReadIndex(this.categoryId + "/" + this.forumId + "/" + this.topicId + "/" + this.lastPostId, this.isApprove, this.isHidden, this.userName);
                        if (index.intValue() <= maxPost) {
                            this.pageSelect = 1;
                        } else {
                            this.pageSelect = (int)(index / (long)maxPost);
                            if ((long)(maxPost * this.pageSelect) < index) {
                                ++this.pageSelect;
                            }
                        }
                        this.lastPostId = "";
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                posts = this.pageList.getPage(this.pageSelect);
                this.pagePostRemember.put(this.topicId, this.pageSelect);
                if (posts == null) {
                    posts = new ArrayList();
                }
                ArrayList<String> userNames = new ArrayList<String>();
                this.mapUserProfile.clear();
                for (Post post : posts) {
                    if (!userNames.contains(post.getOwner())) {
                        userNames.add(post.getOwner());
                    }
                    if (this.getUIFormCheckBoxInput(post.getId()) != null) {
                        this.getUIFormCheckBoxInput(post.getId()).setChecked(false);
                    } else {
                        this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(post.getId(), post.getId(), (Object)false));
                    }
                    this.IdLastPost = post.getId();
                }
                if (!this.lastPoistIdSave.equals(this.IdLastPost)) {
                    this.lastPoistIdSave = this.IdLastPost;
                    this.userProfile.addLastPostIdReadOfForum(this.forumId, this.topicId + "/" + this.IdLastPost);
                    this.userProfile.addLastPostIdReadOfTopic(this.topicId, this.IdLastPost);
                    UIForumPortlet forumPortlet = (UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class);
                    forumPortlet.getUserProfile().addLastPostIdReadOfForum(this.forumId, this.topicId + "/" + this.IdLastPost);
                    forumPortlet.getUserProfile().addLastPostIdReadOfTopic(this.topicId, this.IdLastPost + "," + ForumUtils.getInstanceTempCalendar().getTimeInMillis());
                    this.forumService.saveLastPostIdRead(this.userName, this.userProfile.getLastReadPostOfForum(), this.userProfile.getLastReadPostOfTopic());
                }
                if (userNames.size() <= 0) break block18;
                try {
                    List profiles = this.forumService.getQuickProfiles(userNames);
                    for (UserProfile profile : profiles) {
                        this.mapUserProfile.put(profile.getUserId(), profile);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return posts;
    }

    private List<Tag> getTagsByTopic() throws Exception {
        List<Object> list = new ArrayList<Tag>();
        ArrayList<String> listTagId = new ArrayList<String>();
        String[] tagIds = this.topic.getTagId();
        for (int i = 0; i < tagIds.length; ++i) {
            String[] temp = tagIds[i].split(":");
            if (!temp[0].equals(this.userName)) continue;
            listTagId.add(temp[1]);
        }
        try {
            list = this.forumService.getMyTagInTopic(listTagId.toArray(new String[0]));
        }
        catch (Exception e) {
            // empty catch block
        }
        return list;
    }

    public List<Post> getAllPost() throws Exception {
        return this.pageList.getAll();
    }

    private Post getPost(String postId) throws Exception {
        for (Post post : this.getAllPost()) {
            if (!post.getId().equals(postId)) continue;
            return post;
        }
        return null;
    }

    public void setPostRules(boolean isNull) throws Exception {
        UIPostRules postRules = (UIPostRules)this.getChild(UIPostRules.class);
        postRules.setUserProfile(this.userProfile);
        if (!isNull) {
            if (this.forum.getIsClosed() || this.forum.getIsLock()) {
                postRules.setLock(true);
            } else {
                postRules.setCanCreateNewThread(this.canCreateTopic);
                if (this.topic != null && !this.topic.getIsClosed() && !this.topic.getIsLock()) {
                    postRules.setCanAddPost(this.getCanPost());
                } else {
                    postRules.setCanAddPost(false);
                }
            }
        } else {
            postRules.setCanCreateNewThread(!isNull);
            postRules.setCanAddPost(!isNull);
        }
    }

    private UserProfile getUserInfo(String userName) throws Exception {
        if (!this.mapUserProfile.containsKey(userName)) {
            try {
                this.mapUserProfile.put(userName, this.forumService.getQuickProfile(userName));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return (UserProfile)this.mapUserProfile.get(userName);
    }

    public void setListWatches(List<Watch> listWatches) {
        this.listWatches = listWatches;
    }

    private boolean isWatching(String path) throws Exception {
        for (Watch watch : this.listWatches) {
            if (!path.equals(watch.getNodePath())) continue;
            return true;
        }
        return false;
    }

    private String getEmailWatching(String path) throws Exception {
        for (Watch watch : this.listWatches) {
            try {
                if (!watch.getNodePath().endsWith(path)) continue;
                return watch.getEmail();
            }
            catch (Exception e) {
            }
        }
        return "";
    }

    private boolean checkForumHasAddTopic(UserProfile userProfile) throws Exception {
        this.topic = (Topic)this.forumService.getObjectNameById(this.topicId, Utils.TOPIC);
        if (this.topic.getIsClosed() || this.topic.getIsLock()) {
            return false;
        }
        Forum forum = (Forum)this.forumService.getObjectNameById(this.forumId, Utils.FORUM);
        if (forum.getIsClosed() || forum.getIsLock()) {
            return false;
        }
        if (userProfile.getUserRole() > 1L || userProfile.getUserRole() == 1L && !ForumServiceUtils.hasPermission((String[])forum.getModerators(), (String)userProfile.getUserId())) {
            if (!this.topic.getIsActive() || !this.topic.getIsActiveByForum()) {
                return false;
            }
            String[] canCreadPost = this.topic.getCanPost();
            if (canCreadPost != null && canCreadPost.length > 0 && !canCreadPost[0].equals(" ")) {
                return ForumServiceUtils.hasPermission((String[])canCreadPost, (String)userProfile.getUserId());
            }
        }
        return true;
    }

    private String[] getCensoredKeyword() throws Exception {
        ForumAdministration forumAdministration = this.forumService.getForumAdministration();
        String stringKey = forumAdministration.getCensoredKeyword();
        if (stringKey != null && stringKey.length() > 0) {
            if ((stringKey = stringKey.toLowerCase().replaceAll(", ", ",").replaceAll(" ,", ",")).contains(",")) {
                stringKey.replaceAll(";", ",");
                return stringKey.trim().split(",");
            }
            return stringKey.trim().split(";");
        }
        return new String[0];
    }

    static /* synthetic */ String access$000(UITopicDetail x0) {
        return x0.categoryId;
    }

    static /* synthetic */ String access$100(UITopicDetail x0) {
        return x0.forumId;
    }

    static /* synthetic */ String access$200(UITopicDetail x0) {
        return x0.topicId;
    }

    static /* synthetic */ Topic access$300(UITopicDetail x0) {
        return x0.topic;
    }

    static /* synthetic */ boolean access$400(UITopicDetail x0) {
        return x0.isMod;
    }

    static /* synthetic */ boolean access$502(UITopicDetail x0, boolean x1) {
        x0.isEditTopic = x1;
        return x0.isEditTopic;
    }

    static /* synthetic */ String access$600(UITopicDetail x0) {
        return x0.userName;
    }

    static /* synthetic */ ForumService access$700(UITopicDetail x0) {
        return x0.forumService;
    }

    static /* synthetic */ Post access$800(UITopicDetail x0, String x1) throws Exception {
        return x0.getPost(x1);
    }

    static /* synthetic */ String access$902(UITopicDetail x0, String x1) {
        x0.IdPostView = x1;
        return x0.IdPostView;
    }

    static /* synthetic */ Forum access$1000(UITopicDetail x0) {
        return x0.forum;
    }

    static /* synthetic */ UserProfile access$1100(UITopicDetail x0) {
        return x0.userProfile;
    }

    static /* synthetic */ Topic access$1200(UITopicDetail x0) throws Exception {
        return x0.getTopic();
    }

    static /* synthetic */ Map access$1300(UITopicDetail x0) {
        return x0.mapUserProfile;
    }

    static /* synthetic */ Map access$1400(UITopicDetail x0) {
        return x0.mapContact;
    }

    static /* synthetic */ boolean access$1500(UITopicDetail x0) {
        return x0.isDoubleClickQuickReply;
    }

    static /* synthetic */ boolean access$1502(UITopicDetail x0, boolean x1) {
        x0.isDoubleClickQuickReply = x1;
        return x0.isDoubleClickQuickReply;
    }

    static /* synthetic */ boolean access$1600(UITopicDetail x0, UserProfile x1) throws Exception {
        return x0.checkForumHasAddTopic(x1);
    }

    static /* synthetic */ String[] access$1700(UITopicDetail x0) throws Exception {
        return x0.getCensoredKeyword();
    }

    static /* synthetic */ String access$1800(UITopicDetail x0) throws Exception {
        return x0.getIPRemoter();
    }

    static /* synthetic */ UserProfile access$1900(UITopicDetail x0, String x1) throws Exception {
        return x0.getUserInfo(x1);
    }

    static /* synthetic */ List access$2002(UITopicDetail x0, List x1) {
        x0.listWatches = x1;
        return x0.listWatches;
    }

    static /* synthetic */ String access$2100(UITopicDetail x0, String x1) throws Exception {
        return x0.getEmailWatching(x1);
    }
}

