/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui.popup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.SettingPortletPreference;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.ForumServiceUtils;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.webui.UIForumPortlet;
import org.exoplatform.forum.webui.popup.UIForumInputWithActions;
import org.exoplatform.forum.webui.popup.UIPopupComponent;
import org.exoplatform.forum.webui.popup.UISettingEditModeForm;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/popup/UISettingEditModeForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={SelectTabActionListener.class})})
public class UISettingEditModeForm
extends UIForm
implements UIPopupComponent {
    private UserProfile userProfile;
    public static final String FIELD_SCOPED_TAB = "Scoped";
    public static final String FIELD_SHOW_HIDDEN_TAB = "EnabledPanel";
    public static final String FIELD_FORUM_PREFERENCE_TAB = "ForumPreference";
    public static final String FIELD_ISFORUMJUMP_CHECKBOX = "isShowForumJump";
    public static final String FIELD_ISPOLL_CHECKBOX = "IsShowPoll";
    public static final String FIELD_ISMODERATOR_CHECKBOX = "isShowModerator";
    public static final String FIELD_ISQUICKREPLY_CHECKBOX = "isShowQuickReply";
    public static final String FIELD_ISICONSLEGEND_CHECKBOX = "isShowIconsLegend";
    public static final String FIELD_ISRULES_CHECKBOX = "isShowRules";
    public static final String FIELD_ISSTATISTIC_CHECKBOX = "isShowStatistic";
    public static final String FIELD_ISUSEAJAX_CHECKBOX = "isUseAjax";
    private boolean isSave = false;
    private int tabId = 0;
    private static List<String> listCategoryinv = new ArrayList();
    private static List<String> listforuminv = new ArrayList();
    private SettingPortletPreference portletPreference;

    public UISettingEditModeForm() {
        UIForumInputWithActions Scoped = new UIForumInputWithActions(FIELD_SCOPED_TAB);
        UIForumInputWithActions EnabledPanel = new UIForumInputWithActions(FIELD_SHOW_HIDDEN_TAB);
        UIForumInputWithActions ForumPreference = new UIForumInputWithActions(FIELD_FORUM_PREFERENCE_TAB);
        UIFormCheckBoxInput isShowForumJump = new UIFormCheckBoxInput(FIELD_ISFORUMJUMP_CHECKBOX, FIELD_ISFORUMJUMP_CHECKBOX, (Object)true);
        UIFormCheckBoxInput IsShowPoll = new UIFormCheckBoxInput(FIELD_ISPOLL_CHECKBOX, FIELD_ISPOLL_CHECKBOX, (Object)true);
        UIFormCheckBoxInput isShowModerator = new UIFormCheckBoxInput(FIELD_ISMODERATOR_CHECKBOX, FIELD_ISMODERATOR_CHECKBOX, (Object)true);
        UIFormCheckBoxInput isShowQuickReply = new UIFormCheckBoxInput(FIELD_ISQUICKREPLY_CHECKBOX, FIELD_ISQUICKREPLY_CHECKBOX, (Object)true);
        UIFormCheckBoxInput isShowIconsLegend = new UIFormCheckBoxInput(FIELD_ISICONSLEGEND_CHECKBOX, FIELD_ISICONSLEGEND_CHECKBOX, (Object)true);
        UIFormCheckBoxInput isShowRules = new UIFormCheckBoxInput(FIELD_ISRULES_CHECKBOX, FIELD_ISRULES_CHECKBOX, (Object)true);
        UIFormCheckBoxInput isShowStatistic = new UIFormCheckBoxInput(FIELD_ISSTATISTIC_CHECKBOX, FIELD_ISSTATISTIC_CHECKBOX, (Object)true);
        UIFormCheckBoxInput isUseAjax = new UIFormCheckBoxInput(FIELD_ISUSEAJAX_CHECKBOX, FIELD_ISUSEAJAX_CHECKBOX, (Object)true);
        EnabledPanel.addUIFormInput((UIFormInput)isShowForumJump);
        EnabledPanel.addUIFormInput((UIFormInput)IsShowPoll);
        EnabledPanel.addUIFormInput((UIFormInput)isShowModerator);
        EnabledPanel.addUIFormInput((UIFormInput)isShowQuickReply);
        EnabledPanel.addUIFormInput((UIFormInput)isShowIconsLegend);
        EnabledPanel.addUIFormInput((UIFormInput)isShowRules);
        EnabledPanel.addUIFormInput((UIFormInput)isShowStatistic);
        ForumPreference.addUIFormInput((UIFormInput)isUseAjax);
        this.addUIFormInput((UIFormInputSet)Scoped);
        this.addUIFormInput((UIFormInputSet)EnabledPanel);
        this.addUIFormInput((UIFormInputSet)ForumPreference);
        this.setActions(new String[]{"Save"});
    }

    public void setInitComponent() throws Exception {
        UIForumInputWithActions EnabledPanel = (UIForumInputWithActions)this.getChildById(FIELD_SHOW_HIDDEN_TAB);
        UIForumInputWithActions ForumPreference = (UIForumInputWithActions)this.getChildById(FIELD_FORUM_PREFERENCE_TAB);
        this.portletPreference = ForumUtils.getPorletPreference();
        EnabledPanel.getUIFormCheckBoxInput(FIELD_ISFORUMJUMP_CHECKBOX).setChecked(this.portletPreference.isShowForumJump());
        EnabledPanel.getUIFormCheckBoxInput(FIELD_ISPOLL_CHECKBOX).setChecked(this.portletPreference.isShowPoll());
        EnabledPanel.getUIFormCheckBoxInput(FIELD_ISQUICKREPLY_CHECKBOX).setChecked(this.portletPreference.isShowQuickReply());
        EnabledPanel.getUIFormCheckBoxInput(FIELD_ISICONSLEGEND_CHECKBOX).setChecked(this.portletPreference.isShowIconsLegend());
        EnabledPanel.getUIFormCheckBoxInput(FIELD_ISRULES_CHECKBOX).setChecked(this.portletPreference.isShowRules());
        EnabledPanel.getUIFormCheckBoxInput(FIELD_ISSTATISTIC_CHECKBOX).setChecked(this.portletPreference.isShowStatistics());
        EnabledPanel.getUIFormCheckBoxInput(FIELD_ISMODERATOR_CHECKBOX).setChecked(this.portletPreference.isShowModerators());
        ForumPreference.getUIFormCheckBoxInput(FIELD_ISUSEAJAX_CHECKBOX).setChecked(this.portletPreference.isUseAjax());
    }

    public void setUserProfile(UserProfile userProfile) throws Exception {
        this.setInitComponent();
        this.userProfile = userProfile;
        this.isSave = false;
    }

    private List<String> getListInValus(String value) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        if (!ForumUtils.isEmpty((String)value)) {
            list.addAll(Arrays.asList(ForumUtils.addStringToString((String)value, (String)value)));
        }
        return list;
    }

    private boolean tabIsSelected(int tabId) {
        return this.tabId == tabId;
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    private List<Category> getCategoryList() throws Exception {
        ArrayList<Category> categoryList = new ArrayList<Category>();
        try {
            ForumService forumService = (ForumService)PortalContainer.getInstance().getComponentInstanceOfType(ForumService.class);
            String userId = this.userProfile.getUserId();
            if (this.userProfile.getUserRole() > 0L) {
                for (Category category : forumService.getCategories()) {
                    String[] uesrs = category.getUserPrivate();
                    if (uesrs != null && uesrs.length > 0 && !uesrs[0].equals(" ")) {
                        if (!ForumServiceUtils.hasPermission((String[])uesrs, (String)userId)) continue;
                        categoryList.add(category);
                        continue;
                    }
                    categoryList.add(category);
                }
            } else {
                categoryList.addAll(forumService.getCategories());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!this.isSave) {
            listCategoryinv = ((UIForumPortlet)this.getParent()).getInvisibleCategories();
        }
        for (Category category : categoryList) {
            String categoryId = category.getId();
            boolean isCheck = false;
            if (listCategoryinv.contains(categoryId) || listCategoryinv.isEmpty()) {
                isCheck = true;
            }
            if (this.getUIFormCheckBoxInput(categoryId) != null) {
                this.getUIFormCheckBoxInput(categoryId).setChecked(isCheck);
                continue;
            }
            UIFormCheckBoxInput boxInput = new UIFormCheckBoxInput(categoryId, categoryId, (Object)isCheck);
            boxInput.setChecked(isCheck);
            this.addUIFormInput((UIFormInput)boxInput);
        }
        return categoryList;
    }

    private List<Forum> getForumList(String categoryId) throws Exception {
        List<Forum> forumList = null;
        String strQuery = "";
        if (this.userProfile.getUserRole() > 0L) {
            strQuery = "(@exo:isClosed='false') or (exo:moderators='" + this.userProfile.getUserId() + "')";
        }
        try {
            ForumService forumService = (ForumService)PortalContainer.getInstance().getComponentInstanceOfType(ForumService.class);
            forumList = forumService.getForums(categoryId, strQuery);
        }
        catch (Exception e) {
            forumList = new ArrayList();
        }
        if (!this.isSave) {
            listforuminv = ((UIForumPortlet)this.getParent()).getInvisibleForums();
        }
        for (Forum forum : forumList) {
            String forumId = forum.getId();
            boolean isCheck = false;
            if (listforuminv.contains(forumId) || listCategoryinv.isEmpty()) {
                isCheck = true;
            }
            if (this.getUIFormCheckBoxInput(forumId) != null) {
                this.getUIFormCheckBoxInput(forumId).setChecked(isCheck);
                continue;
            }
            UIFormCheckBoxInput boxInput = new UIFormCheckBoxInput(forumId, forumId, (Object)isCheck);
            boxInput.setChecked(isCheck);
            this.addUIFormInput((UIFormInput)boxInput);
        }
        return forumList;
    }

    static /* synthetic */ SettingPortletPreference access$000(UISettingEditModeForm x0) {
        return x0.portletPreference;
    }

    static /* synthetic */ boolean access$102(UISettingEditModeForm x0, boolean x1) {
        x0.isSave = x1;
        return x0.isSave;
    }

    static /* synthetic */ List access$202(List x0) {
        listCategoryinv = x0;
        return listCategoryinv;
    }

    static /* synthetic */ List access$300(UISettingEditModeForm x0, String x1) throws Exception {
        return x0.getListInValus(x1);
    }

    static /* synthetic */ List access$402(List x0) {
        listforuminv = x0;
        return listforuminv;
    }

    static /* synthetic */ List access$200() {
        return listCategoryinv;
    }

    static /* synthetic */ List access$400() {
        return listforuminv;
    }

    static /* synthetic */ int access$502(UISettingEditModeForm x0, int x1) {
        x0.tabId = x1;
        return x0.tabId;
    }
}

