/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui.popup;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.forum.service.ForumLinkData;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.forum.webui.popup.UIPopupComponent;
import org.exoplatform.forum.webui.popup.UISelectCategoryForm;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/popup/UISelectCategoryForm.gtmpl", events={@EventConfig(listeners={AddActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UISelectCategoryForm
extends UIForm
implements UIPopupComponent {
    private List<String> listIdIsSelected = new ArrayList();
    List<ForumLinkData> forumLinks = new ArrayList();

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public void setSelectCateId(List<String> listIdIsSelected) throws Exception {
        this.listIdIsSelected = listIdIsSelected;
        ForumService forumService = (ForumService)PortalContainer.getInstance().getComponentInstanceOfType(ForumService.class);
        this.forumLinks = forumService.getAllLink("", "");
    }

    private List<ForumLinkData> getForumLinks() throws Exception {
        String categoryId = "";
        String forumId = "";
        boolean isPut = true;
        String cateId = "";
        for (ForumLinkData forumLink : this.forumLinks) {
            if (!forumLink.getType().equals(Utils.CATEGORY)) continue;
            cateId = forumLink.getId();
            if (this.getUIFormCheckBoxInput(forumLink.getPath()) != null) continue;
            if (this.listIdIsSelected.contains(cateId)) {
                this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(cateId, cateId, (Object)false).setChecked(true));
                continue;
            }
            this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(cateId, cateId, (Object)false).setChecked(false));
        }
        return this.forumLinks;
    }

    private String getNameForumLinkData(String id) throws Exception {
        for (ForumLinkData linkData : this.forumLinks) {
            if (!linkData.getId().equals(id)) continue;
            return linkData.getName();
        }
        return null;
    }

    static /* synthetic */ String access$000(UISelectCategoryForm x0, String x1) throws Exception {
        return x0.getNameForumLinkData(x1);
    }
}

