/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.download.DownloadResource;
import org.exoplatform.download.DownloadService;
import org.exoplatform.download.InputStreamDownloadResource;
import org.exoplatform.forum.service.ForumAttachment;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.user.ContactProvider;
import org.exoplatform.forum.service.user.ForumContact;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.impl.GroupImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class ForumSessionUtils {
    public static final String DEFAULT_AVATAR = "/forum/skin/DefaultSkin/webui/background/Avatar1.gif";

    public static String getCurrentUser() throws Exception {
        return Util.getPortalRequestContext().getRemoteUser();
    }

    public static String getEmailUser(String userName) throws Exception {
        OrganizationService organizationService = (OrganizationService)PortalContainer.getComponent(OrganizationService.class);
        User user = organizationService.getUserHandler().findUserByName(userName);
        String email = user.getEmail();
        return email;
    }

    public static List<String> getAllGroupAndMembershipOfUser(String userId) throws Exception {
        ArrayList<String> listOfUser = new ArrayList<String>();
        listOfUser.add(userId);
        String value = "";
        String id = "";
        Membership membership = null;
        OrganizationService organizationService_ = (OrganizationService)PortalContainer.getComponent(OrganizationService.class);
        for (Object object : organizationService_.getMembershipHandler().findMembershipsByUser(userId).toArray()) {
            id = object.toString();
            id = id.replace("Membership[", "").replace("]", "");
            membership = organizationService_.getMembershipHandler().findMembership(id);
            value = membership.getGroupId();
            listOfUser.add(value);
            value = membership.getMembershipType() + ":" + value;
            listOfUser.add(value);
        }
        return listOfUser;
    }

    public static boolean isAnonim() throws Exception {
        String userId = ForumSessionUtils.getCurrentUser();
        return userId == null;
    }

    public static String getImageUrl(String imagePath) throws Exception {
        StringBuilder url = new StringBuilder();
        PortalContainer pcontainer = PortalContainer.getInstance();
        try {
            url.append("/").append(pcontainer.getPortalContainerInfo().getContainerName());
        }
        catch (Exception e) {
            return "portal";
        }
        RepositoryService rService = (RepositoryService)pcontainer.getComponentInstanceOfType(RepositoryService.class);
        url.append("/rest/jcr/").append(rService.getCurrentRepository().getConfiguration().getName()).append(imagePath);
        return url.toString();
    }

    public static String getUserAvatarURL(String userName, ForumService forumService) throws Exception {
        String url = null;
        try {
            ForumAttachment attachment = forumService.getUserAvatar(userName);
            url = ForumSessionUtils.getImageUrl((String)attachment.getPath()) + "?size=" + attachment.getSize();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (url == null || url.trim().length() < 1) {
            ForumContact contact = ForumSessionUtils.getPersonalContact((String)userName);
            if (contact != null && contact.getAvatarUrl() != null && contact.getAvatarUrl().trim().length() > 0) {
                url = contact.getAvatarUrl();
            }
            url = url == null || url.trim().length() < 1 ? "/forum/skin/DefaultSkin/webui/background/Avatar1.gif" : url;
        }
        return url;
    }

    public static String getFileSource(InputStream input, String fileName, DownloadService dservice) throws Exception {
        byte[] imageBytes = null;
        if (input != null) {
            imageBytes = new byte[input.available()];
            input.read(imageBytes);
            ByteArrayInputStream byteImage = new ByteArrayInputStream(imageBytes);
            InputStreamDownloadResource dresource = new InputStreamDownloadResource((InputStream)byteImage, "image");
            dresource.setDownloadName(fileName);
            return dservice.getDownloadLink(dservice.addDownloadResource((DownloadResource)dresource));
        }
        return null;
    }

    public static String[] getUserGroups() throws Exception {
        OrganizationService organizationService = (OrganizationService)PortalContainer.getComponent(OrganizationService.class);
        Object[] objGroupIds = organizationService.getGroupHandler().findGroupsOfUser(ForumSessionUtils.getCurrentUser()).toArray();
        String[] groupIds = new String[objGroupIds.length];
        for (int i = 0; i < groupIds.length; ++i) {
            groupIds[i] = ((GroupImpl)objGroupIds[i]).getId();
        }
        return groupIds;
    }

    public static PageList getPageListUser() throws Exception {
        OrganizationService organizationService = (OrganizationService)PortalContainer.getComponent(OrganizationService.class);
        return organizationService.getUserHandler().getUserPageList(10);
    }

    public static List<User> getAllUser() throws Exception {
        OrganizationService organizationService = (OrganizationService)PortalContainer.getComponent(OrganizationService.class);
        PageList pageList = organizationService.getUserHandler().getUserPageList(10);
        ArrayList<User> userList = new ArrayList<User>();
        for (int i = 1; i <= pageList.getAvailablePage(); ++i) {
            userList.addAll(pageList.getPage(i));
        }
        return userList;
    }

    public static User getUserByUserId(String userId) throws Exception {
        OrganizationService organizationService = (OrganizationService)PortalContainer.getComponent(OrganizationService.class);
        return organizationService.getUserHandler().findUserByName(userId);
    }

    public static List<User> getUserByGroupId(String groupId) throws Exception {
        OrganizationService organizationService = (OrganizationService)PortalContainer.getComponent(OrganizationService.class);
        return organizationService.getUserHandler().findUsersByGroup(groupId).getAll();
    }

    public static boolean hasUserInGroup(String groupId, String userId) throws Exception {
        OrganizationService organizationService = (OrganizationService)PortalContainer.getComponent(OrganizationService.class);
        List users = organizationService.getUserHandler().findUsersByGroup(groupId).getAll();
        for (User user : users) {
            if (!user.getUserName().equals(userId)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean hasGroupIdAndMembershipId(String str, OrganizationService organizationService) throws Exception {
        if (str.indexOf(":") >= 0) {
            String[] array = str.split(":");
            try {
                organizationService.getGroupHandler().findGroupById(array[1]).getId();
            }
            catch (Exception e) {
                return false;
            }
            if (array[0].length() == 1 && array[0].charAt(0) == '*') {
                return true;
            }
            if (array[0].length() <= 0) return false;
            if (organizationService.getMembershipTypeHandler().findMembershipType(array[0]) != null) return true;
            return false;
        }
        try {
            organizationService.getGroupHandler().findGroupById(str).getId();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String checkValueUser(String values) throws Exception {
        String erroUser = null;
        if (values != null && values.trim().length() > 0) {
            OrganizationService organizationService = (OrganizationService)PortalContainer.getComponent(OrganizationService.class);
            String[] userIds = values.split(",");
            boolean isUser = false;
            List users = ForumSessionUtils.getAllUser();
            for (String str : userIds) {
                if ((str = str.trim()).indexOf("/") >= 0) {
                    if (ForumSessionUtils.hasGroupIdAndMembershipId((String)str, (OrganizationService)organizationService)) continue;
                    if (erroUser == null) {
                        erroUser = str;
                        continue;
                    }
                    erroUser = erroUser + ", " + str;
                    continue;
                }
                isUser = false;
                for (User user : users) {
                    if (!user.getUserName().equals(str)) continue;
                    isUser = true;
                    break;
                }
                if (isUser) continue;
                erroUser = erroUser == null ? str : erroUser + ", " + str;
            }
        }
        return erroUser;
    }

    public static ForumContact getPersonalContact(String userId) throws Exception {
        try {
            ContactProvider provider = (ContactProvider)PortalContainer.getComponent(ContactProvider.class);
            return provider.getForumContact(userId);
        }
        catch (Exception e) {
            return new ForumContact();
        }
    }

    public static String getBreadcumbUrl(String link, String componentName, String actionName, String objectId) throws Exception {
        PortalRequestContext portalContext = Util.getPortalRequestContext();
        String url = portalContext.getRequest().getRequestURL().toString();
        url = url.substring(0, url.indexOf("/", 8));
        link = link.replaceFirst(componentName, "UIBreadcumbs").replaceFirst(actionName, "ChangePath").replace("pathId", objectId).replaceAll("&amp;", "&");
        return url + link;
    }
}

