/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui.popup;

import java.util.ArrayList;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.service.ForumPrivateMessage;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.webui.popup.UIListInBoxPrivateMessage;
import org.exoplatform.forum.webui.popup.UIListSentPrivateMessage;
import org.exoplatform.forum.webui.popup.UIPopupComponent;
import org.exoplatform.forum.webui.popup.UIPrivateMessageForm;
import org.exoplatform.forum.webui.popup.UISelector;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormInputWithActions;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.wysiwyg.UIFormWYSIWYGInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/popup/UIPrivateMessegeForm.gtmpl", events={@EventConfig(listeners={CloseActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SendPrivateMessageActionListener.class}), @EventConfig(listeners={AddValuesUserActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SelectTabActionListener.class}, phase=Event.Phase.DECODE)})
public class UIPrivateMessageForm
extends UIForm
implements UIPopupComponent,
UISelector {
    private ForumService forumService = (ForumService)PortalContainer.getInstance().getComponentInstanceOfType(ForumService.class);
    private UserProfile userProfile;
    private String userName;
    private int id = 0;
    private boolean fullMessage = true;
    public static final String FIELD_SENDTO_TEXTAREA = "SendTo";
    public static final String FIELD_MAILTITLE_INPUT = "MailTitle";
    public static final String FIELD_MAILMESSAGE_INPUT = "MailMessage";
    public static final String FIELD_SENDMESSAGE_TAB = "MessageTab";
    public static final String FIELD_REPLY_LABEL = "Reply";
    public static final String FIELD_FORWARD_LABEL = "Forward";

    public UIPrivateMessageForm() throws Exception {
        UIFormTextAreaInput SendTo = new UIFormTextAreaInput(FIELD_SENDTO_TEXTAREA, FIELD_SENDTO_TEXTAREA, null);
        SendTo.addValidator(MandatoryValidator.class, new Object[0]);
        UIFormStringInput MailTitle = new UIFormStringInput(FIELD_MAILTITLE_INPUT, FIELD_MAILTITLE_INPUT, null);
        MailTitle.addValidator(MandatoryValidator.class, new Object[0]);
        UIFormWYSIWYGInput formWYSIWYGInput = new UIFormWYSIWYGInput(FIELD_MAILMESSAGE_INPUT, FIELD_MAILMESSAGE_INPUT, "");
        UIFormInputWithActions sendMessageTab = new UIFormInputWithActions(FIELD_SENDMESSAGE_TAB);
        sendMessageTab.addUIFormInput((UIFormInput)SendTo);
        sendMessageTab.addUIFormInput((UIFormInput)MailTitle);
        sendMessageTab.addUIFormInput((UIFormInput)formWYSIWYGInput);
        String[] strings = new String[]{"SelectUser", "SelectMemberShip", "SelectGroup"};
        int i = 0;
        ArrayList<UIFormInputWithActions.ActionData> actions = new ArrayList<UIFormInputWithActions.ActionData>();
        for (String string : strings) {
            UIFormInputWithActions.ActionData ad = new UIFormInputWithActions.ActionData();
            ad.setActionListener("AddValuesUser");
            ad.setActionParameter(String.valueOf(i));
            ad.setCssIconClass(string + "Icon");
            ad.setActionName(string);
            actions.add(ad);
            ++i;
        }
        sendMessageTab.setActionField(FIELD_SENDTO_TEXTAREA, actions);
        this.addUIFormInput((UIFormInputSet)sendMessageTab);
        this.addChild(UIListInBoxPrivateMessage.class, null, null);
        this.addChild(UIListSentPrivateMessage.class, null, null);
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public void setUserProfile(UserProfile userProfile) {
        this.userProfile = userProfile;
        this.userName = userProfile.getUserId();
    }

    private UserProfile getUserProfile() throws Exception {
        return this.userProfile;
    }

    public void setSendtoField(String str) {
        this.getUIFormTextAreaInput(FIELD_SENDTO_TEXTAREA).setValue((Object)str);
    }

    public void updateSelect(String selectField, String value) throws Exception {
        UIFormTextAreaInput fieldInput = this.getUIFormTextAreaInput(selectField);
        String values = (String)fieldInput.getValue();
        if (!ForumUtils.isEmpty((String)values)) {
            if (!ForumUtils.isStringInStrings((String[])(values = ForumUtils.removeSpaceInString((String)values)).split(","), (String)value)) {
                if (values.lastIndexOf(",") != values.length() - 1) {
                    values = values + ",";
                }
                values = values + value;
            }
        } else {
            values = value;
        }
        fieldInput.setValue((Object)values);
    }

    private int getIsSelected() {
        return this.id;
    }

    public void setUpdate(ForumPrivateMessage privateMessage, boolean isReply) throws Exception {
        UIFormInputWithActions MessageTab = (UIFormInputWithActions)this.getChildById(FIELD_SENDMESSAGE_TAB);
        UIFormStringInput stringInput = MessageTab.getUIStringInput(FIELD_MAILTITLE_INPUT);
        UIFormWYSIWYGInput message = (UIFormWYSIWYGInput)MessageTab.getChild(UIFormWYSIWYGInput.class);
        String content = privateMessage.getMessage();
        String label = this.getLabel(FIELD_REPLY_LABEL);
        String title = privateMessage.getName();
        if (isReply) {
            UIFormTextAreaInput areaInput = this.getUIFormTextAreaInput(FIELD_SENDTO_TEXTAREA);
            areaInput.setValue((Object)privateMessage.getFrom());
            if (title.indexOf(label) < 0) {
                title = label + ": " + title;
            }
            stringInput.setValue((Object)title);
            content = "<br/><br/><br/><div style=\"padding: 5px; border-left:solid 2px blue;\">" + content + "</div>";
            message.setValue((Object)content);
        } else {
            label = this.getLabel(FIELD_FORWARD_LABEL);
            if (title.indexOf(label) < 0) {
                title = label + ": " + title;
            }
            stringInput.setValue((Object)title);
        }
        message.setValue((Object)content);
        this.id = 2;
    }

    public boolean isFullMessage() {
        return this.fullMessage;
    }

    public void setFullMessage(boolean fullMessage) {
        this.fullMessage = fullMessage;
    }

    static /* synthetic */ int access$002(UIPrivateMessageForm x0, int x1) {
        x0.id = x1;
        return x0.id;
    }

    static /* synthetic */ String access$100(UIPrivateMessageForm x0) {
        return x0.userName;
    }

    static /* synthetic */ ForumService access$200(UIPrivateMessageForm x0) {
        return x0.forumService;
    }

    static /* synthetic */ boolean access$300(UIPrivateMessageForm x0) {
        return x0.fullMessage;
    }
}

