/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.portlet.ActionResponse;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.xml.namespace.QName;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.forum.ForumSessionUtils;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.info.ForumParameter;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.service.user.ForumContact;
import org.exoplatform.forum.webui.UIBreadcumbs;
import org.exoplatform.forum.webui.UICategoryContainer;
import org.exoplatform.forum.webui.UIForumActionBar;
import org.exoplatform.forum.webui.UIForumContainer;
import org.exoplatform.forum.webui.UIForumLinks;
import org.exoplatform.forum.webui.UIForumPortlet;
import org.exoplatform.forum.webui.UISearchForm;
import org.exoplatform.forum.webui.UITopicsTag;
import org.exoplatform.forum.webui.popup.UIPopupAction;
import org.exoplatform.forum.webui.popup.UISettingEditModeForm;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.PortletRequestImp;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupMessages;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIApplicationLifecycle.class, template="app:/templates/forum/webui/UIForumPortlet.gtmpl", events={@EventConfig(listeners={ReLoadPortletEventActionListener.class}), @EventConfig(listeners={ViewPublicUserInfoActionListener.class}), @EventConfig(listeners={ViewPostedByUserActionListener.class}), @EventConfig(listeners={PrivateMessageActionListener.class}), @EventConfig(listeners={ViewThreadByUserActionListener.class}), @EventConfig(listeners={OpenLinkActionListener.class})})
public class UIForumPortlet
extends UIPortletApplication {
    private ForumService forumService;
    private boolean isCategoryRendered = true;
    private boolean isForumRendered = false;
    private boolean isTagRendered = false;
    private boolean isSearchRendered = false;
    private boolean isJumpRendered = false;
    private boolean isShowForumJump = false;
    private boolean isShowPoll = false;
    private boolean isShowModerators = false;
    private boolean isShowRules = false;
    private boolean isShowIconsLegend = false;
    private boolean isShowStatistics = false;
    private boolean isShowQuickReply = false;
    private UserProfile userProfile = null;
    private boolean enableIPLogging = false;
    private boolean isShowForumActionBar = false;
    private boolean enableBanIP = false;
    private boolean useAjax = true;
    private int dayForumNewPost = 0;
    private List<String> invisibleForums = new ArrayList();
    private List<String> invisibleCategories = new ArrayList();

    public UIForumPortlet() throws Exception {
        this.forumService = (ForumService)PortalContainer.getInstance().getComponentInstanceOfType(ForumService.class);
        this.addChild(UIBreadcumbs.class, null, null);
        boolean isRenderBar = !ForumSessionUtils.isAnonim();
        ((UIForumActionBar)this.addChild(UIForumActionBar.class, null, null)).setRendered(isRenderBar);
        ((UICategoryContainer)this.addChild(UICategoryContainer.class, null, null)).setRendered(this.isCategoryRendered);
        ((UIForumContainer)this.addChild(UIForumContainer.class, null, null)).setRendered(this.isForumRendered);
        ((UITopicsTag)this.addChild(UITopicsTag.class, null, null)).setRendered(this.isTagRendered);
        ((UISearchForm)this.addChild(UISearchForm.class, null, null)).setRendered(this.isSearchRendered);
        ((UIForumLinks)this.addChild(UIForumLinks.class, null, null)).setRendered(this.isJumpRendered);
        this.addChild(UIPopupAction.class, null, "UIForumPopupAction");
        this.loadPreferences();
    }

    public void processRender(WebuiApplication app, WebuiRequestContext context) throws Exception {
        PortletRequestContext portletReqContext = (PortletRequestContext)context;
        if (portletReqContext.getApplicationMode() == PortletMode.VIEW) {
            if (this.getChild(UIBreadcumbs.class) == null) {
                if (this.getChild(UISettingEditModeForm.class) != null) {
                    this.removeChild(UISettingEditModeForm.class);
                }
                this.addChild(UIBreadcumbs.class, null, null);
                ((UIForumActionBar)this.addChild(UIForumActionBar.class, null, null)).setRendered(!ForumSessionUtils.isAnonim());
                UICategoryContainer categoryContainer = (UICategoryContainer)((UICategoryContainer)this.addChild(UICategoryContainer.class, null, null)).setRendered(this.isCategoryRendered);
                ((UIForumContainer)this.addChild(UIForumContainer.class, null, null)).setRendered(this.isForumRendered);
                ((UITopicsTag)this.addChild(UITopicsTag.class, null, null)).setRendered(this.isTagRendered);
                ((UISearchForm)this.addChild(UISearchForm.class, null, null)).setRendered(this.isSearchRendered);
                ((UIForumLinks)this.addChild(UIForumLinks.class, null, null)).setRendered(this.isJumpRendered);
                this.updateIsRendered(ForumUtils.CATEGORIES);
                categoryContainer.updateIsRender(true);
            }
        } else if (portletReqContext.getApplicationMode() == PortletMode.EDIT && this.getChild(UISettingEditModeForm.class) == null) {
            UISettingEditModeForm editModeForm = (UISettingEditModeForm)this.addChild(UISettingEditModeForm.class, null, null);
            editModeForm.setUserProfile(this.getUserProfile());
            if (this.getChild(UIBreadcumbs.class) != null) {
                this.removeChild(UIBreadcumbs.class);
                this.removeChild(UIForumActionBar.class);
                this.removeChild(UICategoryContainer.class);
                this.removeChild(UIForumContainer.class);
                this.removeChild(UITopicsTag.class);
                this.removeChild(UISearchForm.class);
                this.removeChild(UIForumLinks.class);
            }
        }
        super.processRender(app, context);
    }

    public void updateIsRendered(String selected) throws Exception {
        if (selected.equals(ForumUtils.CATEGORIES)) {
            this.isCategoryRendered = true;
            this.isForumRendered = false;
            this.isTagRendered = false;
            this.isSearchRendered = false;
        } else if (selected.equals(ForumUtils.FORUM)) {
            this.isForumRendered = true;
            this.isCategoryRendered = false;
            this.isTagRendered = false;
            this.isSearchRendered = false;
        } else if (selected.equals(ForumUtils.TAG)) {
            this.isTagRendered = true;
            this.isForumRendered = false;
            this.isCategoryRendered = false;
            this.isSearchRendered = false;
        } else {
            this.isTagRendered = false;
            this.isForumRendered = false;
            this.isCategoryRendered = false;
            this.isSearchRendered = true;
        }
        if (!(this.isShowForumActionBar || this.isCategoryRendered && !this.isSearchRendered)) {
            ((UIForumActionBar)this.getChild(UIForumActionBar.class)).setRendered(false);
        }
        this.setRenderForumLink();
        ((UIForumContainer)this.getChild(UIForumContainer.class)).setRendered(this.isForumRendered);
        ((UITopicsTag)this.getChild(UITopicsTag.class)).setRendered(this.isTagRendered);
        ((UISearchForm)this.getChild(UISearchForm.class)).setRendered(this.isSearchRendered);
        if (!this.isForumRendered) {
            try {
                this.setRenderQuickReply();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setRenderForumLink() throws Exception {
        if (this.userProfile == null) {
            this.updateUserProfileInfo();
        }
        this.isJumpRendered = this.isShowForumJump ? this.userProfile.getIsShowForumJump() : false;
        UICategoryContainer categoryContainer = (UICategoryContainer)((UICategoryContainer)this.getChild(UICategoryContainer.class)).setRendered(this.isCategoryRendered);
        categoryContainer.setIsRenderJump(this.isJumpRendered);
        if (!this.isCategoryRendered) {
            ((UIForumLinks)this.getChild(UIForumLinks.class)).setRendered(this.isJumpRendered);
        }
    }

    public void setRenderQuickReply() {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        ActionResponse actionRes = (ActionResponse)pcontext.getResponse();
        ForumParameter param = new ForumParameter();
        param.setRenderQuickReply(false);
        param.setRenderPoll(false);
        param.setRenderModerator(false);
        param.setRenderRule(false);
        actionRes.setEvent(new QName("QuickReplyEvent"), (Serializable)param);
        actionRes.setEvent(new QName("ForumPollEvent"), (Serializable)param);
        actionRes.setEvent(new QName("ForumModerateEvent"), (Serializable)param);
        actionRes.setEvent(new QName("ForumRuleEvent"), (Serializable)param);
    }

    public void loadPreferences() throws Exception {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        this.invisibleCategories.clear();
        this.invisibleForums.clear();
        try {
            this.isShowForumActionBar = Boolean.parseBoolean(portletPref.getValue("showForumActionBar", ""));
            this.dayForumNewPost = Integer.parseInt(portletPref.getValue("forumNewPost", ""));
            this.useAjax = Boolean.parseBoolean(portletPref.getValue("useAjax", ""));
            this.enableIPLogging = Boolean.parseBoolean(portletPref.getValue("enableIPLogging", ""));
            this.enableBanIP = Boolean.parseBoolean(portletPref.getValue("enableIPFiltering", ""));
            this.isShowForumJump = Boolean.parseBoolean(portletPref.getValue("isShowForumJump", ""));
            this.isShowPoll = Boolean.parseBoolean(portletPref.getValue("isShowPoll", ""));
            this.isShowModerators = Boolean.parseBoolean(portletPref.getValue("isShowModerators", ""));
            this.isShowRules = Boolean.parseBoolean(portletPref.getValue("isShowRules", ""));
            this.isShowQuickReply = Boolean.parseBoolean(portletPref.getValue("isShowQuickReply", ""));
            this.isShowStatistics = Boolean.parseBoolean(portletPref.getValue("isShowStatistics", ""));
            this.isShowIconsLegend = Boolean.parseBoolean(portletPref.getValue("isShowIconsLegend", ""));
            this.invisibleCategories.addAll(this.getListInValus(portletPref.getValue("invisibleCategories", "")));
            this.invisibleForums.addAll(this.getListInValus(portletPref.getValue("invisibleForums", "")));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.invisibleCategories.size() == 1 && ((String)this.invisibleCategories.get(0)).equals(" ")) {
            this.invisibleCategories.clear();
        }
    }

    private List<String> getListInValus(String value) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        if (!ForumUtils.isEmpty((String)value)) {
            list.addAll(Arrays.asList(ForumUtils.addStringToString((String)value, (String)value)));
        }
        return list;
    }

    public List<String> getInvisibleForums() {
        return this.invisibleForums;
    }

    public List<String> getInvisibleCategories() {
        return this.invisibleCategories;
    }

    public boolean isEnableIPLogging() {
        return this.enableIPLogging;
    }

    public boolean isEnableBanIp() {
        return this.enableBanIP;
    }

    public boolean isShowForumActionBar() {
        return this.isShowForumActionBar;
    }

    public boolean isShowPoll() {
        return this.isShowPoll;
    }

    public boolean isShowModerators() {
        return this.isShowModerators;
    }

    public boolean isShowRules() {
        return this.isShowRules;
    }

    public boolean isShowIconsLegend() {
        return this.isShowIconsLegend;
    }

    public boolean isShowQuickReply() {
        return this.isShowQuickReply;
    }

    public boolean isShowStatistics() {
        return this.isShowStatistics;
    }

    public boolean isUseAjax() {
        return this.useAjax;
    }

    public int getDayForumNewPost() {
        return this.dayForumNewPost;
    }

    public void renderPopupMessages() throws Exception {
        UIPopupMessages popupMess = this.getUIPopupMessages();
        if (popupMess == null) {
            return;
        }
        WebuiRequestContext context = (WebuiRequestContext)RequestContext.getCurrentInstance();
        popupMess.processRender(context);
    }

    public void cancelAction() throws Exception {
        WebuiRequestContext context = (WebuiRequestContext)RequestContext.getCurrentInstance();
        UIPopupAction popupAction = (UIPopupAction)this.getChild(UIPopupAction.class);
        popupAction.deActivate();
        context.addUIComponentToUpdateByAjax((UIComponent)popupAction);
    }

    public UserProfile getUserProfile() throws Exception {
        if (this.userProfile == null) {
            this.updateUserProfileInfo();
        }
        return this.userProfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAccessTopic(String topicId) throws Exception {
        String userId = ForumSessionUtils.getCurrentUser();
        if (userId != null && userId.length() > 0) {
            SessionProvider sProvider = ForumSessionUtils.getSystemProvider();
            try {
                this.forumService.updateTopicAccess(userId, topicId);
            }
            finally {
                sProvider.close();
            }
        }
        this.userProfile.setLastTimeAccessTopic(topicId, ForumUtils.getInstanceTempCalendar().getTimeInMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAccessForum(String forumId) throws Exception {
        String userId = ForumSessionUtils.getCurrentUser();
        if (userId != null && userId.length() > 0) {
            SessionProvider sProvider = ForumSessionUtils.getSystemProvider();
            try {
                this.forumService.updateForumAccess(userId, forumId);
            }
            finally {
                sProvider.close();
            }
        }
        this.userProfile.setLastTimeAccessForum(forumId, ForumUtils.getInstanceTempCalendar().getTimeInMillis());
    }

    public void updateUserProfileInfo() throws Exception {
        String userId = "";
        try {
            userId = ForumSessionUtils.getCurrentUser();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            ForumService forumService = (ForumService)PortalContainer.getInstance().getComponentInstanceOfType(ForumService.class);
            if (this.enableBanIP) {
                WebuiRequestContext context = (WebuiRequestContext)RequestContext.getCurrentInstance();
                PortletRequestImp request = (PortletRequestImp)context.getRequest();
                this.userProfile = forumService.getDefaultUserProfile(userId, request.getRemoteAddr());
            } else {
                this.userProfile = forumService.getDefaultUserProfile(userId, null);
            }
            if (!ForumUtils.isEmpty((String)userId)) {
                this.userProfile.setEmail(ForumSessionUtils.getUserByUserId((String)userId).getEmail());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private ForumContact getPersonalContact(String userId) throws Exception {
        ForumContact contact = ForumSessionUtils.getPersonalContact((String)userId);
        if (contact == null) {
            contact = new ForumContact();
        }
        return contact;
    }

    static /* synthetic */ UserProfile access$000(UIForumPortlet x0) {
        return x0.userProfile;
    }

    static /* synthetic */ ForumService access$100(UIForumPortlet x0) {
        return x0.forumService;
    }

    static /* synthetic */ ForumContact access$200(UIForumPortlet x0, String x1) throws Exception {
        return x0.getPersonalContact(x1);
    }
}

