/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.service.ForumLinkData;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.forum.webui.UIFormSelectBoxForum;
import org.exoplatform.forum.webui.UIForumLinks;
import org.exoplatform.forum.webui.UIForumPortlet;
import org.exoplatform.ks.common.UserHelper;
import org.exoplatform.ks.common.webui.BaseUIForm;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIFormInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/UIForumLinks.gtmpl", events={@EventConfig(listeners={SelectActionListener.class})})
public class UIForumLinks
extends BaseUIForm {
    private ForumService forumService;
    public static final String FIELD_FORUMLINK_SELECTBOX = "forumLink";
    public static final String FIELD_FORUMHOMEPAGE_LABEL = "forumHomePage";
    private String path = Utils.FORUM_SERVICE;
    private List<ForumLinkData> forumLinks = null;
    private UserProfile userProfile = new UserProfile();

    public UIForumLinks() throws Exception {
        this.forumService = (ForumService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ForumService.class);
    }

    private String getStrQuery(List<String> list, String property) {
        StringBuffer strQuery = new StringBuffer();
        int t = 0;
        for (String string : list) {
            if (t == 0) {
                strQuery.append("(").append(property).append("='").append(string).append("'");
            } else {
                strQuery.append(" or ").append(property).append("='").append(string).append("'");
            }
            ++t;
        }
        if (t > 0) {
            strQuery.append(")");
        }
        return strQuery.toString();
    }

    public void setUpdateForumLinks() throws Exception {
        UIFormSelectBoxForum forumLink;
        String s;
        UIForumPortlet forumPortlet;
        block18: {
            forumPortlet = (UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class);
            try {
                this.userProfile = forumPortlet.getUserProfile();
            }
            catch (Exception e) {
                String userName = UserHelper.getCurrentUser();
                if (userName == null) break block18;
                try {
                    this.userProfile = this.forumService.getQuickProfile(userName);
                }
                catch (Exception ex) {
                    this.userProfile = new UserProfile();
                }
            }
        }
        String strQueryCate = "";
        String strQueryForum = "";
        List listUser = UserHelper.getAllGroupAndMembershipOfUser((String)this.userProfile.getUserId());
        if (this.userProfile.getUserRole() > 0L) {
            strQueryForum = this.getStrQuery(listUser, "@exo:moderators");
            strQueryForum = !ForumUtils.isEmpty((String)strQueryForum) ? "(@exo:isClosed='false' or " + strQueryForum + ")" : "@exo:isClosed='false'";
            listUser.add(" ");
            strQueryCate = this.getStrQuery(listUser, "@exo:userPrivate");
        }
        List listCateIdScope = forumPortlet.getInvisibleCategories();
        List listForumIdScope = forumPortlet.getInvisibleForums();
        if (!listForumIdScope.isEmpty() && !((String)listForumIdScope.get(0)).equals(" ")) {
            s = this.getStrQuery(listForumIdScope, "fn:name()");
            strQueryForum = !ForumUtils.isEmpty((String)strQueryForum) ? strQueryForum + " and " + s : s;
        }
        if (!listCateIdScope.isEmpty() && !((String)listCateIdScope.get(0)).equals(" ")) {
            s = this.getStrQuery(listCateIdScope, "fn:name()");
            strQueryCate = !ForumUtils.isEmpty((String)strQueryCate) ? strQueryCate + " and " + s : s;
        }
        if (!ForumUtils.isEmpty((String)strQueryForum)) {
            strQueryForum = "[" + strQueryForum + "]";
        }
        if (!ForumUtils.isEmpty((String)strQueryCate)) {
            strQueryCate = "[" + strQueryCate + "]";
        }
        this.forumLinks = this.forumService.getAllLink(strQueryCate, strQueryForum);
        ArrayList<SelectItemOption> list = new ArrayList<SelectItemOption>();
        list.add(new SelectItemOption(this.getLabel(FIELD_FORUMHOMEPAGE_LABEL) + "/" + FIELD_FORUMHOMEPAGE_LABEL, (Object)Utils.FORUM_SERVICE));
        String space = "&nbsp; &nbsp; ";
        String type = "/categoryLink";
        for (ForumLinkData linkData : this.forumLinks) {
            if (linkData.getType().equals(Utils.FORUM)) {
                type = "/forumLink";
                space = "&nbsp; &nbsp; &nbsp; &nbsp; ";
            }
            if (linkData.getType().equals(Utils.CATEGORY)) {
                type = "/categoryLink";
                space = "&nbsp; &nbsp; ";
            }
            if (linkData.getType().equals(Utils.TOPIC)) continue;
            list.add(new SelectItemOption(space + linkData.getName() + type, (Object)linkData.getPath()));
        }
        if (this.getChild(UIFormSelectBoxForum.class) != null) {
            forumLink = ((UIFormSelectBoxForum)this.getChild(UIFormSelectBoxForum.class)).setOptions(list);
            if (ForumUtils.isEmpty((String)this.path)) {
                forumLink.setValue(Utils.FORUM_SERVICE);
            } else {
                forumLink.setValue(this.path.trim());
            }
        } else {
            forumLink = new UIFormSelectBoxForum(FIELD_FORUMLINK_SELECTBOX, FIELD_FORUMLINK_SELECTBOX, list);
            if (ForumUtils.isEmpty((String)this.path)) {
                forumLink.setValue(Utils.FORUM_SERVICE);
            } else {
                forumLink.setValue(this.path.trim());
            }
            this.addUIFormInput((UIFormInput)forumLink);
        }
    }

    public UIFormSelectBoxForum getUIFormSelectBoxForum(String name) {
        return (UIFormSelectBoxForum)this.findComponentById(name);
    }

    public List<ForumLinkData> getForumLinks() throws Exception {
        return this.forumLinks;
    }

    public void setValueOption(String path) throws Exception {
        this.path = path;
    }

    static /* synthetic */ String access$000(UIForumLinks x0) {
        return x0.path;
    }

    static /* synthetic */ ForumService access$100(UIForumLinks x0) {
        return x0.forumService;
    }

    static /* synthetic */ void access$200(UIForumLinks x0, String x1) {
        x0.warning(x1);
    }

    static /* synthetic */ String access$002(UIForumLinks x0, String x1) {
        x0.path = x1;
        return x0.path;
    }
}

